/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.APolygon;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class APolygonSerializerDeserializer
implements ISerializerDeserializer<APolygon> {
    private static final long serialVersionUID = 1L;
    public static final APolygonSerializerDeserializer INSTANCE = new APolygonSerializerDeserializer();

    private APolygonSerializerDeserializer() {
    }

    public APolygon deserialize(DataInput in) throws HyracksDataException {
        try {
            int numberOfPoints = in.readShort();
            APoint[] points = new APoint[numberOfPoints];
            for (int i = 0; i < numberOfPoints; ++i) {
                points[i] = APointSerializerDeserializer.INSTANCE.deserialize(in);
            }
            return new APolygon(points);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(APolygon instance, DataOutput out) throws HyracksDataException {
        try {
            int n = instance.getNumberOfPoints();
            out.writeShort(n);
            for (int i = 0; i < n; ++i) {
                APointSerializerDeserializer.INSTANCE.serialize(instance.getPoints()[i], out);
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static final int getNumberOfPointsOffset() throws HyracksDataException {
        return 1;
    }

    public static final int getCoordinateOffset(int pointId, Coordinate coordinate) throws HyracksDataException {
        switch (coordinate) {
            case X: {
                return 3 + pointId * 16;
            }
            case Y: {
                return 11 + pointId * 16;
            }
        }
        throw new HyracksDataException("Wrong coordinate");
    }

    public static void parse(String polygon, DataOutput out) throws HyracksDataException {
        try {
            String[] points = polygon.split(" ");
            if (points.length < 3) {
                throw new HyracksDataException("Polygon must have at least 3 points.");
            }
            out.writeByte(ATypeTag.POLYGON.serialize());
            out.writeShort(points.length);
            for (int i = 0; i < points.length; ++i) {
                APointSerializerDeserializer.serialize(Double.parseDouble(points[i].split(",")[0]), Double.parseDouble(points[i].split(",")[1]), out);
            }
        }
        catch (Exception e) {
            throw new HyracksDataException(polygon + " can not be an instance of polygon");
        }
    }
}

