/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.om.base.APoint;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class APointSerializerDeserializer
implements ISerializerDeserializer<APoint> {
    private static final long serialVersionUID = 1L;
    public static final APointSerializerDeserializer INSTANCE = new APointSerializerDeserializer();

    private APointSerializerDeserializer() {
    }

    public APoint deserialize(DataInput in) throws HyracksDataException {
        try {
            return new APoint(in.readDouble(), in.readDouble());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(APoint instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeDouble(instance.getX());
            out.writeDouble(instance.getY());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static void serialize(double x, double y, DataOutput out) throws HyracksDataException {
        try {
            out.writeDouble(x);
            out.writeDouble(y);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static final int getCoordinateOffset(Coordinate coordinate) throws HyracksDataException {
        switch (coordinate) {
            case X: {
                return 1;
            }
            case Y: {
                return 9;
            }
        }
        throw new HyracksDataException("Wrong coordinate");
    }
}

