/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class AOrderedListSerializerDeserializer
implements ISerializerDeserializer<AOrderedList> {
    private static final long serialVersionUID = 1L;
    public static final AOrderedListSerializerDeserializer SCHEMALESS_INSTANCE = new AOrderedListSerializerDeserializer();
    private final IAType itemType;
    private final ISerializerDeserializer serializer;
    private final ISerializerDeserializer deserializer;
    private final AOrderedListType orderedlistType;

    private AOrderedListSerializerDeserializer() {
        this(new AOrderedListType(BuiltinType.ANY, "orderedlist"));
    }

    public AOrderedListSerializerDeserializer(AOrderedListType orderedlistType) {
        this.orderedlistType = orderedlistType;
        this.itemType = orderedlistType.getItemType();
        this.serializer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(this.itemType);
        this.deserializer = this.itemType.getTypeTag() == ATypeTag.ANY ? SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(this.itemType) : SerializerDeserializerProvider.INSTANCE.getNonTaggedSerializerDeserializer(this.itemType);
    }

    public AOrderedList deserialize(DataInput in) throws HyracksDataException {
        try {
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(in.readByte());
            IAType currentItemType = this.itemType;
            ISerializerDeserializer currentDeserializer = this.deserializer;
            if (this.itemType.getTypeTag() == ATypeTag.ANY && typeTag != ATypeTag.ANY) {
                currentItemType = TypeTagUtil.getBuiltinTypeByTag(typeTag);
                currentDeserializer = SerializerDeserializerProvider.INSTANCE.getNonTaggedSerializerDeserializer(currentItemType);
            }
            ArrayList<IAObject> items = new ArrayList<IAObject>();
            in.readInt();
            int numberOfitems = in.readInt();
            if (numberOfitems > 0) {
                int i;
                if (!NonTaggedFormatUtil.isFixedSizedCollection(currentItemType)) {
                    for (i = 0; i < numberOfitems; ++i) {
                        in.readInt();
                    }
                }
                for (i = 0; i < numberOfitems; ++i) {
                    IAObject v = (IAObject)currentDeserializer.deserialize(in);
                    items.add(v);
                }
            }
            AOrderedListType type = new AOrderedListType(currentItemType, "orderedlist");
            return new AOrderedList(type, items);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(AOrderedList instance, DataOutput out) throws HyracksDataException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset(this.orderedlistType);
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        for (int i = 0; i < instance.size(); ++i) {
            itemValue.reset();
            this.serializer.serialize((Object)instance.getItem(i), itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        listBuilder.write(out, false);
    }

    public static final int getOrderedListLength(byte[] serOrderedList, int offset) {
        return AInt32SerializerDeserializer.getInt(serOrderedList, offset + 1);
    }

    public static int getNumberOfItems(byte[] serOrderedList, int offset) {
        if (serOrderedList[offset] == ATypeTag.ORDEREDLIST.serialize()) {
            return AInt32SerializerDeserializer.getInt(serOrderedList, offset + 6);
        }
        return -1;
    }

    public static int getItemOffset(byte[] serOrderedList, int offset, int itemIndex) throws AsterixException {
        if (serOrderedList[offset] == ATypeTag.ORDEREDLIST.serialize()) {
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serOrderedList[offset + 1]);
            if (NonTaggedFormatUtil.isFixedSizedCollection(typeTag)) {
                int length = NonTaggedFormatUtil.getFieldValueLength(serOrderedList, offset + 1, typeTag, true);
                return offset + 10 + length * itemIndex;
            }
            return offset + AInt32SerializerDeserializer.getInt(serOrderedList, offset + 10 + 4 * itemIndex);
        }
        return -1;
    }
}

