/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.AInt64;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AInt64SerializerDeserializer
implements ISerializerDeserializer<AInt64> {
    private static final long serialVersionUID = 1L;
    public static final AInt64SerializerDeserializer INSTANCE = new AInt64SerializerDeserializer();

    private AInt64SerializerDeserializer() {
    }

    public AInt64 deserialize(DataInput in) throws HyracksDataException {
        try {
            return new AInt64(in.readLong());
        }
        catch (IOException ioe) {
            throw new HyracksDataException((Throwable)ioe);
        }
    }

    public void serialize(AInt64 instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeLong(instance.getLongValue());
        }
        catch (IOException ioe) {
            throw new HyracksDataException((Throwable)ioe);
        }
    }

    public static long getLong(byte[] bytes, int offset) {
        return ((long)(bytes[offset] & 0xFF) << 56) + ((long)(bytes[offset + 1] & 0xFF) << 48) + ((long)(bytes[offset + 2] & 0xFF) << 40) + ((long)(bytes[offset + 3] & 0xFF) << 32) + ((long)(bytes[offset + 4] & 0xFF) << 24) + ((long)(bytes[offset + 5] & 0xFF) << 16) + ((long)(bytes[offset + 6] & 0xFF) << 8) + (long)(bytes[offset + 7] & 0xFF);
    }
}

