/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.om.base.ACircle;
import org.apache.asterix.om.base.APoint;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ACircleSerializerDeserializer
implements ISerializerDeserializer<ACircle> {
    private static final long serialVersionUID = 1L;
    public static final ACircleSerializerDeserializer INSTANCE = new ACircleSerializerDeserializer();

    private ACircleSerializerDeserializer() {
    }

    public ACircle deserialize(DataInput in) throws HyracksDataException {
        try {
            APoint center = APointSerializerDeserializer.INSTANCE.deserialize(in);
            double radius = ADoubleSerializerDeserializer.INSTANCE.deserialize(in).getDoubleValue();
            return new ACircle(center, radius);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(ACircle instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeDouble(instance.getP().getX());
            out.writeDouble(instance.getP().getY());
            out.writeDouble(instance.getRadius());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static final int getCenterPointCoordinateOffset(Coordinate coordinate) throws HyracksDataException {
        switch (coordinate) {
            case X: {
                return 1;
            }
            case Y: {
                return 9;
            }
        }
        throw new HyracksDataException("Wrong coordinate");
    }

    public static final int getRadiusOffset() throws HyracksDataException {
        return 17;
    }
}

