/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class APolygonPartialBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static final APolygonPartialBinaryComparatorFactory INSTANCE = new APolygonPartialBinaryComparatorFactory();

    private APolygonPartialBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return new IBinaryComparator(){

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                try {
                    int pointCount1 = AInt16SerializerDeserializer.getShort(b1, s1 + APolygonSerializerDeserializer.getNumberOfPointsOffset() - 1);
                    int c = Short.compare((short)pointCount1, AInt16SerializerDeserializer.getShort(b2, s2 + APolygonSerializerDeserializer.getNumberOfPointsOffset() - 1));
                    if (c == 0) {
                        int ci = 0;
                        for (int i = 0; i < pointCount1; ++i) {
                            ci = Double.compare(DoublePointable.getDouble((byte[])b1, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.X) - 1)), DoublePointable.getDouble((byte[])b2, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.X) - 1)));
                            if (ci == 0 && (ci = Double.compare(DoublePointable.getDouble((byte[])b1, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.Y) - 1)), DoublePointable.getDouble((byte[])b2, (int)(s1 + APolygonSerializerDeserializer.getCoordinateOffset(i, Coordinate.Y) - 1)))) == 0) continue;
                            return ci;
                        }
                    }
                    return c;
                }
                catch (HyracksDataException hex) {
                    throw new IllegalStateException(hex);
                }
            }
        };
    }
}

