/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.util.logging.Logger;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.transactions.CheckpointProperties;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.recovery.AbstractCheckpointManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class CheckpointManager
extends AbstractCheckpointManager {
    private static final Logger LOGGER = Logger.getLogger(CheckpointManager.class.getName());

    public CheckpointManager(ITransactionSubsystem txnSubsystem, CheckpointProperties checkpointProperties) {
        super(txnSubsystem, checkpointProperties);
    }

    public synchronized void doSharpCheckpoint() throws HyracksDataException {
        LOGGER.info("Starting sharp checkpoint...");
        IDatasetLifecycleManager datasetLifecycleManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getDatasetLifecycleManager();
        datasetLifecycleManager.flushAllDatasets();
        this.capture(-1L, true);
        this.txnSubsystem.getLogManager().renewLogFiles();
        LOGGER.info("Completed sharp checkpoint.");
    }

    public synchronized long tryCheckpoint(long checkpointTargetLSN) throws HyracksDataException {
        boolean checkpointSucceeded;
        LOGGER.info("Attemping soft checkpoint...");
        long minFirstLSN = this.txnSubsystem.getRecoveryManager().getMinFirstLSN();
        boolean bl = checkpointSucceeded = minFirstLSN >= checkpointTargetLSN;
        if (!checkpointSucceeded) {
            IDatasetLifecycleManager datasetLifecycleManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getDatasetLifecycleManager();
            datasetLifecycleManager.scheduleAsyncFlushForLaggingDatasets(checkpointTargetLSN);
        }
        this.capture(minFirstLSN, false);
        if (checkpointSucceeded) {
            this.txnSubsystem.getLogManager().deleteOldLogFiles(minFirstLSN);
            LOGGER.info(String.format("soft checkpoint succeeded at LSN(%s)", minFirstLSN));
        }
        return minFirstLSN;
    }
}

