/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ILogReader;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.LogManagerProperties;
import org.apache.asterix.common.transactions.MutableLong;
import org.apache.asterix.common.transactions.TxnLogFile;
import org.apache.asterix.transaction.management.service.logging.LogBuffer;
import org.apache.asterix.transaction.management.service.logging.LogFlusher;
import org.apache.asterix.transaction.management.service.logging.LogReader;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;

public class LogManager
implements ILogManager,
ILifeCycleComponent {
    public static final boolean IS_DEBUG_MODE = false;
    private static final Logger LOGGER = Logger.getLogger(LogManager.class.getName());
    private final ITransactionSubsystem txnSubsystem;
    private final LogManagerProperties logManagerProperties;
    protected final long logFileSize;
    protected final int logPageSize;
    private final int numLogPages;
    private final String logDir;
    private final String logFilePrefix;
    private final MutableLong flushLSN;
    private LinkedBlockingQueue<LogBuffer> emptyQ;
    private LinkedBlockingQueue<LogBuffer> flushQ;
    private LinkedBlockingQueue<LogBuffer> stashQ;
    protected final AtomicLong appendLSN;
    private FileChannel appendChannel;
    protected LogBuffer appendPage;
    private LogFlusher logFlusher;
    private Future<? extends Object> futureLogFlusher;
    private static final long SMALLEST_LOG_FILE_ID = 0L;
    private static final int INITIAL_LOG_SIZE = 0;
    private final String nodeId;
    protected LinkedBlockingQueue<ILogRecord> flushLogsQ;
    private final FlushLogsLogger flushLogsLogger;
    private final HashMap<Long, Integer> txnLogFileId2ReaderCount = new HashMap();

    public LogManager(ITransactionSubsystem txnSubsystem) {
        this.txnSubsystem = txnSubsystem;
        this.logManagerProperties = new LogManagerProperties(this.txnSubsystem.getTransactionProperties(), this.txnSubsystem.getId());
        this.logFileSize = this.logManagerProperties.getLogPartitionSize();
        this.logPageSize = this.logManagerProperties.getLogPageSize();
        this.numLogPages = this.logManagerProperties.getNumLogPages();
        this.logDir = this.logManagerProperties.getLogDir();
        this.logFilePrefix = this.logManagerProperties.getLogFilePrefix();
        this.flushLSN = new MutableLong();
        this.appendLSN = new AtomicLong();
        this.nodeId = txnSubsystem.getId();
        this.flushLogsQ = new LinkedBlockingQueue();
        this.flushLogsLogger = new FlushLogsLogger();
        this.initializeLogManager(0L);
    }

    private void initializeLogManager(long nextLogFileId) {
        this.emptyQ = new LinkedBlockingQueue(this.numLogPages);
        this.flushQ = new LinkedBlockingQueue(this.numLogPages);
        this.stashQ = new LinkedBlockingQueue(this.numLogPages);
        for (int i = 0; i < this.numLogPages; ++i) {
            this.emptyQ.offer(new LogBuffer(this.txnSubsystem, this.logPageSize, this.flushLSN));
        }
        this.appendLSN.set(this.initializeLogAnchor(nextLogFileId));
        this.flushLSN.set(this.appendLSN.get());
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("LogManager starts logging in LSN: " + this.appendLSN);
        }
        this.appendChannel = this.getFileChannel(this.appendLSN.get(), false);
        this.getAndInitNewPage(0);
        this.logFlusher = new LogFlusher(this, this.emptyQ, this.flushQ, this.stashQ);
        this.futureLogFlusher = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getThreadExecutor().submit((Callable)this.logFlusher);
        if (!this.flushLogsLogger.isAlive()) {
            this.txnSubsystem.getAsterixAppRuntimeContextProvider().getThreadExecutor().execute((Runnable)this.flushLogsLogger);
        }
    }

    public void log(ILogRecord logRecord) throws ACIDException {
        if (logRecord.getLogType() == 4) {
            this.flushLogsQ.offer(logRecord);
            return;
        }
        this.appendToLogTail(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendToLogTail(ILogRecord logRecord) throws ACIDException {
        this.syncAppendToLogTail(logRecord);
        if (!(logRecord.getLogType() != 1 && logRecord.getLogType() != 3 && logRecord.getLogType() != 6 || logRecord.isFlushed())) {
            ILogRecord iLogRecord = logRecord;
            synchronized (iLogRecord) {
                while (!logRecord.isFlushed()) {
                    try {
                        logRecord.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void syncAppendToLogTail(ILogRecord logRecord) throws ACIDException {
        ITransactionContext txnCtx;
        if (logRecord.getLogType() != 4 && (txnCtx = logRecord.getTxnCtx()).getTxnState() == 2 && logRecord.getLogType() != 3) {
            throw new ACIDException("Aborted job(" + txnCtx.getJobId() + ") tried to write non-abort type log record.");
        }
        int logSize = logRecord.getLogSize();
        if (this.getLogFileOffset(this.appendLSN.get()) + (long)logSize >= this.logFileSize) {
            this.prepareNextLogFile();
            this.prepareNextPage(logSize);
        } else if (!this.appendPage.hasSpace(logSize)) {
            this.prepareNextPage(logSize);
        }
        this.appendPage.append(logRecord, this.appendLSN.get());
        if (logRecord.getLogType() == 4) {
            logRecord.setLSN(this.appendLSN.get());
        }
        if (logRecord.isMarker()) {
            logRecord.logAppended(this.appendLSN.get());
        }
        this.appendLSN.addAndGet(logSize);
    }

    protected void prepareNextPage(int logSize) {
        this.appendPage.isFull(true);
        this.getAndInitNewPage(logSize);
    }

    protected void getAndInitNewPage(int logSize) {
        if (logSize > this.logPageSize) {
            this.appendPage = null;
            while (this.appendPage == null) {
                try {
                    this.appendPage = this.emptyQ.take();
                    this.stashQ.add(this.appendPage);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.appendPage = new LogBuffer(this.txnSubsystem, logSize, this.flushLSN);
            this.appendPage.setFileChannel(this.appendChannel);
            this.flushQ.offer(this.appendPage);
        } else {
            this.appendPage = null;
            while (this.appendPage == null) {
                try {
                    this.appendPage = this.emptyQ.take();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.appendPage.reset();
            this.appendPage.setFileChannel(this.appendChannel);
            this.flushQ.offer(this.appendPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareNextLogFile() {
        this.appendPage.isLastPage(true);
        this.appendPage.isFull(true);
        MutableLong mutableLong = this.flushLSN;
        synchronized (mutableLong) {
            try {
                while (this.flushLSN.get() != this.appendLSN.get()) {
                    this.flushLSN.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.appendLSN.addAndGet(this.logFileSize - this.getLogFileOffset(this.appendLSN.get()));
        this.flushLSN.set(this.appendLSN.get());
        this.appendChannel = this.getFileChannel(this.appendLSN.get(), true);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Created new txn log file with id(" + this.getLogFileId(this.appendLSN.get()) + ") starting with LSN = " + this.appendLSN.get());
        }
    }

    public ILogReader getLogReader(boolean isRecoveryMode) {
        return new LogReader(this, this.logFileSize, this.logPageSize, this.flushLSN, isRecoveryMode);
    }

    public LogManagerProperties getLogManagerProperties() {
        return this.logManagerProperties;
    }

    public ITransactionSubsystem getTransactionSubsystem() {
        return this.txnSubsystem;
    }

    public long getAppendLSN() {
        return this.appendLSN.get();
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) {
        this.terminateLogFlusher();
        if (dumpState) {
            this.dumpState(os);
        }
    }

    public void dumpState(OutputStream os) {
        this.dumpConfVars(os);
        this.dumpLSNInfo(os);
    }

    private void dumpConfVars(OutputStream os) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n>>dump_begin\t>>----- [ConfVars] -----");
            sb.append(this.logManagerProperties.toString());
            sb.append("\n>>dump_end\t>>----- [ConfVars] -----\n");
            os.write(sb.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dumpLSNInfo(OutputStream os) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n>>dump_begin\t>>----- [LSNInfo] -----");
            sb.append("\nappendLsn: " + this.appendLSN);
            sb.append("\nflushLsn: " + this.flushLSN.get());
            sb.append("\n>>dump_end\t>>----- [LSNInfo] -----\n");
            os.write(sb.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long initializeLogAnchor(long nextLogFileId) {
        long fileId = 0L;
        long offset = 0L;
        File fileLogDir = new File(this.logDir);
        try {
            if (fileLogDir.exists()) {
                List<Long> logFileIds = this.getLogFileIds();
                if (logFileIds == null) {
                    fileId = nextLogFileId;
                    LogManager.createFileIfNotExists(this.getLogFilePath(fileId));
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("created a log file: " + this.getLogFilePath(fileId));
                    }
                } else {
                    fileId = logFileIds.get(logFileIds.size() - 1);
                    File logFile = new File(this.getLogFilePath(fileId));
                    offset = logFile.length();
                }
            } else {
                fileId = nextLogFileId;
                LogManager.createNewDirectory(this.logDir);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("created the log directory: " + this.logManagerProperties.getLogDir());
                }
                LogManager.createFileIfNotExists(this.getLogFilePath(fileId));
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("created a log file: " + this.getLogFilePath(fileId));
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to initialize the log anchor", ioe);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("log file Id: " + fileId + ", offset: " + offset);
        }
        return this.logFileSize * fileId + offset;
    }

    public void renewLogFiles() {
        this.terminateLogFlusher();
        long lastMaxLogFileId = this.deleteAllLogFiles();
        this.initializeLogManager(lastMaxLogFileId + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldLogFiles(long checkpointLSN) {
        Long checkpointLSNLogFileID = this.getLogFileId(checkpointLSN);
        List<Long> logFileIds = this.getLogFileIds();
        if (logFileIds != null) {
            Collections.sort(logFileIds);
            HashMap<Long, Integer> hashMap = this.txnLogFileId2ReaderCount;
            synchronized (hashMap) {
                for (Long id : logFileIds) {
                    if (id >= checkpointLSNLogFileID || this.txnLogFileId2ReaderCount.containsKey(id) && this.txnLogFileId2ReaderCount.get(id) > 0) break;
                    File file = new File(this.getLogFilePath(id));
                    file.delete();
                    this.txnLogFileId2ReaderCount.remove(id);
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Deleted log file " + file.getAbsolutePath());
                }
            }
        }
    }

    private void terminateLogFlusher() {
        block4: {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Terminating LogFlusher thread ...");
            }
            this.logFlusher.terminate();
            try {
                this.futureLogFlusher.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block4;
                LOGGER.info("---------- warning(begin): LogFlusher thread is terminated abnormally --------");
                e.printStackTrace();
                LOGGER.info("---------- warning(end)  : LogFlusher thread is terminated abnormally --------");
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("LogFlusher thread is terminated.");
        }
    }

    private long deleteAllLogFiles() {
        if (this.appendChannel != null) {
            try {
                this.appendChannel.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to close a fileChannel of a log file");
            }
        }
        this.txnLogFileId2ReaderCount.clear();
        List<Long> logFileIds = this.getLogFileIds();
        if (logFileIds != null) {
            for (Long id : logFileIds) {
                File file = new File(this.getLogFilePath(id));
                if (file.delete()) continue;
                throw new IllegalStateException("Failed to delete a file: " + file.getAbsolutePath());
            }
            return logFileIds.get(logFileIds.size() - 1);
        }
        throw new IllegalStateException("Couldn't find any log files.");
    }

    public List<Long> getLogFileIds() {
        File fileLogDir = new File(this.logDir);
        String[] logFileNames = null;
        ArrayList<Long> logFileIds = null;
        if (fileLogDir.exists() && (logFileNames = fileLogDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(LogManager.this.logFilePrefix);
            }
        })) != null && logFileNames.length != 0) {
            logFileIds = new ArrayList<Long>();
            for (String fileName : logFileNames) {
                logFileIds.add(Long.parseLong(fileName.substring(this.logFilePrefix.length() + 1)));
            }
            Collections.sort(logFileIds, new Comparator<Long>(){

                @Override
                public int compare(Long arg0, Long arg1) {
                    return arg0.compareTo(arg1);
                }
            });
        }
        return logFileIds;
    }

    public String getLogFilePath(long fileId) {
        return this.logDir + File.separator + this.logFilePrefix + "_" + fileId;
    }

    public long getLogFileOffset(long lsn) {
        return lsn % this.logFileSize;
    }

    public long getLogFileId(long lsn) {
        return lsn / this.logFileSize;
    }

    private static boolean createFileIfNotExists(String path) throws IOException {
        File file = new File(path);
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        return file.createNewFile();
    }

    private static boolean createNewDirectory(String path) {
        return new File(path).mkdir();
    }

    private FileChannel getFileChannel(long lsn, boolean create) {
        FileChannel newFileChannel = null;
        try {
            long fileId = this.getLogFileId(lsn);
            String logFilePath = this.getLogFilePath(fileId);
            File file = new File(logFilePath);
            if (create ? !file.createNewFile() : !file.exists()) {
                throw new IllegalStateException();
            }
            RandomAccessFile raf = new RandomAccessFile(new File(logFilePath), "rw");
            newFileChannel = raf.getChannel();
            newFileChannel.position(this.getLogFileOffset(lsn));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return newFileChannel;
    }

    public long getReadableSmallestLSN() {
        List<Long> logFileIds = this.getLogFileIds();
        if (logFileIds != null) {
            return logFileIds.get(0) * this.logFileSize;
        }
        throw new IllegalStateException("Couldn't find any log files.");
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getLogPageSize() {
        return this.logPageSize;
    }

    public void renewLogFilesAndStartFromLSN(long LSNtoStartFrom) throws IOException {
        this.terminateLogFlusher();
        this.deleteAllLogFiles();
        long newLogFile = this.getLogFileId(LSNtoStartFrom);
        this.initializeLogManager(newLogFile + 1L);
    }

    public void setReplicationManager(IReplicationManager replicationManager) {
        throw new IllegalStateException("This log manager does not support replication");
    }

    public int getNumLogPages() {
        return this.numLogPages;
    }

    public TxnLogFile getLogFile(long LSN) throws IOException {
        long fileId = this.getLogFileId(LSN);
        String logFilePath = this.getLogFilePath(fileId);
        File file = new File(logFilePath);
        if (!file.exists()) {
            throw new IOException("Log file with id(" + fileId + ") was not found. Requested LSN: " + LSN);
        }
        RandomAccessFile raf = new RandomAccessFile(new File(logFilePath), "r");
        FileChannel newFileChannel = raf.getChannel();
        TxnLogFile logFile = new TxnLogFile((ILogManager)this, newFileChannel, fileId, fileId * this.logFileSize);
        this.touchLogFile(fileId);
        return logFile;
    }

    public void closeLogFile(TxnLogFile logFileRef, FileChannel fileChannel) throws IOException {
        if (!fileChannel.isOpen()) {
            throw new IllegalStateException("File channel is not open");
        }
        fileChannel.close();
        this.untouchLogFile(logFileRef.getLogFileId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touchLogFile(long fileId) {
        HashMap<Long, Integer> hashMap = this.txnLogFileId2ReaderCount;
        synchronized (hashMap) {
            if (this.txnLogFileId2ReaderCount.containsKey(fileId)) {
                this.txnLogFileId2ReaderCount.put(fileId, this.txnLogFileId2ReaderCount.get(fileId) + 1);
            } else {
                this.txnLogFileId2ReaderCount.put(fileId, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untouchLogFile(long fileId) {
        HashMap<Long, Integer> hashMap = this.txnLogFileId2ReaderCount;
        synchronized (hashMap) {
            int newReaderCount;
            if (this.txnLogFileId2ReaderCount.containsKey(fileId)) {
                newReaderCount = this.txnLogFileId2ReaderCount.get(fileId) - 1;
                if (newReaderCount < 0) {
                    throw new IllegalStateException("Invalid log file reader count (ID=" + fileId + ", count: " + newReaderCount + ")");
                }
            } else {
                throw new IllegalStateException("Trying to close log file id(" + fileId + ") which was not opened.");
            }
            this.txnLogFileId2ReaderCount.put(fileId, newReaderCount);
        }
    }

    private class FlushLogsLogger
    extends Thread {
        private ILogRecord logRecord;

        private FlushLogsLogger() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.logRecord = LogManager.this.flushLogsQ.take();
                        LogManager.this.appendToLogTail(this.logRecord);
                    }
                }
                catch (ACIDException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

