/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.transaction.management.service.logging.LogBuffer;
import org.apache.asterix.transaction.management.service.logging.LogManager;

class LogFlusher
implements Callable<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(LogFlusher.class.getName());
    private static final LogBuffer POISON_PILL = new LogBuffer(null, 14, null);
    private final LogManager logMgr;
    private final LinkedBlockingQueue<LogBuffer> emptyQ;
    private final LinkedBlockingQueue<LogBuffer> flushQ;
    private final LinkedBlockingQueue<LogBuffer> stashQ;
    private LogBuffer flushPage;
    private final AtomicBoolean isStarted;
    private final AtomicBoolean terminateFlag;

    public LogFlusher(LogManager logMgr, LinkedBlockingQueue<LogBuffer> emptyQ, LinkedBlockingQueue<LogBuffer> flushQ, LinkedBlockingQueue<LogBuffer> stashQ) {
        this.logMgr = logMgr;
        this.emptyQ = emptyQ;
        this.flushQ = flushQ;
        this.stashQ = stashQ;
        this.flushPage = null;
        this.isStarted = new AtomicBoolean(false);
        this.terminateFlag = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.isStarted;
        synchronized (object) {
            while (!this.isStarted.get()) {
                try {
                    this.isStarted.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.terminateFlag.set(true);
        if (this.flushPage != null) {
            object = this.flushPage;
            synchronized (object) {
                this.flushPage.isStop(true);
                this.flushPage.notify();
            }
        }
        this.flushQ.offer(POISON_PILL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        AtomicBoolean atomicBoolean = this.isStarted;
        synchronized (atomicBoolean) {
            this.isStarted.set(true);
            this.isStarted.notify();
        }
        try {
            while (true) {
                this.flushPage = null;
                try {
                    this.flushPage = this.flushQ.take();
                    if (this.flushPage == POISON_PILL || this.terminateFlag.get()) {
                        return true;
                    }
                }
                catch (InterruptedException e) {
                    if (this.flushPage == null) continue;
                }
                this.flushPage.flush();
                this.emptyQ.offer(this.flushPage.getLogPageSize() == this.logMgr.getLogPageSize() ? this.flushPage : (LogBuffer)this.stashQ.remove());
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("-------------------------------------------------------------------------");
                LOGGER.info("LogFlusher is terminating abnormally. System is in unusalbe state.");
                LOGGER.info("-------------------------------------------------------------------------");
            }
            e.printStackTrace();
            throw e;
        }
    }
}

