/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import org.apache.asterix.transaction.management.service.locking.AllocInfo;
import org.apache.asterix.transaction.management.service.locking.RecordManagerStats;
import org.apache.asterix.transaction.management.service.locking.ResourceRecordManager;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;

public class ResourceArenaManager {
    public static final boolean TRACK_ALLOC_ID = false;
    private final int noArenas;
    private final ResourceRecordManager[] arenas;
    private ThreadLocal<LocalManager> local;

    public ResourceArenaManager(final int noArenas, long txnShrinkTimer) {
        this.noArenas = noArenas;
        this.arenas = new ResourceRecordManager[noArenas];
        for (int i = 0; i < noArenas; ++i) {
            this.arenas[i] = new ResourceRecordManager(txnShrinkTimer);
        }
        this.local = new ThreadLocal<LocalManager>(){
            private int nextArena = 0;

            @Override
            protected synchronized LocalManager initialValue() {
                ResourceRecordManager mgr = ResourceArenaManager.this.arenas[this.nextArena];
                LocalManager res = new LocalManager();
                res.mgr = mgr;
                res.arenaId = this.nextArena;
                this.nextArena = (this.nextArena + 1) % noArenas;
                return res;
            }
        };
    }

    public long allocate() {
        LocalManager localManager = this.local.get();
        ResourceRecordManager recMgr = localManager.mgr;
        int allocId = 0;
        int localId = recMgr.allocate();
        long result = TypeUtil.Global.build(localManager.arenaId, allocId, localId);
        assert (TypeUtil.Global.allocId(result) == allocId);
        assert (TypeUtil.Global.arenaId(result) == localManager.arenaId);
        assert (TypeUtil.Global.localId(result) == localId);
        return result;
    }

    public void deallocate(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        this.get(arenaId).deallocate(TypeUtil.Global.localId(slotNum));
    }

    public ResourceRecordManager get(int i) {
        return this.arenas[i];
    }

    public ResourceRecordManager local() {
        return this.local.get().mgr;
    }

    public long getLastHolder(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getLastHolder(localId);
    }

    public void setLastHolder(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setLastHolder(localId, value);
    }

    public long getFirstWaiter(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getFirstWaiter(localId);
    }

    public void setFirstWaiter(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setFirstWaiter(localId, value);
    }

    public long getFirstUpgrader(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getFirstUpgrader(localId);
    }

    public void setFirstUpgrader(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setFirstUpgrader(localId, value);
    }

    public long getNext(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getNext(localId);
    }

    public void setNext(long slotNum, long value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setNext(localId, value);
    }

    public int getMaxMode(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getMaxMode(localId);
    }

    public void setMaxMode(long slotNum, int value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setMaxMode(localId, value);
    }

    public int getDatasetId(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getDatasetId(localId);
    }

    public void setDatasetId(long slotNum, int value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setDatasetId(localId, value);
    }

    public int getPkHashVal(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getPkHashVal(localId);
    }

    public void setPkHashVal(long slotNum, int value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setPkHashVal(localId, value);
    }

    public short getAllocId(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        return this.get(arenaId).getAllocId(localId);
    }

    public void setAllocId(long slotNum, short value) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        int localId = TypeUtil.Global.localId(slotNum);
        this.get(arenaId).setAllocId(localId, value);
    }

    private void checkAllocId(long slotNum) {
        short curAllocId;
        int refAllocId = TypeUtil.Global.allocId(slotNum);
        if (refAllocId != (curAllocId = this.getAllocId(slotNum))) {
            String msg = "reference to slot " + TypeUtil.Global.toString(slotNum) + " of arena " + TypeUtil.Global.arenaId(slotNum) + " refers to version " + Integer.toHexString(refAllocId) + " current version is " + Integer.toHexString(curAllocId);
            AllocInfo a = this.getAllocInfo(slotNum);
            if (a != null) {
                msg = msg + "\n" + a.toString();
            }
            throw new IllegalStateException(msg);
        }
    }

    public AllocInfo getAllocInfo(long slotNum) {
        int arenaId = TypeUtil.Global.arenaId(slotNum);
        return this.get(arenaId).getAllocInfo(TypeUtil.Global.localId(slotNum));
    }

    public StringBuilder appendRecord(StringBuilder sb, long slotNum) {
        sb.append("{ ");
        sb.append("\"last holder\" : \"");
        sb = TypeUtil.Global.append(sb, this.getLastHolder(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"first waiter\" : \"");
        sb = TypeUtil.Global.append(sb, this.getFirstWaiter(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"first upgrader\" : \"");
        sb = TypeUtil.Global.append(sb, this.getFirstUpgrader(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"next\" : \"");
        sb = TypeUtil.Global.append(sb, this.getNext(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"max mode\" : \"");
        sb = TypeUtil.Int.append(sb, this.getMaxMode(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"dataset id\" : \"");
        sb = TypeUtil.Int.append(sb, this.getDatasetId(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"pk hash val\" : \"");
        sb = TypeUtil.Int.append(sb, this.getPkHashVal(slotNum));
        sb.append("\"");
        sb.append(", ");
        sb.append("\"alloc id\" : \"");
        sb = TypeUtil.Short.append(sb, this.getAllocId(slotNum));
        sb.append("\"");
        return sb.append(" }");
    }

    public StringBuilder append(StringBuilder sb) {
        for (int i = 0; i < this.noArenas; ++i) {
            sb.append("++++ arena ").append(i).append(" ++++\n");
            this.arenas[i].append(sb);
        }
        return sb;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public RecordManagerStats addTo(RecordManagerStats s) {
        s.arenas += this.noArenas;
        for (int i = 0; i < this.noArenas; ++i) {
            this.arenas[i].addTo(s);
        }
        return s;
    }

    static class LocalManager {
        int arenaId;
        ResourceRecordManager mgr;

        LocalManager() {
        }
    }
}

