/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.runtime;

import java.nio.ByteBuffer;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ILogMarkerCallback;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.io.MessagingFrameTupleAppender;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.bloomfilter.impls.MurmurHash128Bit;

public class CommitRuntime
extends AbstractOneInputOneOutputOneFramePushRuntime {
    protected static final long SEED = 0L;
    protected final ITransactionManager transactionManager;
    protected final ILogManager logMgr;
    protected final JobId jobId;
    protected final int datasetId;
    protected final int[] primaryKeyFields;
    protected final boolean isTemporaryDatasetWriteJob;
    protected final boolean isWriteTransaction;
    protected final long[] longHashes;
    protected final IHyracksTaskContext ctx;
    protected final int resourcePartition;
    protected ITransactionContext transactionContext;
    protected LogRecord logRecord;
    protected final boolean isSink;

    public CommitRuntime(IHyracksTaskContext ctx, JobId jobId, int datasetId, int[] primaryKeyFields, boolean isTemporaryDatasetWriteJob, boolean isWriteTransaction, int resourcePartition, boolean isSink) {
        this.ctx = ctx;
        IAppRuntimeContext appCtx = (IAppRuntimeContext)ctx.getJobletContext().getServiceContext().getApplicationContext();
        this.transactionManager = appCtx.getTransactionSubsystem().getTransactionManager();
        this.logMgr = appCtx.getTransactionSubsystem().getLogManager();
        this.jobId = jobId;
        this.datasetId = datasetId;
        this.primaryKeyFields = primaryKeyFields;
        this.tRef = new FrameTupleReference();
        this.isTemporaryDatasetWriteJob = isTemporaryDatasetWriteJob;
        this.isWriteTransaction = isWriteTransaction;
        this.resourcePartition = resourcePartition;
        this.isSink = isSink;
        this.longHashes = new long[2];
    }

    public void open() throws HyracksDataException {
        try {
            this.transactionContext = this.transactionManager.getTransactionContext(this.jobId, false);
            this.transactionContext.setWriteTxn(this.isWriteTransaction);
            ILogMarkerCallback callback = (ILogMarkerCallback)TaskUtil.get((String)"MARKER_CALLBACK", (IHyracksTaskContext)this.ctx);
            this.logRecord = new LogRecord(callback);
            if (this.isSink) {
                return;
            }
            this.initAccessAppend(this.ctx);
            this.writer.open();
        }
        catch (ACIDException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tAccess.reset(buffer);
        int nTuple = this.tAccess.getTupleCount();
        for (int t = 0; t < nTuple; ++t) {
            if (this.isTemporaryDatasetWriteJob) {
                this.transactionContext.notifyOptracker(false);
                continue;
            }
            this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
            try {
                this.formLogRecord(buffer, t);
                this.logMgr.log((ILogRecord)this.logRecord);
                if (this.isSink) continue;
                this.appendTupleToFrame(t);
                continue;
            }
            catch (ACIDException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        IFrame message = (IFrame)TaskUtil.get((String)"HYX:MSG", (IHyracksTaskContext)this.ctx);
        if (message != null && MessagingFrameTupleAppender.getMessageType((IFrame)message) == 3) {
            try {
                this.formMarkerLogRecords(message.getBuffer());
                this.logMgr.log((ILogRecord)this.logRecord);
            }
            catch (ACIDException e) {
                throw new HyracksDataException((Throwable)e);
            }
            message.reset();
            message.getBuffer().put((byte)1);
            message.getBuffer().flip();
        }
    }

    private void formMarkerLogRecords(ByteBuffer marker) {
        TransactionUtil.formMarkerLogRecord((LogRecord)this.logRecord, (ITransactionContext)this.transactionContext, (int)this.datasetId, (int)this.resourcePartition, (ByteBuffer)marker);
    }

    protected void formLogRecord(ByteBuffer buffer, int t) {
        int pkHash = this.computePrimaryKeyHashValue((ITupleReference)this.tRef, this.primaryKeyFields);
        TransactionUtil.formEntityCommitLogRecord((LogRecord)this.logRecord, (ITransactionContext)this.transactionContext, (int)this.datasetId, (int)pkHash, (ITupleReference)this.tRef, (int[])this.primaryKeyFields, (int)this.resourcePartition, (byte)2);
    }

    protected int computePrimaryKeyHashValue(ITupleReference tuple, int[] primaryKeyFields) {
        MurmurHash128Bit.hash3_x64_128((ITupleReference)tuple, (int[])primaryKeyFields, (long)0L, (long[])this.longHashes);
        return Math.abs((int)this.longHashes[0]);
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        if (this.isSink) {
            return;
        }
        this.writer.fail();
    }

    public void close() throws HyracksDataException {
        if (this.isSink) {
            return;
        }
        try {
            this.flushIfNotFailed();
        }
        catch (Exception e) {
            this.writer.fail();
            throw e;
        }
        finally {
            this.writer.close();
        }
        this.appender.reset(this.frame, true);
    }

    public void setInputRecordDescriptor(int index, RecordDescriptor recordDescriptor) {
        this.inputRecordDesc = recordDescriptor;
        this.tAccess = new FrameTupleAccessor(this.inputRecordDesc);
    }

    public void flush() throws HyracksDataException {
    }
}

