/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.opcallbacks;

import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.SimpleTupleWriter;

public abstract class AbstractIndexModificationOperationCallback
extends AbstractOperationCallback
implements IModificationOperationCallback {
    public static final byte INSERT_BYTE = 1;
    public static final byte DELETE_BYTE = 2;
    public static final byte UPSERT_BYTE = 3;
    protected final long resourceId;
    protected final byte resourceType;
    protected final Operation indexOp;
    protected final ITransactionSubsystem txnSubsystem;
    protected final ILogRecord logRecord;

    protected AbstractIndexModificationOperationCallback(DatasetId datasetId, int[] primaryKeyFields, ITransactionContext txnCtx, ILockManager lockManager, ITransactionSubsystem txnSubsystem, long resourceId, int resourcePartition, byte resourceType, Operation indexOp) {
        super(datasetId, primaryKeyFields, txnCtx, lockManager);
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.indexOp = indexOp;
        this.txnSubsystem = txnSubsystem;
        this.logRecord = new LogRecord();
        this.logRecord.setTxnCtx(txnCtx);
        this.logRecord.setLogType((byte)0);
        this.logRecord.setJobId(txnCtx.getJobId().getId());
        this.logRecord.setDatasetId(datasetId.getId());
        this.logRecord.setResourceId(resourceId);
        this.logRecord.setResourcePartition(resourcePartition);
        this.logRecord.setNewOp(indexOp.value());
    }

    protected void log(int PKHash, ITupleReference newValue, ITupleReference oldValue) throws ACIDException {
        this.logRecord.setPKHashValue(PKHash);
        this.logRecord.setPKFields(this.primaryKeyFields);
        this.logRecord.setPKValue(newValue);
        this.logRecord.computeAndSetPKValueSize();
        if (newValue != null) {
            this.logRecord.setNewValueSize(SimpleTupleWriter.INSTANCE.bytesRequired(newValue));
            this.logRecord.setNewValue(newValue);
        } else {
            this.logRecord.setNewValueSize(0);
        }
        if (oldValue != null) {
            this.logRecord.setOldValueSize(SimpleTupleWriter.INSTANCE.bytesRequired(oldValue));
            this.logRecord.setOldValue(oldValue);
        } else {
            this.logRecord.setOldValueSize(0);
        }
        this.logRecord.computeAndSetLogSize();
        this.txnSubsystem.getLogManager().log(this.logRecord);
    }

    public void setOp(Operation op) throws HyracksDataException {
        this.logRecord.setNewOp(op.value());
    }

    public static enum Operation {
        INSERT(1),
        DELETE(2),
        UPSERT(3);

        private byte value;

        private Operation(byte value) {
            this.value = value;
        }

        byte value() {
            return this.value;
        }

        public static Operation get(IndexOperation op) {
            switch (op) {
                case DELETE: {
                    return DELETE;
                }
                case INSERT: {
                    return INSERT;
                }
                case UPSERT: {
                    return UPSERT;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

