/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.util.ArrayList;
import java.util.Date;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.pattern.Pattern;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.StopConfig;
import org.apache.asterix.installer.driver.InstallerDriver;

public class StopCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((StopConfig)this.config).name;
        AsterixInstance asterixInstance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.ACTIVE, AsterixInstance.State.UNUSABLE});
        AsterixEventServiceClient client = AsterixEventService.getAsterixEventServiceClient((Cluster)asterixInstance.getCluster());
        ArrayList<Pattern> ncKillPatterns = new ArrayList<Pattern>();
        for (Node node : asterixInstance.getCluster().getNode()) {
            ncKillPatterns.add(PatternCreator.INSTANCE.createNCStopPattern(node.getId(), asterixInstanceName + "_" + node.getId()));
        }
        ArrayList<Pattern> ccKillPatterns = new ArrayList<Pattern>();
        ccKillPatterns.add(PatternCreator.INSTANCE.createCCStopPattern(asterixInstance.getCluster().getMasterNode().getId()));
        try {
            client.submit(new Patterns(ncKillPatterns));
            client.submit(new Patterns(ccKillPatterns));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Attempt to kill non-existing processess");
        }
        asterixInstance.setState(AsterixInstance.State.INACTIVE);
        asterixInstance.setStateChangeTimestamp(new Date());
        ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(asterixInstance);
        LOGGER.info((Object)("Stopped Asterix instance: " + asterixInstanceName));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new StopConfig();
    }

    public String getAsterixInstanceName() {
        return ((StopConfig)this.config).name;
    }

    @Override
    protected String getUsageDescription() {
        return "\nShuts an ASTERIX instance that is in ACTIVE/UNUSABLE state.\nAfter executing the stop command, the ASTERIX instance transits\nto the INACTIVE state, indicating that it is no longer available\nfor executing statements/queries.\n\nAvailable arguments/options\n-n name of the ASTERIX instance.";
    }
}

