/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.io.File;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.configuration.AsterixConfiguration;
import org.apache.asterix.event.error.VerificationUtil;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.management.EventUtil;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.AsterixRuntimeState;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ClusterStateWatcher;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.CreateConfig;
import org.apache.asterix.installer.command.ValidateCommand;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.driver.InstallerUtil;

public class CreateCommand
extends AbstractCommand {
    private String asterixInstanceName;
    private Cluster cluster;
    private AsterixConfiguration asterixConfiguration;

    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        ValidateCommand validateCommand = new ValidateCommand();
        boolean valid = validateCommand.validateCluster(((CreateConfig)this.config).clusterPath);
        if (!valid) {
            throw new Exception("Cannot create an Asterix instance.");
        }
        this.asterixInstanceName = ((CreateConfig)this.config).name;
        AsterixEventServiceUtil.validateAsterixInstanceNotExists((String)this.asterixInstanceName);
        CreateConfig createConfig = (CreateConfig)this.config;
        this.cluster = EventUtil.getCluster((String)createConfig.clusterPath);
        this.cluster.setInstanceName(this.asterixInstanceName);
        this.asterixConfiguration = InstallerUtil.getAsterixConfiguration(createConfig.asterixConfPath);
        AsterixInstance asterixInstance = AsterixEventServiceUtil.createAsterixInstance((String)this.asterixInstanceName, (Cluster)this.cluster, (AsterixConfiguration)this.asterixConfiguration);
        AsterixEventServiceUtil.evaluateConflictWithOtherInstances((AsterixInstance)asterixInstance);
        AsterixEventServiceUtil.createAsterixZip((AsterixInstance)asterixInstance);
        AsterixEventServiceUtil.createClusterProperties((Cluster)this.cluster, (AsterixConfiguration)this.asterixConfiguration);
        AsterixEventServiceClient eventrixClient = AsterixEventService.getAsterixEventServiceClient((Cluster)this.cluster, (boolean)true, (boolean)false);
        ServiceProvider.INSTANCE.getLookupService().writeAsterixInstance(asterixInstance);
        ClusterStateWatcher stateWatcher = ServiceProvider.INSTANCE.getLookupService().startWatchingClusterState(this.asterixInstanceName);
        Patterns asterixBinarytrasnferPattern = PatternCreator.INSTANCE.getAsterixBinaryTransferPattern(this.asterixInstanceName, this.cluster);
        eventrixClient.submit(asterixBinarytrasnferPattern);
        Patterns patterns = PatternCreator.INSTANCE.getStartAsterixPattern(this.asterixInstanceName, this.cluster, true);
        eventrixClient.submit(patterns);
        IClusterManagementWork.ClusterState clusterState = stateWatcher.waitForClusterStart();
        if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
            throw new Exception("CC failed to start");
        }
        AsterixRuntimeState runtimeState = VerificationUtil.getAsterixRuntimeState((AsterixInstance)asterixInstance);
        VerificationUtil.updateInstanceWithRuntimeDescription((AsterixInstance)asterixInstance, (AsterixRuntimeState)runtimeState, (boolean)true);
        ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(asterixInstance);
        AsterixEventServiceUtil.deleteDirectory((String)(InstallerDriver.getManagixHome() + File.separator + "asterix" + File.separator + this.asterixInstanceName));
        LOGGER.info((Object)asterixInstance.getDescription(false));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new CreateConfig();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getAsterixInstanceName() {
        return this.asterixInstanceName;
    }

    @Override
    protected String getUsageDescription() {
        return "\nCreates an ASTERIX instance with a specified name.\n\nPost creation, the instance is in ACTIVE state, indicating its \navailability for executing statements/queries.\n\nUsage arguments/options:\n-n Name of the ASTERIX instance.\n-c Path to the cluster configuration file\n[-a] Path to asterix configuration file\n [..] indicates optional flag";
    }
}

