/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;

public class PrimaryIndexOperationTracker
extends BaseOperationTracker {
    private final AtomicInteger numActiveOperations;
    private final ILogManager logManager;
    private boolean flushOnExit = false;
    private boolean flushLogCreated = false;

    public PrimaryIndexOperationTracker(int datasetID, ILogManager logManager, DatasetInfo dsInfo) {
        super(datasetID, dsInfo);
        this.logManager = logManager;
        this.numActiveOperations = new AtomicInteger();
    }

    @Override
    public void beforeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.incrementNumActiveOperations(modificationCallback);
        } else if (opType == LSMOperationType.FLUSH || opType == LSMOperationType.MERGE || opType == LSMOperationType.REPLICATE) {
            this.dsInfo.declareActiveIOOperation();
        }
    }

    @Override
    public void afterOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.FLUSH || opType == LSMOperationType.MERGE || opType == LSMOperationType.REPLICATE) {
            this.completeOperation(index, opType, searchCallback, modificationCallback);
        }
    }

    @Override
    public synchronized void completeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.decrementNumActiveOperations(modificationCallback);
            if (this.numActiveOperations.get() == 0) {
                this.flushIfRequested();
            } else if (this.numActiveOperations.get() < 0) {
                throw new HyracksDataException("The number of active operations cannot be negative!");
            }
        } else if (opType == LSMOperationType.FLUSH || opType == LSMOperationType.MERGE || opType == LSMOperationType.REPLICATE) {
            this.dsInfo.undeclareActiveIOOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIfRequested() throws HyracksDataException {
        boolean needsFlush = false;
        Set<ILSMIndex> indexes = this.dsInfo.getDatasetIndexes();
        if (!this.flushOnExit) {
            for (ILSMIndex lsmIndex : indexes) {
                if (!lsmIndex.hasFlushRequestForCurrentMutableComponent()) continue;
                needsFlush = true;
                break;
            }
        }
        if (needsFlush || this.flushOnExit) {
            for (ILSMIndex lsmIndex : indexes) {
                ILSMOperationTracker opTracker;
                AbstractLSMIndex abstractLSMIndex = (AbstractLSMIndex)lsmIndex;
                ILSMOperationTracker iLSMOperationTracker = opTracker = abstractLSMIndex.getOperationTracker();
                synchronized (iLSMOperationTracker) {
                    if (abstractLSMIndex.getCurrentMutableComponentState() == ILSMComponent.ComponentState.READABLE_WRITABLE) {
                        abstractLSMIndex.setCurrentMutableComponentState(ILSMComponent.ComponentState.READABLE_UNWRITABLE);
                    }
                }
            }
            LogRecord logRecord = new LogRecord();
            this.flushOnExit = false;
            if (this.dsInfo.isDurable()) {
                TransactionUtil.formFlushLogRecord(logRecord, this.datasetID, this, this.logManager.getNodeId(), this.dsInfo.getDatasetIndexes().size());
                try {
                    this.logManager.log(logRecord);
                }
                catch (ACIDException e) {
                    throw new HyracksDataException("could not write flush log", (Throwable)e);
                }
                this.flushLogCreated = true;
            } else {
                this.triggerScheduleFlush(logRecord);
            }
        }
    }

    public synchronized void triggerScheduleFlush(LogRecord logRecord) throws HyracksDataException {
        for (ILSMIndex lsmIndex : this.dsInfo.getDatasetIndexes()) {
            ILSMIndexAccessor accessor = lsmIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            AbstractLSMIOOperationCallback ioOpCallback = (AbstractLSMIOOperationCallback)lsmIndex.getIOOperationCallback();
            ioOpCallback.updateLastLSN(logRecord.getLSN());
            accessor.scheduleFlush(lsmIndex.getIOOperationCallback());
        }
        this.flushLogCreated = false;
    }

    @Override
    public void exclusiveJobCommitted() throws HyracksDataException {
        this.numActiveOperations.set(0);
        this.flushIfRequested();
    }

    public int getNumActiveOperations() {
        return this.numActiveOperations.get();
    }

    private void incrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            this.numActiveOperations.incrementAndGet();
            ((AbstractOperationCallback)modificationCallback).incrementLocalNumActiveOperations();
        }
    }

    private void decrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            this.numActiveOperations.decrementAndGet();
            ((AbstractOperationCallback)modificationCallback).decrementLocalNumActiveOperations();
        }
    }

    public void cleanupNumActiveOperationsForAbortedJob(int numberOfActiveOperations) {
        this.numActiveOperations.getAndAdd(numberOfActiveOperations *= -1);
    }

    public boolean isFlushOnExit() {
        return this.flushOnExit;
    }

    public void setFlushOnExit(boolean flushOnExit) {
        this.flushOnExit = flushOnExit;
    }

    public boolean isFlushLogCreated() {
        return this.flushLogCreated;
    }
}

