/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.ReplicationStrategyFactory;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.cluster.Replica;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ClusterProperties {
    public static final ClusterProperties INSTANCE = new ClusterProperties();
    private static final String CLUSTER_CONFIGURATION_FILE = "cluster.xml";
    private static final String DEFAULT_STORAGE_DIR_NAME = "storage";
    private String nodeNamePrefix = "";
    private Cluster cluster;

    private ClusterProperties() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(CLUSTER_CONFIGURATION_FILE);
        if (is != null) {
            try {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Cluster.class});
                Unmarshaller unmarshaller = ctx.createUnmarshaller();
                this.cluster = (Cluster)unmarshaller.unmarshal(is);
                this.nodeNamePrefix = this.cluster.getInstanceName() + "_";
                this.updateNodeIdToFullName();
            }
            catch (JAXBException e) {
                throw new IllegalStateException("Failed to read configuration file cluster.xml", e);
            }
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getStorageDirectoryName() {
        if (this.cluster != null) {
            return this.cluster.getStore();
        }
        return DEFAULT_STORAGE_DIR_NAME;
    }

    public Node getNodeById(String nodeId) {
        Optional<Node> matchingNode = this.cluster.getNode().stream().filter(node -> node.getId().equals(nodeId)).findAny();
        return matchingNode.isPresent() ? matchingNode.get() : null;
    }

    public int getNodeIndex(String nodeId) {
        for (int i = 0; i < this.cluster.getNode().size(); ++i) {
            Node node = this.cluster.getNode().get(i);
            if (!node.getId().equals(nodeId)) continue;
            return i;
        }
        return -1;
    }

    public IReplicationStrategy getReplicationStrategy() throws HyracksDataException {
        return ReplicationStrategyFactory.create(this.cluster);
    }

    private String getNodeFullName(String nodeId) {
        if (nodeId.startsWith(this.nodeNamePrefix)) {
            return nodeId;
        }
        return this.nodeNamePrefix + nodeId;
    }

    private void updateNodeIdToFullName() {
        this.cluster.getNode().forEach(node -> node.setId(this.getNodeFullName(node.getId())));
        if (this.cluster.getMetadataNode() != null) {
            this.cluster.setMetadataNode(this.getNodeFullName(this.cluster.getMetadataNode()));
        }
        if (this.cluster.getHighAvailability() != null && this.cluster.getHighAvailability().getFaultTolerance() != null && this.cluster.getHighAvailability().getFaultTolerance().getReplica() != null) {
            Replica replicas = this.cluster.getHighAvailability().getFaultTolerance().getReplica();
            replicas.setNodeId(replicas.getNodeId().stream().map(this::getNodeFullName).collect(Collectors.toList()));
        }
    }
}

