// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#![allow(dead_code)]
#![allow(unused_imports)]

use flatbuffers::EndianScalar;
use std::{cmp::Ordering, mem};
// automatically generated by the FlatBuffers compiler, do not modify

#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_METADATA_VERSION: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_METADATA_VERSION: i16 = 4;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_METADATA_VERSION: [MetadataVersion; 5] = [
    MetadataVersion::V1,
    MetadataVersion::V2,
    MetadataVersion::V3,
    MetadataVersion::V4,
    MetadataVersion::V5,
];

#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct MetadataVersion(pub i16);
#[allow(non_upper_case_globals)]
impl MetadataVersion {
    /// 0.1.0 (October 2016).
    pub const V1: Self = Self(0);
    /// 0.2.0 (February 2017). Non-backwards compatible with V1.
    pub const V2: Self = Self(1);
    /// 0.3.0 -> 0.7.1 (May - December 2017). Non-backwards compatible with V2.
    pub const V3: Self = Self(2);
    /// >= 0.8.0 (December 2017). Non-backwards compatible with V3.
    pub const V4: Self = Self(3);
    /// >= 1.0.0 (July 2020. Backwards compatible with V4 (V5 readers can read V4
    /// metadata and IPC messages). Implementations are recommended to provide a
    /// V4 compatibility mode with V5 format changes disabled.
    ///
    /// Incompatible changes between V4 and V5:
    /// - Union buffer layout has changed. In V5, Unions don't have a validity
    ///   bitmap buffer.
    pub const V5: Self = Self(4);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 4;
    pub const ENUM_VALUES: &'static [Self] =
        &[Self::V1, Self::V2, Self::V3, Self::V4, Self::V5];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::V1 => Some("V1"),
            Self::V2 => Some("V2"),
            Self::V3 => Some("V3"),
            Self::V4 => Some("V4"),
            Self::V5 => Some("V5"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for MetadataVersion {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for MetadataVersion {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for MetadataVersion {
    type Output = MetadataVersion;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for MetadataVersion {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for MetadataVersion {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for MetadataVersion {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_FEATURE: i64 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_FEATURE: i64 = 2;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_FEATURE: [Feature; 3] = [
    Feature::UNUSED,
    Feature::DICTIONARY_REPLACEMENT,
    Feature::COMPRESSED_BODY,
];

/// Represents Arrow Features that might not have full support
/// within implementations. This is intended to be used in
/// two scenarios:
///  1.  A mechanism for readers of Arrow Streams
///      and files to understand that the stream or file makes
///      use of a feature that isn't supported or unknown to
///      the implementation (and therefore can meet the Arrow
///      forward compatibility guarantees).
///  2.  A means of negotiating between a client and server
///      what features a stream is allowed to use. The enums
///      values here are intented to represent higher level
///      features, additional details maybe negotiated
///      with key-value pairs specific to the protocol.
///
/// Enums added to this list should be assigned power-of-two values
/// to facilitate exchanging and comparing bitmaps for supported
/// features.
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct Feature(pub i64);
#[allow(non_upper_case_globals)]
impl Feature {
    /// Needed to make flatbuffers happy.
    pub const UNUSED: Self = Self(0);
    /// The stream makes use of multiple full dictionaries with the
    /// same ID and assumes clients implement dictionary replacement
    /// correctly.
    pub const DICTIONARY_REPLACEMENT: Self = Self(1);
    /// The stream makes use of compressed bodies as described
    /// in Message.fbs.
    pub const COMPRESSED_BODY: Self = Self(2);

    pub const ENUM_MIN: i64 = 0;
    pub const ENUM_MAX: i64 = 2;
    pub const ENUM_VALUES: &'static [Self] = &[
        Self::UNUSED,
        Self::DICTIONARY_REPLACEMENT,
        Self::COMPRESSED_BODY,
    ];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::UNUSED => Some("UNUSED"),
            Self::DICTIONARY_REPLACEMENT => Some("DICTIONARY_REPLACEMENT"),
            Self::COMPRESSED_BODY => Some("COMPRESSED_BODY"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for Feature {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for Feature {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i64>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for Feature {
    type Output = Feature;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i64>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for Feature {
    type Scalar = i64;
    #[inline]
    fn to_little_endian(self) -> i64 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i64) -> Self {
        let b = i64::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for Feature {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i64::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for Feature {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_UNION_MODE: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_UNION_MODE: i16 = 1;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_UNION_MODE: [UnionMode; 2] = [UnionMode::Sparse, UnionMode::Dense];

#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct UnionMode(pub i16);
#[allow(non_upper_case_globals)]
impl UnionMode {
    pub const Sparse: Self = Self(0);
    pub const Dense: Self = Self(1);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 1;
    pub const ENUM_VALUES: &'static [Self] = &[Self::Sparse, Self::Dense];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::Sparse => Some("Sparse"),
            Self::Dense => Some("Dense"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for UnionMode {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for UnionMode {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for UnionMode {
    type Output = UnionMode;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for UnionMode {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for UnionMode {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for UnionMode {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_PRECISION: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_PRECISION: i16 = 2;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_PRECISION: [Precision; 3] =
    [Precision::HALF, Precision::SINGLE, Precision::DOUBLE];

#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct Precision(pub i16);
#[allow(non_upper_case_globals)]
impl Precision {
    pub const HALF: Self = Self(0);
    pub const SINGLE: Self = Self(1);
    pub const DOUBLE: Self = Self(2);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 2;
    pub const ENUM_VALUES: &'static [Self] = &[Self::HALF, Self::SINGLE, Self::DOUBLE];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::HALF => Some("HALF"),
            Self::SINGLE => Some("SINGLE"),
            Self::DOUBLE => Some("DOUBLE"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for Precision {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for Precision {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for Precision {
    type Output = Precision;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for Precision {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for Precision {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for Precision {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_DATE_UNIT: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_DATE_UNIT: i16 = 1;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_DATE_UNIT: [DateUnit; 2] = [DateUnit::DAY, DateUnit::MILLISECOND];

#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct DateUnit(pub i16);
#[allow(non_upper_case_globals)]
impl DateUnit {
    pub const DAY: Self = Self(0);
    pub const MILLISECOND: Self = Self(1);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 1;
    pub const ENUM_VALUES: &'static [Self] = &[Self::DAY, Self::MILLISECOND];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::DAY => Some("DAY"),
            Self::MILLISECOND => Some("MILLISECOND"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for DateUnit {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for DateUnit {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for DateUnit {
    type Output = DateUnit;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for DateUnit {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for DateUnit {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for DateUnit {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_TIME_UNIT: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_TIME_UNIT: i16 = 3;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_TIME_UNIT: [TimeUnit; 4] = [
    TimeUnit::SECOND,
    TimeUnit::MILLISECOND,
    TimeUnit::MICROSECOND,
    TimeUnit::NANOSECOND,
];

#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct TimeUnit(pub i16);
#[allow(non_upper_case_globals)]
impl TimeUnit {
    pub const SECOND: Self = Self(0);
    pub const MILLISECOND: Self = Self(1);
    pub const MICROSECOND: Self = Self(2);
    pub const NANOSECOND: Self = Self(3);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 3;
    pub const ENUM_VALUES: &'static [Self] = &[
        Self::SECOND,
        Self::MILLISECOND,
        Self::MICROSECOND,
        Self::NANOSECOND,
    ];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::SECOND => Some("SECOND"),
            Self::MILLISECOND => Some("MILLISECOND"),
            Self::MICROSECOND => Some("MICROSECOND"),
            Self::NANOSECOND => Some("NANOSECOND"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for TimeUnit {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for TimeUnit {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for TimeUnit {
    type Output = TimeUnit;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for TimeUnit {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for TimeUnit {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for TimeUnit {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_INTERVAL_UNIT: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_INTERVAL_UNIT: i16 = 2;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_INTERVAL_UNIT: [IntervalUnit; 3] = [
    IntervalUnit::YEAR_MONTH,
    IntervalUnit::DAY_TIME,
    IntervalUnit::MONTH_DAY_NANO,
];

#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct IntervalUnit(pub i16);
#[allow(non_upper_case_globals)]
impl IntervalUnit {
    pub const YEAR_MONTH: Self = Self(0);
    pub const DAY_TIME: Self = Self(1);
    pub const MONTH_DAY_NANO: Self = Self(2);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 2;
    pub const ENUM_VALUES: &'static [Self] =
        &[Self::YEAR_MONTH, Self::DAY_TIME, Self::MONTH_DAY_NANO];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::YEAR_MONTH => Some("YEAR_MONTH"),
            Self::DAY_TIME => Some("DAY_TIME"),
            Self::MONTH_DAY_NANO => Some("MONTH_DAY_NANO"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for IntervalUnit {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for IntervalUnit {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for IntervalUnit {
    type Output = IntervalUnit;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for IntervalUnit {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for IntervalUnit {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for IntervalUnit {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_TYPE: u8 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_TYPE: u8 = 22;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_TYPE: [Type; 23] = [
    Type::NONE,
    Type::Null,
    Type::Int,
    Type::FloatingPoint,
    Type::Binary,
    Type::Utf8,
    Type::Bool,
    Type::Decimal,
    Type::Date,
    Type::Time,
    Type::Timestamp,
    Type::Interval,
    Type::List,
    Type::Struct_,
    Type::Union,
    Type::FixedSizeBinary,
    Type::FixedSizeList,
    Type::Map,
    Type::Duration,
    Type::LargeBinary,
    Type::LargeUtf8,
    Type::LargeList,
    Type::RunEndEncoded,
];

/// ----------------------------------------------------------------------
/// Top-level Type value, enabling extensible type-specific metadata. We can
/// add new logical types to Type without breaking backwards compatibility
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct Type(pub u8);
#[allow(non_upper_case_globals)]
impl Type {
    pub const NONE: Self = Self(0);
    pub const Null: Self = Self(1);
    pub const Int: Self = Self(2);
    pub const FloatingPoint: Self = Self(3);
    pub const Binary: Self = Self(4);
    pub const Utf8: Self = Self(5);
    pub const Bool: Self = Self(6);
    pub const Decimal: Self = Self(7);
    pub const Date: Self = Self(8);
    pub const Time: Self = Self(9);
    pub const Timestamp: Self = Self(10);
    pub const Interval: Self = Self(11);
    pub const List: Self = Self(12);
    pub const Struct_: Self = Self(13);
    pub const Union: Self = Self(14);
    pub const FixedSizeBinary: Self = Self(15);
    pub const FixedSizeList: Self = Self(16);
    pub const Map: Self = Self(17);
    pub const Duration: Self = Self(18);
    pub const LargeBinary: Self = Self(19);
    pub const LargeUtf8: Self = Self(20);
    pub const LargeList: Self = Self(21);
    pub const RunEndEncoded: Self = Self(22);

    pub const ENUM_MIN: u8 = 0;
    pub const ENUM_MAX: u8 = 22;
    pub const ENUM_VALUES: &'static [Self] = &[
        Self::NONE,
        Self::Null,
        Self::Int,
        Self::FloatingPoint,
        Self::Binary,
        Self::Utf8,
        Self::Bool,
        Self::Decimal,
        Self::Date,
        Self::Time,
        Self::Timestamp,
        Self::Interval,
        Self::List,
        Self::Struct_,
        Self::Union,
        Self::FixedSizeBinary,
        Self::FixedSizeList,
        Self::Map,
        Self::Duration,
        Self::LargeBinary,
        Self::LargeUtf8,
        Self::LargeList,
        Self::RunEndEncoded,
    ];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::NONE => Some("NONE"),
            Self::Null => Some("Null"),
            Self::Int => Some("Int"),
            Self::FloatingPoint => Some("FloatingPoint"),
            Self::Binary => Some("Binary"),
            Self::Utf8 => Some("Utf8"),
            Self::Bool => Some("Bool"),
            Self::Decimal => Some("Decimal"),
            Self::Date => Some("Date"),
            Self::Time => Some("Time"),
            Self::Timestamp => Some("Timestamp"),
            Self::Interval => Some("Interval"),
            Self::List => Some("List"),
            Self::Struct_ => Some("Struct_"),
            Self::Union => Some("Union"),
            Self::FixedSizeBinary => Some("FixedSizeBinary"),
            Self::FixedSizeList => Some("FixedSizeList"),
            Self::Map => Some("Map"),
            Self::Duration => Some("Duration"),
            Self::LargeBinary => Some("LargeBinary"),
            Self::LargeUtf8 => Some("LargeUtf8"),
            Self::LargeList => Some("LargeList"),
            Self::RunEndEncoded => Some("RunEndEncoded"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for Type {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for Type {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<u8>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for Type {
    type Output = Type;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<u8>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for Type {
    type Scalar = u8;
    #[inline]
    fn to_little_endian(self) -> u8 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: u8) -> Self {
        let b = u8::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for Type {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        u8::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for Type {}
pub struct TypeUnionTableOffset {}

#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_DICTIONARY_KIND: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_DICTIONARY_KIND: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_DICTIONARY_KIND: [DictionaryKind; 1] = [DictionaryKind::DenseArray];

/// ----------------------------------------------------------------------
/// Dictionary encoding metadata
/// Maintained for forwards compatibility, in the future
/// Dictionaries might be explicit maps between integers and values
/// allowing for non-contiguous index values
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct DictionaryKind(pub i16);
#[allow(non_upper_case_globals)]
impl DictionaryKind {
    pub const DenseArray: Self = Self(0);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 0;
    pub const ENUM_VALUES: &'static [Self] = &[Self::DenseArray];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::DenseArray => Some("DenseArray"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for DictionaryKind {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for DictionaryKind {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for DictionaryKind {
    type Output = DictionaryKind;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for DictionaryKind {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for DictionaryKind {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for DictionaryKind {}
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MIN_ENDIANNESS: i16 = 0;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
pub const ENUM_MAX_ENDIANNESS: i16 = 1;
#[deprecated(
    since = "2.0.0",
    note = "Use associated constants instead. This will no longer be generated in 2021."
)]
#[allow(non_camel_case_types)]
pub const ENUM_VALUES_ENDIANNESS: [Endianness; 2] = [Endianness::Little, Endianness::Big];

/// ----------------------------------------------------------------------
/// Endianness of the platform producing the data
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash, Default)]
#[repr(transparent)]
pub struct Endianness(pub i16);
#[allow(non_upper_case_globals)]
impl Endianness {
    pub const Little: Self = Self(0);
    pub const Big: Self = Self(1);

    pub const ENUM_MIN: i16 = 0;
    pub const ENUM_MAX: i16 = 1;
    pub const ENUM_VALUES: &'static [Self] = &[Self::Little, Self::Big];
    /// Returns the variant's name or "" if unknown.
    pub fn variant_name(self) -> Option<&'static str> {
        match self {
            Self::Little => Some("Little"),
            Self::Big => Some("Big"),
            _ => None,
        }
    }
}
impl core::fmt::Debug for Endianness {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        if let Some(name) = self.variant_name() {
            f.write_str(name)
        } else {
            f.write_fmt(format_args!("<UNKNOWN {:?}>", self.0))
        }
    }
}
impl<'a> flatbuffers::Follow<'a> for Endianness {
    type Inner = Self;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        let b = flatbuffers::read_scalar_at::<i16>(buf, loc);
        Self(b)
    }
}

impl flatbuffers::Push for Endianness {
    type Output = Endianness;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        flatbuffers::emplace_scalar::<i16>(dst, self.0);
    }
}

impl flatbuffers::EndianScalar for Endianness {
    type Scalar = i16;
    #[inline]
    fn to_little_endian(self) -> i16 {
        self.0.to_le()
    }
    #[inline]
    #[allow(clippy::wrong_self_convention)]
    fn from_little_endian(v: i16) -> Self {
        let b = i16::from_le(v);
        Self(b)
    }
}

impl<'a> flatbuffers::Verifiable for Endianness {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        i16::run_verifier(v, pos)
    }
}

impl flatbuffers::SimpleToVerifyInSlice for Endianness {}
/// ----------------------------------------------------------------------
/// A Buffer represents a single contiguous memory segment
// struct Buffer, aligned to 8
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq)]
pub struct Buffer(pub [u8; 16]);
impl Default for Buffer {
    fn default() -> Self {
        Self([0; 16])
    }
}
impl core::fmt::Debug for Buffer {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("Buffer")
            .field("offset", &self.offset())
            .field("length", &self.length())
            .finish()
    }
}

impl flatbuffers::SimpleToVerifyInSlice for Buffer {}
impl<'a> flatbuffers::Follow<'a> for Buffer {
    type Inner = &'a Buffer;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        <&'a Buffer>::follow(buf, loc)
    }
}
impl<'a> flatbuffers::Follow<'a> for &'a Buffer {
    type Inner = &'a Buffer;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        flatbuffers::follow_cast_ref::<Buffer>(buf, loc)
    }
}
impl<'b> flatbuffers::Push for Buffer {
    type Output = Buffer;
    #[inline]
    unsafe fn push(&self, dst: &mut [u8], _written_len: usize) {
        let src = ::core::slice::from_raw_parts(
            self as *const Buffer as *const u8,
            Self::size(),
        );
        dst.copy_from_slice(src);
    }
}

impl<'a> flatbuffers::Verifiable for Buffer {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.in_buffer::<Self>(pos)
    }
}

impl<'a> Buffer {
    #[allow(clippy::too_many_arguments)]
    pub fn new(offset: i64, length: i64) -> Self {
        let mut s = Self([0; 16]);
        s.set_offset(offset);
        s.set_length(length);
        s
    }

    /// The relative offset into the shared memory page where the bytes for this
    /// buffer starts
    pub fn offset(&self) -> i64 {
        let mut mem = core::mem::MaybeUninit::<<i64 as EndianScalar>::Scalar>::uninit();
        // Safety:
        // Created from a valid Table for this object
        // Which contains a valid value in this slot
        EndianScalar::from_little_endian(unsafe {
            core::ptr::copy_nonoverlapping(
                self.0[0..].as_ptr(),
                mem.as_mut_ptr() as *mut u8,
                core::mem::size_of::<<i64 as EndianScalar>::Scalar>(),
            );
            mem.assume_init()
        })
    }

    pub fn set_offset(&mut self, x: i64) {
        let x_le = x.to_little_endian();
        // Safety:
        // Created from a valid Table for this object
        // Which contains a valid value in this slot
        unsafe {
            core::ptr::copy_nonoverlapping(
                &x_le as *const _ as *const u8,
                self.0[0..].as_mut_ptr(),
                core::mem::size_of::<<i64 as EndianScalar>::Scalar>(),
            );
        }
    }

    /// The absolute length (in bytes) of the memory buffer. The memory is found
    /// from offset (inclusive) to offset + length (non-inclusive). When building
    /// messages using the encapsulated IPC message, padding bytes may be written
    /// after a buffer, but such padding bytes do not need to be accounted for in
    /// the size here.
    pub fn length(&self) -> i64 {
        let mut mem = core::mem::MaybeUninit::<<i64 as EndianScalar>::Scalar>::uninit();
        // Safety:
        // Created from a valid Table for this object
        // Which contains a valid value in this slot
        EndianScalar::from_little_endian(unsafe {
            core::ptr::copy_nonoverlapping(
                self.0[8..].as_ptr(),
                mem.as_mut_ptr() as *mut u8,
                core::mem::size_of::<<i64 as EndianScalar>::Scalar>(),
            );
            mem.assume_init()
        })
    }

    pub fn set_length(&mut self, x: i64) {
        let x_le = x.to_little_endian();
        // Safety:
        // Created from a valid Table for this object
        // Which contains a valid value in this slot
        unsafe {
            core::ptr::copy_nonoverlapping(
                &x_le as *const _ as *const u8,
                self.0[8..].as_mut_ptr(),
                core::mem::size_of::<<i64 as EndianScalar>::Scalar>(),
            );
        }
    }
}

pub enum NullOffset {}
#[derive(Copy, Clone, PartialEq)]

/// These are stored in the flatbuffer in the Type union below
pub struct Null<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Null<'a> {
    type Inner = Null<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Null<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Null { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args NullArgs,
    ) -> flatbuffers::WIPOffset<Null<'bldr>> {
        let mut builder = NullBuilder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for Null<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct NullArgs {}
impl<'a> Default for NullArgs {
    #[inline]
    fn default() -> Self {
        NullArgs {}
    }
}

pub struct NullBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> NullBuilder<'a, 'b> {
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> NullBuilder<'a, 'b> {
        let start = _fbb.start_table();
        NullBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Null<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Null<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Null");
        ds.finish()
    }
}
pub enum Struct_Offset {}
#[derive(Copy, Clone, PartialEq)]

/// A Struct_ in the flatbuffer metadata is the same as an Arrow Struct
/// (according to the physical memory layout). We used Struct_ here as
/// Struct is a reserved word in Flatbuffers
pub struct Struct_<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Struct_<'a> {
    type Inner = Struct_<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Struct_<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Struct_ { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args Struct_Args,
    ) -> flatbuffers::WIPOffset<Struct_<'bldr>> {
        let mut builder = Struct_Builder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for Struct_<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct Struct_Args {}
impl<'a> Default for Struct_Args {
    #[inline]
    fn default() -> Self {
        Struct_Args {}
    }
}

pub struct Struct_Builder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> Struct_Builder<'a, 'b> {
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> Struct_Builder<'a, 'b> {
        let start = _fbb.start_table();
        Struct_Builder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Struct_<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Struct_<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Struct_");
        ds.finish()
    }
}
pub enum ListOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct List<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for List<'a> {
    type Inner = List<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> List<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        List { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args ListArgs,
    ) -> flatbuffers::WIPOffset<List<'bldr>> {
        let mut builder = ListBuilder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for List<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct ListArgs {}
impl<'a> Default for ListArgs {
    #[inline]
    fn default() -> Self {
        ListArgs {}
    }
}

pub struct ListBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> ListBuilder<'a, 'b> {
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> ListBuilder<'a, 'b> {
        let start = _fbb.start_table();
        ListBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<List<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for List<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("List");
        ds.finish()
    }
}
pub enum LargeListOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Same as List, but with 64-bit offsets, allowing to represent
/// extremely large data values.
pub struct LargeList<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for LargeList<'a> {
    type Inner = LargeList<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> LargeList<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        LargeList { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args LargeListArgs,
    ) -> flatbuffers::WIPOffset<LargeList<'bldr>> {
        let mut builder = LargeListBuilder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for LargeList<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct LargeListArgs {}
impl<'a> Default for LargeListArgs {
    #[inline]
    fn default() -> Self {
        LargeListArgs {}
    }
}

pub struct LargeListBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> LargeListBuilder<'a, 'b> {
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> LargeListBuilder<'a, 'b> {
        let start = _fbb.start_table();
        LargeListBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<LargeList<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for LargeList<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("LargeList");
        ds.finish()
    }
}
pub enum FixedSizeListOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct FixedSizeList<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for FixedSizeList<'a> {
    type Inner = FixedSizeList<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> FixedSizeList<'a> {
    pub const VT_LISTSIZE: flatbuffers::VOffsetT = 4;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        FixedSizeList { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args FixedSizeListArgs,
    ) -> flatbuffers::WIPOffset<FixedSizeList<'bldr>> {
        let mut builder = FixedSizeListBuilder::new(_fbb);
        builder.add_listSize(args.listSize);
        builder.finish()
    }

    /// Number of list items per value
    #[inline]
    pub fn listSize(&self) -> i32 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<i32>(FixedSizeList::VT_LISTSIZE, Some(0))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for FixedSizeList<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<i32>("listSize", Self::VT_LISTSIZE, false)?
            .finish();
        Ok(())
    }
}
pub struct FixedSizeListArgs {
    pub listSize: i32,
}
impl<'a> Default for FixedSizeListArgs {
    #[inline]
    fn default() -> Self {
        FixedSizeListArgs { listSize: 0 }
    }
}

pub struct FixedSizeListBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> FixedSizeListBuilder<'a, 'b> {
    #[inline]
    pub fn add_listSize(&mut self, listSize: i32) {
        self.fbb_
            .push_slot::<i32>(FixedSizeList::VT_LISTSIZE, listSize, 0);
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> FixedSizeListBuilder<'a, 'b> {
        let start = _fbb.start_table();
        FixedSizeListBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<FixedSizeList<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for FixedSizeList<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("FixedSizeList");
        ds.field("listSize", &self.listSize());
        ds.finish()
    }
}
pub enum MapOffset {}
#[derive(Copy, Clone, PartialEq)]

/// A Map is a logical nested type that is represented as
///
/// List<entries: Struct<key: K, value: V>>
///
/// In this layout, the keys and values are each respectively contiguous. We do
/// not constrain the key and value types, so the application is responsible
/// for ensuring that the keys are hashable and unique. Whether the keys are sorted
/// may be set in the metadata for this field.
///
/// In a field with Map type, the field has a child Struct field, which then
/// has two children: key type and the second the value type. The names of the
/// child fields may be respectively "entries", "key", and "value", but this is
/// not enforced.
///
/// Map
/// ```text
///   - child[0] entries: Struct
///     - child[0] key: K
///     - child[1] value: V
/// ```
/// Neither the "entries" field nor the "key" field may be nullable.
///
/// The metadata is structured so that Arrow systems without special handling
/// for Map can make Map an alias for List. The "layout" attribute for the Map
/// field must have the same contents as a List.
pub struct Map<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Map<'a> {
    type Inner = Map<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Map<'a> {
    pub const VT_KEYSSORTED: flatbuffers::VOffsetT = 4;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Map { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args MapArgs,
    ) -> flatbuffers::WIPOffset<Map<'bldr>> {
        let mut builder = MapBuilder::new(_fbb);
        builder.add_keysSorted(args.keysSorted);
        builder.finish()
    }

    /// Set to true if the keys within each value are sorted
    #[inline]
    pub fn keysSorted(&self) -> bool {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<bool>(Map::VT_KEYSSORTED, Some(false))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for Map<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<bool>("keysSorted", Self::VT_KEYSSORTED, false)?
            .finish();
        Ok(())
    }
}
pub struct MapArgs {
    pub keysSorted: bool,
}
impl<'a> Default for MapArgs {
    #[inline]
    fn default() -> Self {
        MapArgs { keysSorted: false }
    }
}

pub struct MapBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> MapBuilder<'a, 'b> {
    #[inline]
    pub fn add_keysSorted(&mut self, keysSorted: bool) {
        self.fbb_
            .push_slot::<bool>(Map::VT_KEYSSORTED, keysSorted, false);
    }
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> MapBuilder<'a, 'b> {
        let start = _fbb.start_table();
        MapBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Map<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Map<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Map");
        ds.field("keysSorted", &self.keysSorted());
        ds.finish()
    }
}
pub enum UnionOffset {}
#[derive(Copy, Clone, PartialEq)]

/// A union is a complex type with children in Field
/// By default ids in the type vector refer to the offsets in the children
/// optionally typeIds provides an indirection between the child offset and the type id
/// for each child `typeIds[offset]` is the id used in the type vector
pub struct Union<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Union<'a> {
    type Inner = Union<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Union<'a> {
    pub const VT_MODE: flatbuffers::VOffsetT = 4;
    pub const VT_TYPEIDS: flatbuffers::VOffsetT = 6;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Union { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args UnionArgs<'args>,
    ) -> flatbuffers::WIPOffset<Union<'bldr>> {
        let mut builder = UnionBuilder::new(_fbb);
        if let Some(x) = args.typeIds {
            builder.add_typeIds(x);
        }
        builder.add_mode(args.mode);
        builder.finish()
    }

    #[inline]
    pub fn mode(&self) -> UnionMode {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<UnionMode>(Union::VT_MODE, Some(UnionMode::Sparse))
                .unwrap()
        }
    }
    #[inline]
    pub fn typeIds(&self) -> Option<flatbuffers::Vector<'a, i32>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, i32>>>(
                    Union::VT_TYPEIDS,
                    None,
                )
        }
    }
}

impl flatbuffers::Verifiable for Union<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<UnionMode>("mode", Self::VT_MODE, false)?
            .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, i32>>>(
                "typeIds",
                Self::VT_TYPEIDS,
                false,
            )?
            .finish();
        Ok(())
    }
}
pub struct UnionArgs<'a> {
    pub mode: UnionMode,
    pub typeIds: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, i32>>>,
}
impl<'a> Default for UnionArgs<'a> {
    #[inline]
    fn default() -> Self {
        UnionArgs {
            mode: UnionMode::Sparse,
            typeIds: None,
        }
    }
}

pub struct UnionBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> UnionBuilder<'a, 'b> {
    #[inline]
    pub fn add_mode(&mut self, mode: UnionMode) {
        self.fbb_
            .push_slot::<UnionMode>(Union::VT_MODE, mode, UnionMode::Sparse);
    }
    #[inline]
    pub fn add_typeIds(
        &mut self,
        typeIds: flatbuffers::WIPOffset<flatbuffers::Vector<'b, i32>>,
    ) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(Union::VT_TYPEIDS, typeIds);
    }
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> UnionBuilder<'a, 'b> {
        let start = _fbb.start_table();
        UnionBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Union<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Union<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Union");
        ds.field("mode", &self.mode());
        ds.field("typeIds", &self.typeIds());
        ds.finish()
    }
}
pub enum IntOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct Int<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Int<'a> {
    type Inner = Int<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Int<'a> {
    pub const VT_BITWIDTH: flatbuffers::VOffsetT = 4;
    pub const VT_IS_SIGNED: flatbuffers::VOffsetT = 6;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Int { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args IntArgs,
    ) -> flatbuffers::WIPOffset<Int<'bldr>> {
        let mut builder = IntBuilder::new(_fbb);
        builder.add_bitWidth(args.bitWidth);
        builder.add_is_signed(args.is_signed);
        builder.finish()
    }

    #[inline]
    pub fn bitWidth(&self) -> i32 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe { self._tab.get::<i32>(Int::VT_BITWIDTH, Some(0)).unwrap() }
    }
    #[inline]
    pub fn is_signed(&self) -> bool {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<bool>(Int::VT_IS_SIGNED, Some(false))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for Int<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<i32>("bitWidth", Self::VT_BITWIDTH, false)?
            .visit_field::<bool>("is_signed", Self::VT_IS_SIGNED, false)?
            .finish();
        Ok(())
    }
}
pub struct IntArgs {
    pub bitWidth: i32,
    pub is_signed: bool,
}
impl<'a> Default for IntArgs {
    #[inline]
    fn default() -> Self {
        IntArgs {
            bitWidth: 0,
            is_signed: false,
        }
    }
}

pub struct IntBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> IntBuilder<'a, 'b> {
    #[inline]
    pub fn add_bitWidth(&mut self, bitWidth: i32) {
        self.fbb_.push_slot::<i32>(Int::VT_BITWIDTH, bitWidth, 0);
    }
    #[inline]
    pub fn add_is_signed(&mut self, is_signed: bool) {
        self.fbb_
            .push_slot::<bool>(Int::VT_IS_SIGNED, is_signed, false);
    }
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> IntBuilder<'a, 'b> {
        let start = _fbb.start_table();
        IntBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Int<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Int<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Int");
        ds.field("bitWidth", &self.bitWidth());
        ds.field("is_signed", &self.is_signed());
        ds.finish()
    }
}
pub enum FloatingPointOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct FloatingPoint<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for FloatingPoint<'a> {
    type Inner = FloatingPoint<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> FloatingPoint<'a> {
    pub const VT_PRECISION: flatbuffers::VOffsetT = 4;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        FloatingPoint { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args FloatingPointArgs,
    ) -> flatbuffers::WIPOffset<FloatingPoint<'bldr>> {
        let mut builder = FloatingPointBuilder::new(_fbb);
        builder.add_precision(args.precision);
        builder.finish()
    }

    #[inline]
    pub fn precision(&self) -> Precision {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<Precision>(FloatingPoint::VT_PRECISION, Some(Precision::HALF))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for FloatingPoint<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<Precision>("precision", Self::VT_PRECISION, false)?
            .finish();
        Ok(())
    }
}
pub struct FloatingPointArgs {
    pub precision: Precision,
}
impl<'a> Default for FloatingPointArgs {
    #[inline]
    fn default() -> Self {
        FloatingPointArgs {
            precision: Precision::HALF,
        }
    }
}

pub struct FloatingPointBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> FloatingPointBuilder<'a, 'b> {
    #[inline]
    pub fn add_precision(&mut self, precision: Precision) {
        self.fbb_.push_slot::<Precision>(
            FloatingPoint::VT_PRECISION,
            precision,
            Precision::HALF,
        );
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> FloatingPointBuilder<'a, 'b> {
        let start = _fbb.start_table();
        FloatingPointBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<FloatingPoint<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for FloatingPoint<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("FloatingPoint");
        ds.field("precision", &self.precision());
        ds.finish()
    }
}
pub enum Utf8Offset {}
#[derive(Copy, Clone, PartialEq)]

/// Unicode with UTF-8 encoding
pub struct Utf8<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Utf8<'a> {
    type Inner = Utf8<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Utf8<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Utf8 { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args Utf8Args,
    ) -> flatbuffers::WIPOffset<Utf8<'bldr>> {
        let mut builder = Utf8Builder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for Utf8<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct Utf8Args {}
impl<'a> Default for Utf8Args {
    #[inline]
    fn default() -> Self {
        Utf8Args {}
    }
}

pub struct Utf8Builder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> Utf8Builder<'a, 'b> {
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> Utf8Builder<'a, 'b> {
        let start = _fbb.start_table();
        Utf8Builder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Utf8<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Utf8<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Utf8");
        ds.finish()
    }
}
pub enum BinaryOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Opaque binary data
pub struct Binary<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Binary<'a> {
    type Inner = Binary<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Binary<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Binary { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args BinaryArgs,
    ) -> flatbuffers::WIPOffset<Binary<'bldr>> {
        let mut builder = BinaryBuilder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for Binary<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct BinaryArgs {}
impl<'a> Default for BinaryArgs {
    #[inline]
    fn default() -> Self {
        BinaryArgs {}
    }
}

pub struct BinaryBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> BinaryBuilder<'a, 'b> {
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> BinaryBuilder<'a, 'b> {
        let start = _fbb.start_table();
        BinaryBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Binary<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Binary<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Binary");
        ds.finish()
    }
}
pub enum LargeUtf8Offset {}
#[derive(Copy, Clone, PartialEq)]

/// Same as Utf8, but with 64-bit offsets, allowing to represent
/// extremely large data values.
pub struct LargeUtf8<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for LargeUtf8<'a> {
    type Inner = LargeUtf8<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> LargeUtf8<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        LargeUtf8 { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args LargeUtf8Args,
    ) -> flatbuffers::WIPOffset<LargeUtf8<'bldr>> {
        let mut builder = LargeUtf8Builder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for LargeUtf8<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct LargeUtf8Args {}
impl<'a> Default for LargeUtf8Args {
    #[inline]
    fn default() -> Self {
        LargeUtf8Args {}
    }
}

pub struct LargeUtf8Builder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> LargeUtf8Builder<'a, 'b> {
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> LargeUtf8Builder<'a, 'b> {
        let start = _fbb.start_table();
        LargeUtf8Builder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<LargeUtf8<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for LargeUtf8<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("LargeUtf8");
        ds.finish()
    }
}
pub enum LargeBinaryOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Same as Binary, but with 64-bit offsets, allowing to represent
/// extremely large data values.
pub struct LargeBinary<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for LargeBinary<'a> {
    type Inner = LargeBinary<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> LargeBinary<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        LargeBinary { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args LargeBinaryArgs,
    ) -> flatbuffers::WIPOffset<LargeBinary<'bldr>> {
        let mut builder = LargeBinaryBuilder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for LargeBinary<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct LargeBinaryArgs {}
impl<'a> Default for LargeBinaryArgs {
    #[inline]
    fn default() -> Self {
        LargeBinaryArgs {}
    }
}

pub struct LargeBinaryBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> LargeBinaryBuilder<'a, 'b> {
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> LargeBinaryBuilder<'a, 'b> {
        let start = _fbb.start_table();
        LargeBinaryBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<LargeBinary<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for LargeBinary<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("LargeBinary");
        ds.finish()
    }
}
pub enum FixedSizeBinaryOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct FixedSizeBinary<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for FixedSizeBinary<'a> {
    type Inner = FixedSizeBinary<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> FixedSizeBinary<'a> {
    pub const VT_BYTEWIDTH: flatbuffers::VOffsetT = 4;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        FixedSizeBinary { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args FixedSizeBinaryArgs,
    ) -> flatbuffers::WIPOffset<FixedSizeBinary<'bldr>> {
        let mut builder = FixedSizeBinaryBuilder::new(_fbb);
        builder.add_byteWidth(args.byteWidth);
        builder.finish()
    }

    /// Number of bytes per value
    #[inline]
    pub fn byteWidth(&self) -> i32 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<i32>(FixedSizeBinary::VT_BYTEWIDTH, Some(0))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for FixedSizeBinary<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<i32>("byteWidth", Self::VT_BYTEWIDTH, false)?
            .finish();
        Ok(())
    }
}
pub struct FixedSizeBinaryArgs {
    pub byteWidth: i32,
}
impl<'a> Default for FixedSizeBinaryArgs {
    #[inline]
    fn default() -> Self {
        FixedSizeBinaryArgs { byteWidth: 0 }
    }
}

pub struct FixedSizeBinaryBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> FixedSizeBinaryBuilder<'a, 'b> {
    #[inline]
    pub fn add_byteWidth(&mut self, byteWidth: i32) {
        self.fbb_
            .push_slot::<i32>(FixedSizeBinary::VT_BYTEWIDTH, byteWidth, 0);
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> FixedSizeBinaryBuilder<'a, 'b> {
        let start = _fbb.start_table();
        FixedSizeBinaryBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<FixedSizeBinary<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for FixedSizeBinary<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("FixedSizeBinary");
        ds.field("byteWidth", &self.byteWidth());
        ds.finish()
    }
}
pub enum BoolOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct Bool<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Bool<'a> {
    type Inner = Bool<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Bool<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Bool { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args BoolArgs,
    ) -> flatbuffers::WIPOffset<Bool<'bldr>> {
        let mut builder = BoolBuilder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for Bool<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct BoolArgs {}
impl<'a> Default for BoolArgs {
    #[inline]
    fn default() -> Self {
        BoolArgs {}
    }
}

pub struct BoolBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> BoolBuilder<'a, 'b> {
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> BoolBuilder<'a, 'b> {
        let start = _fbb.start_table();
        BoolBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Bool<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Bool<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Bool");
        ds.finish()
    }
}
pub enum RunEndEncodedOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Contains two child arrays, run_ends and values.
/// The run_ends child array must be a 16/32/64-bit integer array
/// which encodes the indices at which the run with the value in
/// each corresponding index in the values child array ends.
/// Like list/struct types, the value array can be of any type.
pub struct RunEndEncoded<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for RunEndEncoded<'a> {
    type Inner = RunEndEncoded<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> RunEndEncoded<'a> {
    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        RunEndEncoded { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        _args: &'args RunEndEncodedArgs,
    ) -> flatbuffers::WIPOffset<RunEndEncoded<'bldr>> {
        let mut builder = RunEndEncodedBuilder::new(_fbb);
        builder.finish()
    }
}

impl flatbuffers::Verifiable for RunEndEncoded<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?.finish();
        Ok(())
    }
}
pub struct RunEndEncodedArgs {}
impl<'a> Default for RunEndEncodedArgs {
    #[inline]
    fn default() -> Self {
        RunEndEncodedArgs {}
    }
}

pub struct RunEndEncodedBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> RunEndEncodedBuilder<'a, 'b> {
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> RunEndEncodedBuilder<'a, 'b> {
        let start = _fbb.start_table();
        RunEndEncodedBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<RunEndEncoded<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for RunEndEncoded<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("RunEndEncoded");
        ds.finish()
    }
}
pub enum DecimalOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Exact decimal value represented as an integer value in two's
/// complement. Currently only 128-bit (16-byte) and 256-bit (32-byte) integers
/// are used. The representation uses the endianness indicated
/// in the Schema.
pub struct Decimal<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Decimal<'a> {
    type Inner = Decimal<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Decimal<'a> {
    pub const VT_PRECISION: flatbuffers::VOffsetT = 4;
    pub const VT_SCALE: flatbuffers::VOffsetT = 6;
    pub const VT_BITWIDTH: flatbuffers::VOffsetT = 8;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Decimal { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args DecimalArgs,
    ) -> flatbuffers::WIPOffset<Decimal<'bldr>> {
        let mut builder = DecimalBuilder::new(_fbb);
        builder.add_bitWidth(args.bitWidth);
        builder.add_scale(args.scale);
        builder.add_precision(args.precision);
        builder.finish()
    }

    /// Total number of decimal digits
    #[inline]
    pub fn precision(&self) -> i32 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<i32>(Decimal::VT_PRECISION, Some(0))
                .unwrap()
        }
    }
    /// Number of digits after the decimal point "."
    #[inline]
    pub fn scale(&self) -> i32 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe { self._tab.get::<i32>(Decimal::VT_SCALE, Some(0)).unwrap() }
    }
    /// Number of bits per value. The only accepted widths are 128 and 256.
    /// We use bitWidth for consistency with Int::bitWidth.
    #[inline]
    pub fn bitWidth(&self) -> i32 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<i32>(Decimal::VT_BITWIDTH, Some(128))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for Decimal<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<i32>("precision", Self::VT_PRECISION, false)?
            .visit_field::<i32>("scale", Self::VT_SCALE, false)?
            .visit_field::<i32>("bitWidth", Self::VT_BITWIDTH, false)?
            .finish();
        Ok(())
    }
}
pub struct DecimalArgs {
    pub precision: i32,
    pub scale: i32,
    pub bitWidth: i32,
}
impl<'a> Default for DecimalArgs {
    #[inline]
    fn default() -> Self {
        DecimalArgs {
            precision: 0,
            scale: 0,
            bitWidth: 128,
        }
    }
}

pub struct DecimalBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> DecimalBuilder<'a, 'b> {
    #[inline]
    pub fn add_precision(&mut self, precision: i32) {
        self.fbb_
            .push_slot::<i32>(Decimal::VT_PRECISION, precision, 0);
    }
    #[inline]
    pub fn add_scale(&mut self, scale: i32) {
        self.fbb_.push_slot::<i32>(Decimal::VT_SCALE, scale, 0);
    }
    #[inline]
    pub fn add_bitWidth(&mut self, bitWidth: i32) {
        self.fbb_
            .push_slot::<i32>(Decimal::VT_BITWIDTH, bitWidth, 128);
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> DecimalBuilder<'a, 'b> {
        let start = _fbb.start_table();
        DecimalBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Decimal<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Decimal<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Decimal");
        ds.field("precision", &self.precision());
        ds.field("scale", &self.scale());
        ds.field("bitWidth", &self.bitWidth());
        ds.finish()
    }
}
pub enum DateOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Date is either a 32-bit or 64-bit signed integer type representing an
/// elapsed time since UNIX epoch (1970-01-01), stored in either of two units:
///
/// * Milliseconds (64 bits) indicating UNIX time elapsed since the epoch (no
///   leap seconds), where the values are evenly divisible by 86400000
/// * Days (32 bits) since the UNIX epoch
pub struct Date<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Date<'a> {
    type Inner = Date<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Date<'a> {
    pub const VT_UNIT: flatbuffers::VOffsetT = 4;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Date { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args DateArgs,
    ) -> flatbuffers::WIPOffset<Date<'bldr>> {
        let mut builder = DateBuilder::new(_fbb);
        builder.add_unit(args.unit);
        builder.finish()
    }

    #[inline]
    pub fn unit(&self) -> DateUnit {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<DateUnit>(Date::VT_UNIT, Some(DateUnit::MILLISECOND))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for Date<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<DateUnit>("unit", Self::VT_UNIT, false)?
            .finish();
        Ok(())
    }
}
pub struct DateArgs {
    pub unit: DateUnit,
}
impl<'a> Default for DateArgs {
    #[inline]
    fn default() -> Self {
        DateArgs {
            unit: DateUnit::MILLISECOND,
        }
    }
}

pub struct DateBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> DateBuilder<'a, 'b> {
    #[inline]
    pub fn add_unit(&mut self, unit: DateUnit) {
        self.fbb_
            .push_slot::<DateUnit>(Date::VT_UNIT, unit, DateUnit::MILLISECOND);
    }
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> DateBuilder<'a, 'b> {
        let start = _fbb.start_table();
        DateBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Date<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Date<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Date");
        ds.field("unit", &self.unit());
        ds.finish()
    }
}
pub enum TimeOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Time is either a 32-bit or 64-bit signed integer type representing an
/// elapsed time since midnight, stored in either of four units: seconds,
/// milliseconds, microseconds or nanoseconds.
///
/// The integer `bitWidth` depends on the `unit` and must be one of the following:
/// * SECOND and MILLISECOND: 32 bits
/// * MICROSECOND and NANOSECOND: 64 bits
///
/// The allowed values are between 0 (inclusive) and 86400 (=24*60*60) seconds
/// (exclusive), adjusted for the time unit (for example, up to 86400000
/// exclusive for the MILLISECOND unit).
/// This definition doesn't allow for leap seconds. Time values from
/// measurements with leap seconds will need to be corrected when ingesting
/// into Arrow (for example by replacing the value 86400 with 86399).
pub struct Time<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Time<'a> {
    type Inner = Time<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Time<'a> {
    pub const VT_UNIT: flatbuffers::VOffsetT = 4;
    pub const VT_BITWIDTH: flatbuffers::VOffsetT = 6;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Time { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args TimeArgs,
    ) -> flatbuffers::WIPOffset<Time<'bldr>> {
        let mut builder = TimeBuilder::new(_fbb);
        builder.add_bitWidth(args.bitWidth);
        builder.add_unit(args.unit);
        builder.finish()
    }

    #[inline]
    pub fn unit(&self) -> TimeUnit {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<TimeUnit>(Time::VT_UNIT, Some(TimeUnit::MILLISECOND))
                .unwrap()
        }
    }
    #[inline]
    pub fn bitWidth(&self) -> i32 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe { self._tab.get::<i32>(Time::VT_BITWIDTH, Some(32)).unwrap() }
    }
}

impl flatbuffers::Verifiable for Time<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<TimeUnit>("unit", Self::VT_UNIT, false)?
            .visit_field::<i32>("bitWidth", Self::VT_BITWIDTH, false)?
            .finish();
        Ok(())
    }
}
pub struct TimeArgs {
    pub unit: TimeUnit,
    pub bitWidth: i32,
}
impl<'a> Default for TimeArgs {
    #[inline]
    fn default() -> Self {
        TimeArgs {
            unit: TimeUnit::MILLISECOND,
            bitWidth: 32,
        }
    }
}

pub struct TimeBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> TimeBuilder<'a, 'b> {
    #[inline]
    pub fn add_unit(&mut self, unit: TimeUnit) {
        self.fbb_
            .push_slot::<TimeUnit>(Time::VT_UNIT, unit, TimeUnit::MILLISECOND);
    }
    #[inline]
    pub fn add_bitWidth(&mut self, bitWidth: i32) {
        self.fbb_.push_slot::<i32>(Time::VT_BITWIDTH, bitWidth, 32);
    }
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> TimeBuilder<'a, 'b> {
        let start = _fbb.start_table();
        TimeBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Time<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Time<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Time");
        ds.field("unit", &self.unit());
        ds.field("bitWidth", &self.bitWidth());
        ds.finish()
    }
}
pub enum TimestampOffset {}
#[derive(Copy, Clone, PartialEq)]

/// Timestamp is a 64-bit signed integer representing an elapsed time since a
/// fixed epoch, stored in either of four units: seconds, milliseconds,
/// microseconds or nanoseconds, and is optionally annotated with a timezone.
///
/// Timestamp values do not include any leap seconds (in other words, all
/// days are considered 86400 seconds long).
///
/// Timestamps with a non-empty timezone
/// ------------------------------------
///
/// If a Timestamp column has a non-empty timezone value, its epoch is
/// 1970-01-01 00:00:00 (January 1st 1970, midnight) in the *UTC* timezone
/// (the Unix epoch), regardless of the Timestamp's own timezone.
///
/// Therefore, timestamp values with a non-empty timezone correspond to
/// physical points in time together with some additional information about
/// how the data was obtained and/or how to display it (the timezone).
///
///   For example, the timestamp value 0 with the timezone string "Europe/Paris"
///   corresponds to "January 1st 1970, 00h00" in the UTC timezone, but the
///   application may prefer to display it as "January 1st 1970, 01h00" in
///   the Europe/Paris timezone (which is the same physical point in time).
///
/// One consequence is that timestamp values with a non-empty timezone
/// can be compared and ordered directly, since they all share the same
/// well-known point of reference (the Unix epoch).
///
/// Timestamps with an unset / empty timezone
/// -----------------------------------------
///
/// If a Timestamp column has no timezone value, its epoch is
/// 1970-01-01 00:00:00 (January 1st 1970, midnight) in an *unknown* timezone.
///
/// Therefore, timestamp values without a timezone cannot be meaningfully
/// interpreted as physical points in time, but only as calendar / clock
/// indications ("wall clock time") in an unspecified timezone.
///
///   For example, the timestamp value 0 with an empty timezone string
///   corresponds to "January 1st 1970, 00h00" in an unknown timezone: there
///   is not enough information to interpret it as a well-defined physical
///   point in time.
///
/// One consequence is that timestamp values without a timezone cannot
/// be reliably compared or ordered, since they may have different points of
/// reference.  In particular, it is *not* possible to interpret an unset
/// or empty timezone as the same as "UTC".
///
/// Conversion between timezones
/// ----------------------------
///
/// If a Timestamp column has a non-empty timezone, changing the timezone
/// to a different non-empty value is a metadata-only operation:
/// the timestamp values need not change as their point of reference remains
/// the same (the Unix epoch).
///
/// However, if a Timestamp column has no timezone value, changing it to a
/// non-empty value requires to think about the desired semantics.
/// One possibility is to assume that the original timestamp values are
/// relative to the epoch of the timezone being set; timestamp values should
/// then adjusted to the Unix epoch (for example, changing the timezone from
/// empty to "Europe/Paris" would require converting the timestamp values
/// from "Europe/Paris" to "UTC", which seems counter-intuitive but is
/// nevertheless correct).
///
/// Guidelines for encoding data from external libraries
/// ----------------------------------------------------
///
/// Date & time libraries often have multiple different data types for temporal
/// data. In order to ease interoperability between different implementations the
/// Arrow project has some recommendations for encoding these types into a Timestamp
/// column.
///
/// An "instant" represents a physical point in time that has no relevant timezone
/// (for example, astronomical data). To encode an instant, use a Timestamp with
/// the timezone string set to "UTC", and make sure the Timestamp values
/// are relative to the UTC epoch (January 1st 1970, midnight).
///
/// A "zoned date-time" represents a physical point in time annotated with an
/// informative timezone (for example, the timezone in which the data was
/// recorded).  To encode a zoned date-time, use a Timestamp with the timezone
/// string set to the name of the timezone, and make sure the Timestamp values
/// are relative to the UTC epoch (January 1st 1970, midnight).
///
///  (There is some ambiguity between an instant and a zoned date-time with the
///   UTC timezone.  Both of these are stored the same in Arrow.  Typically,
///   this distinction does not matter.  If it does, then an application should
///   use custom metadata or an extension type to distinguish between the two cases.)
///
/// An "offset date-time" represents a physical point in time combined with an
/// explicit offset from UTC.  To encode an offset date-time, use a Timestamp
/// with the timezone string set to the numeric timezone offset string
/// (e.g. "+03:00"), and make sure the Timestamp values are relative to
/// the UTC epoch (January 1st 1970, midnight).
///
/// A "naive date-time" (also called "local date-time" in some libraries)
/// represents a wall clock time combined with a calendar date, but with
/// no indication of how to map this information to a physical point in time.
/// Naive date-times must be handled with care because of this missing
/// information, and also because daylight saving time (DST) may make
/// some values ambiguous or non-existent. A naive date-time may be
/// stored as a struct with Date and Time fields. However, it may also be
/// encoded into a Timestamp column with an empty timezone. The timestamp
/// values should be computed "as if" the timezone of the date-time values
/// was UTC; for example, the naive date-time "January 1st 1970, 00h00" would
/// be encoded as timestamp value 0.
pub struct Timestamp<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Timestamp<'a> {
    type Inner = Timestamp<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Timestamp<'a> {
    pub const VT_UNIT: flatbuffers::VOffsetT = 4;
    pub const VT_TIMEZONE: flatbuffers::VOffsetT = 6;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Timestamp { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args TimestampArgs<'args>,
    ) -> flatbuffers::WIPOffset<Timestamp<'bldr>> {
        let mut builder = TimestampBuilder::new(_fbb);
        if let Some(x) = args.timezone {
            builder.add_timezone(x);
        }
        builder.add_unit(args.unit);
        builder.finish()
    }

    #[inline]
    pub fn unit(&self) -> TimeUnit {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<TimeUnit>(Timestamp::VT_UNIT, Some(TimeUnit::SECOND))
                .unwrap()
        }
    }
    /// The timezone is an optional string indicating the name of a timezone,
    /// one of:
    ///
    /// * As used in the Olson timezone database (the "tz database" or
    ///   "tzdata"), such as "America/New_York".
    /// * An absolute timezone offset of the form "+XX:XX" or "-XX:XX",
    ///   such as "+07:30".
    ///
    /// Whether a timezone string is present indicates different semantics about
    /// the data (see above).
    #[inline]
    pub fn timezone(&self) -> Option<&'a str> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<&str>>(Timestamp::VT_TIMEZONE, None)
        }
    }
}

impl flatbuffers::Verifiable for Timestamp<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<TimeUnit>("unit", Self::VT_UNIT, false)?
            .visit_field::<flatbuffers::ForwardsUOffset<&str>>(
                "timezone",
                Self::VT_TIMEZONE,
                false,
            )?
            .finish();
        Ok(())
    }
}
pub struct TimestampArgs<'a> {
    pub unit: TimeUnit,
    pub timezone: Option<flatbuffers::WIPOffset<&'a str>>,
}
impl<'a> Default for TimestampArgs<'a> {
    #[inline]
    fn default() -> Self {
        TimestampArgs {
            unit: TimeUnit::SECOND,
            timezone: None,
        }
    }
}

pub struct TimestampBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> TimestampBuilder<'a, 'b> {
    #[inline]
    pub fn add_unit(&mut self, unit: TimeUnit) {
        self.fbb_
            .push_slot::<TimeUnit>(Timestamp::VT_UNIT, unit, TimeUnit::SECOND);
    }
    #[inline]
    pub fn add_timezone(&mut self, timezone: flatbuffers::WIPOffset<&'b str>) {
        self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
            Timestamp::VT_TIMEZONE,
            timezone,
        );
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> TimestampBuilder<'a, 'b> {
        let start = _fbb.start_table();
        TimestampBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Timestamp<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Timestamp<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Timestamp");
        ds.field("unit", &self.unit());
        ds.field("timezone", &self.timezone());
        ds.finish()
    }
}
pub enum IntervalOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct Interval<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Interval<'a> {
    type Inner = Interval<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Interval<'a> {
    pub const VT_UNIT: flatbuffers::VOffsetT = 4;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Interval { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args IntervalArgs,
    ) -> flatbuffers::WIPOffset<Interval<'bldr>> {
        let mut builder = IntervalBuilder::new(_fbb);
        builder.add_unit(args.unit);
        builder.finish()
    }

    #[inline]
    pub fn unit(&self) -> IntervalUnit {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<IntervalUnit>(Interval::VT_UNIT, Some(IntervalUnit::YEAR_MONTH))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for Interval<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<IntervalUnit>("unit", Self::VT_UNIT, false)?
            .finish();
        Ok(())
    }
}
pub struct IntervalArgs {
    pub unit: IntervalUnit,
}
impl<'a> Default for IntervalArgs {
    #[inline]
    fn default() -> Self {
        IntervalArgs {
            unit: IntervalUnit::YEAR_MONTH,
        }
    }
}

pub struct IntervalBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> IntervalBuilder<'a, 'b> {
    #[inline]
    pub fn add_unit(&mut self, unit: IntervalUnit) {
        self.fbb_.push_slot::<IntervalUnit>(
            Interval::VT_UNIT,
            unit,
            IntervalUnit::YEAR_MONTH,
        );
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> IntervalBuilder<'a, 'b> {
        let start = _fbb.start_table();
        IntervalBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Interval<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Interval<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Interval");
        ds.field("unit", &self.unit());
        ds.finish()
    }
}
pub enum DurationOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct Duration<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Duration<'a> {
    type Inner = Duration<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Duration<'a> {
    pub const VT_UNIT: flatbuffers::VOffsetT = 4;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Duration { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args DurationArgs,
    ) -> flatbuffers::WIPOffset<Duration<'bldr>> {
        let mut builder = DurationBuilder::new(_fbb);
        builder.add_unit(args.unit);
        builder.finish()
    }

    #[inline]
    pub fn unit(&self) -> TimeUnit {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<TimeUnit>(Duration::VT_UNIT, Some(TimeUnit::MILLISECOND))
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for Duration<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<TimeUnit>("unit", Self::VT_UNIT, false)?
            .finish();
        Ok(())
    }
}
pub struct DurationArgs {
    pub unit: TimeUnit,
}
impl<'a> Default for DurationArgs {
    #[inline]
    fn default() -> Self {
        DurationArgs {
            unit: TimeUnit::MILLISECOND,
        }
    }
}

pub struct DurationBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> DurationBuilder<'a, 'b> {
    #[inline]
    pub fn add_unit(&mut self, unit: TimeUnit) {
        self.fbb_
            .push_slot::<TimeUnit>(Duration::VT_UNIT, unit, TimeUnit::MILLISECOND);
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> DurationBuilder<'a, 'b> {
        let start = _fbb.start_table();
        DurationBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Duration<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Duration<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Duration");
        ds.field("unit", &self.unit());
        ds.finish()
    }
}
pub enum KeyValueOffset {}
#[derive(Copy, Clone, PartialEq)]

/// ----------------------------------------------------------------------
/// user defined key value pairs to add custom metadata to arrow
/// key namespacing is the responsibility of the user
pub struct KeyValue<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for KeyValue<'a> {
    type Inner = KeyValue<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> KeyValue<'a> {
    pub const VT_KEY: flatbuffers::VOffsetT = 4;
    pub const VT_VALUE: flatbuffers::VOffsetT = 6;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        KeyValue { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args KeyValueArgs<'args>,
    ) -> flatbuffers::WIPOffset<KeyValue<'bldr>> {
        let mut builder = KeyValueBuilder::new(_fbb);
        if let Some(x) = args.value {
            builder.add_value(x);
        }
        if let Some(x) = args.key {
            builder.add_key(x);
        }
        builder.finish()
    }

    #[inline]
    pub fn key(&self) -> Option<&'a str> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<&str>>(KeyValue::VT_KEY, None)
        }
    }
    #[inline]
    pub fn value(&self) -> Option<&'a str> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<&str>>(KeyValue::VT_VALUE, None)
        }
    }
}

impl flatbuffers::Verifiable for KeyValue<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<flatbuffers::ForwardsUOffset<&str>>(
                "key",
                Self::VT_KEY,
                false,
            )?
            .visit_field::<flatbuffers::ForwardsUOffset<&str>>(
                "value",
                Self::VT_VALUE,
                false,
            )?
            .finish();
        Ok(())
    }
}
pub struct KeyValueArgs<'a> {
    pub key: Option<flatbuffers::WIPOffset<&'a str>>,
    pub value: Option<flatbuffers::WIPOffset<&'a str>>,
}
impl<'a> Default for KeyValueArgs<'a> {
    #[inline]
    fn default() -> Self {
        KeyValueArgs {
            key: None,
            value: None,
        }
    }
}

pub struct KeyValueBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> KeyValueBuilder<'a, 'b> {
    #[inline]
    pub fn add_key(&mut self, key: flatbuffers::WIPOffset<&'b str>) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(KeyValue::VT_KEY, key);
    }
    #[inline]
    pub fn add_value(&mut self, value: flatbuffers::WIPOffset<&'b str>) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(KeyValue::VT_VALUE, value);
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> KeyValueBuilder<'a, 'b> {
        let start = _fbb.start_table();
        KeyValueBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<KeyValue<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for KeyValue<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("KeyValue");
        ds.field("key", &self.key());
        ds.field("value", &self.value());
        ds.finish()
    }
}
pub enum DictionaryEncodingOffset {}
#[derive(Copy, Clone, PartialEq)]

pub struct DictionaryEncoding<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for DictionaryEncoding<'a> {
    type Inner = DictionaryEncoding<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> DictionaryEncoding<'a> {
    pub const VT_ID: flatbuffers::VOffsetT = 4;
    pub const VT_INDEXTYPE: flatbuffers::VOffsetT = 6;
    pub const VT_ISORDERED: flatbuffers::VOffsetT = 8;
    pub const VT_DICTIONARYKIND: flatbuffers::VOffsetT = 10;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        DictionaryEncoding { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args DictionaryEncodingArgs<'args>,
    ) -> flatbuffers::WIPOffset<DictionaryEncoding<'bldr>> {
        let mut builder = DictionaryEncodingBuilder::new(_fbb);
        builder.add_id(args.id);
        if let Some(x) = args.indexType {
            builder.add_indexType(x);
        }
        builder.add_dictionaryKind(args.dictionaryKind);
        builder.add_isOrdered(args.isOrdered);
        builder.finish()
    }

    /// The known dictionary id in the application where this data is used. In
    /// the file or streaming formats, the dictionary ids are found in the
    /// DictionaryBatch messages
    #[inline]
    pub fn id(&self) -> i64 {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<i64>(DictionaryEncoding::VT_ID, Some(0))
                .unwrap()
        }
    }
    /// The dictionary indices are constrained to be non-negative integers. If
    /// this field is null, the indices must be signed int32. To maximize
    /// cross-language compatibility and performance, implementations are
    /// recommended to prefer signed integer types over unsigned integer types
    /// and to avoid uint64 indices unless they are required by an application.
    #[inline]
    pub fn indexType(&self) -> Option<Int<'a>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab.get::<flatbuffers::ForwardsUOffset<Int>>(
                DictionaryEncoding::VT_INDEXTYPE,
                None,
            )
        }
    }
    /// By default, dictionaries are not ordered, or the order does not have
    /// semantic meaning. In some statistical, applications, dictionary-encoding
    /// is used to represent ordered categorical data, and we provide a way to
    /// preserve that metadata here
    #[inline]
    pub fn isOrdered(&self) -> bool {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<bool>(DictionaryEncoding::VT_ISORDERED, Some(false))
                .unwrap()
        }
    }
    #[inline]
    pub fn dictionaryKind(&self) -> DictionaryKind {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<DictionaryKind>(
                    DictionaryEncoding::VT_DICTIONARYKIND,
                    Some(DictionaryKind::DenseArray),
                )
                .unwrap()
        }
    }
}

impl flatbuffers::Verifiable for DictionaryEncoding<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
            .visit_field::<i64>("id", Self::VT_ID, false)?
            .visit_field::<flatbuffers::ForwardsUOffset<Int>>(
                "indexType",
                Self::VT_INDEXTYPE,
                false,
            )?
            .visit_field::<bool>("isOrdered", Self::VT_ISORDERED, false)?
            .visit_field::<DictionaryKind>(
                "dictionaryKind",
                Self::VT_DICTIONARYKIND,
                false,
            )?
            .finish();
        Ok(())
    }
}
pub struct DictionaryEncodingArgs<'a> {
    pub id: i64,
    pub indexType: Option<flatbuffers::WIPOffset<Int<'a>>>,
    pub isOrdered: bool,
    pub dictionaryKind: DictionaryKind,
}
impl<'a> Default for DictionaryEncodingArgs<'a> {
    #[inline]
    fn default() -> Self {
        DictionaryEncodingArgs {
            id: 0,
            indexType: None,
            isOrdered: false,
            dictionaryKind: DictionaryKind::DenseArray,
        }
    }
}

pub struct DictionaryEncodingBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> DictionaryEncodingBuilder<'a, 'b> {
    #[inline]
    pub fn add_id(&mut self, id: i64) {
        self.fbb_.push_slot::<i64>(DictionaryEncoding::VT_ID, id, 0);
    }
    #[inline]
    pub fn add_indexType(&mut self, indexType: flatbuffers::WIPOffset<Int<'b>>) {
        self.fbb_.push_slot_always::<flatbuffers::WIPOffset<Int>>(
            DictionaryEncoding::VT_INDEXTYPE,
            indexType,
        );
    }
    #[inline]
    pub fn add_isOrdered(&mut self, isOrdered: bool) {
        self.fbb_
            .push_slot::<bool>(DictionaryEncoding::VT_ISORDERED, isOrdered, false);
    }
    #[inline]
    pub fn add_dictionaryKind(&mut self, dictionaryKind: DictionaryKind) {
        self.fbb_.push_slot::<DictionaryKind>(
            DictionaryEncoding::VT_DICTIONARYKIND,
            dictionaryKind,
            DictionaryKind::DenseArray,
        );
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> DictionaryEncodingBuilder<'a, 'b> {
        let start = _fbb.start_table();
        DictionaryEncodingBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<DictionaryEncoding<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for DictionaryEncoding<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("DictionaryEncoding");
        ds.field("id", &self.id());
        ds.field("indexType", &self.indexType());
        ds.field("isOrdered", &self.isOrdered());
        ds.field("dictionaryKind", &self.dictionaryKind());
        ds.finish()
    }
}
pub enum FieldOffset {}
#[derive(Copy, Clone, PartialEq)]

/// ----------------------------------------------------------------------
/// A field represents a named column in a record / row batch or child of a
/// nested type.
pub struct Field<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Field<'a> {
    type Inner = Field<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Field<'a> {
    pub const VT_NAME: flatbuffers::VOffsetT = 4;
    pub const VT_NULLABLE: flatbuffers::VOffsetT = 6;
    pub const VT_TYPE_TYPE: flatbuffers::VOffsetT = 8;
    pub const VT_TYPE_: flatbuffers::VOffsetT = 10;
    pub const VT_DICTIONARY: flatbuffers::VOffsetT = 12;
    pub const VT_CHILDREN: flatbuffers::VOffsetT = 14;
    pub const VT_CUSTOM_METADATA: flatbuffers::VOffsetT = 16;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Field { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args FieldArgs<'args>,
    ) -> flatbuffers::WIPOffset<Field<'bldr>> {
        let mut builder = FieldBuilder::new(_fbb);
        if let Some(x) = args.custom_metadata {
            builder.add_custom_metadata(x);
        }
        if let Some(x) = args.children {
            builder.add_children(x);
        }
        if let Some(x) = args.dictionary {
            builder.add_dictionary(x);
        }
        if let Some(x) = args.type_ {
            builder.add_type_(x);
        }
        if let Some(x) = args.name {
            builder.add_name(x);
        }
        builder.add_type_type(args.type_type);
        builder.add_nullable(args.nullable);
        builder.finish()
    }

    /// Name is not required, in i.e. a List
    #[inline]
    pub fn name(&self) -> Option<&'a str> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<&str>>(Field::VT_NAME, None)
        }
    }
    /// Whether or not this field can contain nulls. Should be true in general.
    #[inline]
    pub fn nullable(&self) -> bool {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<bool>(Field::VT_NULLABLE, Some(false))
                .unwrap()
        }
    }
    #[inline]
    pub fn type_type(&self) -> Type {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<Type>(Field::VT_TYPE_TYPE, Some(Type::NONE))
                .unwrap()
        }
    }
    /// This is the type of the decoded value if the field is dictionary encoded.
    #[inline]
    pub fn type_(&self) -> Option<flatbuffers::Table<'a>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<flatbuffers::Table<'a>>>(
                    Field::VT_TYPE_,
                    None,
                )
        }
    }
    /// Present only if the field is dictionary encoded.
    #[inline]
    pub fn dictionary(&self) -> Option<DictionaryEncoding<'a>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<DictionaryEncoding>>(
                    Field::VT_DICTIONARY,
                    None,
                )
        }
    }
    /// children apply only to nested data types like Struct, List and Union. For
    /// primitive types children will have length 0.
    #[inline]
    pub fn children(
        &self,
    ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<Field<'a>>>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab.get::<flatbuffers::ForwardsUOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<Field>>,
            >>(Field::VT_CHILDREN, None)
        }
    }
    /// User-defined metadata
    #[inline]
    pub fn custom_metadata(
        &self,
    ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<KeyValue<'a>>>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab.get::<flatbuffers::ForwardsUOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<KeyValue>>,
            >>(Field::VT_CUSTOM_METADATA, None)
        }
    }
    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_null(&self) -> Option<Null<'a>> {
        if self.type_type() == Type::Null {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Null::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_int(&self) -> Option<Int<'a>> {
        if self.type_type() == Type::Int {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Int::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_floating_point(&self) -> Option<FloatingPoint<'a>> {
        if self.type_type() == Type::FloatingPoint {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { FloatingPoint::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_binary(&self) -> Option<Binary<'a>> {
        if self.type_type() == Type::Binary {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Binary::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_utf_8(&self) -> Option<Utf8<'a>> {
        if self.type_type() == Type::Utf8 {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Utf8::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_bool(&self) -> Option<Bool<'a>> {
        if self.type_type() == Type::Bool {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Bool::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_decimal(&self) -> Option<Decimal<'a>> {
        if self.type_type() == Type::Decimal {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Decimal::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_date(&self) -> Option<Date<'a>> {
        if self.type_type() == Type::Date {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Date::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_time(&self) -> Option<Time<'a>> {
        if self.type_type() == Type::Time {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Time::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_timestamp(&self) -> Option<Timestamp<'a>> {
        if self.type_type() == Type::Timestamp {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Timestamp::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_interval(&self) -> Option<Interval<'a>> {
        if self.type_type() == Type::Interval {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Interval::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_list(&self) -> Option<List<'a>> {
        if self.type_type() == Type::List {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { List::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_struct_(&self) -> Option<Struct_<'a>> {
        if self.type_type() == Type::Struct_ {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Struct_::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_union(&self) -> Option<Union<'a>> {
        if self.type_type() == Type::Union {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Union::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_fixed_size_binary(&self) -> Option<FixedSizeBinary<'a>> {
        if self.type_type() == Type::FixedSizeBinary {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { FixedSizeBinary::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_fixed_size_list(&self) -> Option<FixedSizeList<'a>> {
        if self.type_type() == Type::FixedSizeList {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { FixedSizeList::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_map(&self) -> Option<Map<'a>> {
        if self.type_type() == Type::Map {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Map::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_duration(&self) -> Option<Duration<'a>> {
        if self.type_type() == Type::Duration {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { Duration::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_large_binary(&self) -> Option<LargeBinary<'a>> {
        if self.type_type() == Type::LargeBinary {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { LargeBinary::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_large_utf_8(&self) -> Option<LargeUtf8<'a>> {
        if self.type_type() == Type::LargeUtf8 {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { LargeUtf8::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_large_list(&self) -> Option<LargeList<'a>> {
        if self.type_type() == Type::LargeList {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { LargeList::init_from_table(t) }
            })
        } else {
            None
        }
    }

    #[inline]
    #[allow(non_snake_case)]
    pub fn type_as_run_end_encoded(&self) -> Option<RunEndEncoded<'a>> {
        if self.type_type() == Type::RunEndEncoded {
            self.type_().map(|t| {
                // Safety:
                // Created from a valid Table for this object
                // Which contains a valid union in this slot
                unsafe { RunEndEncoded::init_from_table(t) }
            })
        } else {
            None
        }
    }
}

impl flatbuffers::Verifiable for Field<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
     .visit_field::<flatbuffers::ForwardsUOffset<&str>>("name", Self::VT_NAME, false)?
     .visit_field::<bool>("nullable", Self::VT_NULLABLE, false)?
     .visit_union::<Type, _>("type_type", Self::VT_TYPE_TYPE, "type_", Self::VT_TYPE_, false, |key, v, pos| {
        match key {
          Type::Null => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Null>>("Type::Null", pos),
          Type::Int => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Int>>("Type::Int", pos),
          Type::FloatingPoint => v.verify_union_variant::<flatbuffers::ForwardsUOffset<FloatingPoint>>("Type::FloatingPoint", pos),
          Type::Binary => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Binary>>("Type::Binary", pos),
          Type::Utf8 => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Utf8>>("Type::Utf8", pos),
          Type::Bool => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Bool>>("Type::Bool", pos),
          Type::Decimal => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Decimal>>("Type::Decimal", pos),
          Type::Date => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Date>>("Type::Date", pos),
          Type::Time => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Time>>("Type::Time", pos),
          Type::Timestamp => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Timestamp>>("Type::Timestamp", pos),
          Type::Interval => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Interval>>("Type::Interval", pos),
          Type::List => v.verify_union_variant::<flatbuffers::ForwardsUOffset<List>>("Type::List", pos),
          Type::Struct_ => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Struct_>>("Type::Struct_", pos),
          Type::Union => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Union>>("Type::Union", pos),
          Type::FixedSizeBinary => v.verify_union_variant::<flatbuffers::ForwardsUOffset<FixedSizeBinary>>("Type::FixedSizeBinary", pos),
          Type::FixedSizeList => v.verify_union_variant::<flatbuffers::ForwardsUOffset<FixedSizeList>>("Type::FixedSizeList", pos),
          Type::Map => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Map>>("Type::Map", pos),
          Type::Duration => v.verify_union_variant::<flatbuffers::ForwardsUOffset<Duration>>("Type::Duration", pos),
          Type::LargeBinary => v.verify_union_variant::<flatbuffers::ForwardsUOffset<LargeBinary>>("Type::LargeBinary", pos),
          Type::LargeUtf8 => v.verify_union_variant::<flatbuffers::ForwardsUOffset<LargeUtf8>>("Type::LargeUtf8", pos),
          Type::LargeList => v.verify_union_variant::<flatbuffers::ForwardsUOffset<LargeList>>("Type::LargeList", pos),
          Type::RunEndEncoded => v.verify_union_variant::<flatbuffers::ForwardsUOffset<RunEndEncoded>>("Type::RunEndEncoded", pos),
          _ => Ok(()),
        }
     })?
     .visit_field::<flatbuffers::ForwardsUOffset<DictionaryEncoding>>("dictionary", Self::VT_DICTIONARY, false)?
     .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<Field>>>>("children", Self::VT_CHILDREN, false)?
     .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<KeyValue>>>>("custom_metadata", Self::VT_CUSTOM_METADATA, false)?
     .finish();
        Ok(())
    }
}
pub struct FieldArgs<'a> {
    pub name: Option<flatbuffers::WIPOffset<&'a str>>,
    pub nullable: bool,
    pub type_type: Type,
    pub type_: Option<flatbuffers::WIPOffset<flatbuffers::UnionWIPOffset>>,
    pub dictionary: Option<flatbuffers::WIPOffset<DictionaryEncoding<'a>>>,
    pub children: Option<
        flatbuffers::WIPOffset<
            flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<Field<'a>>>,
        >,
    >,
    pub custom_metadata: Option<
        flatbuffers::WIPOffset<
            flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<KeyValue<'a>>>,
        >,
    >,
}
impl<'a> Default for FieldArgs<'a> {
    #[inline]
    fn default() -> Self {
        FieldArgs {
            name: None,
            nullable: false,
            type_type: Type::NONE,
            type_: None,
            dictionary: None,
            children: None,
            custom_metadata: None,
        }
    }
}

pub struct FieldBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> FieldBuilder<'a, 'b> {
    #[inline]
    pub fn add_name(&mut self, name: flatbuffers::WIPOffset<&'b str>) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(Field::VT_NAME, name);
    }
    #[inline]
    pub fn add_nullable(&mut self, nullable: bool) {
        self.fbb_
            .push_slot::<bool>(Field::VT_NULLABLE, nullable, false);
    }
    #[inline]
    pub fn add_type_type(&mut self, type_type: Type) {
        self.fbb_
            .push_slot::<Type>(Field::VT_TYPE_TYPE, type_type, Type::NONE);
    }
    #[inline]
    pub fn add_type_(
        &mut self,
        type_: flatbuffers::WIPOffset<flatbuffers::UnionWIPOffset>,
    ) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(Field::VT_TYPE_, type_);
    }
    #[inline]
    pub fn add_dictionary(
        &mut self,
        dictionary: flatbuffers::WIPOffset<DictionaryEncoding<'b>>,
    ) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<DictionaryEncoding>>(
                Field::VT_DICTIONARY,
                dictionary,
            );
    }
    #[inline]
    pub fn add_children(
        &mut self,
        children: flatbuffers::WIPOffset<
            flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<Field<'b>>>,
        >,
    ) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(Field::VT_CHILDREN, children);
    }
    #[inline]
    pub fn add_custom_metadata(
        &mut self,
        custom_metadata: flatbuffers::WIPOffset<
            flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<KeyValue<'b>>>,
        >,
    ) {
        self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
            Field::VT_CUSTOM_METADATA,
            custom_metadata,
        );
    }
    #[inline]
    pub fn new(_fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>) -> FieldBuilder<'a, 'b> {
        let start = _fbb.start_table();
        FieldBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Field<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Field<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Field");
        ds.field("name", &self.name());
        ds.field("nullable", &self.nullable());
        ds.field("type_type", &self.type_type());
        match self.type_type() {
            Type::Null => {
                if let Some(x) = self.type_as_null() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Int => {
                if let Some(x) = self.type_as_int() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::FloatingPoint => {
                if let Some(x) = self.type_as_floating_point() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Binary => {
                if let Some(x) = self.type_as_binary() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Utf8 => {
                if let Some(x) = self.type_as_utf_8() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Bool => {
                if let Some(x) = self.type_as_bool() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Decimal => {
                if let Some(x) = self.type_as_decimal() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Date => {
                if let Some(x) = self.type_as_date() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Time => {
                if let Some(x) = self.type_as_time() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Timestamp => {
                if let Some(x) = self.type_as_timestamp() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Interval => {
                if let Some(x) = self.type_as_interval() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::List => {
                if let Some(x) = self.type_as_list() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Struct_ => {
                if let Some(x) = self.type_as_struct_() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Union => {
                if let Some(x) = self.type_as_union() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::FixedSizeBinary => {
                if let Some(x) = self.type_as_fixed_size_binary() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::FixedSizeList => {
                if let Some(x) = self.type_as_fixed_size_list() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Map => {
                if let Some(x) = self.type_as_map() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::Duration => {
                if let Some(x) = self.type_as_duration() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::LargeBinary => {
                if let Some(x) = self.type_as_large_binary() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::LargeUtf8 => {
                if let Some(x) = self.type_as_large_utf_8() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::LargeList => {
                if let Some(x) = self.type_as_large_list() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            Type::RunEndEncoded => {
                if let Some(x) = self.type_as_run_end_encoded() {
                    ds.field("type_", &x)
                } else {
                    ds.field(
                        "type_",
                        &"InvalidFlatbuffer: Union discriminant does not match value.",
                    )
                }
            }
            _ => {
                let x: Option<()> = None;
                ds.field("type_", &x)
            }
        };
        ds.field("dictionary", &self.dictionary());
        ds.field("children", &self.children());
        ds.field("custom_metadata", &self.custom_metadata());
        ds.finish()
    }
}
pub enum SchemaOffset {}
#[derive(Copy, Clone, PartialEq)]

/// ----------------------------------------------------------------------
/// A Schema describes the columns in a row batch
pub struct Schema<'a> {
    pub _tab: flatbuffers::Table<'a>,
}

impl<'a> flatbuffers::Follow<'a> for Schema<'a> {
    type Inner = Schema<'a>;
    #[inline]
    unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
        Self {
            _tab: flatbuffers::Table::new(buf, loc),
        }
    }
}

impl<'a> Schema<'a> {
    pub const VT_ENDIANNESS: flatbuffers::VOffsetT = 4;
    pub const VT_FIELDS: flatbuffers::VOffsetT = 6;
    pub const VT_CUSTOM_METADATA: flatbuffers::VOffsetT = 8;
    pub const VT_FEATURES: flatbuffers::VOffsetT = 10;

    #[inline]
    pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
        Schema { _tab: table }
    }
    #[allow(unused_mut)]
    pub fn create<'bldr: 'args, 'args: 'mut_bldr, 'mut_bldr>(
        _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr>,
        args: &'args SchemaArgs<'args>,
    ) -> flatbuffers::WIPOffset<Schema<'bldr>> {
        let mut builder = SchemaBuilder::new(_fbb);
        if let Some(x) = args.features {
            builder.add_features(x);
        }
        if let Some(x) = args.custom_metadata {
            builder.add_custom_metadata(x);
        }
        if let Some(x) = args.fields {
            builder.add_fields(x);
        }
        builder.add_endianness(args.endianness);
        builder.finish()
    }

    /// endianness of the buffer
    /// it is Little Endian by default
    /// if endianness doesn't match the underlying system then the vectors need to be converted
    #[inline]
    pub fn endianness(&self) -> Endianness {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<Endianness>(Schema::VT_ENDIANNESS, Some(Endianness::Little))
                .unwrap()
        }
    }
    #[inline]
    pub fn fields(
        &self,
    ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<Field<'a>>>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab.get::<flatbuffers::ForwardsUOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<Field>>,
            >>(Schema::VT_FIELDS, None)
        }
    }
    #[inline]
    pub fn custom_metadata(
        &self,
    ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<KeyValue<'a>>>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab.get::<flatbuffers::ForwardsUOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<KeyValue>>,
            >>(Schema::VT_CUSTOM_METADATA, None)
        }
    }
    /// Features used in the stream/file.
    #[inline]
    pub fn features(&self) -> Option<flatbuffers::Vector<'a, Feature>> {
        // Safety:
        // Created from valid Table for this object
        // which contains a valid value in this slot
        unsafe {
            self._tab
                .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, Feature>>>(
                    Schema::VT_FEATURES,
                    None,
                )
        }
    }
}

impl flatbuffers::Verifiable for Schema<'_> {
    #[inline]
    fn run_verifier(
        v: &mut flatbuffers::Verifier,
        pos: usize,
    ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
        use flatbuffers::Verifiable;
        v.visit_table(pos)?
     .visit_field::<Endianness>("endianness", Self::VT_ENDIANNESS, false)?
     .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<Field>>>>("fields", Self::VT_FIELDS, false)?
     .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<KeyValue>>>>("custom_metadata", Self::VT_CUSTOM_METADATA, false)?
     .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, Feature>>>("features", Self::VT_FEATURES, false)?
     .finish();
        Ok(())
    }
}
pub struct SchemaArgs<'a> {
    pub endianness: Endianness,
    pub fields: Option<
        flatbuffers::WIPOffset<
            flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<Field<'a>>>,
        >,
    >,
    pub custom_metadata: Option<
        flatbuffers::WIPOffset<
            flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<KeyValue<'a>>>,
        >,
    >,
    pub features: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, Feature>>>,
}
impl<'a> Default for SchemaArgs<'a> {
    #[inline]
    fn default() -> Self {
        SchemaArgs {
            endianness: Endianness::Little,
            fields: None,
            custom_metadata: None,
            features: None,
        }
    }
}

pub struct SchemaBuilder<'a: 'b, 'b> {
    fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
}
impl<'a: 'b, 'b> SchemaBuilder<'a, 'b> {
    #[inline]
    pub fn add_endianness(&mut self, endianness: Endianness) {
        self.fbb_.push_slot::<Endianness>(
            Schema::VT_ENDIANNESS,
            endianness,
            Endianness::Little,
        );
    }
    #[inline]
    pub fn add_fields(
        &mut self,
        fields: flatbuffers::WIPOffset<
            flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<Field<'b>>>,
        >,
    ) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(Schema::VT_FIELDS, fields);
    }
    #[inline]
    pub fn add_custom_metadata(
        &mut self,
        custom_metadata: flatbuffers::WIPOffset<
            flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<KeyValue<'b>>>,
        >,
    ) {
        self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
            Schema::VT_CUSTOM_METADATA,
            custom_metadata,
        );
    }
    #[inline]
    pub fn add_features(
        &mut self,
        features: flatbuffers::WIPOffset<flatbuffers::Vector<'b, Feature>>,
    ) {
        self.fbb_
            .push_slot_always::<flatbuffers::WIPOffset<_>>(Schema::VT_FEATURES, features);
    }
    #[inline]
    pub fn new(
        _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    ) -> SchemaBuilder<'a, 'b> {
        let start = _fbb.start_table();
        SchemaBuilder {
            fbb_: _fbb,
            start_: start,
        }
    }
    #[inline]
    pub fn finish(self) -> flatbuffers::WIPOffset<Schema<'a>> {
        let o = self.fbb_.end_table(self.start_);
        flatbuffers::WIPOffset::new(o.value())
    }
}

impl core::fmt::Debug for Schema<'_> {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        let mut ds = f.debug_struct("Schema");
        ds.field("endianness", &self.endianness());
        ds.field("fields", &self.fields());
        ds.field("custom_metadata", &self.custom_metadata());
        ds.field("features", &self.features());
        ds.finish()
    }
}
#[inline]
/// Verifies that a buffer of bytes contains a `Schema`
/// and returns it.
/// Note that verification is still experimental and may not
/// catch every error, or be maximally performant. For the
/// previous, unchecked, behavior use
/// `root_as_schema_unchecked`.
pub fn root_as_schema(buf: &[u8]) -> Result<Schema, flatbuffers::InvalidFlatbuffer> {
    flatbuffers::root::<Schema>(buf)
}
#[inline]
/// Verifies that a buffer of bytes contains a size prefixed
/// `Schema` and returns it.
/// Note that verification is still experimental and may not
/// catch every error, or be maximally performant. For the
/// previous, unchecked, behavior use
/// `size_prefixed_root_as_schema_unchecked`.
pub fn size_prefixed_root_as_schema(
    buf: &[u8],
) -> Result<Schema, flatbuffers::InvalidFlatbuffer> {
    flatbuffers::size_prefixed_root::<Schema>(buf)
}
#[inline]
/// Verifies, with the given options, that a buffer of bytes
/// contains a `Schema` and returns it.
/// Note that verification is still experimental and may not
/// catch every error, or be maximally performant. For the
/// previous, unchecked, behavior use
/// `root_as_schema_unchecked`.
pub fn root_as_schema_with_opts<'b, 'o>(
    opts: &'o flatbuffers::VerifierOptions,
    buf: &'b [u8],
) -> Result<Schema<'b>, flatbuffers::InvalidFlatbuffer> {
    flatbuffers::root_with_opts::<Schema<'b>>(opts, buf)
}
#[inline]
/// Verifies, with the given verifier options, that a buffer of
/// bytes contains a size prefixed `Schema` and returns
/// it. Note that verification is still experimental and may not
/// catch every error, or be maximally performant. For the
/// previous, unchecked, behavior use
/// `root_as_schema_unchecked`.
pub fn size_prefixed_root_as_schema_with_opts<'b, 'o>(
    opts: &'o flatbuffers::VerifierOptions,
    buf: &'b [u8],
) -> Result<Schema<'b>, flatbuffers::InvalidFlatbuffer> {
    flatbuffers::size_prefixed_root_with_opts::<Schema<'b>>(opts, buf)
}
#[inline]
/// Assumes, without verification, that a buffer of bytes contains a Schema and returns it.
/// # Safety
/// Callers must trust the given bytes do indeed contain a valid `Schema`.
pub unsafe fn root_as_schema_unchecked(buf: &[u8]) -> Schema {
    flatbuffers::root_unchecked::<Schema>(buf)
}
#[inline]
/// Assumes, without verification, that a buffer of bytes contains a size prefixed Schema and returns it.
/// # Safety
/// Callers must trust the given bytes do indeed contain a valid size prefixed `Schema`.
pub unsafe fn size_prefixed_root_as_schema_unchecked(buf: &[u8]) -> Schema {
    flatbuffers::size_prefixed_root_unchecked::<Schema>(buf)
}
#[inline]
pub fn finish_schema_buffer<'a, 'b>(
    fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    root: flatbuffers::WIPOffset<Schema<'a>>,
) {
    fbb.finish(root, None);
}

#[inline]
pub fn finish_size_prefixed_schema_buffer<'a, 'b>(
    fbb: &'b mut flatbuffers::FlatBufferBuilder<'a>,
    root: flatbuffers::WIPOffset<Schema<'a>>,
) {
    fbb.finish_size_prefixed(root, None);
}
