<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

## [12.0.0](https://github.com/apache/arrow-datafusion/tree/12.0.0) (2022-09-12)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/11.0.0...12.0.0)

**Breaking changes:**

- Pass `return_type` to `AccumulatorFunctionImplementation ` for user defined aggregates [\#3428](https://github.com/apache/arrow-datafusion/pull/3428) ([alamb](https://github.com/alamb))
- Use `usize` rather than `Option<usize>` to represent `Limit::skip`and `Limit::offset` [\#3374](https://github.com/apache/arrow-datafusion/pull/3374) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([HaoYang670](https://github.com/HaoYang670))
- Deprecate legacy datafusion::logical_plan module [\#3338](https://github.com/apache/arrow-datafusion/pull/3338) ([andygrove](https://github.com/andygrove))
- Update signature for Expr.name so that schema is no longer required [\#3336](https://github.com/apache/arrow-datafusion/pull/3336) ([andygrove](https://github.com/andygrove))
- MINOR: rename optimizer rule to ScalarSubqueryToJoin [\#3306](https://github.com/apache/arrow-datafusion/pull/3306) ([kmitchener](https://github.com/kmitchener))
- Add top-level `Like`, `ILike`, `SimilarTo` expressions in logical plan [\#3298](https://github.com/apache/arrow-datafusion/pull/3298) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Upgrade to sqlparser 0.22 [\#3278](https://github.com/apache/arrow-datafusion/pull/3278) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- `Expr` variants for boolean operations [\#3275](https://github.com/apache/arrow-datafusion/pull/3275) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([sarahyurick](https://github.com/sarahyurick))
- Upgrade to sqlparser 0.21 [\#3200](https://github.com/apache/arrow-datafusion/pull/3200) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Add SQL planner support for `Like`, `ILike` and `SimilarTo`, with optional escape character [\#3101](https://github.com/apache/arrow-datafusion/pull/3101) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))

**Implemented enhancements:**

- support `cast` inside `values` [\#3446](https://github.com/apache/arrow-datafusion/issues/3446)
- update TPCH test schemas to use Decimal128 from Float [\#3435](https://github.com/apache/arrow-datafusion/issues/3435)
- Include Bitwise operators in the documentation [\#3434](https://github.com/apache/arrow-datafusion/issues/3434)
- How to read excel file with datafusion? [\#3433](https://github.com/apache/arrow-datafusion/issues/3433)
- Pass return type to the accumulator state factory in aggregates [\#3427](https://github.com/apache/arrow-datafusion/issues/3427)
- Support bitwise XOR operator \(`#`\) [\#3420](https://github.com/apache/arrow-datafusion/issues/3420)
- support InList with datatype Date32 [\#3412](https://github.com/apache/arrow-datafusion/issues/3412)
- add simplification for `between` expression during logical plan optimization [\#3402](https://github.com/apache/arrow-datafusion/issues/3402)
- Replace From trait with TryFrom trait for datafusion-proto crate [\#3401](https://github.com/apache/arrow-datafusion/issues/3401)
- update TPC-H benchmark to Decimal types from Float [\#3392](https://github.com/apache/arrow-datafusion/issues/3392)
- Use `usize` to represent `Limit::skip` [\#3369](https://github.com/apache/arrow-datafusion/issues/3369)
- Avoid coping in `LogicalPlan::expressions` [\#3368](https://github.com/apache/arrow-datafusion/issues/3368)
- Upgrade to Arrow 22 [\#3362](https://github.com/apache/arrow-datafusion/issues/3362)
- Eliminate `OFFSET 0` in the logical plan optimization [\#3355](https://github.com/apache/arrow-datafusion/issues/3355)
- Add ability to get unoptimized logical plan from DataFrame [\#3340](https://github.com/apache/arrow-datafusion/issues/3340)
- Allow IDEs to recognize generated code [\#3332](https://github.com/apache/arrow-datafusion/issues/3332)
- `CAST` should not change the name of an expression [\#3326](https://github.com/apache/arrow-datafusion/issues/3326)
- add SQL support for unsigned integers [\#3325](https://github.com/apache/arrow-datafusion/issues/3325)
- Review use of panic in `datafusion-proto` crate [\#3318](https://github.com/apache/arrow-datafusion/issues/3318)
- Review use of panic in `datafusion-sql` crate [\#3315](https://github.com/apache/arrow-datafusion/issues/3315)
- Review use of panic in `datafusion-optimizer` crate [\#3314](https://github.com/apache/arrow-datafusion/issues/3314)
- Review use of panic in `datafusion-expr` crate [\#3312](https://github.com/apache/arrow-datafusion/issues/3312)
- Support registration of custom TableProviders through SQL [\#3310](https://github.com/apache/arrow-datafusion/issues/3310)
- Support binary data in sha hash functions [\#3308](https://github.com/apache/arrow-datafusion/issues/3308)
- add SQL support for tinyint and unsigned versions of all INTs [\#3307](https://github.com/apache/arrow-datafusion/issues/3307)
- Support binary types in InList expression [\#3300](https://github.com/apache/arrow-datafusion/issues/3300)
- Physical planner should map `IsTrue` and similar expressions to `IsDistinctFrom` [\#3288](https://github.com/apache/arrow-datafusion/issues/3288)
- Introduce physical plan version of `Operator` enum [\#3269](https://github.com/apache/arrow-datafusion/issues/3269)
- Introduce `Expr` variants for `IS [NOT] TRUE / FALSE / UNKNOWN` [\#3268](https://github.com/apache/arrow-datafusion/issues/3268)
- Add support for non-correlated subqueries [\#3266](https://github.com/apache/arrow-datafusion/issues/3266) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- \(Re-\)add support for glob patterns in ListingTableUrl [\#3261](https://github.com/apache/arrow-datafusion/issues/3261)
- `PreCastLitInComparisonExpressions` should use ExprRewriter and supported nested expressions [\#3259](https://github.com/apache/arrow-datafusion/issues/3259)
- implement `DROP VIEW` [\#3251](https://github.com/apache/arrow-datafusion/issues/3251)
- Upgrade to Arrow 21 [\#3224](https://github.com/apache/arrow-datafusion/issues/3224)
- Add TypeCoercion optimizer rule [\#3221](https://github.com/apache/arrow-datafusion/issues/3221)
- Create bench for approx_percentile_cont aggregate [\#3217](https://github.com/apache/arrow-datafusion/issues/3217)
- Add SQL query planner support for `DISTRIBUTED BY` [\#3207](https://github.com/apache/arrow-datafusion/issues/3207)
- Support "IS \[NOT\] UNKNOWN" syntax [\#3195](https://github.com/apache/arrow-datafusion/issues/3195)
- sqlparser 0.21 upgrade [\#3192](https://github.com/apache/arrow-datafusion/issues/3192)
- Re-implement parsing/planning for SHOW TABLES due to sqlparser changes [\#3188](https://github.com/apache/arrow-datafusion/issues/3188)
- Support `SUM` `AVG`, `MIN`, `MAX` on `Time` columns. [\#3166](https://github.com/apache/arrow-datafusion/issues/3166)
- Support "IS TRUE/FALSE" syntax [\#3159](https://github.com/apache/arrow-datafusion/issues/3159)
- Support number of histogram bins in approx_percentile_cont [\#3145](https://github.com/apache/arrow-datafusion/issues/3145)
- Support create ApproxPercentileAccumulator with TDigest max_size [\#3142](https://github.com/apache/arrow-datafusion/issues/3142)
- Remove support for `array` function and only support `array[]` style postgres syntax [\#3115](https://github.com/apache/arrow-datafusion/issues/3115)
- Allow inline column aliases for create view [\#3108](https://github.com/apache/arrow-datafusion/issues/3108) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- Add support for Postgres `SIMILAR TO` and `ILIKE` syntax [\#3099](https://github.com/apache/arrow-datafusion/issues/3099) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- Update SQL reference in user guide to cover all supported syntax [\#3091](https://github.com/apache/arrow-datafusion/issues/3091)
- DataFusion prelude should import all logical expression functions [\#3068](https://github.com/apache/arrow-datafusion/issues/3068)
- Proposal: Add similar to operator [\#3016](https://github.com/apache/arrow-datafusion/issues/3016) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- Release DataFusion 11.0.0 [\#3012](https://github.com/apache/arrow-datafusion/issues/3012)
- Implement "SHOW CREATE TABLE" for external tables [\#2848](https://github.com/apache/arrow-datafusion/issues/2848)
- Change java package names in protobuf files [\#2513](https://github.com/apache/arrow-datafusion/issues/2513)
- When creating `DFField` from `Expr` we should provide input plan not input schema [\#2456](https://github.com/apache/arrow-datafusion/issues/2456)
- Support "IS NOT TRUE/FALSE" syntax [\#2265](https://github.com/apache/arrow-datafusion/issues/2265)
- RFC: Spill-To-Disk Object Storage Download [\#2205](https://github.com/apache/arrow-datafusion/issues/2205)
- Support for BitwiseAnd `&`, BitOr `|` binary operators [\#1619](https://github.com/apache/arrow-datafusion/issues/1619)
- \[Question\] Usage of async object store APIs in consuming code [\#1313](https://github.com/apache/arrow-datafusion/issues/1313)
- Allow User Defined Aggregates to return multiple values / structs [\#600](https://github.com/apache/arrow-datafusion/issues/600)
- Implement vectorized hashing for dictionary types [\#331](https://github.com/apache/arrow-datafusion/issues/331)

**Fixed bugs:**

- Intermittent build error when changing selected features [\#3366](https://github.com/apache/arrow-datafusion/issues/3366)
- `sql::timestamp::timestamp_add_interval_months` failing since September 1st [\#3327](https://github.com/apache/arrow-datafusion/issues/3327)
- `sql::timestamp::timestamp_add_interval_months` test fails [\#3322](https://github.com/apache/arrow-datafusion/issues/3322)
- test case `timestamp_add_interval_months` failed on master branch [\#3321](https://github.com/apache/arrow-datafusion/issues/3321)
- datafusion-proto does not support untyped null scalar values [\#3302](https://github.com/apache/arrow-datafusion/issues/3302)
- `ConfigOptions` creation is slow [\#3295](https://github.com/apache/arrow-datafusion/issues/3295)
- FilterPushDown optimization through UNION ALL results in SchemaError [\#3281](https://github.com/apache/arrow-datafusion/issues/3281)
- Execute LogicalPlans after building for TPCH Benchmarks [\#3273](https://github.com/apache/arrow-datafusion/issues/3273)
- `CREATE TABLE` should return empty DataFrame [\#3265](https://github.com/apache/arrow-datafusion/issues/3265) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- `CREATE EXTERNAL TABLE` from CSV creates a table with no columns if there is just a header row [\#3263](https://github.com/apache/arrow-datafusion/issues/3263)
- View TableProvider ignores projections, resulting in invalid plans [\#3240](https://github.com/apache/arrow-datafusion/issues/3240)
- CREATE VIEW should return an empty dataframe on success [\#3236](https://github.com/apache/arrow-datafusion/issues/3236)
- `DISTRIBUTE BY` expressions get removed during optimization [\#3234](https://github.com/apache/arrow-datafusion/issues/3234)
- datafusion cannot recognize chinese charactors. [\#3203](https://github.com/apache/arrow-datafusion/issues/3203)
- Panicked at 'byte index 1 is out of bounds on invalid query [\#3190](https://github.com/apache/arrow-datafusion/issues/3190)
- `like_nlike_with_null_lt` fails with latest sqlparser code [\#3187](https://github.com/apache/arrow-datafusion/issues/3187)
- Interval Literal output inconsistent date_type [\#3180](https://github.com/apache/arrow-datafusion/issues/3180)
- `array` function allows different data types [\#3123](https://github.com/apache/arrow-datafusion/issues/3123)
- eq operator doesn't work on binary data [\#3117](https://github.com/apache/arrow-datafusion/issues/3117)
- incorrect `where` clause comparison while using table alias [\#3073](https://github.com/apache/arrow-datafusion/issues/3073)
- Some functions are incorrectly declared as unary [\#3069](https://github.com/apache/arrow-datafusion/issues/3069)
- once now\(\) is called in a statement, it forever returns the same value [\#3057](https://github.com/apache/arrow-datafusion/issues/3057)
- single_distinct_to_groupby panic when group by expr is a binaryExpr [\#2994](https://github.com/apache/arrow-datafusion/issues/2994)
- Cannot have `order by` expression that references complex `group by` expression [\#2360](https://github.com/apache/arrow-datafusion/issues/2360)
- Fix some bugs in TypeCoercion rule [\#3407](https://github.com/apache/arrow-datafusion/pull/3407) ([andygrove](https://github.com/andygrove))
- MINOR: Stop ignoring `AggregateFunction::distinct` in protobuf serde code [\#3250](https://github.com/apache/arrow-datafusion/pull/3250) ([andygrove](https://github.com/andygrove))
- Add assertion for invariant in `create_physical_expression` and fix ViewTable projection [\#3242](https://github.com/apache/arrow-datafusion/pull/3242) ([andygrove](https://github.com/andygrove))
- Fix bug where optimizer was removing `Partitioning::DistributeBy` expressions [\#3229](https://github.com/apache/arrow-datafusion/pull/3229) ([andygrove](https://github.com/andygrove))

**Documentation updates:**

- \[minor\] add Coverage Status in readme [\#3220](https://github.com/apache/arrow-datafusion/pull/3220) ([Ted-Jiang](https://github.com/Ted-Jiang))

**Closed issues:**

- Add `\i` command to datafusion-cli [\#1906](https://github.com/apache/arrow-datafusion/issues/1906)
- TPC-H Query 15 [\#166](https://github.com/apache/arrow-datafusion/issues/166)

**Merged pull requests:**

- minor: fix some typo. [\#3453](https://github.com/apache/arrow-datafusion/pull/3453) ([jackwener](https://github.com/jackwener))
- Update criterion requirement from 0.3 to 0.4 [\#3452](https://github.com/apache/arrow-datafusion/pull/3452) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update object_store requirement from 0.4.0 to 0.5.0 [\#3451](https://github.com/apache/arrow-datafusion/pull/3451) ([dependabot[bot]](https://github.com/apps/dependabot))
- add `cast` support inside `values` [\#3447](https://github.com/apache/arrow-datafusion/pull/3447) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([kmitchener](https://github.com/kmitchener))
- Use hash repartitioning for aggregates on dictionaries [\#3445](https://github.com/apache/arrow-datafusion/pull/3445) ([isidentical](https://github.com/isidentical))
- Review `unwrap` and `panic` from the `aggregate` directory of `datafusion-physical-expr` [\#3443](https://github.com/apache/arrow-datafusion/pull/3443) ([iajoiner](https://github.com/iajoiner))
- MINOR: Implement protobuf serde for all binary operators [\#3441](https://github.com/apache/arrow-datafusion/pull/3441) ([andygrove](https://github.com/andygrove))
- MINOR: Add accessor methods to DateTimeIntervalExpr [\#3440](https://github.com/apache/arrow-datafusion/pull/3440) ([andygrove](https://github.com/andygrove))
- update TPCH-mimicking tests to Decimal data type from Float, matching the benchmark [\#3438](https://github.com/apache/arrow-datafusion/pull/3438) ([kmitchener](https://github.com/kmitchener))
- Include Bitwise operators in the documentation [\#3436](https://github.com/apache/arrow-datafusion/pull/3436) ([askoa](https://github.com/askoa))
- minor: make sql number parsing slightly more efficient + functional [\#3432](https://github.com/apache/arrow-datafusion/pull/3432) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Implement bitwise XOR operator \(`#`\) [\#3430](https://github.com/apache/arrow-datafusion/pull/3430) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([askoa](https://github.com/askoa))
- Replace From trait with TryFrom trait for datafusion-proto crate \#3401 [\#3429](https://github.com/apache/arrow-datafusion/pull/3429) ([comphead](https://github.com/comphead))
- Tests showing user defined aggregate returning a struct [\#3425](https://github.com/apache/arrow-datafusion/pull/3425) ([alamb](https://github.com/alamb))
- MINOR: update optimizer rule names to be consistent style as the rest [\#3415](https://github.com/apache/arrow-datafusion/pull/3415) ([kmitchener](https://github.com/kmitchener))
- Support date32 and date 64 in inlist node [\#3413](https://github.com/apache/arrow-datafusion/pull/3413) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Update sqlparser requirement from 0.22 to 0.23 [\#3411](https://github.com/apache/arrow-datafusion/pull/3411) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([dependabot[bot]](https://github.com/apps/dependabot))
- simplify the `between` expr during logical plan optimization [\#3404](https://github.com/apache/arrow-datafusion/pull/3404) ([kmitchener](https://github.com/kmitchener))
- MINOR: Improve optimizer error [\#3403](https://github.com/apache/arrow-datafusion/pull/3403) ([andygrove](https://github.com/andygrove))
- Review panics in the sql crate [\#3397](https://github.com/apache/arrow-datafusion/pull/3397) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([HaoYang670](https://github.com/HaoYang670))
- changed TPC-H benchmark to use Decimal types [\#3393](https://github.com/apache/arrow-datafusion/pull/3393) ([kmitchener](https://github.com/kmitchener))
- minor: remove redundant code. [\#3389](https://github.com/apache/arrow-datafusion/pull/3389) ([jackwener](https://github.com/jackwener))
- Add dictionary cases to merge bench [\#3384](https://github.com/apache/arrow-datafusion/pull/3384) ([tustvold](https://github.com/tustvold))
- Implement Eq trait for Expr and nested types [\#3381](https://github.com/apache/arrow-datafusion/pull/3381) ([jdye64](https://github.com/jdye64))
- Minor: Improvements to type coercion rule [\#3379](https://github.com/apache/arrow-datafusion/pull/3379) ([alamb](https://github.com/alamb))
- MINOR: Note that most communication happens on github [\#3375](https://github.com/apache/arrow-datafusion/pull/3375) ([alamb](https://github.com/alamb))
- minor fix: clean data type for negative operation [\#3370](https://github.com/apache/arrow-datafusion/pull/3370) ([liukun4515](https://github.com/liukun4515))
- Fix code generation for json feature [\#3367](https://github.com/apache/arrow-datafusion/pull/3367) ([avantgardnerio](https://github.com/avantgardnerio))
- Review use of panic in datafusion-proto crate [\#3365](https://github.com/apache/arrow-datafusion/pull/3365) ([comphead](https://github.com/comphead))
- Upgrade to arrow 22 [\#3363](https://github.com/apache/arrow-datafusion/pull/3363) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- return empty dataframe on create table, remove a duplicate optimize call [\#3361](https://github.com/apache/arrow-datafusion/pull/3361) ([kmitchener](https://github.com/kmitchener))
- Add SQL support for `tinyint` , `smallint`, and `unsigned int variants` [\#3359](https://github.com/apache/arrow-datafusion/pull/3359) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([kmitchener](https://github.com/kmitchener))
- Minor: add hint in README of example [\#3358](https://github.com/apache/arrow-datafusion/pull/3358) ([jackwener](https://github.com/jackwener))
- Collect to `HashSet` directly in `in_list` [\#3356](https://github.com/apache/arrow-datafusion/pull/3356) ([HaoYang670](https://github.com/HaoYang670))
- MINOR: Add comments about rewrite_disjunctive_predicate [\#3351](https://github.com/apache/arrow-datafusion/pull/3351) ([alamb](https://github.com/alamb))
- \[MINOR\] Add debug logging to plan teardown [\#3350](https://github.com/apache/arrow-datafusion/pull/3350) ([alamb](https://github.com/alamb))
- MINOR: add df.to_unoptimized_plan\(\) to docs, remove erroneous comment [\#3348](https://github.com/apache/arrow-datafusion/pull/3348) ([kmitchener](https://github.com/kmitchener))
- Replace `unwrap` in `convert_to_ordered_float` and add `downcast_value` [\#3347](https://github.com/apache/arrow-datafusion/pull/3347) ([iajoiner](https://github.com/iajoiner))
- Remove panics from `common_subexpr_eliminate` [\#3346](https://github.com/apache/arrow-datafusion/pull/3346) ([andygrove](https://github.com/andygrove))
- Remove Result.unwrap from single_distinct_to_groupby [\#3345](https://github.com/apache/arrow-datafusion/pull/3345) ([andygrove](https://github.com/andygrove))
- Add to_unoptimized_plan [\#3344](https://github.com/apache/arrow-datafusion/pull/3344) ([iajoiner](https://github.com/iajoiner))
- Remove panics from simplify_expressions optimizer rule [\#3343](https://github.com/apache/arrow-datafusion/pull/3343) ([andygrove](https://github.com/andygrove))
- Remove `unreachable!` from filter push down rule [\#3342](https://github.com/apache/arrow-datafusion/pull/3342) ([andygrove](https://github.com/andygrove))
- Replace panic in `datafusion-expr` crate [\#3341](https://github.com/apache/arrow-datafusion/pull/3341) ([iajoiner](https://github.com/iajoiner))
- Re-implement ExprIdentifierVisitor::desc_expr to use Expr::Display [\#3339](https://github.com/apache/arrow-datafusion/pull/3339) ([andygrove](https://github.com/andygrove))
- Fix the test`timestamp_add_interval_months` [\#3337](https://github.com/apache/arrow-datafusion/pull/3337) ([HaoYang670](https://github.com/HaoYang670))
- Bump lz4-sys from 1.9.3 to 1.9.4 in /datafusion-cli [\#3335](https://github.com/apache/arrow-datafusion/pull/3335) ([dependabot[bot]](https://github.com/apps/dependabot))
- Make binary operator formatting consistent between logical and physical plans [\#3331](https://github.com/apache/arrow-datafusion/pull/3331) ([andygrove](https://github.com/andygrove))
- Fix build: Ignore failing test [\#3329](https://github.com/apache/arrow-datafusion/pull/3329) ([andygrove](https://github.com/andygrove))
- Add `InList` support for binary type. [\#3324](https://github.com/apache/arrow-datafusion/pull/3324) ([HaoYang670](https://github.com/HaoYang670))
- MINOR: add github action trigger [\#3323](https://github.com/apache/arrow-datafusion/pull/3323) ([waynexia](https://github.com/waynexia))
- add explain sql test for optimizer rule PreCastLitInComparisonExpressions [\#3320](https://github.com/apache/arrow-datafusion/pull/3320) ([liukun4515](https://github.com/liukun4515))
- Custom / Dynamic table provider factories [\#3311](https://github.com/apache/arrow-datafusion/pull/3311) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- fix: alias group_by exprs in single_distinct_to_groupby optimizer [\#3305](https://github.com/apache/arrow-datafusion/pull/3305) ([waynexia](https://github.com/waynexia))
- Add support for serializing null scalar values [\#3303](https://github.com/apache/arrow-datafusion/pull/3303) ([andygrove](https://github.com/andygrove))
- Finish integrating `Expr::Is[Not]True` and similar expressions [\#3301](https://github.com/apache/arrow-datafusion/pull/3301) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- MINOR: Remove `unwrap` calls from `single_distinct_to_groupby optimizer` rule [\#3299](https://github.com/apache/arrow-datafusion/pull/3299) ([andygrove](https://github.com/andygrove))
- docs: update the Python library repository [\#3297](https://github.com/apache/arrow-datafusion/pull/3297) ([haoxins](https://github.com/haoxins))
- fix: speed up `ConfigOptions` creation [\#3296](https://github.com/apache/arrow-datafusion/pull/3296) ([crepererum](https://github.com/crepererum))
- Execute LogicalPlans after building for TPCH Benchmarks [\#3290](https://github.com/apache/arrow-datafusion/pull/3290) ([DaltonModlin](https://github.com/DaltonModlin))
- support for non-correlated subqueries [\#3287](https://github.com/apache/arrow-datafusion/pull/3287) ([kmitchener](https://github.com/kmitchener))
- Add `Aggregate::try new` with validation checks [\#3286](https://github.com/apache/arrow-datafusion/pull/3286) ([andygrove](https://github.com/andygrove))
- Fix SchemaError in FilterPushDown optimization with UNION ALL [\#3282](https://github.com/apache/arrow-datafusion/pull/3282) ([jonmmease](https://github.com/jonmmease))
- Allow sorting by aggregated groups [\#3280](https://github.com/apache/arrow-datafusion/pull/3280) ([isidentical](https://github.com/isidentical))
- Add show external tables [\#3279](https://github.com/apache/arrow-datafusion/pull/3279) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([psvri](https://github.com/psvri))
- Return from task execution if send fails as there is nothing more to do \(faster cancel / limit\) [\#3276](https://github.com/apache/arrow-datafusion/pull/3276) ([nvartolomei](https://github.com/nvartolomei))
- Let prelude import all expression functions [\#3274](https://github.com/apache/arrow-datafusion/pull/3274) ([sadilet](https://github.com/sadilet))
- Fix no schema when CSV is only header [\#3272](https://github.com/apache/arrow-datafusion/pull/3272) ([comphead](https://github.com/comphead))
- support inlist for pre cast literal expression [\#3270](https://github.com/apache/arrow-datafusion/pull/3270) ([liukun4515](https://github.com/liukun4515))
- implement `drop view` [\#3267](https://github.com/apache/arrow-datafusion/pull/3267) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([kmitchener](https://github.com/kmitchener))
- Use `ExprRewriter` in `pre_cast_lit_in_comparison` [\#3260](https://github.com/apache/arrow-datafusion/pull/3260) ([andygrove](https://github.com/andygrove))
- Add type coercion for UDFs in logical plan [\#3254](https://github.com/apache/arrow-datafusion/pull/3254) ([andygrove](https://github.com/andygrove))
- Support "IS NOT TRUE/FALSE" syntax [\#3252](https://github.com/apache/arrow-datafusion/pull/3252) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([sarahyurick](https://github.com/sarahyurick))
- Implement `IS UNKNOWN`/`IS NOT UNKNOWN` operators [\#3246](https://github.com/apache/arrow-datafusion/pull/3246) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([isidentical](https://github.com/isidentical))
- support decimal data type for the optimizer rule of PreCastLitInComparisonExpressions [\#3245](https://github.com/apache/arrow-datafusion/pull/3245) ([liukun4515](https://github.com/liukun4515))
- chore: update cranelifts to 0.87.0 [\#3243](https://github.com/apache/arrow-datafusion/pull/3243) ([yjshen](https://github.com/yjshen))
- Moved nullif out of unary functions [\#3241](https://github.com/apache/arrow-datafusion/pull/3241) ([comphead](https://github.com/comphead))
- MINOR: documentation updates [\#3239](https://github.com/apache/arrow-datafusion/pull/3239) ([kmitchener](https://github.com/kmitchener))
- MINOR: Add bounds check to Column physical expression [\#3238](https://github.com/apache/arrow-datafusion/pull/3238) ([andygrove](https://github.com/andygrove))
- CREATE VIEW should return empty dataframe [\#3237](https://github.com/apache/arrow-datafusion/pull/3237) ([kmitchener](https://github.com/kmitchener))
- Support "IS TRUE/FALSE" syntax \(redo\) [\#3235](https://github.com/apache/arrow-datafusion/pull/3235) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([sarahyurick](https://github.com/sarahyurick))
- Fix propagation of optimized predicates on nested projections [\#3228](https://github.com/apache/arrow-datafusion/pull/3228) ([isidentical](https://github.com/isidentical))
- Add more trim test cases [\#3226](https://github.com/apache/arrow-datafusion/pull/3226) ([ayushdg](https://github.com/ayushdg))
- Upgrade to arrow 21 [\#3225](https://github.com/apache/arrow-datafusion/pull/3225) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- Add optimizer rule for type coercion \(binary operations only\) [\#3222](https://github.com/apache/arrow-datafusion/pull/3222) ([andygrove](https://github.com/andygrove))
- \[Improve\] Use arrow::compute::sort in approx_percentile_cont [\#3219](https://github.com/apache/arrow-datafusion/pull/3219) ([Ted-Jiang](https://github.com/Ted-Jiang))
- \[minor\] fix bench aggregate_query_sql meta [\#3218](https://github.com/apache/arrow-datafusion/pull/3218) ([Ted-Jiang](https://github.com/Ted-Jiang))
- minor: refactor simplify negate [\#3213](https://github.com/apache/arrow-datafusion/pull/3213) ([jackwener](https://github.com/jackwener))
- MINOR: update cargo.lock and rust-version for datafusion-cli [\#3212](https://github.com/apache/arrow-datafusion/pull/3212) ([kmitchener](https://github.com/kmitchener))
- fix issue with now\(\) returning same value across statements [\#3210](https://github.com/apache/arrow-datafusion/pull/3210) ([kmitchener](https://github.com/kmitchener))
- Add support for inline column alias in CREATE VIEW [\#3209](https://github.com/apache/arrow-datafusion/pull/3209) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([DaltonModlin](https://github.com/DaltonModlin))
- Add SQL query planner support for `DISTRIBUTE BY` [\#3208](https://github.com/apache/arrow-datafusion/pull/3208) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- minor: remove test code that's in the arrow library now [\#3206](https://github.com/apache/arrow-datafusion/pull/3206) ([kmitchener](https://github.com/kmitchener))
- Use .get\(\) to avoid panic [\#3201](https://github.com/apache/arrow-datafusion/pull/3201) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([jklamer](https://github.com/jklamer))
- \[Minor\] Reduce code duplication creating ScalarValue::List [\#3197](https://github.com/apache/arrow-datafusion/pull/3197) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Clean up CI workflows by removing "matrix" strategy, simplifying names [\#3196](https://github.com/apache/arrow-datafusion/pull/3196) ([alamb](https://github.com/alamb))
- optimizer: add framework for the rule of pre-add cast to the literal in comparison binary [\#3185](https://github.com/apache/arrow-datafusion/pull/3185) ([liukun4515](https://github.com/liukun4515))
- Fix clippy [\#3182](https://github.com/apache/arrow-datafusion/pull/3182) ([alamb](https://github.com/alamb))
- MINOR: Add notes on writing release blog posts [\#3179](https://github.com/apache/arrow-datafusion/pull/3179) ([andygrove](https://github.com/andygrove))
- add min/max for time [\#3178](https://github.com/apache/arrow-datafusion/pull/3178) ([waitingkuo](https://github.com/waitingkuo))
- Recursively apply remove filter rule if filter is a true scalar value [\#3175](https://github.com/apache/arrow-datafusion/pull/3175) ([byteink](https://github.com/byteink))
- Update `ahash` requirement from 0.7 to 0.8 [\#3161](https://github.com/apache/arrow-datafusion/pull/3161) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Support number of centroids in approx_percentile_cont [\#3146](https://github.com/apache/arrow-datafusion/pull/3146) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Introduce `\i` command to execute from a file [\#3136](https://github.com/apache/arrow-datafusion/pull/3136) ([turbo1912](https://github.com/turbo1912))
- impl binary ops between binary arrays and scalars [\#3124](https://github.com/apache/arrow-datafusion/pull/3124) ([ozgrakkurt](https://github.com/ozgrakkurt))
