<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

## [25.0.0](https://github.com/apache/arrow-datafusion/tree/25.0.0) (2023-05-19)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/24.0.0...25.0.0)

**Breaking changes:**

- refactor: Expr::ScalarFunction to use a struct [#6281](https://github.com/apache/arrow-datafusion/pull/6281) (jackwener)
- Remove SizedRecordBatchStream [#6309](https://github.com/apache/arrow-datafusion/pull/6309) (tustvold)
- Add support for ordering sensitive aggregation [#6332](https://github.com/apache/arrow-datafusion/pull/6332) (mustafasrepo)
- Cleanup ExternalSorter metrics (#5885) [#6364](https://github.com/apache/arrow-datafusion/pull/6364) (tustvold)

**Implemented enhancements:**

- feat: LCM, GCD and Factorial [#6149](https://github.com/apache/arrow-datafusion/pull/6149) (izveigor)
- feat: negation of `Intervals` [#6312](https://github.com/apache/arrow-datafusion/pull/6312) (izveigor)
- feat: support bitwise and boolean aggregate functions [#6276](https://github.com/apache/arrow-datafusion/pull/6276) (izveigor)
- feat: min/max agg for bool [#6226](https://github.com/apache/arrow-datafusion/pull/6226) (crepererum)
- feat: add pattern for simplifying exprs like `str ~ '^foo$'` [#6369](https://github.com/apache/arrow-datafusion/pull/6369) (wolffcm)

**Fixed bugs:**

- fix: `projection_push_down` don't consider VarProvider in columns. [#6254](https://github.com/apache/arrow-datafusion/pull/6254) (jackwener)

**Documentation updates:**

- Bump snmalloc version in the example usage doc [#6344](https://github.com/apache/arrow-datafusion/pull/6344) (qrilka)

**Merged pull requests:**

- doc: add more sql example in ddl.md [#6266](https://github.com/apache/arrow-datafusion/pull/6266) (jackwener)
- Port tests in functions.rs to sqllogictest [#6256](https://github.com/apache/arrow-datafusion/pull/6256) (parkma99)
- Prepare 24.0.0 release [#6262](https://github.com/apache/arrow-datafusion/pull/6262) (andygrove)
- fix: `projection_push_down` don't consider VarProvider in columns. [#6254](https://github.com/apache/arrow-datafusion/pull/6254) (jackwener)
- Minor: rename NestedLoopsJoin memory reservation for clarity [#6228](https://github.com/apache/arrow-datafusion/pull/6228) (alamb)
- refactor: Expr::ScalarFunction to use a struct [#6281](https://github.com/apache/arrow-datafusion/pull/6281) (jackwener)
- Minor: document syntax of CREATE EXTERNAL TABLE [#6247](https://github.com/apache/arrow-datafusion/pull/6247) (alamb)
- feat: LCM, GCD and Factorial [#6149](https://github.com/apache/arrow-datafusion/pull/6149) (izveigor)
- Port tests in unicode.rs to sqllogictest [#6259](https://github.com/apache/arrow-datafusion/pull/6259) (parkma99)
- minor: remove prefix in type_coercion [#6283](https://github.com/apache/arrow-datafusion/pull/6283) (jackwener)
- Enable parser to parse create external clauses in arbitrary order [#6257](https://github.com/apache/arrow-datafusion/pull/6257) (aprimadi)
- minor: Remove dead code for casting dictionaries [#6286](https://github.com/apache/arrow-datafusion/pull/6286) (alamb)
- refactor: Expr::ScalarUDF to use a struct [#6284](https://github.com/apache/arrow-datafusion/pull/6284) (jackwener)
- refactor: Expr::AggregateUDF to use a struct [#6294](https://github.com/apache/arrow-datafusion/pull/6294) (my-vegetable-has-exploded)
- refactor: Expr::Exists to use a struct. [#6292](https://github.com/apache/arrow-datafusion/pull/6292) (QuenKar)
- refactor: Expr::InList to use a struct [#6293](https://github.com/apache/arrow-datafusion/pull/6293) (jackwener)
- Fix `CREATE EXTERNAL TABLE` doesn't work with non-standard file ext [#6274](https://github.com/apache/arrow-datafusion/pull/6274) (aprimadi)
- Support `interval '1 month' + date/timestamp`: Handle binary op interval in logical AST builder [#6270](https://github.com/apache/arrow-datafusion/pull/6270) (aprimadi)
- chore(deps): update substrait requirement from 0.8.0 to 0.9.0 [#6296](https://github.com/apache/arrow-datafusion/pull/6296) (dependabot[bot])
- Refactor: Expr::InSubquery to use a struct [#6295](https://github.com/apache/arrow-datafusion/pull/6295) (gitccl)
- Add more documentation to SortPreservingMergeStream [#6260](https://github.com/apache/arrow-datafusion/pull/6260) (aprimadi)
- refactor: Expr::PlaceHolder to use a struct [#6304](https://github.com/apache/arrow-datafusion/pull/6304) (jackwener)
- Fix inconsistent array type for binary numerical operators result between array and scalar [#6269](https://github.com/apache/arrow-datafusion/pull/6269) (viirya)
- Remove SizedRecordBatchStream [#6309](https://github.com/apache/arrow-datafusion/pull/6309) (tustvold)
- Improve error message for CREATE EXTERNAL TABLE [#6291](https://github.com/apache/arrow-datafusion/pull/6291) (parkma99)
- Remove the PhysicalSortExpr restriction on union get meet [#6273](https://github.com/apache/arrow-datafusion/pull/6273) (berkaysynnada)
- Disable `skip_failed_rules` optimizer config by default [#6265](https://github.com/apache/arrow-datafusion/pull/6265) (jackwener)
- Update Arrow 39 [#6252](https://github.com/apache/arrow-datafusion/pull/6252) (tustvold)
- Port tests in `json.rs` to sqllogictest [#6314](https://github.com/apache/arrow-datafusion/pull/6314) (gitccl)
- corrected order of cd command to git checkout [#6318](https://github.com/apache/arrow-datafusion/pull/6318) (sunny-jain-maersk)
- Port remainder of `window.rs` to sqllogictest [#6234](https://github.com/apache/arrow-datafusion/pull/6234) (alamb)
- feat: negation of `Intervals` [#6312](https://github.com/apache/arrow-datafusion/pull/6312) (izveigor)
- [parquet] Avoid read parquet index when there is no filter pushdown. [#6317](https://github.com/apache/arrow-datafusion/pull/6317) (Ted-Jiang)
- Parallel merge sort (#6162) [#6308](https://github.com/apache/arrow-datafusion/pull/6308) (tustvold)
- Port some tests in joins.rs to sqllogictest [#6306](https://github.com/apache/arrow-datafusion/pull/6306) (parkma99)
- Fix case evaluation with NULL [#6334](https://github.com/apache/arrow-datafusion/pull/6334) (byteink)
- Support null values in Avro string columns [#6307](https://github.com/apache/arrow-datafusion/pull/6307) (nenorbot)
- Add bdt to the list of known users [#6341](https://github.com/apache/arrow-datafusion/pull/6341) (qrilka)
- Port tests in errors.rs to context.rs [#6340](https://github.com/apache/arrow-datafusion/pull/6340) (masanobbb)
- Enable parquet page level skipping (page index pruning) by default [#5099](https://github.com/apache/arrow-datafusion/pull/5099) (alamb)
- Bump snmalloc version in the example usage doc [#6344](https://github.com/apache/arrow-datafusion/pull/6344) (qrilka)
- Port tests in explain.rs to sqllogictests [#6343](https://github.com/apache/arrow-datafusion/pull/6343) (my-vegetable-has-exploded)
- Improve parallelism of repartition operator with multiple cores [#6310](https://github.com/apache/arrow-datafusion/pull/6310) (alamb)
- Ordering satisfy consider ordering equivalence of different lengths [#6330](https://github.com/apache/arrow-datafusion/pull/6330) (berkaysynnada)
- Minor: Update documentation for `datafusion.execution.parquet.enable_page_index` [#6342](https://github.com/apache/arrow-datafusion/pull/6342) (alamb)
- refine decimal multiply, avoid cast to wider type [#6331](https://github.com/apache/arrow-datafusion/pull/6331) (mingmwang)
- Combine the two rules: DecorrelateWhereExists and DecorrelateWhereIn [#6271](https://github.com/apache/arrow-datafusion/pull/6271) (mingmwang)
- feat: support bitwise and boolean aggregate functions [#6276](https://github.com/apache/arrow-datafusion/pull/6276) (izveigor)
- Fix explain plan formatting in sqllogictest [#6329](https://github.com/apache/arrow-datafusion/pull/6329) (alamb)
- Fix expected output [#6353](https://github.com/apache/arrow-datafusion/pull/6353) (alamb)
- Simplify IsNotNull and IsNull expression [#6345](https://github.com/apache/arrow-datafusion/pull/6345) (byteink)
- Add support for ordering sensitive aggregation [#6332](https://github.com/apache/arrow-datafusion/pull/6332) (mustafasrepo)
- chore(deps): update substrait requirement from 0.9.0 to 0.10.0 [#6351](https://github.com/apache/arrow-datafusion/pull/6351) (dependabot[bot])
- Minor: Update the testing section of contributor guide [#6357](https://github.com/apache/arrow-datafusion/pull/6357) (alamb)
- Add support for reading Arrow files [#6337](https://github.com/apache/arrow-datafusion/pull/6337) (jonmmease)
- Support CREATE TABLE via SQL for infinite streams [#6352](https://github.com/apache/arrow-datafusion/pull/6352) (aprimadi)
- feat: min/max agg for bool [#6226](https://github.com/apache/arrow-datafusion/pull/6226) (crepererum)
- Fix variable shadowing in test code [#6361](https://github.com/apache/arrow-datafusion/pull/6361) (lokax)
- Cleanup ExternalSorter metrics (#5885) [#6364](https://github.com/apache/arrow-datafusion/pull/6364) (tustvold)
- Fix nullability calculation for boolean expressions [#6365](https://github.com/apache/arrow-datafusion/pull/6365) (byteink)
- Faster ListingTable partition listing (#6182) [#6183](https://github.com/apache/arrow-datafusion/pull/6183) (tustvold)
- feat: add pattern for simplifying exprs like `str ~ '^foo$'` [#6369](https://github.com/apache/arrow-datafusion/pull/6369) (wolffcm)
- Minor: remove left over println [#6375](https://github.com/apache/arrow-datafusion/pull/6375) (alamb)
- Limit the number of partition files to be displayed for FileGroupsDisplay [#6359](https://github.com/apache/arrow-datafusion/pull/6359) (yahoNanJing)
- Switch to non-recursive on heap virtual stack when building logical plan from SQL expression [#6360](https://github.com/apache/arrow-datafusion/pull/6360) (aprimadi)
- Fix UNION ALL aliasing [#6373](https://github.com/apache/arrow-datafusion/pull/6373) (comphead)
- [sqllogictest] port tests in avro.rs to sqllogictest [#6362](https://github.com/apache/arrow-datafusion/pull/6362) (e1ijah1)
- Concurrent Parquet Schema Inference [#6366](https://github.com/apache/arrow-datafusion/pull/6366) (tustvold)
- Add` COPY .. TO ..` syntax support [#6355](https://github.com/apache/arrow-datafusion/pull/6355) (alamb)
