<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Communication

We welcome participation from everyone and encourage you to join us, ask
questions, and get involved.

All participation in the Apache Arrow DataFusion project is governed by the
Apache Software Foundation's [code of
conduct](https://www.apache.org/foundation/policies/conduct.html).

## GitHub

The vast majority of communication occurs in the open on our
[github repository](https://github.com/apache/arrow-datafusion) in the form of tickets, issues, discussions, and Pull Requests.

## Slack and Discord

We use the Slack and Discord platforms for informal discussions and coordination. These are great places to
meet other contributors and get guidance on where to contribute. It is important to note that any technical designs and
decisions are made fully in the open, on GitHub.

Most of us use the `#arrow-datafusion` and `#arrow-rust` channels in the [ASF Slack workspace](https://s.apache.org/slack-invite) .
Unfortunately, due to spammers, the ASF Slack workspace requires an invitation to join. To get an invitation,
request one in the `Arrow Rust` channel of the [Arrow Rust Discord server](https://discord.gg/Qw5gKqHxUM).

## Mailing list

We also use arrow.apache.org's `dev@` mailing list for release coordination and occasional design discussions. Other
than the the release process, most DataFusion mailing list traffic will link to a GitHub issue or PR for discussion.
([subscribe](mailto:dev-subscribe@arrow.apache.org),
[unsubscribe](mailto:dev-unsubscribe@arrow.apache.org),
[archives](https://lists.apache.org/list.html?dev@arrow.apache.org)).

When emailing the dev list, please make sure to prefix the subject line with a
`[DataFusion]` tag, e.g. `"[DataFusion] New API for remote data sources"`, so
that the appropriate people in the Apache Arrow community notice the message.
