<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

## [22.0.0](https://github.com/apache/arrow-datafusion/tree/22.0.0) (2023-04-07)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/21.1.0...22.0.0)

**Breaking changes:**

- Introduce a common trait TreeNode for ExecutionPlan, PhysicalExpr, LogicalExpr, LogicalPlan [#5630](https://github.com/apache/arrow-datafusion/pull/5630) (yahoNanJing)
- Minor: Reduce clones in AnalyzerRule [#5728](https://github.com/apache/arrow-datafusion/pull/5728) (alamb)
- Change required input ordering physical plan API to allow any NULLS FIRST / LAST and ASC / DESC [#5772](https://github.com/apache/arrow-datafusion/pull/5772) (mustafasrepo)
- Remove batch_idx from SortKeyCursor [#5855](https://github.com/apache/arrow-datafusion/pull/5855) (tustvold)
- Top down `EnforceSorting`, Extended testbench for `EnforceSorting` rule to prepare for refactors, additional functionality such as pushdowns over unions [#5661](https://github.com/apache/arrow-datafusion/pull/5661) (mustafasrepo)
- Move `TransactionStart`/`TransactionEnd`/`SetVariable` into `LogicalPlan::Statement` [#5842](https://github.com/apache/arrow-datafusion/pull/5842) (alamb)

**Implemented enhancements:**

- feat: Simplify LOG and POWER functions [#5816](https://github.com/apache/arrow-datafusion/pull/5816) (izveigor)
- feat: Add expression rewrite rules for LIKE and ILIKE [#5819](https://github.com/apache/arrow-datafusion/pull/5819) (Weijun-H)
- feat: BuiltinScalarFunction::Cbrt [#5839](https://github.com/apache/arrow-datafusion/pull/5839) (izveigor)
- feat: Quote column names if required in error messages [#5778](https://github.com/apache/arrow-datafusion/pull/5778) (alamb)

**Fixed bugs:**

- Fix parquet pruning when column names have periods [#5710](https://github.com/apache/arrow-datafusion/pull/5710) (alamb)
- fix: parse table name into TableReference on converting substrait read [#5716](https://github.com/apache/arrow-datafusion/pull/5716) (waynexia)
- fix: Enhance case expression type coercion [#5820](https://github.com/apache/arrow-datafusion/pull/5820) (Jefffrey)
- fix: type_coercion support BinaryExpr ( interval , timestamp ). [#5845](https://github.com/apache/arrow-datafusion/pull/5845) (jackwener)
- fix: coerce type for InSubquery and fix timestamp minus timestamp. [#5853](https://github.com/apache/arrow-datafusion/pull/5853) (jackwener)

**Documentation updates:**

- chore: update sql function documentation [#5780](https://github.com/apache/arrow-datafusion/pull/5780) (sanderson)
- Minor: fix docs build [#5795](https://github.com/apache/arrow-datafusion/pull/5795) (alamb)
- Move content from README.md to docs site [#5824](https://github.com/apache/arrow-datafusion/pull/5824) (alamb)
- Update docs/source/contributor-guide/index.md [#5872](https://github.com/apache/arrow-datafusion/pull/5872) (2010YOUY01)

**Merged pull requests:**

- Fix parquet pruning when column names have periods [#5710](https://github.com/apache/arrow-datafusion/pull/5710) (alamb)
- Executing LocalLimitExec with no column should not return an Err [#5709](https://github.com/apache/arrow-datafusion/pull/5709) (kazuyukitanimura)
- Minor: Comments to .asf.yaml [#5703](https://github.com/apache/arrow-datafusion/pull/5703) (alamb)
- Exclude some .github files from rat license check [#5720](https://github.com/apache/arrow-datafusion/pull/5720) (andygrove)
- Minor: Trigger docs CI build on changes to asf.yaml [#5726](https://github.com/apache/arrow-datafusion/pull/5726) (alamb)
- Use consistent arrow version (do not use both arrrow 34 and arrow-array 35) [#5724](https://github.com/apache/arrow-datafusion/pull/5724) (tustvold)
- LIMIT edge cases [#5723](https://github.com/apache/arrow-datafusion/pull/5723) (comphead)
- Put the file "type_coercion" in the same named fold and rename the file "mod.rs" [#5736](https://github.com/apache/arrow-datafusion/pull/5736) (HaoYang670)
- fix: parse table name into TableReference on converting substrait read [#5716](https://github.com/apache/arrow-datafusion/pull/5716) (waynexia)
- Modify tests for TPCH explain plans to avoid regressions [#5741](https://github.com/apache/arrow-datafusion/pull/5741) (jiangyinzuo)
- Minor: port select tests to sqllogictests [#5740](https://github.com/apache/arrow-datafusion/pull/5740) (alamb)
- Introduce a common trait TreeNode for ExecutionPlan, PhysicalExpr, LogicalExpr, LogicalPlan [#5630](https://github.com/apache/arrow-datafusion/pull/5630) (yahoNanJing)
- Minor: Reduce clones in AnalyzerRule [#5728](https://github.com/apache/arrow-datafusion/pull/5728) (alamb)
- Upgrade to substrait 0.5.1 and set the version field of produced plans [#5707](https://github.com/apache/arrow-datafusion/pull/5707) (mbrobbel)
- excluding doctests for mac/win64 platform ,Make them consistent with amd64 [#5730](https://github.com/apache/arrow-datafusion/pull/5730) (jiangzhx)
- fix test of benchmarks warning [#5737](https://github.com/apache/arrow-datafusion/pull/5737) (r4ntix)
- Move protoc generation to binary crate (#5718) [#5742](https://github.com/apache/arrow-datafusion/pull/5742) (l0kr)
- Add compare.py to compare the output of multiple benchmarks [#5655](https://github.com/apache/arrow-datafusion/pull/5655) (alamb)
- Move and rename `expr_rewriter.rs` [#5743](https://github.com/apache/arrow-datafusion/pull/5743) (HaoYang670)
- Minor: port some decimal tests to sqllogictests [#5739](https://github.com/apache/arrow-datafusion/pull/5739) (alamb)
- Update to arrow 36 [#5685](https://github.com/apache/arrow-datafusion/pull/5685) (tustvold)
- Minor: Avoid an unecessary contruction in `map_children` some extra plan construction [#5761](https://github.com/apache/arrow-datafusion/pull/5761) (alamb)
- minor: fix typos in planner.rs error msg [#5776](https://github.com/apache/arrow-datafusion/pull/5776) (jiangzhx)
- minor: add timestampstz utf8 conversion test [#5777](https://github.com/apache/arrow-datafusion/pull/5777) (comphead)
- Update prost-build requirement from =0.11.7 to =0.11.8 [#5773](https://github.com/apache/arrow-datafusion/pull/5773) (dependabot[bot])
- infer right side nullability for LEFT join [#5748](https://github.com/apache/arrow-datafusion/pull/5748) (comphead)
- MINOR: simplify sqllogic test schema check [#5769](https://github.com/apache/arrow-datafusion/pull/5769) (comphead)
- Change required input ordering physical plan API to allow any NULLS FIRST / LAST and ASC / DESC [#5772](https://github.com/apache/arrow-datafusion/pull/5772) (mustafasrepo)
- Support timestamp and interval arithmetic [#5764](https://github.com/apache/arrow-datafusion/pull/5764) (berkaysynnada)
- chore: update sql function documentation [#5780](https://github.com/apache/arrow-datafusion/pull/5780) (sanderson)
- Minor: fix docs build [#5795](https://github.com/apache/arrow-datafusion/pull/5795) (alamb)
- Minor: use workspace arrow-array rather than hard coded 34 [#5794](https://github.com/apache/arrow-datafusion/pull/5794) (alamb)
- Return an error for invalid placeholder `$0` instead of panicking [#5787](https://github.com/apache/arrow-datafusion/pull/5787) (kawadakk)
- Bump substrait version to 0.6.0 [#5798](https://github.com/apache/arrow-datafusion/pull/5798) (jdye64)
- Support `INTERVAL` SQL Type [#5792](https://github.com/apache/arrow-datafusion/pull/5792) (alamb)
- Minor: fix flaking test [#5805](https://github.com/apache/arrow-datafusion/pull/5805) (alamb)
- Incorrect row comparison for tpch queries in benchmarks [#5784](https://github.com/apache/arrow-datafusion/pull/5784) (viirya)
- Update ctor requirement from 0.1.22 to 0.2.0 [#5752](https://github.com/apache/arrow-datafusion/pull/5752) (dependabot[bot])
- Minor: Port some timestamp tests to sqllogictests [#5804](https://github.com/apache/arrow-datafusion/pull/5804) (alamb)
- Minor: remove typed_min_max_batch_decimal128 [#5809](https://github.com/apache/arrow-datafusion/pull/5809) (izveigor)
- Minor: Run rust workflow on changes to .github [#5758](https://github.com/apache/arrow-datafusion/pull/5758) (alamb)
- Minor: clean up timestamp arithmetic tests [#5803](https://github.com/apache/arrow-datafusion/pull/5803) (alamb)
- improve Filter pushdown to Join [#5770](https://github.com/apache/arrow-datafusion/pull/5770) (mingmwang)
- Support `round()` function with two parameters [#5807](https://github.com/apache/arrow-datafusion/pull/5807) (viirya)
- Fix datatype of case expression [#5734](https://github.com/apache/arrow-datafusion/pull/5734) (mslapek)
- Minor: Add ticket reference as comment [#5822](https://github.com/apache/arrow-datafusion/pull/5822) (alamb)
- Forward port version and Changelog for `21.1.0` [#5767](https://github.com/apache/arrow-datafusion/pull/5767) (alamb)
- Implement LogicalPlan support for transactions [#5827](https://github.com/apache/arrow-datafusion/pull/5827) (avantgardnerio)
- Minor: port more timestamp tests to sqllogictests [#5832](https://github.com/apache/arrow-datafusion/pull/5832) (alamb)
- feat: Simplify LOG and POWER functions [#5816](https://github.com/apache/arrow-datafusion/pull/5816) (izveigor)
- fix: Enhance case expression type coercion [#5820](https://github.com/apache/arrow-datafusion/pull/5820) (Jefffrey)
- feat: Add expression rewrite rules for LIKE and ILIKE [#5819](https://github.com/apache/arrow-datafusion/pull/5819) (Weijun-H)
- fix: type_coercion support BinaryExpr ( interval , timestamp ). [#5845](https://github.com/apache/arrow-datafusion/pull/5845) (jackwener)
- Add primary key information to CreateMemoryTable LogicalPlan node [#5835](https://github.com/apache/arrow-datafusion/pull/5835) (avantgardnerio)
- Expose substrait protoc feature [#5852](https://github.com/apache/arrow-datafusion/pull/5852) (andygrove)
- minor(sqlparser): encapsulate PlanerContext, reduce some clones [#5814](https://github.com/apache/arrow-datafusion/pull/5814) (alamb)
- Remove batch_idx from SortKeyCursor [#5855](https://github.com/apache/arrow-datafusion/pull/5855) (tustvold)
- Improving optimizer performance by eliminating unnecessary sort and distribution passes, add more SymmetricHashJoin improvements [#5754](https://github.com/apache/arrow-datafusion/pull/5754) (metesynnada)
- Poll next open file future while scanning current file [#5800](https://github.com/apache/arrow-datafusion/pull/5800) (nenorbot)
- Top down `EnforceSorting`, Extended testbench for `EnforceSorting` rule to prepare for refactors, additional functionality such as pushdowns over unions [#5661](https://github.com/apache/arrow-datafusion/pull/5661) (mustafasrepo)
- Move `TransactionStart`/`TransactionEnd`/`SetVariable` into `LogicalPlan::Statement` [#5842](https://github.com/apache/arrow-datafusion/pull/5842) (alamb)
- Move content from README.md to docs site [#5824](https://github.com/apache/arrow-datafusion/pull/5824) (alamb)
- Fix `interval` to use consistent units and arrow parser [#5806](https://github.com/apache/arrow-datafusion/pull/5806) (alamb)
- Enhance Asynchronous Performance of SHJ Implementation [#5864](https://github.com/apache/arrow-datafusion/pull/5864) (metesynnada)
- Prove timestamptz <=> timestamp now works [#5869](https://github.com/apache/arrow-datafusion/pull/5869) (comphead)
- Update docs/source/contributor-guide/index.md [#5872](https://github.com/apache/arrow-datafusion/pull/5872) (2010YOUY01)
- fix: coerce type for InSubquery and fix timestamp minus timestamp. [#5853](https://github.com/apache/arrow-datafusion/pull/5853) (jackwener)
- chore: update sqllogictest version 0.13.2. [#5875](https://github.com/apache/arrow-datafusion/pull/5875) (jackwener)
- Minor: Add crates.io / API links to website [#5871](https://github.com/apache/arrow-datafusion/pull/5871) (alamb)
- minor: made `information_schema` pub [#5862](https://github.com/apache/arrow-datafusion/pull/5862) (MichaelScofield)
- Update substrait requirement from 0.6.0 to 0.7.1 [#5876](https://github.com/apache/arrow-datafusion/pull/5876) (dependabot[bot])
- refactor: move type_coercion to analyzer [#5831](https://github.com/apache/arrow-datafusion/pull/5831) (jackwener)
- feat: BuiltinScalarFunction::Cbrt [#5839](https://github.com/apache/arrow-datafusion/pull/5839) (izveigor)
- [Minor]: Update `architecture.md` to include April tech talks [#5865](https://github.com/apache/arrow-datafusion/pull/5865) (comphead)
- [sqllogictest] Run tests on Windows [#5870](https://github.com/apache/arrow-datafusion/pull/5870) (melgenek)
- Support create object store source tables without depending on environment variables [#5732](https://github.com/apache/arrow-datafusion/pull/5732) (r4ntix)
- feat: Quote column names if required in error messages [#5778](https://github.com/apache/arrow-datafusion/pull/5778) (alamb)
- [MINOR]: Refactor to increase readability [#5874](https://github.com/apache/arrow-datafusion/pull/5874) (mustafasrepo)
- More realistic sort benchmarks [#5881](https://github.com/apache/arrow-datafusion/pull/5881) (tustvold)
- Removal of arithmetic operations for temporal values to binary.rs [#5846](https://github.com/apache/arrow-datafusion/pull/5846) (berkaysynnada)
- Moving PipelineFixer above all rules to use ExecutionPlan APIs [#5880](https://github.com/apache/arrow-datafusion/pull/5880) (metesynnada)
- Add assert on hash children partition count [#5768](https://github.com/apache/arrow-datafusion/pull/5768) (duongcongtoai)
- Use ScalarValue for single input on math expression [#5891](https://github.com/apache/arrow-datafusion/pull/5891) (viirya)
- Generify SortPreservingMerge (#5882) (#5879) [#5886](https://github.com/apache/arrow-datafusion/pull/5886) (tustvold)
- Fix: allow arbitrary exprs in VALUES clause [#5813](https://github.com/apache/arrow-datafusion/pull/5813) (alamb)
