<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Communication

We welcome participation from everyone and encourage you to join us, ask
questions, and get involved.

All participation in the Apache Arrow DataFusion project is governed by the
Apache Software Foundation's [code of
conduct](https://www.apache.org/foundation/policies/conduct.html).

The vast majority of communication occurs in the open on our
[github repository](https://github.com/apache/arrow-datafusion).

## Questions?

### Mailing list

We use arrow.apache.org's `dev@` mailing list for project management, release
coordination and design discussions
([subscribe](mailto:dev-subscribe@arrow.apache.org),
[unsubscribe](mailto:dev-unsubscribe@arrow.apache.org),
[archives](https://lists.apache.org/list.html?dev@arrow.apache.org)).

When emailing the dev list, please make sure to prefix the subject line with a
`[DataFusion]` tag, e.g. `"[DataFusion] New API for remote data sources"`, so
that the appropriate people in the Apache Arrow community notice the message.

### Slack and Discord

We use the official [ASF](https://s.apache.org/slack-invite) Slack workspace
for informal discussions and coordination. This is a great place to meet other
contributors and get guidance on where to contribute. Join us in the
`#arrow-rust` channel.

We also have a backup Arrow Rust Discord
server ([invite link](https://discord.gg/Qw5gKqHxUM)) in case you are not able
to join the Slack workspace. If you need an invite to the Slack workspace, you
can also ask for one in our Discord server.

### Sync up video calls

We have biweekly sync calls every other Thursdays at both 04:00 UTC
and 16:00 UTC (starting September 30, 2021) depending on if there are
items on the agenda to discuss and someone being willing to host.

Please see the [agenda](https://docs.google.com/document/d/1atCVnoff5SR4eM4Lwf2M1BBJTY6g3_HUNR6qswYJW_U/edit)
for the video call link, add topics and to see what others plan to discuss.

The goals of these calls are:

1. Help "put a face to the name" of some of other contributors we are working with
2. Discuss / synchronize on the goals and major initiatives from different stakeholders to identify areas where more alignment is needed

No decisions are made on the call and anything of substance will be discussed on the mailing list or in github issues / google docs.

We will send a summary of all sync ups to the dev@arrow.apache.org mailing list.
