<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Changelog

## [13.0.0](https://github.com/apache/arrow-datafusion/tree/13.0.0) (2022-10-06)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/12.0.0...13.0.0)

**Breaking changes:**

- Make ObjectStoreProvider fallible \(return `Result` rather than `Option`\) [\#3584](https://github.com/apache/arrow-datafusion/pull/3584) ([tustvold](https://github.com/tustvold))
- Make `OptimizerConfig` a builder style API [\#3525](https://github.com/apache/arrow-datafusion/pull/3525) ([alamb](https://github.com/alamb))

**Implemented enhancements:**

- remove `type coercion` for ScalarUDF in the physical phase [\#3734](https://github.com/apache/arrow-datafusion/issues/3734)
- Allow with statements to specify their columns alongside their expression names [\#3716](https://github.com/apache/arrow-datafusion/issues/3716)
- Support SQLDataType::Timestamp\(TimezoneInfo\) [\#3693](https://github.com/apache/arrow-datafusion/issues/3693)
- support `type coercion` for case when expr [\#3673](https://github.com/apache/arrow-datafusion/issues/3673)
- Add simplification rules for the `Modulo` operator [\#3664](https://github.com/apache/arrow-datafusion/issues/3664)
- Add TIMESTAMPTZ [\#3659](https://github.com/apache/arrow-datafusion/issues/3659)
- Simplify `A * 0` and `A * null`. [\#3626](https://github.com/apache/arrow-datafusion/issues/3626)
- change rule of `PreCastLitInComparisonExpressions` to unwrap cast rule after \#3582 [\#3622](https://github.com/apache/arrow-datafusion/issues/3622)
- Optimize regex\_replace with a known pattern / replacement [\#3613](https://github.com/apache/arrow-datafusion/issues/3613)
- Simplify `CONCAT_WS(NULL, ..)` to `NULL` [\#3607](https://github.com/apache/arrow-datafusion/issues/3607)
- Add OctoSQL to list of systems powered by DataFusion [\#3605](https://github.com/apache/arrow-datafusion/issues/3605)
- Prevent over-allocation \(and spills\) on TopK queries [\#3596](https://github.com/apache/arrow-datafusion/issues/3596)
- Allow ObjectStoreProvider to return None \(return Result\<Option\> rather than Result\)  [\#3594](https://github.com/apache/arrow-datafusion/issues/3594)
- simplify between expr should consider the data type [\#3587](https://github.com/apache/arrow-datafusion/issues/3587)
- make type coercion simple and remove the evaluate logic [\#3585](https://github.com/apache/arrow-datafusion/issues/3585)
- ReduceOuterJoin optimizer support `cast or try_cast` expr. [\#3565](https://github.com/apache/arrow-datafusion/issues/3565)
- Support type coercion for subquery [\#3557](https://github.com/apache/arrow-datafusion/issues/3557)
- Make `ParquetScanOptions` public and expose a reference to the scan options from `ParquetExec` [\#3550](https://github.com/apache/arrow-datafusion/issues/3550)
- Use `fetch` limit in `get_sorted_iter`  [\#3544](https://github.com/apache/arrow-datafusion/issues/3544)
- Push limit to sort [\#3528](https://github.com/apache/arrow-datafusion/issues/3528)
- Execute sorts in parallel when limit is used after sort [\#3526](https://github.com/apache/arrow-datafusion/issues/3526)
- Consolidate optimizer passes in optimizer module for better testing [\#3524](https://github.com/apache/arrow-datafusion/issues/3524)
- Support Top-K query optimization for `ORDER BY \<EXPR\> \[ASC [\#3515](https://github.com/apache/arrow-datafusion/issues/3515)
- support the type coercion for `like` `unlike` `istrue` `isfalse` `isunknown` [\#3509](https://github.com/apache/arrow-datafusion/issues/3509)
- Automate the pushing of releases to Homebrew [\#3506](https://github.com/apache/arrow-datafusion/issues/3506)
- Add extra DATE\_PART units that are already supported in arrow-rs [\#3502](https://github.com/apache/arrow-datafusion/issues/3502)
- Release datafusion-cli 12.0.0 on Homebrew [\#3501](https://github.com/apache/arrow-datafusion/issues/3501)
- Make `from_proto_binary_op` public [\#3489](https://github.com/apache/arrow-datafusion/issues/3489)
- coercion between decimal and other types lacking, compared to other numeric types [\#3479](https://github.com/apache/arrow-datafusion/issues/3479)
- move type coercion for inlist from physical phase to logical phase [\#3468](https://github.com/apache/arrow-datafusion/issues/3468)
- Make `datafusion::physical_plan::file_format::file_strean::FileStream` public [\#3466](https://github.com/apache/arrow-datafusion/issues/3466)
- Support using offset index in `ParquetRecordBatchStream` when pushing down `RowFilter` [\#3456](https://github.com/apache/arrow-datafusion/issues/3456)
- Support timestamp data type in In\_list node [\#3449](https://github.com/apache/arrow-datafusion/issues/3449)
- Evaluate expressions after type coercion  [\#3431](https://github.com/apache/arrow-datafusion/issues/3431)
- Make a convenience function to register a single `RecordBatch` as a table from SessionContext [\#3426](https://github.com/apache/arrow-datafusion/issues/3426)
- add datafusion-cli support of external table locations that object\_store supports [\#3424](https://github.com/apache/arrow-datafusion/issues/3424)
- pruning support cast/try\_cast expr [\#3414](https://github.com/apache/arrow-datafusion/issues/3414)
- Add documentation on querying against files in object store such as S3 [\#3399](https://github.com/apache/arrow-datafusion/issues/3399)
- Remove type-coercion from physical planner [\#3388](https://github.com/apache/arrow-datafusion/issues/3388)
- support `Statement::ShowVariable` to show session configs [\#3364](https://github.com/apache/arrow-datafusion/issues/3364)
- Support `RowFilter` in `ParquetExec` [\#3360](https://github.com/apache/arrow-datafusion/issues/3360)
- Apply `TypeCoercion` rule before `FilterPushDown` [\#3289](https://github.com/apache/arrow-datafusion/issues/3289)
- Add support for `get` / `show` timezone [\#3255](https://github.com/apache/arrow-datafusion/issues/3255)
- Consider adding DataFusion to ClickBench benchmarks [\#2902](https://github.com/apache/arrow-datafusion/issues/2902)
- `filter_push_down` panics on semi/anti join with join filters [\#2888](https://github.com/apache/arrow-datafusion/issues/2888)
- Migrate the `cross join -> inner join optimization` from the planner to the optimizer [\#2859](https://github.com/apache/arrow-datafusion/issues/2859)
- ObjectStore write support [\#2185](https://github.com/apache/arrow-datafusion/issues/2185)
- DataFusion should scan Parquet statistics once per query [\#871](https://github.com/apache/arrow-datafusion/issues/871)
- Extend & generalize constant folding / evaluation in logical optimizer  [\#237](https://github.com/apache/arrow-datafusion/issues/237)

**Fixed bugs:**

- `projection_push_down` produces invalid aggregate plans in some cases [\#3738](https://github.com/apache/arrow-datafusion/issues/3738)
- `Time With Time Zone` should raise error until `DataType::Time64` support tz [\#3715](https://github.com/apache/arrow-datafusion/issues/3715)
- SQL Planner doesn't distinguish normal CTEs from the recursive ones. [\#3713](https://github.com/apache/arrow-datafusion/issues/3713)
- Fix inconsistency between column name formats [\#3711](https://github.com/apache/arrow-datafusion/issues/3711)
- Optimizer rule 'projection\_push\_down' failed due to unexpected error: Error during planning: Aggregate schema has wrong number of fields. Expected 3 got 8 [\#3704](https://github.com/apache/arrow-datafusion/issues/3704)
- Optimizer regressions in `unwrap_cast_in_comparison` [\#3690](https://github.com/apache/arrow-datafusion/issues/3690)
- Internal error when evaluating a predicate = "The type of Dictionary\(Int16, Utf8\) = Int64 of binary physical should be same" [\#3685](https://github.com/apache/arrow-datafusion/issues/3685)
- Specialized regexp\_replace should early-abort when the the input arrays are empty [\#3647](https://github.com/apache/arrow-datafusion/issues/3647)
- Internal error: Failed to coerce types Decimal128\(10, 2\) and Boolean in BETWEEN expression [\#3646](https://github.com/apache/arrow-datafusion/issues/3646)
- Internal error: Failed to coerce types Decimal128\(10, 2\) and Boolean in BETWEEN expression [\#3645](https://github.com/apache/arrow-datafusion/issues/3645)
- Type coercion error: The type of Boolean AND Decimal128\(10, 2\) of binary physical should be same [\#3644](https://github.com/apache/arrow-datafusion/issues/3644)
- LEFT JOIN not working as expected, error message is confusing [\#3639](https://github.com/apache/arrow-datafusion/issues/3639)
- `INTERSECT` and `EXCEPT` don't return an error when 2 sets have the different number of columns [\#3632](https://github.com/apache/arrow-datafusion/issues/3632)
- The datafusion-cli panics when `union` 2 table with different number of columns. [\#3630](https://github.com/apache/arrow-datafusion/issues/3630)
- The expression `col(a) / null` is not optimized. [\#3624](https://github.com/apache/arrow-datafusion/issues/3624)
- `s3_build_error` test may fail in some environments [\#3601](https://github.com/apache/arrow-datafusion/issues/3601)
- New clippy errors appears to be break the CI on the master [\#3597](https://github.com/apache/arrow-datafusion/issues/3597)
- `StringConcat` gives inconsistent result with `concat` when containing `null` [\#3569](https://github.com/apache/arrow-datafusion/issues/3569)
- simplify\_expressions don't support different data type for binary [\#3556](https://github.com/apache/arrow-datafusion/issues/3556)
- Broken logical plan serialization for aggregation queries  [\#3555](https://github.com/apache/arrow-datafusion/issues/3555)
- Aggregate filters do not get pushed down to table scan [\#3546](https://github.com/apache/arrow-datafusion/issues/3546)
- `docs.rs` cannot build `datafusion-proto` crate [\#3538](https://github.com/apache/arrow-datafusion/issues/3538)
- DataFusion serialization doesn't handle `ScalarValue::Dictionary, Binary, LargeBinary, Time64, IntervalMonthDayNano, Struct` [\#3531](https://github.com/apache/arrow-datafusion/issues/3531)
- What should be returned when trying to get a config in invalid format? [\#3505](https://github.com/apache/arrow-datafusion/issues/3505)
- Dividing decimal type gives wrong error: "170141183460469231731687303715884105727 is too large to store in a Decimal128 [\#3498](https://github.com/apache/arrow-datafusion/issues/3498)
- Add BitwiseXor in function `from_proto_binary_op` [\#3495](https://github.com/apache/arrow-datafusion/issues/3495)
- comparison operations with a scalar null and decimal array panics [\#3487](https://github.com/apache/arrow-datafusion/issues/3487)
- Union columns with different types [\#3467](https://github.com/apache/arrow-datafusion/issues/3467)
- Can't get the right logical plan after optimizer [\#3421](https://github.com/apache/arrow-datafusion/issues/3421)
- Fix conflict between simplify\_expression rule and CAST expressions [\#3409](https://github.com/apache/arrow-datafusion/issues/3409)
- Empty array giving error [\#2439](https://github.com/apache/arrow-datafusion/issues/2439)
- Internal error: Unsupported data type in hasher: FixedSizeBinary\(16\) [\#1516](https://github.com/apache/arrow-datafusion/issues/1516)
- Predicates on to\_timestamp do not work as expected with "naive" timestamp strings [\#765](https://github.com/apache/arrow-datafusion/issues/765)
- Address performance/execution plan of TPCH query 19 [\#78](https://github.com/apache/arrow-datafusion/issues/78)
- Bug fix: expr\_visitor was not visiting aggregate filter expressions [\#3548](https://github.com/apache/arrow-datafusion/pull/3548) ([andygrove](https://github.com/andygrove))

**Documentation updates:**

- Publish 8.0.0 user guide [\#2558](https://github.com/apache/arrow-datafusion/issues/2558)
- MINOR: Add Dask SQL to list of projects powered by DataFusion [\#3581](https://github.com/apache/arrow-datafusion/pull/3581) ([andygrove](https://github.com/andygrove))
- Add Parseable as Datafusion user [\#3471](https://github.com/apache/arrow-datafusion/pull/3471) ([nitisht](https://github.com/nitisht))

**Closed issues:**

- Upgrade to Arrow 24.0.0 [\#3689](https://github.com/apache/arrow-datafusion/issues/3689)
- what's the best practice to get a single value from arrow array? [\#3497](https://github.com/apache/arrow-datafusion/issues/3497)
- The data type of predicate in the row filter should be same in the binary expr [\#3469](https://github.com/apache/arrow-datafusion/issues/3469)
-  Extend constant folding and parquet filtering support [\#188](https://github.com/apache/arrow-datafusion/issues/188)
-  Add FORMAT to explain plan and an easy to visualize format [\#96](https://github.com/apache/arrow-datafusion/issues/96)

**Merged pull requests:**

- Build aggregate schema in Aggregate::try\_new [\#3739](https://github.com/apache/arrow-datafusion/pull/3739) ([andygrove](https://github.com/andygrove))
- delete type coercion for scalar udf in the physical phase [\#3735](https://github.com/apache/arrow-datafusion/pull/3735) ([liukun4515](https://github.com/liukun4515))
- Consolidate coercion code in `datafusion_expr::type_coercion` and submodules [\#3728](https://github.com/apache/arrow-datafusion/pull/3728) ([alamb](https://github.com/alamb))
- Skip filter push down on semi/anti joins [\#3723](https://github.com/apache/arrow-datafusion/pull/3723) ([andygrove](https://github.com/andygrove))
- Raise `Unsupported SQL type` for `Time(WithTimeZone)` and `Time(Tz)` [\#3718](https://github.com/apache/arrow-datafusion/pull/3718) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- Support column aliases specified by `WITH` statements [\#3717](https://github.com/apache/arrow-datafusion/pull/3717) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([isidentical](https://github.com/isidentical))
- Reject recursive CTEs before processing the sub-expressions [\#3714](https://github.com/apache/arrow-datafusion/pull/3714) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([isidentical](https://github.com/isidentical))
- Make column name consistent between Expr::name and Display/Debug [\#3712](https://github.com/apache/arrow-datafusion/pull/3712) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Fix aggregate type coercion bug [\#3710](https://github.com/apache/arrow-datafusion/pull/3710) ([alamb](https://github.com/alamb))
- MINOR: Add `Expr::canonical_name` and improve docs on `Expr::name` [\#3706](https://github.com/apache/arrow-datafusion/pull/3706) ([andygrove](https://github.com/andygrove))
- Remove type coercions from ScalarValue and aggregation function code [\#3705](https://github.com/apache/arrow-datafusion/pull/3705) ([ozankabak](https://github.com/ozankabak))
- `unwrap_cast_in_comparison`: fix bug which can find the field for the schema [\#3699](https://github.com/apache/arrow-datafusion/pull/3699) ([liukun4515](https://github.com/liukun4515))
- bump sql-parser 0.25 [\#3698](https://github.com/apache/arrow-datafusion/pull/3698) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Move optimizer init to optimizer crate [\#3692](https://github.com/apache/arrow-datafusion/pull/3692) ([andygrove](https://github.com/andygrove))
- Upgrade `arrow` `parquet` and `arrow-flight` to 24.0.0 [\#3691](https://github.com/apache/arrow-datafusion/pull/3691) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fix bug in dictionary coercion and allow better coercion [\#3688](https://github.com/apache/arrow-datafusion/pull/3688) ([alamb](https://github.com/alamb))
- \[MINOR\] Improve docstrings in binary\_rule.rs [\#3687](https://github.com/apache/arrow-datafusion/pull/3687) ([alamb](https://github.com/alamb))
- \[MINOR\] Add `ScalarValue::new_utf8`, clean up creation of literals in casting tests [\#3680](https://github.com/apache/arrow-datafusion/pull/3680) ([alamb](https://github.com/alamb))
- Disable code coverage until we figure out why it is broken [\#3679](https://github.com/apache/arrow-datafusion/pull/3679) ([alamb](https://github.com/alamb))
- move `type coercion` for case when expr [\#3676](https://github.com/apache/arrow-datafusion/pull/3676) ([liukun4515](https://github.com/liukun4515))
- Update sqlparser to 0.24.0  [\#3675](https://github.com/apache/arrow-datafusion/pull/3675) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fail if field lengths are not same in INTERSECT and EXPECT [\#3674](https://github.com/apache/arrow-datafusion/pull/3674) ([askoa](https://github.com/askoa))
- Simplification Rules for Modulo Operator [\#3669](https://github.com/apache/arrow-datafusion/pull/3669) ([askoa](https://github.com/askoa))
- change pre\_cast\_lit\_in\_comparison to unwrap\_cast\_in\_comparison [\#3662](https://github.com/apache/arrow-datafusion/pull/3662) ([liukun4515](https://github.com/liukun4515))
- restore optimization for `between` in simplify expression rule [\#3661](https://github.com/apache/arrow-datafusion/pull/3661) ([liukun4515](https://github.com/liukun4515))
- add timestamptz [\#3660](https://github.com/apache/arrow-datafusion/pull/3660) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- remove the type coercion in the simplify\_expressions rule [\#3657](https://github.com/apache/arrow-datafusion/pull/3657) ([liukun4515](https://github.com/liukun4515))
- Cache collected file statistics [\#3649](https://github.com/apache/arrow-datafusion/pull/3649) ([mateuszkj](https://github.com/mateuszkj))
- make regexp\_replace early abort with empty input [\#3648](https://github.com/apache/arrow-datafusion/pull/3648) ([isidentical](https://github.com/isidentical))
- Check each query has same number of columns when building the UNION plan [\#3638](https://github.com/apache/arrow-datafusion/pull/3638) ([HaoYang670](https://github.com/HaoYang670))
- move the `type coercion` to the beginning of the optimizer rule and support type coercion for subquery [\#3636](https://github.com/apache/arrow-datafusion/pull/3636) ([liukun4515](https://github.com/liukun4515))
- Add documentation for querying S3 data with CLI [\#3631](https://github.com/apache/arrow-datafusion/pull/3631) ([andygrove](https://github.com/andygrove))
- Simplify multiplication by `0` and by `null`  [\#3627](https://github.com/apache/arrow-datafusion/pull/3627) ([HaoYang670](https://github.com/HaoYang670))
- Simplify null division. [\#3625](https://github.com/apache/arrow-datafusion/pull/3625) ([HaoYang670](https://github.com/HaoYang670))
- support cast/try\_cast expr in reduceOuterJoin [\#3621](https://github.com/apache/arrow-datafusion/pull/3621) ([AssHero](https://github.com/AssHero))
- MINOR: fix TPC-H conversion function to not miss a row of data [\#3620](https://github.com/apache/arrow-datafusion/pull/3620) ([kmitchener](https://github.com/kmitchener))
- Document ObjectStoreProvider [\#3619](https://github.com/apache/arrow-datafusion/pull/3619) ([tustvold](https://github.com/tustvold))
- \[feat\] Support using offset index in ParquetRecordBatchStream when pu… [\#3616](https://github.com/apache/arrow-datafusion/pull/3616) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Optimize `regex_replace` for scalar patterns [\#3614](https://github.com/apache/arrow-datafusion/pull/3614) ([isidentical](https://github.com/isidentical))
- Simplify `concat_ws(null, ..)` to `null` [\#3608](https://github.com/apache/arrow-datafusion/pull/3608) ([HaoYang670](https://github.com/HaoYang670))
- MINOR: improve docstrings on SessionContext [\#3603](https://github.com/apache/arrow-datafusion/pull/3603) ([alamb](https://github.com/alamb))
- Merge s3\_success and s3\_build\_error tests into one test [\#3602](https://github.com/apache/arrow-datafusion/pull/3602) ([Licht-T](https://github.com/Licht-T))
- add `register_batch` and `read_batch` to `SessionContext` to register a single RecordBatch as a table [\#3600](https://github.com/apache/arrow-datafusion/pull/3600) ([BaymaxHWY](https://github.com/BaymaxHWY))
- \[CI\] Fix the newly added linting errors to make clippy happy [\#3598](https://github.com/apache/arrow-datafusion/pull/3598) ([isidentical](https://github.com/isidentical))
- Prevent over-allocations \(and spills\) on sorts with a fixed limit [\#3593](https://github.com/apache/arrow-datafusion/pull/3593) ([isidentical](https://github.com/isidentical))
- update datafusion cli deps [\#3588](https://github.com/apache/arrow-datafusion/pull/3588) ([Jimexist](https://github.com/Jimexist))
- Update cranelift\* dependencies `0.87` --\> `0.88` [\#3586](https://github.com/apache/arrow-datafusion/pull/3586) ([alamb](https://github.com/alamb))
- Fix docs.rs [\#3580](https://github.com/apache/arrow-datafusion/pull/3580) ([avantgardnerio](https://github.com/avantgardnerio))
- Fix build [\#3576](https://github.com/apache/arrow-datafusion/pull/3576) ([alamb](https://github.com/alamb))
- Use consistent name for  `TimeUnit::Millisecond` [\#3575](https://github.com/apache/arrow-datafusion/pull/3575) ([alamb](https://github.com/alamb))
- Fix logical plan serialization  [\#3574](https://github.com/apache/arrow-datafusion/pull/3574) ([thinkharderdev](https://github.com/thinkharderdev))
- Custom window frame logic \(support `ROWS`, `RANGE`, `PRECEDING` and `FOLLOWING` for window functions\) [\#3570](https://github.com/apache/arrow-datafusion/pull/3570) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([metesynnada](https://github.com/metesynnada))
- fix comparison of decimal array with null scalar [\#3567](https://github.com/apache/arrow-datafusion/pull/3567) ([kmitchener](https://github.com/kmitchener))
- Reduce dependencies of `datafusion-sql` crate [\#3566](https://github.com/apache/arrow-datafusion/pull/3566) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([mbrobbel](https://github.com/mbrobbel))
- Update pbjson-types requirement from 0.3 to 0.5 [\#3560](https://github.com/apache/arrow-datafusion/pull/3560) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update pbjson requirement from 0.3 to 0.5 [\#3559](https://github.com/apache/arrow-datafusion/pull/3559) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update pbjson-build requirement from 0.3 to 0.5 [\#3558](https://github.com/apache/arrow-datafusion/pull/3558) ([dependabot[bot]](https://github.com/apps/dependabot))
- MINOR: enable q19 in TPCH [\#3553](https://github.com/apache/arrow-datafusion/pull/3553) ([kmitchener](https://github.com/kmitchener))
- MINOR: remove out-of-date is\_dictionary checks from binary\_rule.rs  [\#3552](https://github.com/apache/arrow-datafusion/pull/3552) ([kmitchener](https://github.com/kmitchener))
- Make ParquetScanOptions public and add method to get a reference from… [\#3551](https://github.com/apache/arrow-datafusion/pull/3551) ([thinkharderdev](https://github.com/thinkharderdev))
- fix coercion of null for decimal math in binary\_rules [\#3549](https://github.com/apache/arrow-datafusion/pull/3549) ([kmitchener](https://github.com/kmitchener))
- Use `fetch` limit in get\_sorted\_iter [\#3545](https://github.com/apache/arrow-datafusion/pull/3545) ([Dandandan](https://github.com/Dandandan))
- feat: allow object store registration from datafusion-cli [\#3540](https://github.com/apache/arrow-datafusion/pull/3540) ([turbo1912](https://github.com/turbo1912))
- Actually test that `ScalarValue`s are the same after round trip serialization [\#3537](https://github.com/apache/arrow-datafusion/pull/3537) ([alamb](https://github.com/alamb))
- Add serialization of `ScalarValue::Struct` [\#3536](https://github.com/apache/arrow-datafusion/pull/3536) ([alamb](https://github.com/alamb))
- Add serialization of `ScalarValue::IntervalMonthDayNano` [\#3535](https://github.com/apache/arrow-datafusion/pull/3535) ([alamb](https://github.com/alamb))
- Add serialization of `ScalarValue::Binary` and `ScalarValue::LargeBinary`, `ScalarValue::Time64` [\#3534](https://github.com/apache/arrow-datafusion/pull/3534) ([alamb](https://github.com/alamb))
- MINOR: Impl `Debug` for TableReference and ResolvedTableReference [\#3533](https://github.com/apache/arrow-datafusion/pull/3533) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Add support for serializing `ScalarValue::Dictionary` to datafusion-proto [\#3532](https://github.com/apache/arrow-datafusion/pull/3532) ([alamb](https://github.com/alamb))
- Push down limit to sort [\#3530](https://github.com/apache/arrow-datafusion/pull/3530) ([Dandandan](https://github.com/Dandandan))
- Execute sort in parallel when a limit is used after sort [\#3527](https://github.com/apache/arrow-datafusion/pull/3527) ([Dandandan](https://github.com/Dandandan))
- Config support type conversion [\#3522](https://github.com/apache/arrow-datafusion/pull/3522) ([comphead](https://github.com/comphead))
- MINOR: Add more execs to list of supported execs [\#3519](https://github.com/apache/arrow-datafusion/pull/3519) ([andygrove](https://github.com/andygrove))
- fix divide by zero not throwing proper error for decimal [\#3517](https://github.com/apache/arrow-datafusion/pull/3517) ([kmitchener](https://github.com/kmitchener))
- Make FileStream and FileOpener public [\#3514](https://github.com/apache/arrow-datafusion/pull/3514) ([thinkharderdev](https://github.com/thinkharderdev))
- feat: Union types coercion [\#3513](https://github.com/apache/arrow-datafusion/pull/3513) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([gandronchik](https://github.com/gandronchik))
- \[DataFrame\] - Add cache function for DataFrame [\#3512](https://github.com/apache/arrow-datafusion/pull/3512) ([francis-du](https://github.com/francis-du))
- type coercion: support is/is\_not\_`bool`/like/unknown expr [\#3510](https://github.com/apache/arrow-datafusion/pull/3510) ([liukun4515](https://github.com/liukun4515))
- MINOR: remove unused dependencies [\#3508](https://github.com/apache/arrow-datafusion/pull/3508) ([waynexia](https://github.com/waynexia))
- Automate postrelease publishing to Homebrew [\#3507](https://github.com/apache/arrow-datafusion/pull/3507) ([iajoiner](https://github.com/iajoiner))
- Add additional DATE\_PART units [\#3503](https://github.com/apache/arrow-datafusion/pull/3503) ([jonmmease](https://github.com/jonmmease))
- Add BitwiseXor in function from\_proto\_binary\_op [\#3496](https://github.com/apache/arrow-datafusion/pull/3496) ([askoa](https://github.com/askoa))
- Make the function from\_proto\_binary\_op public [\#3490](https://github.com/apache/arrow-datafusion/pull/3490) ([askoa](https://github.com/askoa))
- minor: fix bug in `downcast_value!` macro \(`T` --\> `$T`\) [\#3486](https://github.com/apache/arrow-datafusion/pull/3486) ([alamb](https://github.com/alamb))
- add time\_zone into ConfigOptions [\#3485](https://github.com/apache/arrow-datafusion/pull/3485) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- \[MINOR\] Change `downcast_value!` macro so it does not need to use `use std::any::type_name;` [\#3484](https://github.com/apache/arrow-datafusion/pull/3484) ([alamb](https://github.com/alamb))
- Convert more cross joins to inner joins \(Address performance/execution plan of TPCH query 19\) [\#3482](https://github.com/apache/arrow-datafusion/pull/3482) ([DhamoPS](https://github.com/DhamoPS))
- \[minor\] Remove unused arg in macro in Inlist [\#3474](https://github.com/apache/arrow-datafusion/pull/3474) ([Ted-Jiang](https://github.com/Ted-Jiang))
- inlist: move type coercion to logical phase [\#3472](https://github.com/apache/arrow-datafusion/pull/3472) ([liukun4515](https://github.com/liukun4515))
- Use the column data type as the NULL data type in the row filter [\#3470](https://github.com/apache/arrow-datafusion/pull/3470) ([liukun4515](https://github.com/liukun4515))
- apply type coercion before filter pushdown [\#3459](https://github.com/apache/arrow-datafusion/pull/3459) ([liukun4515](https://github.com/liukun4515))
- add FixedSizeBinary support to create\_hashes [\#3458](https://github.com/apache/arrow-datafusion/pull/3458) ([mcassels](https://github.com/mcassels))
- Support ShowVariable Statement [\#3455](https://github.com/apache/arrow-datafusion/pull/3455) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- Add additional pruning tests with casts, handle unsupported predicates better [\#3454](https://github.com/apache/arrow-datafusion/pull/3454) ([alamb](https://github.com/alamb))
- Add `InList` support for timestamp type. \(\#3449\) [\#3450](https://github.com/apache/arrow-datafusion/pull/3450) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Evaluate expressions after type coercion [\#3444](https://github.com/apache/arrow-datafusion/pull/3444) ([Dandandan](https://github.com/Dandandan))
- remove type coercion in the binary physical expr [\#3396](https://github.com/apache/arrow-datafusion/pull/3396) ([liukun4515](https://github.com/liukun4515))
- Use arrow row format in SortPreservingMerge ~50-70% faster [\#3386](https://github.com/apache/arrow-datafusion/pull/3386) ([tustvold](https://github.com/tustvold))
- Pushdown `RowFilter` in `ParquetExec` [\#3380](https://github.com/apache/arrow-datafusion/pull/3380) ([thinkharderdev](https://github.com/thinkharderdev))


## [12.0.0](https://github.com/apache/arrow-datafusion/tree/12.0.0) (2022-09-12)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/11.0.0...12.0.0)

**Breaking changes:**

- Pass `return_type` to `AccumulatorFunctionImplementation ` for user defined aggregates [\#3428](https://github.com/apache/arrow-datafusion/pull/3428) ([alamb](https://github.com/alamb))
- Use `usize` rather than `Option<usize>` to represent `Limit::skip`and `Limit::offset` [\#3374](https://github.com/apache/arrow-datafusion/pull/3374) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([HaoYang670](https://github.com/HaoYang670))
- Deprecate legacy datafusion::logical\_plan module [\#3338](https://github.com/apache/arrow-datafusion/pull/3338) ([andygrove](https://github.com/andygrove))
- Update signature for Expr.name so that schema is no longer required [\#3336](https://github.com/apache/arrow-datafusion/pull/3336) ([andygrove](https://github.com/andygrove))
- MINOR: rename optimizer rule to ScalarSubqueryToJoin [\#3306](https://github.com/apache/arrow-datafusion/pull/3306) ([kmitchener](https://github.com/kmitchener))
- Add top-level `Like`, `ILike`, `SimilarTo` expressions in logical plan [\#3298](https://github.com/apache/arrow-datafusion/pull/3298) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Upgrade to sqlparser 0.22 [\#3278](https://github.com/apache/arrow-datafusion/pull/3278) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- `Expr` variants for boolean operations [\#3275](https://github.com/apache/arrow-datafusion/pull/3275) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([sarahyurick](https://github.com/sarahyurick))
- Upgrade to sqlparser 0.21 [\#3200](https://github.com/apache/arrow-datafusion/pull/3200) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Add SQL planner support for `Like`, `ILike` and `SimilarTo`, with optional escape character [\#3101](https://github.com/apache/arrow-datafusion/pull/3101) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))

**Implemented enhancements:**

- support `cast` inside `values` [\#3446](https://github.com/apache/arrow-datafusion/issues/3446)
- update TPCH test schemas to use Decimal128 from Float [\#3435](https://github.com/apache/arrow-datafusion/issues/3435)
- Include Bitwise operators in the documentation [\#3434](https://github.com/apache/arrow-datafusion/issues/3434)
- How to read excel file with datafusion? [\#3433](https://github.com/apache/arrow-datafusion/issues/3433)
- Pass return type to the accumulator state factory in aggregates [\#3427](https://github.com/apache/arrow-datafusion/issues/3427)
- Support bitwise XOR operator \(`#`\) [\#3420](https://github.com/apache/arrow-datafusion/issues/3420)
- support InList with datatype Date32 [\#3412](https://github.com/apache/arrow-datafusion/issues/3412)
- add simplification for `between` expression during logical plan optimization [\#3402](https://github.com/apache/arrow-datafusion/issues/3402)
- Replace From trait with TryFrom trait for datafusion-proto crate [\#3401](https://github.com/apache/arrow-datafusion/issues/3401)
- update TPC-H benchmark to Decimal types from Float [\#3392](https://github.com/apache/arrow-datafusion/issues/3392)
- Use `usize` to represent `Limit::skip` [\#3369](https://github.com/apache/arrow-datafusion/issues/3369)
- Avoid coping in `LogicalPlan::expressions` [\#3368](https://github.com/apache/arrow-datafusion/issues/3368)
- Upgrade to Arrow 22 [\#3362](https://github.com/apache/arrow-datafusion/issues/3362)
- Eliminate `OFFSET 0` in the logical plan optimization [\#3355](https://github.com/apache/arrow-datafusion/issues/3355)
- Add ability to get unoptimized logical plan from DataFrame [\#3340](https://github.com/apache/arrow-datafusion/issues/3340)
- Allow IDEs to recognize generated code [\#3332](https://github.com/apache/arrow-datafusion/issues/3332)
- `CAST` should not change the name of an expression [\#3326](https://github.com/apache/arrow-datafusion/issues/3326)
- add SQL support for unsigned integers [\#3325](https://github.com/apache/arrow-datafusion/issues/3325)
- Review use of panic in `datafusion-proto` crate [\#3318](https://github.com/apache/arrow-datafusion/issues/3318)
- Review use of panic in `datafusion-sql` crate [\#3315](https://github.com/apache/arrow-datafusion/issues/3315)
- Review use of panic in `datafusion-optimizer` crate [\#3314](https://github.com/apache/arrow-datafusion/issues/3314)
- Review use of panic in `datafusion-expr` crate [\#3312](https://github.com/apache/arrow-datafusion/issues/3312)
- Support registration of custom TableProviders through SQL [\#3310](https://github.com/apache/arrow-datafusion/issues/3310)
- Support binary data in sha hash functions [\#3308](https://github.com/apache/arrow-datafusion/issues/3308)
- add SQL support for tinyint and unsigned versions of all INTs [\#3307](https://github.com/apache/arrow-datafusion/issues/3307)
- Support binary types in InList expression [\#3300](https://github.com/apache/arrow-datafusion/issues/3300)
- Physical planner should map `IsTrue` and similar expressions to `IsDistinctFrom` [\#3288](https://github.com/apache/arrow-datafusion/issues/3288)
- Introduce physical plan version of `Operator` enum [\#3269](https://github.com/apache/arrow-datafusion/issues/3269)
- Introduce `Expr` variants for `IS [NOT] TRUE / FALSE / UNKNOWN` [\#3268](https://github.com/apache/arrow-datafusion/issues/3268)
- Add support for non-correlated subqueries [\#3266](https://github.com/apache/arrow-datafusion/issues/3266) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- \(Re-\)add support for glob patterns in ListingTableUrl [\#3261](https://github.com/apache/arrow-datafusion/issues/3261)
- `PreCastLitInComparisonExpressions` should use ExprRewriter and supported nested expressions [\#3259](https://github.com/apache/arrow-datafusion/issues/3259)
- implement `DROP VIEW` [\#3251](https://github.com/apache/arrow-datafusion/issues/3251)
- Upgrade to Arrow 21 [\#3224](https://github.com/apache/arrow-datafusion/issues/3224)
- Add TypeCoercion optimizer rule [\#3221](https://github.com/apache/arrow-datafusion/issues/3221)
- Create bench for approx\_percentile\_cont aggregate [\#3217](https://github.com/apache/arrow-datafusion/issues/3217)
- Add SQL query planner support for `DISTRIBUTED BY` [\#3207](https://github.com/apache/arrow-datafusion/issues/3207)
- Support "IS \[NOT\] UNKNOWN" syntax [\#3195](https://github.com/apache/arrow-datafusion/issues/3195)
- sqlparser 0.21 upgrade [\#3192](https://github.com/apache/arrow-datafusion/issues/3192)
- Re-implement parsing/planning for SHOW TABLES due to sqlparser changes [\#3188](https://github.com/apache/arrow-datafusion/issues/3188)
- Support `SUM` `AVG`, `MIN`, `MAX` on `Time` columns.  [\#3166](https://github.com/apache/arrow-datafusion/issues/3166)
- Support "IS TRUE/FALSE" syntax [\#3159](https://github.com/apache/arrow-datafusion/issues/3159)
- Support number of histogram bins in approx\_percentile\_cont [\#3145](https://github.com/apache/arrow-datafusion/issues/3145)
- Support create ApproxPercentileAccumulator with TDigest max\_size [\#3142](https://github.com/apache/arrow-datafusion/issues/3142)
- Remove support for `array` function and only support `array[]` style postgres syntax [\#3115](https://github.com/apache/arrow-datafusion/issues/3115)
- Allow inline column aliases for create view [\#3108](https://github.com/apache/arrow-datafusion/issues/3108) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- Add support for Postgres `SIMILAR TO` and `ILIKE` syntax [\#3099](https://github.com/apache/arrow-datafusion/issues/3099) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- Update SQL reference in user guide to cover all supported syntax [\#3091](https://github.com/apache/arrow-datafusion/issues/3091)
- DataFusion prelude should import all logical expression functions [\#3068](https://github.com/apache/arrow-datafusion/issues/3068)
- Proposal: Add similar to operator [\#3016](https://github.com/apache/arrow-datafusion/issues/3016) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- Release DataFusion 11.0.0 [\#3012](https://github.com/apache/arrow-datafusion/issues/3012)
- Implement "SHOW CREATE TABLE" for external tables [\#2848](https://github.com/apache/arrow-datafusion/issues/2848)
- Change java package names in protobuf files [\#2513](https://github.com/apache/arrow-datafusion/issues/2513)
- When creating `DFField` from `Expr` we should provide input plan not input schema [\#2456](https://github.com/apache/arrow-datafusion/issues/2456)
- Support "IS NOT TRUE/FALSE" syntax [\#2265](https://github.com/apache/arrow-datafusion/issues/2265)
- RFC: Spill-To-Disk Object Storage Download [\#2205](https://github.com/apache/arrow-datafusion/issues/2205)
- Support for BitwiseAnd `&`, BitOr `|` binary operators [\#1619](https://github.com/apache/arrow-datafusion/issues/1619)
- \[Question\] Usage of async object store APIs in consuming code [\#1313](https://github.com/apache/arrow-datafusion/issues/1313)
- Allow User Defined Aggregates to return multiple values / structs [\#600](https://github.com/apache/arrow-datafusion/issues/600)
- Implement vectorized hashing for dictionary types [\#331](https://github.com/apache/arrow-datafusion/issues/331)

**Fixed bugs:**

- Intermittent build error when changing selected features [\#3366](https://github.com/apache/arrow-datafusion/issues/3366)
- `sql::timestamp::timestamp_add_interval_months` failing since September 1st [\#3327](https://github.com/apache/arrow-datafusion/issues/3327)
- `sql::timestamp::timestamp_add_interval_months` test fails [\#3322](https://github.com/apache/arrow-datafusion/issues/3322)
- test case `timestamp_add_interval_months` failed on master branch [\#3321](https://github.com/apache/arrow-datafusion/issues/3321)
- datafusion-proto does not support untyped null scalar values [\#3302](https://github.com/apache/arrow-datafusion/issues/3302)
- `ConfigOptions` creation is slow [\#3295](https://github.com/apache/arrow-datafusion/issues/3295)
- FilterPushDown optimization through UNION ALL results in SchemaError [\#3281](https://github.com/apache/arrow-datafusion/issues/3281)
- Execute LogicalPlans after building for TPCH Benchmarks [\#3273](https://github.com/apache/arrow-datafusion/issues/3273)
- `CREATE TABLE` should return empty DataFrame [\#3265](https://github.com/apache/arrow-datafusion/issues/3265) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- `CREATE EXTERNAL TABLE` from CSV creates a table with no columns if there is just a header row [\#3263](https://github.com/apache/arrow-datafusion/issues/3263)
- View TableProvider ignores projections, resulting in invalid plans [\#3240](https://github.com/apache/arrow-datafusion/issues/3240)
- CREATE VIEW should return an empty dataframe on success [\#3236](https://github.com/apache/arrow-datafusion/issues/3236)
- `DISTRIBUTE BY` expressions get removed during optimization [\#3234](https://github.com/apache/arrow-datafusion/issues/3234)
- datafusion cannot recognize chinese charactors. [\#3203](https://github.com/apache/arrow-datafusion/issues/3203)
- Panicked at 'byte index 1 is out of bounds on invalid query [\#3190](https://github.com/apache/arrow-datafusion/issues/3190)
- `like_nlike_with_null_lt` fails with latest sqlparser code [\#3187](https://github.com/apache/arrow-datafusion/issues/3187)
- Interval Literal output inconsistent date\_type [\#3180](https://github.com/apache/arrow-datafusion/issues/3180)
- `array` function allows different data types [\#3123](https://github.com/apache/arrow-datafusion/issues/3123)
- eq operator doesn't work on binary data [\#3117](https://github.com/apache/arrow-datafusion/issues/3117)
- incorrect `where` clause comparison while using table alias [\#3073](https://github.com/apache/arrow-datafusion/issues/3073)
- Some functions are incorrectly declared as unary [\#3069](https://github.com/apache/arrow-datafusion/issues/3069)
- once now\(\) is called in a statement, it forever returns the same value [\#3057](https://github.com/apache/arrow-datafusion/issues/3057)
- single\_distinct\_to\_groupby panic when group by expr is a binaryExpr [\#2994](https://github.com/apache/arrow-datafusion/issues/2994)
- Cannot have `order by` expression that references complex `group by` expression [\#2360](https://github.com/apache/arrow-datafusion/issues/2360)
- Fix some bugs in TypeCoercion rule [\#3407](https://github.com/apache/arrow-datafusion/pull/3407) ([andygrove](https://github.com/andygrove))
- MINOR: Stop ignoring `AggregateFunction::distinct` in protobuf serde code [\#3250](https://github.com/apache/arrow-datafusion/pull/3250) ([andygrove](https://github.com/andygrove))
- Add assertion for invariant in `create_physical_expression` and fix ViewTable projection [\#3242](https://github.com/apache/arrow-datafusion/pull/3242) ([andygrove](https://github.com/andygrove))
- Fix bug where optimizer was removing `Partitioning::DistributeBy` expressions [\#3229](https://github.com/apache/arrow-datafusion/pull/3229) ([andygrove](https://github.com/andygrove))

**Documentation updates:**

- \[minor\] add Coverage Status in readme [\#3220](https://github.com/apache/arrow-datafusion/pull/3220) ([Ted-Jiang](https://github.com/Ted-Jiang))

**Closed issues:**

- Add `\i` command to datafusion-cli [\#1906](https://github.com/apache/arrow-datafusion/issues/1906)
-  TPC-H Query 15 [\#166](https://github.com/apache/arrow-datafusion/issues/166)

**Merged pull requests:**

- minor: fix some typo. [\#3453](https://github.com/apache/arrow-datafusion/pull/3453) ([jackwener](https://github.com/jackwener))
- Update criterion requirement from 0.3 to 0.4 [\#3452](https://github.com/apache/arrow-datafusion/pull/3452) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update object\_store requirement from 0.4.0 to 0.5.0 [\#3451](https://github.com/apache/arrow-datafusion/pull/3451) ([dependabot[bot]](https://github.com/apps/dependabot))
- add `cast` support inside `values` [\#3447](https://github.com/apache/arrow-datafusion/pull/3447) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([kmitchener](https://github.com/kmitchener))
- Use hash repartitioning for aggregates on dictionaries [\#3445](https://github.com/apache/arrow-datafusion/pull/3445) ([isidentical](https://github.com/isidentical))
- Review `unwrap` and `panic` from the `aggregate` directory of `datafusion-physical-expr` [\#3443](https://github.com/apache/arrow-datafusion/pull/3443) ([iajoiner](https://github.com/iajoiner))
- MINOR: Implement protobuf serde for all binary operators [\#3441](https://github.com/apache/arrow-datafusion/pull/3441) ([andygrove](https://github.com/andygrove))
- MINOR: Add accessor methods to DateTimeIntervalExpr [\#3440](https://github.com/apache/arrow-datafusion/pull/3440) ([andygrove](https://github.com/andygrove))
- update TPCH-mimicking tests to Decimal data type from Float, matching the benchmark [\#3438](https://github.com/apache/arrow-datafusion/pull/3438) ([kmitchener](https://github.com/kmitchener))
- Include Bitwise operators in the documentation [\#3436](https://github.com/apache/arrow-datafusion/pull/3436) ([askoa](https://github.com/askoa))
- minor: make sql number parsing slightly more efficient + functional [\#3432](https://github.com/apache/arrow-datafusion/pull/3432) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Implement bitwise XOR operator \(`#`\) [\#3430](https://github.com/apache/arrow-datafusion/pull/3430) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([askoa](https://github.com/askoa))
- Replace From trait with TryFrom trait for datafusion-proto crate \#3401 [\#3429](https://github.com/apache/arrow-datafusion/pull/3429) ([comphead](https://github.com/comphead))
- Tests showing user defined aggregate returning a struct [\#3425](https://github.com/apache/arrow-datafusion/pull/3425) ([alamb](https://github.com/alamb))
- MINOR: update optimizer rule names to be consistent style as the rest [\#3415](https://github.com/apache/arrow-datafusion/pull/3415) ([kmitchener](https://github.com/kmitchener))
- Support date32 and date 64 in inlist node [\#3413](https://github.com/apache/arrow-datafusion/pull/3413) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Update sqlparser requirement from 0.22 to 0.23 [\#3411](https://github.com/apache/arrow-datafusion/pull/3411) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([dependabot[bot]](https://github.com/apps/dependabot))
- simplify the `between` expr during logical plan optimization [\#3404](https://github.com/apache/arrow-datafusion/pull/3404) ([kmitchener](https://github.com/kmitchener))
- MINOR: Improve optimizer error [\#3403](https://github.com/apache/arrow-datafusion/pull/3403) ([andygrove](https://github.com/andygrove))
- Review panics in the sql crate [\#3397](https://github.com/apache/arrow-datafusion/pull/3397) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([HaoYang670](https://github.com/HaoYang670))
- changed TPC-H benchmark to use Decimal types [\#3393](https://github.com/apache/arrow-datafusion/pull/3393) ([kmitchener](https://github.com/kmitchener))
- minor: remove redundant code. [\#3389](https://github.com/apache/arrow-datafusion/pull/3389) ([jackwener](https://github.com/jackwener))
- Add dictionary cases to merge bench [\#3384](https://github.com/apache/arrow-datafusion/pull/3384) ([tustvold](https://github.com/tustvold))
- Implement Eq trait for Expr and nested types [\#3381](https://github.com/apache/arrow-datafusion/pull/3381) ([jdye64](https://github.com/jdye64))
- Minor: Improvements to type coercion rule [\#3379](https://github.com/apache/arrow-datafusion/pull/3379) ([alamb](https://github.com/alamb))
- MINOR: Note that most communication happens on github [\#3375](https://github.com/apache/arrow-datafusion/pull/3375) ([alamb](https://github.com/alamb))
- minor fix: clean data type for negative operation [\#3370](https://github.com/apache/arrow-datafusion/pull/3370) ([liukun4515](https://github.com/liukun4515))
- Fix code generation for json feature [\#3367](https://github.com/apache/arrow-datafusion/pull/3367) ([avantgardnerio](https://github.com/avantgardnerio))
- Review use of panic in datafusion-proto crate [\#3365](https://github.com/apache/arrow-datafusion/pull/3365) ([comphead](https://github.com/comphead))
- Upgrade to arrow 22 [\#3363](https://github.com/apache/arrow-datafusion/pull/3363) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- return empty dataframe on create table, remove a duplicate optimize call [\#3361](https://github.com/apache/arrow-datafusion/pull/3361) ([kmitchener](https://github.com/kmitchener))
- Add SQL support for `tinyint` , `smallint`, and `unsigned int variants`  [\#3359](https://github.com/apache/arrow-datafusion/pull/3359) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([kmitchener](https://github.com/kmitchener))
- Minor: add hint in README of example [\#3358](https://github.com/apache/arrow-datafusion/pull/3358) ([jackwener](https://github.com/jackwener))
- Collect to `HashSet` directly in `in_list` [\#3356](https://github.com/apache/arrow-datafusion/pull/3356) ([HaoYang670](https://github.com/HaoYang670))
- MINOR: Add comments about rewrite\_disjunctive\_predicate [\#3351](https://github.com/apache/arrow-datafusion/pull/3351) ([alamb](https://github.com/alamb))
- \[MINOR\] Add debug logging to plan teardown [\#3350](https://github.com/apache/arrow-datafusion/pull/3350) ([alamb](https://github.com/alamb))
- MINOR: add df.to\_unoptimized\_plan\(\) to docs, remove erroneous comment [\#3348](https://github.com/apache/arrow-datafusion/pull/3348) ([kmitchener](https://github.com/kmitchener))
- Replace `unwrap` in `convert_to_ordered_float` and add `downcast_value` [\#3347](https://github.com/apache/arrow-datafusion/pull/3347) ([iajoiner](https://github.com/iajoiner))
- Remove panics from `common_subexpr_eliminate` [\#3346](https://github.com/apache/arrow-datafusion/pull/3346) ([andygrove](https://github.com/andygrove))
- Remove Result.unwrap from single\_distinct\_to\_groupby [\#3345](https://github.com/apache/arrow-datafusion/pull/3345) ([andygrove](https://github.com/andygrove))
- Add to\_unoptimized\_plan [\#3344](https://github.com/apache/arrow-datafusion/pull/3344) ([iajoiner](https://github.com/iajoiner))
- Remove panics from simplify\_expressions optimizer rule [\#3343](https://github.com/apache/arrow-datafusion/pull/3343) ([andygrove](https://github.com/andygrove))
- Remove `unreachable!` from filter push down rule [\#3342](https://github.com/apache/arrow-datafusion/pull/3342) ([andygrove](https://github.com/andygrove))
- Replace panic in `datafusion-expr` crate [\#3341](https://github.com/apache/arrow-datafusion/pull/3341) ([iajoiner](https://github.com/iajoiner))
- Re-implement ExprIdentifierVisitor::desc\_expr to use Expr::Display [\#3339](https://github.com/apache/arrow-datafusion/pull/3339) ([andygrove](https://github.com/andygrove))
- Fix the test`timestamp_add_interval_months` [\#3337](https://github.com/apache/arrow-datafusion/pull/3337) ([HaoYang670](https://github.com/HaoYang670))
- Bump lz4-sys from 1.9.3 to 1.9.4 in /datafusion-cli [\#3335](https://github.com/apache/arrow-datafusion/pull/3335) ([dependabot[bot]](https://github.com/apps/dependabot))
- Make binary operator formatting consistent between logical and physical plans [\#3331](https://github.com/apache/arrow-datafusion/pull/3331) ([andygrove](https://github.com/andygrove))
- Fix build: Ignore failing test [\#3329](https://github.com/apache/arrow-datafusion/pull/3329) ([andygrove](https://github.com/andygrove))
- Add `InList` support for binary type. [\#3324](https://github.com/apache/arrow-datafusion/pull/3324) ([HaoYang670](https://github.com/HaoYang670))
- MINOR: add github action trigger [\#3323](https://github.com/apache/arrow-datafusion/pull/3323) ([waynexia](https://github.com/waynexia))
- add explain sql test for optimizer rule PreCastLitInComparisonExpressions [\#3320](https://github.com/apache/arrow-datafusion/pull/3320) ([liukun4515](https://github.com/liukun4515))
- Custom / Dynamic table provider factories [\#3311](https://github.com/apache/arrow-datafusion/pull/3311) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- fix: alias group\_by exprs in single\_distinct\_to\_groupby optimizer [\#3305](https://github.com/apache/arrow-datafusion/pull/3305) ([waynexia](https://github.com/waynexia))
- Add support for serializing null scalar values [\#3303](https://github.com/apache/arrow-datafusion/pull/3303) ([andygrove](https://github.com/andygrove))
- Finish integrating `Expr::Is[Not]True` and similar expressions [\#3301](https://github.com/apache/arrow-datafusion/pull/3301) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- MINOR: Remove `unwrap` calls from `single_distinct_to_groupby optimizer` rule [\#3299](https://github.com/apache/arrow-datafusion/pull/3299) ([andygrove](https://github.com/andygrove))
- docs: update the Python library repository [\#3297](https://github.com/apache/arrow-datafusion/pull/3297) ([haoxins](https://github.com/haoxins))
- fix: speed up `ConfigOptions` creation [\#3296](https://github.com/apache/arrow-datafusion/pull/3296) ([crepererum](https://github.com/crepererum))
- Execute LogicalPlans after building for TPCH Benchmarks [\#3290](https://github.com/apache/arrow-datafusion/pull/3290) ([DaltonModlin](https://github.com/DaltonModlin))
- support for non-correlated subqueries [\#3287](https://github.com/apache/arrow-datafusion/pull/3287) ([kmitchener](https://github.com/kmitchener))
- Add `Aggregate::try new` with validation checks [\#3286](https://github.com/apache/arrow-datafusion/pull/3286) ([andygrove](https://github.com/andygrove))
- Fix SchemaError in FilterPushDown optimization with UNION ALL [\#3282](https://github.com/apache/arrow-datafusion/pull/3282) ([jonmmease](https://github.com/jonmmease))
- Allow sorting by aggregated groups [\#3280](https://github.com/apache/arrow-datafusion/pull/3280) ([isidentical](https://github.com/isidentical))
- Add show external tables [\#3279](https://github.com/apache/arrow-datafusion/pull/3279) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([psvri](https://github.com/psvri))
- Return from task execution if send fails as there is nothing more to do \(faster cancel / limit\) [\#3276](https://github.com/apache/arrow-datafusion/pull/3276) ([nvartolomei](https://github.com/nvartolomei))
- Let prelude import all expression functions [\#3274](https://github.com/apache/arrow-datafusion/pull/3274) ([sadilet](https://github.com/sadilet))
- Fix no schema when CSV is only header [\#3272](https://github.com/apache/arrow-datafusion/pull/3272) ([comphead](https://github.com/comphead))
- support inlist for pre cast literal expression [\#3270](https://github.com/apache/arrow-datafusion/pull/3270) ([liukun4515](https://github.com/liukun4515))
- implement `drop view` [\#3267](https://github.com/apache/arrow-datafusion/pull/3267) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([kmitchener](https://github.com/kmitchener))
- Use `ExprRewriter` in `pre_cast_lit_in_comparison` [\#3260](https://github.com/apache/arrow-datafusion/pull/3260) ([andygrove](https://github.com/andygrove))
- Add type coercion for UDFs in logical plan [\#3254](https://github.com/apache/arrow-datafusion/pull/3254) ([andygrove](https://github.com/andygrove))
- Support "IS NOT TRUE/FALSE" syntax [\#3252](https://github.com/apache/arrow-datafusion/pull/3252) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([sarahyurick](https://github.com/sarahyurick))
- Implement `IS UNKNOWN`/`IS NOT UNKNOWN` operators [\#3246](https://github.com/apache/arrow-datafusion/pull/3246) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([isidentical](https://github.com/isidentical))
- support decimal data type for the optimizer rule of PreCastLitInComparisonExpressions [\#3245](https://github.com/apache/arrow-datafusion/pull/3245) ([liukun4515](https://github.com/liukun4515))
- chore: update cranelifts to 0.87.0 [\#3243](https://github.com/apache/arrow-datafusion/pull/3243) ([yjshen](https://github.com/yjshen))
- Moved nullif out of unary functions [\#3241](https://github.com/apache/arrow-datafusion/pull/3241) ([comphead](https://github.com/comphead))
- MINOR: documentation updates [\#3239](https://github.com/apache/arrow-datafusion/pull/3239) ([kmitchener](https://github.com/kmitchener))
- MINOR: Add bounds check to Column physical expression [\#3238](https://github.com/apache/arrow-datafusion/pull/3238) ([andygrove](https://github.com/andygrove))
- CREATE VIEW should return empty dataframe [\#3237](https://github.com/apache/arrow-datafusion/pull/3237) ([kmitchener](https://github.com/kmitchener))
- Support "IS TRUE/FALSE" syntax \(redo\) [\#3235](https://github.com/apache/arrow-datafusion/pull/3235) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([sarahyurick](https://github.com/sarahyurick))
- Fix propagation of optimized predicates on nested projections [\#3228](https://github.com/apache/arrow-datafusion/pull/3228) ([isidentical](https://github.com/isidentical))
- Add more trim test cases [\#3226](https://github.com/apache/arrow-datafusion/pull/3226) ([ayushdg](https://github.com/ayushdg))
- Upgrade to arrow 21 [\#3225](https://github.com/apache/arrow-datafusion/pull/3225) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- Add optimizer rule for type coercion \(binary operations only\) [\#3222](https://github.com/apache/arrow-datafusion/pull/3222) ([andygrove](https://github.com/andygrove))
- \[Improve\] Use arrow::compute::sort in approx\_percentile\_cont [\#3219](https://github.com/apache/arrow-datafusion/pull/3219) ([Ted-Jiang](https://github.com/Ted-Jiang))
- \[minor\] fix bench aggregate\_query\_sql meta [\#3218](https://github.com/apache/arrow-datafusion/pull/3218) ([Ted-Jiang](https://github.com/Ted-Jiang))
- minor: refactor simplify negate [\#3213](https://github.com/apache/arrow-datafusion/pull/3213) ([jackwener](https://github.com/jackwener))
- MINOR: update cargo.lock and rust-version for datafusion-cli [\#3212](https://github.com/apache/arrow-datafusion/pull/3212) ([kmitchener](https://github.com/kmitchener))
- fix issue with now\(\) returning same value across statements [\#3210](https://github.com/apache/arrow-datafusion/pull/3210) ([kmitchener](https://github.com/kmitchener))
- Add support for inline column alias in CREATE VIEW [\#3209](https://github.com/apache/arrow-datafusion/pull/3209) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([DaltonModlin](https://github.com/DaltonModlin))
- Add SQL query planner support for `DISTRIBUTE BY` [\#3208](https://github.com/apache/arrow-datafusion/pull/3208) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- minor: remove test code that's in the arrow library now [\#3206](https://github.com/apache/arrow-datafusion/pull/3206) ([kmitchener](https://github.com/kmitchener))
- Use .get\(\) to avoid panic [\#3201](https://github.com/apache/arrow-datafusion/pull/3201) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([jklamer](https://github.com/jklamer))
- \[Minor\] Reduce code duplication creating ScalarValue::List [\#3197](https://github.com/apache/arrow-datafusion/pull/3197) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Clean up CI workflows by removing "matrix" strategy, simplifying names [\#3196](https://github.com/apache/arrow-datafusion/pull/3196) ([alamb](https://github.com/alamb))
- optimizer: add framework for the rule of pre-add cast to the literal in comparison binary [\#3185](https://github.com/apache/arrow-datafusion/pull/3185) ([liukun4515](https://github.com/liukun4515))
- Fix clippy [\#3182](https://github.com/apache/arrow-datafusion/pull/3182) ([alamb](https://github.com/alamb))
- MINOR: Add notes on writing release blog posts [\#3179](https://github.com/apache/arrow-datafusion/pull/3179) ([andygrove](https://github.com/andygrove))
- add min/max for time [\#3178](https://github.com/apache/arrow-datafusion/pull/3178) ([waitingkuo](https://github.com/waitingkuo))
- Recursively apply remove filter rule if filter is a true scalar value [\#3175](https://github.com/apache/arrow-datafusion/pull/3175) ([byteink](https://github.com/byteink))
- Update `ahash` requirement from 0.7 to 0.8 [\#3161](https://github.com/apache/arrow-datafusion/pull/3161) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Support number of centroids in approx\_percentile\_cont [\#3146](https://github.com/apache/arrow-datafusion/pull/3146) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Introduce  `\i` command to execute from a file [\#3136](https://github.com/apache/arrow-datafusion/pull/3136) ([turbo1912](https://github.com/turbo1912))
- impl binary ops between binary arrays and scalars [\#3124](https://github.com/apache/arrow-datafusion/pull/3124) ([ozgrakkurt](https://github.com/ozgrakkurt))


## [11.0.0](https://github.com/apache/arrow-datafusion/tree/11.0.0) (2022-08-16)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/10.0.0-rc1...11.0.0)

**Breaking changes:**

- Implement exact median, add `AggregateState` [\#3009](https://github.com/apache/arrow-datafusion/pull/3009) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))

**Implemented enhancements:**

- Make RowAccumulator public [\#3138](https://github.com/apache/arrow-datafusion/issues/3138)
- docs: proposal for consolidating docs into a Contributor Guide [\#3127](https://github.com/apache/arrow-datafusion/issues/3127)
- feat: support Timestamp +/- Interval [\#3103](https://github.com/apache/arrow-datafusion/issues/3103)
- a `arrow_typeof` like posgresql's `pg_typeof` [\#3095](https://github.com/apache/arrow-datafusion/issues/3095)
- Add DataFrame section to user guide [\#3066](https://github.com/apache/arrow-datafusion/issues/3066)
- Document all scalar SQL functions in user guide [\#3065](https://github.com/apache/arrow-datafusion/issues/3065)
- Simplify implementation of approx\_median so that it can be exposed in Python [\#3063](https://github.com/apache/arrow-datafusion/issues/3063)
- Support double quoted literal strings for dialects\(such as mysql,bigquery\) [\#3055](https://github.com/apache/arrow-datafusion/issues/3055)
- Simplify / speed up implementation of character\_length to unicode points [\#3049](https://github.com/apache/arrow-datafusion/issues/3049)
- Follow-up on Clickbench benchmark [\#3048](https://github.com/apache/arrow-datafusion/issues/3048)
- Why the PhysicalPlanner is an async trait ? [\#3032](https://github.com/apache/arrow-datafusion/issues/3032)
- Optimize file stream metrics. [\#3024](https://github.com/apache/arrow-datafusion/issues/3024)
- Proposal: Enable typed strings expressions for VALUES clause [\#3017](https://github.com/apache/arrow-datafusion/issues/3017)
- Proposal: Add `date_bin` function [\#3015](https://github.com/apache/arrow-datafusion/issues/3015)
- The upcoming release of Arrow \(20?\) breaks datafusion [\#3006](https://github.com/apache/arrow-datafusion/issues/3006)
- Can I select some files for query based on the filtering rules in the directory? [\#2993](https://github.com/apache/arrow-datafusion/issues/2993)
- Rename FormatReader to FileOpener [\#2990](https://github.com/apache/arrow-datafusion/issues/2990)
- Derive `Hash` trait for `JoinType` [\#2971](https://github.com/apache/arrow-datafusion/issues/2971)
- CAST from Utf8 to Boolean [\#2967](https://github.com/apache/arrow-datafusion/issues/2967)
- Add baseline\_metrics for FileStream to record metrics like elapsed time, record output, etc [\#2961](https://github.com/apache/arrow-datafusion/issues/2961)
- Example to show how to convert query result into rust struct [\#2959](https://github.com/apache/arrow-datafusion/issues/2959)
- simplify not clause [\#2957](https://github.com/apache/arrow-datafusion/issues/2957)
- Implement Debug for ColumnarValue [\#2950](https://github.com/apache/arrow-datafusion/issues/2950)
- Parallel fetching of column chunks when reading parquet files [\#2949](https://github.com/apache/arrow-datafusion/issues/2949)
- Extension mechanism for `SessionConfig` [\#2939](https://github.com/apache/arrow-datafusion/issues/2939)
- Streaming CSV/JSON Object Store Read [\#2935](https://github.com/apache/arrow-datafusion/issues/2935)
- Support CSV Limit Pushdown to Object Storage [\#2930](https://github.com/apache/arrow-datafusion/issues/2930)
- Add support for `pow` scalar function [\#2926](https://github.com/apache/arrow-datafusion/issues/2926)
- Add support for exact `median` aggregate function [\#2925](https://github.com/apache/arrow-datafusion/issues/2925)
- Support `mean` as synonym for `avg` [\#2922](https://github.com/apache/arrow-datafusion/issues/2922)
- Rename a column name [\#2919](https://github.com/apache/arrow-datafusion/issues/2919)
- Move `ScalarValue` tests alongside implementation, move `from_slice` to `core` [\#2913](https://github.com/apache/arrow-datafusion/issues/2913)
- Fail gracefully if optimization rule fails [\#2908](https://github.com/apache/arrow-datafusion/issues/2908)
- Make ObjectStoreRegistry as a trait which can allow Ballista to introduce a self registry ObjectStoreRegistry [\#2905](https://github.com/apache/arrow-datafusion/issues/2905)
- Remove datafusion-data-access crate [\#2903](https://github.com/apache/arrow-datafusion/issues/2903)
- Improve formatting of logical plans containing subquery expressions [\#2898](https://github.com/apache/arrow-datafusion/issues/2898)
- Atan2 added to built-in functions [\#2897](https://github.com/apache/arrow-datafusion/issues/2897)
- The explain statements only print logical plans for debug/other purpose. [\#2894](https://github.com/apache/arrow-datafusion/issues/2894)
- JSON version of `display_indent()` [\#2889](https://github.com/apache/arrow-datafusion/issues/2889)
- It would be nice to have a way to generate unique IDs in optimizer rules [\#2886](https://github.com/apache/arrow-datafusion/issues/2886)
- Add support for `TIME` literal values [\#2883](https://github.com/apache/arrow-datafusion/issues/2883)
- Add h2o benchmark [\#2879](https://github.com/apache/arrow-datafusion/issues/2879)
- Implement `from_unixtime` function [\#2871](https://github.com/apache/arrow-datafusion/issues/2871)
- Add `cast` function for creating logical cast expression [\#2870](https://github.com/apache/arrow-datafusion/issues/2870)
- Release DataFusion 10.0.0 [\#2862](https://github.com/apache/arrow-datafusion/issues/2862)
- Implement `information_schema.views` [\#2857](https://github.com/apache/arrow-datafusion/issues/2857)
- Migrate from avro\_rs to apache\_avro [\#2783](https://github.com/apache/arrow-datafusion/issues/2783)
- Add optimizer rule to remove `OFFSET 0` [\#2584](https://github.com/apache/arrow-datafusion/issues/2584)
- Preserve Element Name in ScalarValue::List [\#2450](https://github.com/apache/arrow-datafusion/issues/2450)
- Add EXISTS subquery support to Ballista [\#2338](https://github.com/apache/arrow-datafusion/issues/2338)
- Add documentation on supported functions to datafusion website [\#1487](https://github.com/apache/arrow-datafusion/issues/1487)
- documentations for datafusion-cli can be consolidated a bit more [\#1352](https://github.com/apache/arrow-datafusion/issues/1352)
- Optimizer: Predicate Rewrite pass for TPCH Q19 [\#217](https://github.com/apache/arrow-datafusion/issues/217)
- feat: add optimize rule `rewrite_disjunctive_predicate` [\#2858](https://github.com/apache/arrow-datafusion/pull/2858) ([xudong963](https://github.com/xudong963))

**Fixed bugs:**

- Regression in SQL support for `ORDER BY` and aliased expressions [\#3160](https://github.com/apache/arrow-datafusion/issues/3160)
- panic when deal with `@` operator [\#3137](https://github.com/apache/arrow-datafusion/issues/3137)
- Incorrect type coercion rule for date + interval [\#3093](https://github.com/apache/arrow-datafusion/issues/3093)
- Cast string to timestamp crash while we input time before 1970 with floating number second [\#3082](https://github.com/apache/arrow-datafusion/issues/3082)
- INTEGER type does't work while importing csv [\#3059](https://github.com/apache/arrow-datafusion/issues/3059)
- Cannot GROUP BY Binary [\#3050](https://github.com/apache/arrow-datafusion/issues/3050)
- incorrect i32 coercion for `to_timestamp` [\#3046](https://github.com/apache/arrow-datafusion/issues/3046)
- Error pruning `IsNull` expressions: Column 'instance\_null\_count' is declared as non-nullable but contains null values [\#3042](https://github.com/apache/arrow-datafusion/issues/3042)
- I want to query some files in a directory. Is there any way?  [\#3013](https://github.com/apache/arrow-datafusion/issues/3013)
- The expression to get an indexed field is only valid for `List` types \(`common_sub_expression_eliminate`\) [\#3002](https://github.com/apache/arrow-datafusion/issues/3002)
- Double to\_timestamp\_seconds produces abnormal result [\#2998](https://github.com/apache/arrow-datafusion/issues/2998)
- External parquet table fails when schema contains differing key / value metadata [\#2982](https://github.com/apache/arrow-datafusion/issues/2982)
- SELECT on column with uppercase column name fails with FieldNotFound error [\#2978](https://github.com/apache/arrow-datafusion/issues/2978)
- panic reading AWS-generated parquet file [\#2963](https://github.com/apache/arrow-datafusion/issues/2963)
- Can't filter rowgroup for parquet prune for some data type [\#2962](https://github.com/apache/arrow-datafusion/issues/2962)
- CI test is failing with ` final link failed: No space left on device` [\#2947](https://github.com/apache/arrow-datafusion/issues/2947)
- bug: new ObjectStore breaks backward compatibility with contrib plugins [\#2931](https://github.com/apache/arrow-datafusion/issues/2931)
- bug: file types handled wrong [\#2929](https://github.com/apache/arrow-datafusion/issues/2929)
- bug: changing the number of partitions does not increase concurrency [\#2928](https://github.com/apache/arrow-datafusion/issues/2928)
- csv\_explain fails on RC verifier [\#2916](https://github.com/apache/arrow-datafusion/issues/2916)
- index out of range error from datafusion\_row::write::write\_field  [\#2910](https://github.com/apache/arrow-datafusion/issues/2910)
- Optimization rule `CommonSubexprEliminate` creates invalid projections [\#2907](https://github.com/apache/arrow-datafusion/issues/2907)
- serde\_json requires that either `std` \(default\) or `alloc` feature is enabled [\#2896](https://github.com/apache/arrow-datafusion/issues/2896)
- Inconsistent type coercion rules with comparison expressions [\#2890](https://github.com/apache/arrow-datafusion/issues/2890)
- Doc Error: the test directory link 404 which is in CONTRIBUTING.md [\#2880](https://github.com/apache/arrow-datafusion/issues/2880)
- Round trips through `ScalarValue`'s sometimes don't preserve types \(e.g. change types from `DictionaryArray`\) [\#2874](https://github.com/apache/arrow-datafusion/issues/2874)
- Error with CASE and DictionaryArrays: `ArrowError(InvalidArgumentError("arguments need to have the same data type"))` [\#2873](https://github.com/apache/arrow-datafusion/issues/2873)
- window functions not supported in expressions [\#2869](https://github.com/apache/arrow-datafusion/issues/2869)
- Unable to work with month intervals [\#2796](https://github.com/apache/arrow-datafusion/issues/2796)
- Discord invite link in communication page has expired [\#2743](https://github.com/apache/arrow-datafusion/issues/2743)
- Test \(path normalization\) failures while verifying release candidate 9.0.0 RC1 [\#2719](https://github.com/apache/arrow-datafusion/issues/2719)
- Reading parquet with \(pre-release\) arrow fails with "out of order projection is not supported" [\#2543](https://github.com/apache/arrow-datafusion/issues/2543)
- Fix SQL planner bug when resolving columns with same name as a relation [\#3003](https://github.com/apache/arrow-datafusion/pull/3003) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- fix `RowWriter`  index out of bounds error [\#2968](https://github.com/apache/arrow-datafusion/pull/2968) ([comphead](https://github.com/comphead))
- fix: support decimal statistic for row group prune [\#2966](https://github.com/apache/arrow-datafusion/pull/2966) ([liukun4515](https://github.com/liukun4515))
- Fix invalid projection in `CommonSubexprEliminate` [\#2915](https://github.com/apache/arrow-datafusion/pull/2915) ([andygrove](https://github.com/andygrove))

**Documentation updates:**

- MINOR: Fix broken links in contrib guide [\#3135](https://github.com/apache/arrow-datafusion/pull/3135) ([andygrove](https://github.com/andygrove))
- MINOR: User Guide: Move expressions to top-level page [\#3134](https://github.com/apache/arrow-datafusion/pull/3134) ([andygrove](https://github.com/andygrove))
- User Guide: Combine CLI pages [\#3133](https://github.com/apache/arrow-datafusion/pull/3133) ([andygrove](https://github.com/andygrove))
- User Guide: Add documentation for JOIN syntax [\#3130](https://github.com/apache/arrow-datafusion/pull/3130) ([andygrove](https://github.com/andygrove))
- separate contributors guide [\#3128](https://github.com/apache/arrow-datafusion/pull/3128) ([kmitchener](https://github.com/kmitchener))
- minor: remove python docs, now they're in another project [\#3119](https://github.com/apache/arrow-datafusion/pull/3119) ([kmitchener](https://github.com/kmitchener))
- minor: doc fixes: fix link to datafusion-python project and add link to slides for rece… [\#3118](https://github.com/apache/arrow-datafusion/pull/3118) ([kmitchener](https://github.com/kmitchener))
- Add all scalar SQL functions to user guide [\#3090](https://github.com/apache/arrow-datafusion/pull/3090) ([andygrove](https://github.com/andygrove))
- Add DataFrame reference to the user guide [\#3067](https://github.com/apache/arrow-datafusion/pull/3067) ([andygrove](https://github.com/andygrove))
- MINOR: Add CeresDB to list of products using DataFusion [\#3060](https://github.com/apache/arrow-datafusion/pull/3060) ([andygrove](https://github.com/andygrove))
- Minor: improve some docstrings about pruning [\#3041](https://github.com/apache/arrow-datafusion/pull/3041) ([alamb](https://github.com/alamb))
- doc: add a new video link about datafusion [\#3025](https://github.com/apache/arrow-datafusion/pull/3025) ([xudong963](https://github.com/xudong963))
- Update README.md to add CnosDB into the Known Uses [\#2933](https://github.com/apache/arrow-datafusion/pull/2933) ([cnoshb](https://github.com/cnoshb))

**Performance improvements:**

- Use code points instead of grapheme clusters for string functions [\#3054](https://github.com/apache/arrow-datafusion/pull/3054) ([Dandandan](https://github.com/Dandandan))

**Closed issues:**

- Rename `do_data_time_math()` to `do_date_time_math()`  [\#3172](https://github.com/apache/arrow-datafusion/issues/3172)
- Automatic version updates for github actions with dependabot [\#3106](https://github.com/apache/arrow-datafusion/issues/3106)
- \[EPIC\] Proposal for Date/Time enhancement [\#3100](https://github.com/apache/arrow-datafusion/issues/3100)
- Upgrade prost/tonic everywhere [\#3028](https://github.com/apache/arrow-datafusion/issues/3028)
- \[Question\] interested in helping with documentation [\#2866](https://github.com/apache/arrow-datafusion/issues/2866)
- Introducing a new optimizer framework for datafusion. [\#2633](https://github.com/apache/arrow-datafusion/issues/2633)
- Enable discussion tab? [\#2350](https://github.com/apache/arrow-datafusion/issues/2350)
-  Add support for AVG\(Timestamp\) types [\#200](https://github.com/apache/arrow-datafusion/issues/200)
-  TPC-H Query 22 [\#175](https://github.com/apache/arrow-datafusion/issues/175)
-  TPC-H Query 21 [\#172](https://github.com/apache/arrow-datafusion/issues/172)
-   TPC-H Query 20 [\#171](https://github.com/apache/arrow-datafusion/issues/171)
-  TPC-H Query 17 [\#168](https://github.com/apache/arrow-datafusion/issues/168)
-  TPC-H Query 11 [\#163](https://github.com/apache/arrow-datafusion/issues/163)
-  TPC-H Query 4 [\#160](https://github.com/apache/arrow-datafusion/issues/160)
-  TPC-H Query 2 [\#159](https://github.com/apache/arrow-datafusion/issues/159)
-  \[Datafusion\] Optimize literal expression evaluation [\#106](https://github.com/apache/arrow-datafusion/issues/106)

**Merged pull requests:**

- Rename do\_data\_time\_math\(\) to do\_date\_time\_math\(\) [\#3173](https://github.com/apache/arrow-datafusion/pull/3173) ([JasonLi-cn](https://github.com/JasonLi-cn))
- \[Minor\] Remove some redundant code [\#3169](https://github.com/apache/arrow-datafusion/pull/3169) ([alamb](https://github.com/alamb))
- Support `INTEGER` again in addition to `INT` in `CREATE TABLE` and `CAST` statements [\#3167](https://github.com/apache/arrow-datafusion/pull/3167) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fix regression in SQL parser related to resolution of aliased expressions [\#3165](https://github.com/apache/arrow-datafusion/pull/3165) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- update cargo lock [\#3164](https://github.com/apache/arrow-datafusion/pull/3164) ([waitingkuo](https://github.com/waitingkuo))
- add test case for cast\_timestamp\_before\_1970 [\#3163](https://github.com/apache/arrow-datafusion/pull/3163) ([waitingkuo](https://github.com/waitingkuo))
- Return proper error message for ill formed variable reference [\#3162](https://github.com/apache/arrow-datafusion/pull/3162) ([alamb](https://github.com/alamb))
- Remove outdated license text left over from arrow repo [\#3154](https://github.com/apache/arrow-datafusion/pull/3154) ([alamb](https://github.com/alamb))
- Expose RowAccumulator in physical\_plan [\#3151](https://github.com/apache/arrow-datafusion/pull/3151) ([iajoiner](https://github.com/iajoiner))
- Rename `DateIntervalExpr` to `DateTimeIntervalExpr` [\#3150](https://github.com/apache/arrow-datafusion/pull/3150) ([alamb](https://github.com/alamb))
- Bump actions/labeler from 4.0.0 to 4.0.1 [\#3144](https://github.com/apache/arrow-datafusion/pull/3144) ([dependabot[bot]](https://github.com/apps/dependabot))
- User Guide: Add documentation for subquery syntax [\#3132](https://github.com/apache/arrow-datafusion/pull/3132) ([andygrove](https://github.com/andygrove))
- MINOR: User Guide: Move Data Types and Information Schema to their own pages [\#3131](https://github.com/apache/arrow-datafusion/pull/3131) ([andygrove](https://github.com/andygrove))
- Minor: Clean up `array` test [\#3121](https://github.com/apache/arrow-datafusion/pull/3121) ([alamb](https://github.com/alamb))
- add arrow\_typeof [\#3120](https://github.com/apache/arrow-datafusion/pull/3120) ([waitingkuo](https://github.com/waitingkuo))
- Bump actions/labeler from 2.2.0 to 4.0.0 [\#3114](https://github.com/apache/arrow-datafusion/pull/3114) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/checkout from 2 to 3 [\#3113](https://github.com/apache/arrow-datafusion/pull/3113) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/setup-node from 2 to 3 [\#3112](https://github.com/apache/arrow-datafusion/pull/3112) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/setup-python from 3 to 4 [\#3111](https://github.com/apache/arrow-datafusion/pull/3111) ([dependabot[bot]](https://github.com/apps/dependabot))
- Feature/support timestamp plus minus interval [\#3110](https://github.com/apache/arrow-datafusion/pull/3110) ([JasonLi-cn](https://github.com/JasonLi-cn))
- docs: fix typo [\#3109](https://github.com/apache/arrow-datafusion/pull/3109) ([dzvon](https://github.com/dzvon))
- Remove offset if its zero [\#3102](https://github.com/apache/arrow-datafusion/pull/3102) ([turbo1912](https://github.com/turbo1912))
- Hash binary values [\#3098](https://github.com/apache/arrow-datafusion/pull/3098) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Dandandan](https://github.com/Dandandan))
- Update to object\_store 0.4 [\#3089](https://github.com/apache/arrow-datafusion/pull/3089) ([tustvold](https://github.com/tustvold))
- Add cast function for creating cast expression [\#3084](https://github.com/apache/arrow-datafusion/pull/3084) ([turbo1912](https://github.com/turbo1912))
- Upgrade to arrow 20.0.0 \(but no change to object\_store\), including `prost`, and `tonic` [\#3083](https://github.com/apache/arrow-datafusion/pull/3083) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- impl Debug for ColumnarValue, add some docs [\#3076](https://github.com/apache/arrow-datafusion/pull/3076) ([alamb](https://github.com/alamb))
- \[Minor\] run cargo update in datafusion-cli directory [\#3075](https://github.com/apache/arrow-datafusion/pull/3075) ([alamb](https://github.com/alamb))
- update cargo.lock in `datafusion-cli` [\#3074](https://github.com/apache/arrow-datafusion/pull/3074) ([waitingkuo](https://github.com/waitingkuo))
- Update sql parser to v0.20.0 [\#3072](https://github.com/apache/arrow-datafusion/pull/3072) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- Add opening, scanning, processing metrics in file stream [\#3070](https://github.com/apache/arrow-datafusion/pull/3070) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Simplify `approx_median` implementation, expose via `DataFrame` API [\#3064](https://github.com/apache/arrow-datafusion/pull/3064) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- docs: fix PruningStatistics example and some typos [\#3062](https://github.com/apache/arrow-datafusion/pull/3062) ([roeap](https://github.com/roeap))
- feat: support double quoted literal strings for dialects\(such as mysql,bigquery,spark\) [\#3056](https://github.com/apache/arrow-datafusion/pull/3056) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Rachelint](https://github.com/Rachelint))
- Allow Overriding AsyncFileReader used by ParquetExec [\#3051](https://github.com/apache/arrow-datafusion/pull/3051) ([Cheappie](https://github.com/Cheappie))
- to\_timestamp i32 coerced to i64 [\#3047](https://github.com/apache/arrow-datafusion/pull/3047) ([waitingkuo](https://github.com/waitingkuo))
- Fix `IsNull` pruning expression generation without null\_count statistics [\#3044](https://github.com/apache/arrow-datafusion/pull/3044) ([alamb](https://github.com/alamb))
- feat: Support `week`, `decade`, `century` for Interval literal [\#3038](https://github.com/apache/arrow-datafusion/pull/3038) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([ovr](https://github.com/ovr))
- feat: Support Binary bitwise shift operators \(\<\< and \>\>\) [\#3037](https://github.com/apache/arrow-datafusion/pull/3037) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([ovr](https://github.com/ovr))
- Use concat\_elements\_utf8 from arrow rather than custom kernel [\#3036](https://github.com/apache/arrow-datafusion/pull/3036) ([alamb](https://github.com/alamb))
- minor: update minimal rust version to 1.62, matching arrow-rs [\#3035](https://github.com/apache/arrow-datafusion/pull/3035) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([kmitchener](https://github.com/kmitchener))
- feat: Add `date_bin` built-in function [\#3034](https://github.com/apache/arrow-datafusion/pull/3034) ([stuartcarnie](https://github.com/stuartcarnie))
- Split `binary_expr.rs` into smaller modules [\#3026](https://github.com/apache/arrow-datafusion/pull/3026) ([alamb](https://github.com/alamb))
- feat: Enable typed strings expressions for VALUES clause [\#3018](https://github.com/apache/arrow-datafusion/pull/3018) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([stuartcarnie](https://github.com/stuartcarnie))
- fix typo for PR3003 [\#3011](https://github.com/apache/arrow-datafusion/pull/3011) ([waitingkuo](https://github.com/waitingkuo))
- feat: Add support for TIME literal values [\#3010](https://github.com/apache/arrow-datafusion/pull/3010) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([stuartcarnie](https://github.com/stuartcarnie))
- add TimeUnit::Second as signature for ToTimestampSeconds [\#3004](https://github.com/apache/arrow-datafusion/pull/3004) ([waitingkuo](https://github.com/waitingkuo))
- Rename FileReader to FileOpener \(\#2990\) [\#2991](https://github.com/apache/arrow-datafusion/pull/2991) ([tustvold](https://github.com/tustvold))
- minor: collation the prune test [\#2986](https://github.com/apache/arrow-datafusion/pull/2986) ([liukun4515](https://github.com/liukun4515))
- Optionally skip metadata from schema when merging parquet files [\#2985](https://github.com/apache/arrow-datafusion/pull/2985) ([alamb](https://github.com/alamb))
- \[Minor\] Extract interval parsing logic, add unit tests [\#2984](https://github.com/apache/arrow-datafusion/pull/2984) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Update sqlparser to 0.19 [\#2981](https://github.com/apache/arrow-datafusion/pull/2981) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- test: add file/SQL level test for pruning parquet row group with decimal data type. [\#2977](https://github.com/apache/arrow-datafusion/pull/2977) ([liukun4515](https://github.com/liukun4515))
- Derive Hash for JoinType [\#2972](https://github.com/apache/arrow-datafusion/pull/2972) ([liurenjie1024](https://github.com/liurenjie1024))
-  Example that shows how to convert query result into rust struct \#2959  [\#2969](https://github.com/apache/arrow-datafusion/pull/2969) ([thomas-k-cameron](https://github.com/thomas-k-cameron))
- Add baseline\_metrics for FileStream to record metrics like elapsed ti… [\#2965](https://github.com/apache/arrow-datafusion/pull/2965) ([Ted-Jiang](https://github.com/Ted-Jiang))
- test: add test for decimal and pruning for decimal column [\#2960](https://github.com/apache/arrow-datafusion/pull/2960) ([liukun4515](https://github.com/liukun4515))
- Simplify expressions with `NOT` clause [\#2958](https://github.com/apache/arrow-datafusion/pull/2958) ([AssHero](https://github.com/AssHero))
- chore: update jit-related dependencies [\#2956](https://github.com/apache/arrow-datafusion/pull/2956) ([xudong963](https://github.com/xudong963))
- Update to arrow `19.0.0` [\#2955](https://github.com/apache/arrow-datafusion/pull/2955) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Remove CI Caching to preserve diskspace [\#2948](https://github.com/apache/arrow-datafusion/pull/2948) ([alamb](https://github.com/alamb))
- Add metadata\_size\_hint for optimistic fetching of parquet metadata [\#2946](https://github.com/apache/arrow-datafusion/pull/2946) ([thinkharderdev](https://github.com/thinkharderdev))
- Minor: Remove left over debugging statement [\#2944](https://github.com/apache/arrow-datafusion/pull/2944) ([alamb](https://github.com/alamb))
- add Atan2 [\#2942](https://github.com/apache/arrow-datafusion/pull/2942) ([waitingkuo](https://github.com/waitingkuo))
- Use `Arc<ObjectStoreRegistry>` and remove ObjectStoreRegistry::clone [\#2941](https://github.com/apache/arrow-datafusion/pull/2941) ([tustvold](https://github.com/tustvold))
- add extension system to `SessionConfig` [\#2940](https://github.com/apache/arrow-datafusion/pull/2940) ([crepererum](https://github.com/crepererum))
- Update prost-build requirement from 0.7 to 0.10 [\#2937](https://github.com/apache/arrow-datafusion/pull/2937) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add streaming JSON and CSV reading, `NewlineDelimitedStream' \(\#2935\) [\#2936](https://github.com/apache/arrow-datafusion/pull/2936) ([tustvold](https://github.com/tustvold))
- feat\(catalog\): Implement information\_schema.views [\#2934](https://github.com/apache/arrow-datafusion/pull/2934) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([BaymaxHWY](https://github.com/BaymaxHWY))
- Support `window` functions in expressions by re-write projection after building window plan [\#2932](https://github.com/apache/arrow-datafusion/pull/2932) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([AssHero](https://github.com/AssHero))
- Add pow as synonym for power [\#2927](https://github.com/apache/arrow-datafusion/pull/2927) ([andygrove](https://github.com/andygrove))
- Add `from_unixtime` function [\#2924](https://github.com/apache/arrow-datafusion/pull/2924) ([waitingkuo](https://github.com/waitingkuo))
- fix\(aggregate\): support mean as synonym avg [\#2923](https://github.com/apache/arrow-datafusion/pull/2923) ([BaymaxHWY](https://github.com/BaymaxHWY))
- Add `DataFrame::with_column_renamed` [\#2920](https://github.com/apache/arrow-datafusion/pull/2920) ([andygrove](https://github.com/andygrove))
- Run clippy with optional features [\#2918](https://github.com/apache/arrow-datafusion/pull/2918) ([tustvold](https://github.com/tustvold))
- Fix release verification script by not overriding `ARROW_TEST_DATA` or `PARQUET_TEST_DATA` [\#2917](https://github.com/apache/arrow-datafusion/pull/2917) ([alamb](https://github.com/alamb))
- Move `ScalarValue` tests alongside implementation, move `from_slice` to `datafusion_core` [\#2914](https://github.com/apache/arrow-datafusion/pull/2914) ([alamb](https://github.com/alamb))
- Optimizer should have option to skip failing rules [\#2909](https://github.com/apache/arrow-datafusion/pull/2909) ([andygrove](https://github.com/andygrove))
- Introduce ObjectStoreProvider to create an object store based on the url [\#2906](https://github.com/apache/arrow-datafusion/pull/2906) ([yahoNanJing](https://github.com/yahoNanJing))
- Remove datafusion-data-access crate [\#2904](https://github.com/apache/arrow-datafusion/pull/2904) ([yahoNanJing](https://github.com/yahoNanJing))
- Combine all comparison coercion rules [\#2901](https://github.com/apache/arrow-datafusion/pull/2901) ([andygrove](https://github.com/andygrove))
- Add `Projection::try_new` and `Projection::try_new_with_schema` [\#2900](https://github.com/apache/arrow-datafusion/pull/2900) ([andygrove](https://github.com/andygrove))
- Improve formatting of logical plans containing subqueries [\#2899](https://github.com/apache/arrow-datafusion/pull/2899) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- add session option 'datafusion.explain.logical\_plan'. when set to true, the explain statement will only print logical plans. [\#2895](https://github.com/apache/arrow-datafusion/pull/2895) ([AssHero](https://github.com/AssHero))
- Preserve field name in `ScalarValue::List` [\#2893](https://github.com/apache/arrow-datafusion/pull/2893) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([comphead](https://github.com/comphead))
- Adds optional serde support to datafusion-proto [\#2892](https://github.com/apache/arrow-datafusion/pull/2892) ([tustvold](https://github.com/tustvold))
- Implement `ScalarValue::Dictionary` and preserve type through conversion back/forth to Array [\#2891](https://github.com/apache/arrow-datafusion/pull/2891) ([alamb](https://github.com/alamb))
- Add an ID generator in preparation for PR 2885 [\#2887](https://github.com/apache/arrow-datafusion/pull/2887) ([avantgardnerio](https://github.com/avantgardnerio))
- Add support for correlated subqueries & fix all related TPC-H benchmark issues [\#2885](https://github.com/apache/arrow-datafusion/pull/2885) ([avantgardnerio](https://github.com/avantgardnerio))
- fix\(doc\): update test directory link in CONTRIBUTING.md [\#2882](https://github.com/apache/arrow-datafusion/pull/2882) ([BaymaxHWY](https://github.com/BaymaxHWY))
- Add h2o bench groupby queries [\#2881](https://github.com/apache/arrow-datafusion/pull/2881) ([andygrove](https://github.com/andygrove))
- Add support for month & year intervals [\#2797](https://github.com/apache/arrow-datafusion/pull/2797) ([avantgardnerio](https://github.com/avantgardnerio))
- Migrate from avro\_rs \(0.13\) to apache\_avro \(0.14\) [\#2784](https://github.com/apache/arrow-datafusion/pull/2784) ([martin-g](https://github.com/martin-g))

## [10.0.0-rc1](https://github.com/apache/arrow-datafusion/tree/10.0.0-rc1) (2022-07-12)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/10.0.0...10.0.0-rc1)


## [10.0.0](https://github.com/apache/arrow-datafusion/tree/10.0.0) (2022-07-12)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/9.0.0...10.0.0)

**Breaking changes:**

- Convert batch\_size to config option [\#2771](https://github.com/apache/arrow-datafusion/pull/2771) ([andygrove](https://github.com/andygrove))
- MINOR: Remove Offset struct [\#2734](https://github.com/apache/arrow-datafusion/pull/2734) ([andygrove](https://github.com/andygrove))
- feat: async extension planner [\#2713](https://github.com/apache/arrow-datafusion/pull/2713) ([waynexia](https://github.com/waynexia))
- Switch to object\_store crate \(\#2489\) [\#2677](https://github.com/apache/arrow-datafusion/pull/2677) ([tustvold](https://github.com/tustvold))

**Implemented enhancements:**

- update documentation, fix styling to match main Arrow project [\#2864](https://github.com/apache/arrow-datafusion/issues/2864)
- Update top-level README [\#2850](https://github.com/apache/arrow-datafusion/issues/2850)
- \[Question\]How to call an async function in `ExecutionPlan::exec` method? [\#2847](https://github.com/apache/arrow-datafusion/issues/2847)
- Add `DataFrame::with_column` [\#2844](https://github.com/apache/arrow-datafusion/issues/2844)
- Improve ergonomics of physical expr `lit` [\#2827](https://github.com/apache/arrow-datafusion/issues/2827)
- Add Python examples for reading CSV and query by SQL in Doc [\#2824](https://github.com/apache/arrow-datafusion/issues/2824)
- eliminate multi limit-offset nodes to EmptyRelation if possible  [\#2822](https://github.com/apache/arrow-datafusion/issues/2822)
- Make `LogicalPlan::Union` be consistent with other plans  [\#2816](https://github.com/apache/arrow-datafusion/issues/2816)
- Use coerced data type from value and list expressions during planning inlist expression [\#2793](https://github.com/apache/arrow-datafusion/issues/2793)
- Add configuration option to enable/disalbe `CoalesceBatchesExec` [\#2790](https://github.com/apache/arrow-datafusion/issues/2790)
- Simplify FilterNullJoinKeys rule [\#2780](https://github.com/apache/arrow-datafusion/issues/2780)
- Allow configuration settings to be specified with environment variables [\#2776](https://github.com/apache/arrow-datafusion/issues/2776)
- Automatically update `configs.md` in user guide [\#2770](https://github.com/apache/arrow-datafusion/issues/2770)
- Support multiple paths for ListingTableScanNode [\#2768](https://github.com/apache/arrow-datafusion/issues/2768)
- Reduce outer joins [\#2757](https://github.com/apache/arrow-datafusion/issues/2757)
- support data type coerced and decimal in INLIST expr [\#2755](https://github.com/apache/arrow-datafusion/issues/2755)
- Change ExtensionPlanner::plan\_extension\(\) to an async function [\#2749](https://github.com/apache/arrow-datafusion/issues/2749)
- Add `IsNotNull` filter to join inputs if one side of join condition does not allow null [\#2739](https://github.com/apache/arrow-datafusion/issues/2739)
- Sort preserving MergeJoin [\#2698](https://github.com/apache/arrow-datafusion/issues/2698)
- Improve readability of table scan projections in query plans [\#2697](https://github.com/apache/arrow-datafusion/issues/2697)
- DataFusion 9.0.0 Release [\#2676](https://github.com/apache/arrow-datafusion/issues/2676)
- Improve UX for `UNION` vs `UNION ALL` \(introduce a LogicalPlan::Distinct\) [\#2573](https://github.com/apache/arrow-datafusion/issues/2573) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)]
- Implement some way to show the sql used to create a view [\#2529](https://github.com/apache/arrow-datafusion/issues/2529)
- Consider adopting IOx ObjectStore abstraction [\#2489](https://github.com/apache/arrow-datafusion/issues/2489)
- Support `sum0` as a built-in agg function [\#2067](https://github.com/apache/arrow-datafusion/issues/2067)
- implement grouping sets, cubes, and rollups [\#1327](https://github.com/apache/arrow-datafusion/issues/1327)
- Ruby  bindings [\#1114](https://github.com/apache/arrow-datafusion/issues/1114)
- Support dates in hash join [\#2746](https://github.com/apache/arrow-datafusion/pull/2746) ([andygrove](https://github.com/andygrove))

**Fixed bugs:**

- Docker Error [\#2851](https://github.com/apache/arrow-datafusion/issues/2851)
- Anti join ignores join filters [\#2842](https://github.com/apache/arrow-datafusion/issues/2842)
- Can't test or compile sub-model code after upgrade to arrow-rs 17.0.0 [\#2835](https://github.com/apache/arrow-datafusion/issues/2835)
- Not evaluate the set expr in the InList for the optimization [\#2820](https://github.com/apache/arrow-datafusion/issues/2820)
- CASE When: result type should be coercible to a common type [\#2818](https://github.com/apache/arrow-datafusion/issues/2818)
- IN/NOT IN List: NULL is not equal to NULL [\#2817](https://github.com/apache/arrow-datafusion/issues/2817)
- panic when case statement returns null [\#2798](https://github.com/apache/arrow-datafusion/issues/2798)
- InList: Can't cast the list expr data type to value expr data type directly [\#2774](https://github.com/apache/arrow-datafusion/issues/2774)
- InList Expr: expr and list values must can be converted to a same data type [\#2759](https://github.com/apache/arrow-datafusion/issues/2759)
- tpchgen docker syntax change prevents volume from binding [\#2751](https://github.com/apache/arrow-datafusion/issues/2751)
- Cannot join on date columns \(Unsupported data type in hasher: Date32\) [\#2744](https://github.com/apache/arrow-datafusion/issues/2744)
- `rewrite_expression` does not properly handle `Exists` and `ScalarSubquery` [\#2736](https://github.com/apache/arrow-datafusion/issues/2736)
- LocalFileSystem Not sorted by file name， As a result, the data lines queried in multiple files are out of order. [\#2730](https://github.com/apache/arrow-datafusion/issues/2730)
- Filter push down need consider alias columns [\#2725](https://github.com/apache/arrow-datafusion/issues/2725)
- Recent API change in `GlobalLimitExec` breaks compatibility with Ballista [\#2720](https://github.com/apache/arrow-datafusion/issues/2720)
- Common Subexpression Eliminiation pass errors if run twice on some plans: Schema contains duplicate unqualified field name 'IsNull-Column-sys.host' [\#2712](https://github.com/apache/arrow-datafusion/issues/2712)
- The data type is not compatible with other system, for example spark or PG database [\#1379](https://github.com/apache/arrow-datafusion/issues/1379)

**Documentation updates:**

- Fix docs styling [\#2865](https://github.com/apache/arrow-datafusion/pull/2865) ([kmitchener](https://github.com/kmitchener))
- Various updates to top-level README [\#2854](https://github.com/apache/arrow-datafusion/pull/2854) ([andygrove](https://github.com/andygrove))
- MINOR: Add documentation for running integration tests [\#2839](https://github.com/apache/arrow-datafusion/pull/2839) ([andygrove](https://github.com/andygrove))
- add csv registration and sql query to examples [\#2825](https://github.com/apache/arrow-datafusion/pull/2825) ([waitingkuo](https://github.com/waitingkuo))
- \[minor\] refine doc [\#2753](https://github.com/apache/arrow-datafusion/pull/2753) ([Ted-Jiang](https://github.com/Ted-Jiang))

**Closed issues:**

- Consider adding a prominent note in the readme about ballista [\#2853](https://github.com/apache/arrow-datafusion/issues/2853)
- support decimal in \(NULL\) [\#2800](https://github.com/apache/arrow-datafusion/issues/2800)
- InList: Don't treat Null as UTF8\(None\) [\#2782](https://github.com/apache/arrow-datafusion/issues/2782)
- InList: don't need to treat Null as UTF8 data type [\#2773](https://github.com/apache/arrow-datafusion/issues/2773)
-   Implement extensible configuration mechanism [\#138](https://github.com/apache/arrow-datafusion/issues/138)

**Merged pull requests:**

- Update CONTRIBUTING.md [\#2876](https://github.com/apache/arrow-datafusion/pull/2876) ([waitingkuo](https://github.com/waitingkuo))
- Make LogicalPlan::Union be consistent with other plans [\#2868](https://github.com/apache/arrow-datafusion/pull/2868) ([comphead](https://github.com/comphead))
- minor: remove unneeded files from project root [\#2863](https://github.com/apache/arrow-datafusion/pull/2863) ([kmitchener](https://github.com/kmitchener))
- chore: make cargo clippy happy in nigtly [\#2860](https://github.com/apache/arrow-datafusion/pull/2860) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Update to arrow 18.0.0 [\#2856](https://github.com/apache/arrow-datafusion/pull/2856) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- chore: remove ballista-related docker-compose file [\#2852](https://github.com/apache/arrow-datafusion/pull/2852) ([xudong963](https://github.com/xudong963))
- Adding dataframe with\_column function [\#2849](https://github.com/apache/arrow-datafusion/pull/2849) ([comphead](https://github.com/comphead))
- anti joins now respect join filters [\#2843](https://github.com/apache/arrow-datafusion/pull/2843) ([andygrove](https://github.com/andygrove))
- MINOR: make name meaningful and clean up code [\#2841](https://github.com/apache/arrow-datafusion/pull/2841) ([liukun4515](https://github.com/liukun4515))
- Make `lit` implementation more concise [\#2838](https://github.com/apache/arrow-datafusion/pull/2838) ([alamb](https://github.com/alamb))
- InList: set/list value must be evaluated to get the values [\#2834](https://github.com/apache/arrow-datafusion/pull/2834) ([liukun4515](https://github.com/liukun4515))
- Add SHOW CREATE TABLE with initial support for views [\#2830](https://github.com/apache/arrow-datafusion/pull/2830) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([mrob95](https://github.com/mrob95))
- Improve ergonomics of physical expr `lit` [\#2828](https://github.com/apache/arrow-datafusion/pull/2828) ([alamb](https://github.com/alamb))
- Eliminate multi limit-offset nodes to emptyRelation  [\#2823](https://github.com/apache/arrow-datafusion/pull/2823) ([AssHero](https://github.com/AssHero))
- Fix the ci [\#2821](https://github.com/apache/arrow-datafusion/pull/2821) ([liukun4515](https://github.com/liukun4515))
- CaseWhen: coerce the all then and else data type to a common data type [\#2819](https://github.com/apache/arrow-datafusion/pull/2819) ([liukun4515](https://github.com/liukun4515))
- Fix `ScalarValue::isNull` calculation [\#2815](https://github.com/apache/arrow-datafusion/pull/2815) ([alamb](https://github.com/alamb))
- Fix nullability calculation for `CASE` expressions [\#2814](https://github.com/apache/arrow-datafusion/pull/2814) ([alamb](https://github.com/alamb))
- Bump numpy from 1.21.3 to 1.22.0 in /integration-tests [\#2811](https://github.com/apache/arrow-datafusion/pull/2811) ([xudong963](https://github.com/xudong963))
- Fix data type calculation for `CaseExpr` s with `NULLs` [\#2810](https://github.com/apache/arrow-datafusion/pull/2810) ([AssHero](https://github.com/AssHero))
- InList: fix bug for comparing with Null in the list using the set optimization [\#2809](https://github.com/apache/arrow-datafusion/pull/2809) ([liukun4515](https://github.com/liukun4515))
- Use specialized dictionary kernels \(\#1178\) [\#2808](https://github.com/apache/arrow-datafusion/pull/2808) ([tustvold](https://github.com/tustvold))
- fix schema nullability for `information_schema` schema [\#2804](https://github.com/apache/arrow-datafusion/pull/2804) ([alamb](https://github.com/alamb))
- fix: correctly calculate join output schema nullability [\#2803](https://github.com/apache/arrow-datafusion/pull/2803) ([alamb](https://github.com/alamb))
- Correct schema nullability declaration in tests [\#2802](https://github.com/apache/arrow-datafusion/pull/2802) ([alamb](https://github.com/alamb))
- Don't treat Null as UTF8\(None\) and change error info. [\#2801](https://github.com/apache/arrow-datafusion/pull/2801) ([liukun4515](https://github.com/liukun4515))
- MINOR: Remove reference to docker image that is no longer available [\#2795](https://github.com/apache/arrow-datafusion/pull/2795) ([andygrove](https://github.com/andygrove))
- Use coerced type in inlist expr planning [\#2794](https://github.com/apache/arrow-datafusion/pull/2794) ([viirya](https://github.com/viirya))
- Add LogicalPlan::Distinct [\#2792](https://github.com/apache/arrow-datafusion/pull/2792) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([mrob95](https://github.com/mrob95))
- Add config option for coalesce\_batches physical optimization rule, make optional [\#2791](https://github.com/apache/arrow-datafusion/pull/2791) ([andygrove](https://github.com/andygrove))
- Improve readability of table scan projections in query plans \(remove `Some` and `None`\) [\#2789](https://github.com/apache/arrow-datafusion/pull/2789) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([comphead](https://github.com/comphead))
- Simplify FilterNullJoinKeys rule [\#2781](https://github.com/apache/arrow-datafusion/pull/2781) ([andygrove](https://github.com/andygrove))
- MINOR: re-export sqlparser from datafusion-sql crate [\#2779](https://github.com/apache/arrow-datafusion/pull/2779) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Update to arrow 17.0.0 [\#2778](https://github.com/apache/arrow-datafusion/pull/2778) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Support multiple paths for ListingTableScanNode [\#2775](https://github.com/apache/arrow-datafusion/pull/2775) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Remove expr\_sub\_expressions and rewrite\_expression functions [\#2772](https://github.com/apache/arrow-datafusion/pull/2772) ([mrob95](https://github.com/mrob95))
- minor: update cranelift related dependencies [\#2769](https://github.com/apache/arrow-datafusion/pull/2769) ([xudong963](https://github.com/xudong963))
- minor: panic rather than fail silently on bad dictionary in hash join [\#2767](https://github.com/apache/arrow-datafusion/pull/2767) ([alamb](https://github.com/alamb))
- MINOR: make `prettier` use consistent between CI and contributing guide [\#2766](https://github.com/apache/arrow-datafusion/pull/2766) ([andygrove](https://github.com/andygrove))
- Rewrite subexpressions of InSubquery in rewrite\_expression [\#2765](https://github.com/apache/arrow-datafusion/pull/2765) ([mrob95](https://github.com/mrob95))
- Support `DataType::Decimal` for `IN` and `NOT IN` expressions [\#2764](https://github.com/apache/arrow-datafusion/pull/2764) ([liukun4515](https://github.com/liukun4515))
- Implement extensible configuration mechanism [\#2754](https://github.com/apache/arrow-datafusion/pull/2754) ([andygrove](https://github.com/andygrove))
- Remove redundant docker argument [\#2752](https://github.com/apache/arrow-datafusion/pull/2752) ([avantgardnerio](https://github.com/avantgardnerio))
- Add optimizer pass to reduce `left`/`right`/`full` joins to `inner` join if possible [\#2750](https://github.com/apache/arrow-datafusion/pull/2750) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([AssHero](https://github.com/AssHero))
- MINOR: Remove legacy CLI context enum [\#2748](https://github.com/apache/arrow-datafusion/pull/2748) ([andygrove](https://github.com/andygrove))
- CSE unit test for duplicate fields [\#2747](https://github.com/apache/arrow-datafusion/pull/2747) ([waynexia](https://github.com/waynexia))
- MINOR: Improve unsupported data type error message [\#2745](https://github.com/apache/arrow-datafusion/pull/2745) ([andygrove](https://github.com/andygrove))
- Add optimizer rule to filter out null keys before a join [\#2740](https://github.com/apache/arrow-datafusion/pull/2740) ([andygrove](https://github.com/andygrove))
- Sort file names in a directory \#2730 [\#2735](https://github.com/apache/arrow-datafusion/pull/2735) ([yourenawo](https://github.com/yourenawo))
- fix: filter push down with `InList` expressions [\#2729](https://github.com/apache/arrow-datafusion/pull/2729) ([Ted-Jiang](https://github.com/Ted-Jiang))
- \[Minor\] add debug info in optimizer.rs [\#2726](https://github.com/apache/arrow-datafusion/pull/2726) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Add public API for GlobalLimitExec and LocalLimitExec [\#2722](https://github.com/apache/arrow-datafusion/pull/2722) ([andygrove](https://github.com/andygrove))
- Add additional data types are supported in hash join [\#2721](https://github.com/apache/arrow-datafusion/pull/2721) ([AssHero](https://github.com/AssHero))
- Upgrade to arrow `16.0.0` [\#2718](https://github.com/apache/arrow-datafusion/pull/2718) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fix clippy warnings with toolchain 1.63 [\#2717](https://github.com/apache/arrow-datafusion/pull/2717) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([waynexia](https://github.com/waynexia))
- Support for GROUPING SETS/CUBE/ROLLUP [\#2716](https://github.com/apache/arrow-datafusion/pull/2716) ([thinkharderdev](https://github.com/thinkharderdev))
- fix: check redundant fields while building projection plan [\#2715](https://github.com/apache/arrow-datafusion/pull/2715) ([waynexia](https://github.com/waynexia))
- Sort preserving `SortMergeJoin` [\#2699](https://github.com/apache/arrow-datafusion/pull/2699) ([korowa](https://github.com/korowa))
- fix: union schema fix [\#2688](https://github.com/apache/arrow-datafusion/pull/2688) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([gandronchik](https://github.com/gandronchik))
- Support default precision and scale to`CAST <EXPR> AS DECIMAL` [\#2680](https://github.com/apache/arrow-datafusion/pull/2680) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([gandronchik](https://github.com/gandronchik))


## [9.0.0](https://github.com/apache/arrow-datafusion/tree/9.0.0) (2022-06-10)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/8.0.0-rc2...9.0.0)

**Breaking changes:**

- MINOR: Move `simplify_expression` rule to `datafusion-optimizer` crate [\#2686](https://github.com/apache/arrow-datafusion/pull/2686) ([andygrove](https://github.com/andygrove))
- Move physical expression planning to `datafusion-physical-expr` crate [\#2682](https://github.com/apache/arrow-datafusion/pull/2682) ([andygrove](https://github.com/andygrove))
- Create new `datafusion-optimizer` crate for logical optimizer rules [\#2675](https://github.com/apache/arrow-datafusion/pull/2675) ([andygrove](https://github.com/andygrove))
- Remove `ExecutionProps` dependency from `OptimizerRule` [\#2666](https://github.com/apache/arrow-datafusion/pull/2666) ([andygrove](https://github.com/andygrove))
- Remove ObjectStoreSchemaProvider \(\#2656\) [\#2665](https://github.com/apache/arrow-datafusion/pull/2665) ([tustvold](https://github.com/tustvold))
- Move `LogicalPlanBuilder` to `datafusion-expr` crate [\#2576](https://github.com/apache/arrow-datafusion/pull/2576) ([andygrove](https://github.com/andygrove))
- `LogicalPlanBuilder` now uses `TableSource` instead of `TableProvider` [\#2569](https://github.com/apache/arrow-datafusion/pull/2569) ([andygrove](https://github.com/andygrove))
- Remove `scan_empty` method from `LogicalPlanBuilder` [\#2568](https://github.com/apache/arrow-datafusion/pull/2568) ([andygrove](https://github.com/andygrove))
- MINOR: Move expression utils from sql module to expr crate [\#2553](https://github.com/apache/arrow-datafusion/pull/2553) ([andygrove](https://github.com/andygrove))
- Remove `scan_json` methods from `LogicalPlanBuilder` [\#2541](https://github.com/apache/arrow-datafusion/pull/2541) ([andygrove](https://github.com/andygrove))
- Remove `scan_avro` methods from `LogicalPlanBuilder` [\#2540](https://github.com/apache/arrow-datafusion/pull/2540) ([andygrove](https://github.com/andygrove))
- Remove `scan_parquet` methods from `LogicalPlanBuilder` [\#2539](https://github.com/apache/arrow-datafusion/pull/2539) ([andygrove](https://github.com/andygrove))
- MINOR: Move `ExprVisitable` and `exprlist_to_columns` to datafusion-expr crate [\#2538](https://github.com/apache/arrow-datafusion/pull/2538) ([andygrove](https://github.com/andygrove))
- Remove `scan_csv` methods from `LogicalPlanBuilder` [\#2537](https://github.com/apache/arrow-datafusion/pull/2537) ([andygrove](https://github.com/andygrove))
- Fix Redundant ScalarValue Boxed Collection [\#2523](https://github.com/apache/arrow-datafusion/pull/2523) ([comphead](https://github.com/comphead))
- Support for OFFSET in LogicalPlan [\#2521](https://github.com/apache/arrow-datafusion/pull/2521) ([jdye64](https://github.com/jdye64))

**Implemented enhancements:**

- \[EPIC\] JIT support for `DataFusion` [\#2703](https://github.com/apache/arrow-datafusion/issues/2703)
- Show column names instead of column indices in query plans [\#2689](https://github.com/apache/arrow-datafusion/issues/2689)
- Proposal: remove automated ballista CI checks from DataFusion [\#2679](https://github.com/apache/arrow-datafusion/issues/2679)
- Pass SessionState to TableProvider [\#2658](https://github.com/apache/arrow-datafusion/issues/2658)
- Is ObjectStoreSchemaProvider Still Needed? [\#2656](https://github.com/apache/arrow-datafusion/issues/2656)
- Add logical plan support to `datafusion-proto` [\#2630](https://github.com/apache/arrow-datafusion/issues/2630)
- Like, NotLike expressions work with literal `NULL` [\#2626](https://github.com/apache/arrow-datafusion/issues/2626)
- Move `JOIN ON` predicates push down logic from planner to optimizer [\#2619](https://github.com/apache/arrow-datafusion/issues/2619)
- Remove `ExecutionProps` from `OptimizerRule` trait [\#2614](https://github.com/apache/arrow-datafusion/issues/2614)
- Add, Minus, Multiply, divide, Modulo operator work with literal `NULL` [\#2609](https://github.com/apache/arrow-datafusion/issues/2609)
- Support `DESCRIBE <table>` to show table schemas [\#2606](https://github.com/apache/arrow-datafusion/issues/2606)
- Support `CREATE OR REPLACE TABLE`  [\#2605](https://github.com/apache/arrow-datafusion/issues/2605)
- filter\_push\_down tests should not rely on TableProvider and ExecutionPlan [\#2600](https://github.com/apache/arrow-datafusion/issues/2600)
- Move logical optimizer rules out of the core datafusion crate [\#2599](https://github.com/apache/arrow-datafusion/issues/2599)
- Push Limit through outer Join [\#2579](https://github.com/apache/arrow-datafusion/issues/2579)
- `datafusion_proto` crate should have exhaustive match statements for handling `Expr` [\#2565](https://github.com/apache/arrow-datafusion/issues/2565)
- String representation of Expr variant [\#2563](https://github.com/apache/arrow-datafusion/issues/2563)
- File URI Scheme Interpretation [\#2562](https://github.com/apache/arrow-datafusion/issues/2562)
- Implement physical plan for OFFSET [\#2551](https://github.com/apache/arrow-datafusion/issues/2551)
- Update limit pushdown rule to support offsets [\#2550](https://github.com/apache/arrow-datafusion/issues/2550)
- Move `LogicalPlanBuilder` to `datafusion-expr` crate [\#2536](https://github.com/apache/arrow-datafusion/issues/2536)
- Logical optimizer rule "simplify expressions" should not depend on the core datafusion crate [\#2535](https://github.com/apache/arrow-datafusion/issues/2535)
- Support optional filter in Join [\#2509](https://github.com/apache/arrow-datafusion/issues/2509)
- Improve SQL planner & logical plan support for JOIN conditions [\#2496](https://github.com/apache/arrow-datafusion/issues/2496)
- Numeric, String, Boolean comparisons with literal `NULL` [\#2482](https://github.com/apache/arrow-datafusion/issues/2482)
- Redundant ScalarValue Boxed Collection [\#2449](https://github.com/apache/arrow-datafusion/issues/2449)
- ObjectStore Directory Semantics [\#2445](https://github.com/apache/arrow-datafusion/issues/2445)
- Add support for `OFFSET` in SQL query planner + logical plan [\#2377](https://github.com/apache/arrow-datafusion/issues/2377)
- SQL planner should use `TableSource` not `TableProvider` [\#2346](https://github.com/apache/arrow-datafusion/issues/2346)
- Move SQL query planning to new crate [\#2345](https://github.com/apache/arrow-datafusion/issues/2345)
- Update LogicalPlan rustdoc code to not use LogicalPlanBuilder [\#2308](https://github.com/apache/arrow-datafusion/issues/2308)
- \[Optimizer\] Refactor `convert join` [\#2256](https://github.com/apache/arrow-datafusion/issues/2256)
- \[Optimizer\] Infer is not null predicate from `where clause` [\#2254](https://github.com/apache/arrow-datafusion/issues/2254)
- Support ArrayIndex for ScalarValue\(List\)  [\#2207](https://github.com/apache/arrow-datafusion/issues/2207)
- \[Ballista\] Fill functional gaps between datafusion and ballista  [\#2062](https://github.com/apache/arrow-datafusion/issues/2062)
- \[Ballista\] support datafusion built\_in  UDAF work in ballista cluster [\#1985](https://github.com/apache/arrow-datafusion/issues/1985)
- Export C API [\#1113](https://github.com/apache/arrow-datafusion/issues/1113)

**Fixed bugs:**

- Fix Typos in Docs [\#2695](https://github.com/apache/arrow-datafusion/issues/2695)
- Unable to build a docker image [\#2691](https://github.com/apache/arrow-datafusion/issues/2691)
- Optimization pass `AggregateStatistics` changes type of output from `Int64` to `UInt64` [\#2673](https://github.com/apache/arrow-datafusion/issues/2673)
- ViewTable Circular Reference [\#2657](https://github.com/apache/arrow-datafusion/issues/2657)
- `ScalarValue::to_array_of_size` panics computing statistics for nested parquet file [\#2653](https://github.com/apache/arrow-datafusion/issues/2653)
- The result type of count/count\_distinct [\#2635](https://github.com/apache/arrow-datafusion/issues/2635)
- limit\_push\_down is not working properly with OFFSET [\#2624](https://github.com/apache/arrow-datafusion/issues/2624)
- Avro Tests Fail To Compile [\#2570](https://github.com/apache/arrow-datafusion/issues/2570)
- Unused Window functions experssion is wrongly removed from LogicalPlan during optimalization [\#2542](https://github.com/apache/arrow-datafusion/issues/2542)
- Bug: ObjectStoreRegistry get\_by\_uri does not return correct path when "scheme" is provided [\#2525](https://github.com/apache/arrow-datafusion/issues/2525)
- There are duplicate and inconsistent copies of `datafusion.proto` [\#2514](https://github.com/apache/arrow-datafusion/issues/2514)
- Projection pushdown produces incorrect results when column names are reused [\#2462](https://github.com/apache/arrow-datafusion/issues/2462)
- Incorrect Parquet Projection For Nested Types [\#2453](https://github.com/apache/arrow-datafusion/issues/2453)
- LogicalPlanBuilder::scan\_csv creates scans with invalid table names [\#2278](https://github.com/apache/arrow-datafusion/issues/2278)
- Inner join incorrectly pushdown predicate with OR operation [\#2271](https://github.com/apache/arrow-datafusion/issues/2271)
- Ignored alias for columns with aggregate function and incorrect results when collecting statistics is enabled [\#2176](https://github.com/apache/arrow-datafusion/issues/2176)
- Join on path partitioned columns fails with error [\#2145](https://github.com/apache/arrow-datafusion/issues/2145)

**Documentation updates:**

- Fix Ballista link [\#2654](https://github.com/apache/arrow-datafusion/pull/2654) ([dsaxton](https://github.com/dsaxton))
- MINOR: Add Blaze as a project using DataFusion [\#2618](https://github.com/apache/arrow-datafusion/pull/2618) ([yjshen](https://github.com/yjshen))
- \[MINOR\] remove datafusion-cli's ballista feature from docs [\#2612](https://github.com/apache/arrow-datafusion/pull/2612) ([Ted-Jiang](https://github.com/Ted-Jiang))
- chore\(doc\) remove ballista from datafusion-cli readme [\#2604](https://github.com/apache/arrow-datafusion/pull/2604) ([ming535](https://github.com/ming535))

**Closed issues:**

- \[Question\] Converting TableSource to custom TableProvider [\#2644](https://github.com/apache/arrow-datafusion/issues/2644)
- \[Question\] Why DataFusion is shipped with arrow version 9.1.0 on crates.io ? [\#2474](https://github.com/apache/arrow-datafusion/issues/2474)

**Merged pull requests:**

- Test optional features in CI [\#2708](https://github.com/apache/arrow-datafusion/pull/2708) ([tustvold](https://github.com/tustvold))
- support indexed fields proto [\#2707](https://github.com/apache/arrow-datafusion/pull/2707) ([nl5887](https://github.com/nl5887))
- Update sqlparser-rs to 0.18.0 [\#2705](https://github.com/apache/arrow-datafusion/pull/2705) ([alamb](https://github.com/alamb))
- \[MINOR\]: Add documentation to `datafusion-row` modules [\#2704](https://github.com/apache/arrow-datafusion/pull/2704) ([alamb](https://github.com/alamb))
- Make sure that the data types are supported in hashjoin before genera… [\#2702](https://github.com/apache/arrow-datafusion/pull/2702) ([AssHero](https://github.com/AssHero))
- Move remaining code out of legacy `core/logical_plan` module [\#2701](https://github.com/apache/arrow-datafusion/pull/2701) ([andygrove](https://github.com/andygrove))
- Move some tests from core to expr [\#2700](https://github.com/apache/arrow-datafusion/pull/2700) ([andygrove](https://github.com/andygrove))
- MINOR: Improve Docs Readability [\#2696](https://github.com/apache/arrow-datafusion/pull/2696) ([ryanrussell](https://github.com/ryanrussell))
- Combine limit and offset to `fetch` and `skip` and implement physical plan support [\#2694](https://github.com/apache/arrow-datafusion/pull/2694) ([ming535](https://github.com/ming535))
- MINOR: Add datafusion-sql example [\#2693](https://github.com/apache/arrow-datafusion/pull/2693) ([andygrove](https://github.com/andygrove))
- Remove Ballista related lines from Dockerfile [\#2692](https://github.com/apache/arrow-datafusion/pull/2692) ([mocknen](https://github.com/mocknen))
- Show column names instead of indices in query plans [\#2690](https://github.com/apache/arrow-datafusion/pull/2690) ([andygrove](https://github.com/andygrove))
- MINOR: Remove uses of TryClone for Parquet  [\#2681](https://github.com/apache/arrow-datafusion/pull/2681) ([tustvold](https://github.com/tustvold))
- Fix `AggregateStatistics` optimization so it doesn't change output type [\#2674](https://github.com/apache/arrow-datafusion/pull/2674) ([alamb](https://github.com/alamb))
- If statistics of column Max/Min value does not exists in parquet file, sent Min/Max to None [\#2671](https://github.com/apache/arrow-datafusion/pull/2671) ([AssHero](https://github.com/AssHero))
- MINOR: Move more expression code to `datafusion-expr` crate [\#2669](https://github.com/apache/arrow-datafusion/pull/2669) ([andygrove](https://github.com/andygrove))
- MINOR: Rewrite imports in optimizer moduler [\#2667](https://github.com/apache/arrow-datafusion/pull/2667) ([andygrove](https://github.com/andygrove))
- Update snmalloc-rs requirement from 0.2 to 0.3 [\#2663](https://github.com/apache/arrow-datafusion/pull/2663) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add module doc for RuntimeEnv, SessionContext, TaskContext, etc... [\#2655](https://github.com/apache/arrow-datafusion/pull/2655) ([tustvold](https://github.com/tustvold))
- Prune unused dependencies from datafusion-proto [\#2651](https://github.com/apache/arrow-datafusion/pull/2651) ([tustvold](https://github.com/tustvold))
- MINOR: Implement serde for join filter [\#2649](https://github.com/apache/arrow-datafusion/pull/2649) ([andygrove](https://github.com/andygrove))
- pushdown support for predicates in `ON` clause of joins [\#2647](https://github.com/apache/arrow-datafusion/pull/2647) ([korowa](https://github.com/korowa))
- Move `SortKeyCursor` and `RowIndex` into modules, add `sort_key_cursor` test [\#2645](https://github.com/apache/arrow-datafusion/pull/2645) ([alamb](https://github.com/alamb))
- Implement DESCRIBE \<table\> [\#2642](https://github.com/apache/arrow-datafusion/pull/2642) ([LiuYuHui](https://github.com/LiuYuHui))
- Implement `LogicalPlan` serde in `datafusion-proto` [\#2639](https://github.com/apache/arrow-datafusion/pull/2639) ([andygrove](https://github.com/andygrove))
- Fix limit + offset pushdown [\#2638](https://github.com/apache/arrow-datafusion/pull/2638) ([ming535](https://github.com/ming535))
- change result type of count/count\_distinct from uint64 to int64 [\#2636](https://github.com/apache/arrow-datafusion/pull/2636) ([liukun4515](https://github.com/liukun4515))
- if none columns in window expr are needed, remove the window exprs [\#2634](https://github.com/apache/arrow-datafusion/pull/2634) ([AssHero](https://github.com/AssHero))
- Like, NotLike expressions work with literal `NULL` [\#2627](https://github.com/apache/arrow-datafusion/pull/2627) ([WinkerDu](https://github.com/WinkerDu))
- MINOR: Refactor `datafusion-proto` dependencies and imports [\#2623](https://github.com/apache/arrow-datafusion/pull/2623) ([andygrove](https://github.com/andygrove))
- MINOR: add optimizer struct [\#2616](https://github.com/apache/arrow-datafusion/pull/2616) ([jackwener](https://github.com/jackwener))
- Remove FilterPushDown dependency on physical plan [\#2615](https://github.com/apache/arrow-datafusion/pull/2615) ([andygrove](https://github.com/andygrove))
- Support CREATE OR REPLACE TABLE [\#2613](https://github.com/apache/arrow-datafusion/pull/2613) ([AssHero](https://github.com/AssHero))
- Support binary mathematical operators work with `NULL` literals [\#2610](https://github.com/apache/arrow-datafusion/pull/2610) ([WinkerDu](https://github.com/WinkerDu))
- chore: try fix CI coverage [\#2608](https://github.com/apache/arrow-datafusion/pull/2608) ([Ted-Jiang](https://github.com/Ted-Jiang))
- MINOR: Rename benchmark crate [\#2607](https://github.com/apache/arrow-datafusion/pull/2607) ([andygrove](https://github.com/andygrove))
- chore\(dep\): bump cranelift to 0.84.0 [\#2598](https://github.com/apache/arrow-datafusion/pull/2598) ([waynexia](https://github.com/waynexia))
- fix some typos [\#2597](https://github.com/apache/arrow-datafusion/pull/2597) ([ming535](https://github.com/ming535))
- Support limit pushdown through left right outer join [\#2596](https://github.com/apache/arrow-datafusion/pull/2596) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Unignore rustdoc code examples in `datafusion-expr` crate [\#2590](https://github.com/apache/arrow-datafusion/pull/2590) ([andygrove](https://github.com/andygrove))
- Evaluate JIT'd expression over arrays [\#2587](https://github.com/apache/arrow-datafusion/pull/2587) ([waynexia](https://github.com/waynexia))
- \[minor\]Fix ci clippy for unused import [\#2586](https://github.com/apache/arrow-datafusion/pull/2586) ([Ted-Jiang](https://github.com/Ted-Jiang))
- \[Doc\]add doc for enable SIMD need `cargo nightly` [\#2577](https://github.com/apache/arrow-datafusion/pull/2577) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Add DataFrame `union_distinct` and fix documentation for `distinct` [\#2574](https://github.com/apache/arrow-datafusion/pull/2574) ([andygrove](https://github.com/andygrove))
- Fix avro tests \(\#2570\) [\#2571](https://github.com/apache/arrow-datafusion/pull/2571) ([tustvold](https://github.com/tustvold))
- Make datafusion-proto match exhaustive [\#2567](https://github.com/apache/arrow-datafusion/pull/2567) ([andygrove](https://github.com/andygrove))
- Support limit push down for offset\_plan [\#2566](https://github.com/apache/arrow-datafusion/pull/2566) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Introduce Expr.variant\_name\(\) function [\#2564](https://github.com/apache/arrow-datafusion/pull/2564) ([jdye64](https://github.com/jdye64))
- Fix some 404 links in the contribution guide [\#2561](https://github.com/apache/arrow-datafusion/pull/2561) ([hi-rustin](https://github.com/hi-rustin))
- Update datafusion-cli readme cli version [\#2559](https://github.com/apache/arrow-datafusion/pull/2559) ([hi-rustin](https://github.com/hi-rustin))
- MINOR: Move `expr_rewriter.rs` to `datafusion-expr` crate [\#2552](https://github.com/apache/arrow-datafusion/pull/2552) ([andygrove](https://github.com/andygrove))
- Fix `JOIN`s with complex predicates in ON \(split ON expressions only by AND operator\) [\#2534](https://github.com/apache/arrow-datafusion/pull/2534) ([korowa](https://github.com/korowa))
- Reduce duplication in file scan tests [\#2533](https://github.com/apache/arrow-datafusion/pull/2533) ([tustvold](https://github.com/tustvold))
- Fix size\_of\_scalar test [\#2531](https://github.com/apache/arrow-datafusion/pull/2531) ([alamb](https://github.com/alamb))
- Update to arrow-rs 14.0.0  [\#2528](https://github.com/apache/arrow-datafusion/pull/2528) ([alamb](https://github.com/alamb))
- ObjectStoreRegistry get\_by\_uri now returns correct path when "scheme" is provided [\#2526](https://github.com/apache/arrow-datafusion/pull/2526) ([timvw](https://github.com/timvw))
- MINOR: Add ORDER BY clause to test [\#2524](https://github.com/apache/arrow-datafusion/pull/2524) ([andygrove](https://github.com/andygrove))
- Remove unused  `binary_array_op_scalar!` in binary.rs [\#2512](https://github.com/apache/arrow-datafusion/pull/2512) ([alamb](https://github.com/alamb))
- fix `NULL <op> column` evaluation, tests for same [\#2510](https://github.com/apache/arrow-datafusion/pull/2510) ([alamb](https://github.com/alamb))
- Fix projection pushdown produces incorrect results when column names are reused [\#2463](https://github.com/apache/arrow-datafusion/pull/2463) ([jonmmease](https://github.com/jonmmease))
- Benchmark for sort preserving merge [\#2431](https://github.com/apache/arrow-datafusion/pull/2431) ([alamb](https://github.com/alamb))
- Support GetIndexedFieldExpr for ScalarValue [\#2196](https://github.com/apache/arrow-datafusion/pull/2196) ([ovr](https://github.com/ovr))

## [8.0.0](https://github.com/apache/arrow-datafusion/tree/8.0.0) (2022-05-12)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/7.1.0-rc1...8.0.0)

**Breaking changes:**

- Add SQL planner support for `ROLLUP` and `CUBE` grouping set expressions [\#2446](https://github.com/apache/arrow-datafusion/pull/2446) ([andygrove](https://github.com/andygrove))
- Make `ExecutionPlan::execute` Sync [\#2434](https://github.com/apache/arrow-datafusion/pull/2434) ([tustvold](https://github.com/tustvold))
- Introduce new `DataFusionError::SchemaError` type [\#2371](https://github.com/apache/arrow-datafusion/pull/2371) ([andygrove](https://github.com/andygrove))
- Add `Expr::InSubquery` and `Expr::ScalarSubquery` [\#2342](https://github.com/apache/arrow-datafusion/pull/2342) ([andygrove](https://github.com/andygrove))
- Add `Expr::Exists` to represent EXISTS subquery expression [\#2339](https://github.com/apache/arrow-datafusion/pull/2339) ([andygrove](https://github.com/andygrove))
- Move `LogicalPlan` enum to `datafusion-expr` crate [\#2294](https://github.com/apache/arrow-datafusion/pull/2294) ([andygrove](https://github.com/andygrove))
- Remove dependency from `LogicalPlan::TableScan` to `ExecutionPlan` [\#2284](https://github.com/apache/arrow-datafusion/pull/2284) ([andygrove](https://github.com/andygrove))
- Move logical expression type-coercion code from `physical-expr` crate to `expr` crate [\#2257](https://github.com/apache/arrow-datafusion/pull/2257) ([andygrove](https://github.com/andygrove))
- feat: 2061 create external table ddl table partition cols [\#2099](https://github.com/apache/arrow-datafusion/pull/2099) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([jychen7](https://github.com/jychen7))
- Reorganize the project folders [\#2081](https://github.com/apache/arrow-datafusion/pull/2081) ([yahoNanJing](https://github.com/yahoNanJing))
- Support more ScalarFunction in Ballista [\#2008](https://github.com/apache/arrow-datafusion/pull/2008) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Merge dataframe and dataframe imp [\#1998](https://github.com/apache/arrow-datafusion/pull/1998) ([vchag](https://github.com/vchag))
- Rename `ExecutionContext` to `SessionContext`, `ExecutionContextState` to `SessionState`, add `TaskContext` to support multi-tenancy configurations - Part 1 [\#1987](https://github.com/apache/arrow-datafusion/pull/1987) ([mingmwang](https://github.com/mingmwang))
- Add Coalesce function [\#1969](https://github.com/apache/arrow-datafusion/pull/1969) ([msathis](https://github.com/msathis))
- Add Create Schema functionality in SQL [\#1959](https://github.com/apache/arrow-datafusion/pull/1959) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([matthewmturner](https://github.com/matthewmturner))
- omit some clone when converting sql to logical plan [\#1945](https://github.com/apache/arrow-datafusion/pull/1945) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([doki23](https://github.com/doki23))
- \[split/16\] move physical plan expressions folder to datafusion-physical-expr crate [\#1889](https://github.com/apache/arrow-datafusion/pull/1889) ([Jimexist](https://github.com/Jimexist))
- remove sync constraint of SendableRecordBatchStream [\#1884](https://github.com/apache/arrow-datafusion/pull/1884) ([doki23](https://github.com/doki23))
- \[split/15\] move built in window expr and partition evaluator [\#1865](https://github.com/apache/arrow-datafusion/pull/1865) ([Jimexist](https://github.com/Jimexist))

**Implemented enhancements:**

- Include `Expr` to `datafusion::prelude` [\#2347](https://github.com/apache/arrow-datafusion/issues/2347)
- Implement `Serialization` API for DataFusion [\#2340](https://github.com/apache/arrow-datafusion/issues/2340)
- Implement `power` function [\#1493](https://github.com/apache/arrow-datafusion/issues/1493)
- allow `lit` python function to support `boolean` and other types [\#1136](https://github.com/apache/arrow-datafusion/issues/1136)
- Automate dependency updates [\#37](https://github.com/apache/arrow-datafusion/issues/37)
- Add `CREATE VIEW` [\#2279](https://github.com/apache/arrow-datafusion/pull/2279) ([matthewmturner](https://github.com/matthewmturner))
- \[Ballista\] Support Union in ballista. [\#2098](https://github.com/apache/arrow-datafusion/pull/2098) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Change the DataFusion explain plans to make it clearer in the predicate/filter [\#2063](https://github.com/apache/arrow-datafusion/pull/2063) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Add `write_json`, `read_json`, `register_json`, and `JsonFormat` to `CREATE EXTERNAL TABLE` functionality [\#2023](https://github.com/apache/arrow-datafusion/pull/2023) ([matthewmturner](https://github.com/matthewmturner))
- Qualified wildcard [\#2012](https://github.com/apache/arrow-datafusion/pull/2012) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([doki23](https://github.com/doki23))
- support bitwise or/'|' operation [\#1876](https://github.com/apache/arrow-datafusion/pull/1876) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([liukun4515](https://github.com/liukun4515))
- Introduce JIT code generation [\#1849](https://github.com/apache/arrow-datafusion/pull/1849) ([yjshen](https://github.com/yjshen))

**Fixed bugs:**

- CASE expr with NULL literals panics `'WHEN expression did not return a BooleanArray'` [\#1189](https://github.com/apache/arrow-datafusion/issues/1189)
- Function calls with NULL literals do not work [\#1188](https://github.com/apache/arrow-datafusion/issues/1188)
- Add SQL planner support for calling `round` function with two arguments [\#2503](https://github.com/apache/arrow-datafusion/pull/2503) ([andygrove](https://github.com/andygrove))
- nested query fix [\#2402](https://github.com/apache/arrow-datafusion/pull/2402) ([comphead](https://github.com/comphead))
- fix  issue\#2058 file\_format/json.rs attempt to subtract with overflow [\#2066](https://github.com/apache/arrow-datafusion/pull/2066) ([silence-coding](https://github.com/silence-coding))
- fix bug the optimizer rule filter push down [\#2039](https://github.com/apache/arrow-datafusion/pull/2039) ([jackwener](https://github.com/jackwener))
- fix: replace `ExecutionContex` and `ExecutionConfig` with `SessionContext` and `SessionConfig` [\#2030](https://github.com/apache/arrow-datafusion/pull/2030) ([xudong963](https://github.com/xudong963))
- Fixed parquet path partitioning when only selecting partitioned columns [\#2000](https://github.com/apache/arrow-datafusion/pull/2000) ([pjmore](https://github.com/pjmore))
- Fix ambiguous reference error in filter plan [\#1925](https://github.com/apache/arrow-datafusion/pull/1925) ([jonmmease](https://github.com/jonmmease))
- platform aware partition parsing [\#1867](https://github.com/apache/arrow-datafusion/pull/1867) ([korowa](https://github.com/korowa))
- Fix incorrect aggregation in case that GROUP BY contains duplicate column names [\#1855](https://github.com/apache/arrow-datafusion/pull/1855) ([alex-natzka](https://github.com/alex-natzka))

**Documentation updates:**

- MINOR: Make crate READMEs consistent [\#2437](https://github.com/apache/arrow-datafusion/pull/2437) ([andygrove](https://github.com/andygrove))
- minor: Improve documentation for DFSchema join and merge functions [\#2367](https://github.com/apache/arrow-datafusion/pull/2367) ([andygrove](https://github.com/andygrove))
- Change the code location and add annotation [\#2037](https://github.com/apache/arrow-datafusion/pull/2037) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([jackwener](https://github.com/jackwener))
- Fix typos \(Datafusion -\> DataFusion\) [\#1993](https://github.com/apache/arrow-datafusion/pull/1993) ([andygrove](https://github.com/andygrove))
- Add examples to use MemTable and TableProvider \(\#1864\) [\#1946](https://github.com/apache/arrow-datafusion/pull/1946) ([PierreZ](https://github.com/PierreZ))
- Add doc for building `datafusion-cli` when connect the ballista [\#1866](https://github.com/apache/arrow-datafusion/pull/1866) ([liukun4515](https://github.com/liukun4515))
- Add benchmarks section to DEVELOPERS.md [\#1838](https://github.com/apache/arrow-datafusion/pull/1838) ([tustvold](https://github.com/tustvold))

**Performance improvements:**

- Avoid an Arc::clone per row in benchmark [\#1975](https://github.com/apache/arrow-datafusion/pull/1975) ([jhorstmann](https://github.com/jhorstmann))
- Update datafusion-cli allocator [\#1878](https://github.com/apache/arrow-datafusion/pull/1878) ([matthewmturner](https://github.com/matthewmturner))

**Closed issues:**

- Make expected result string in unit tests more readable [\#2412](https://github.com/apache/arrow-datafusion/issues/2412)
- remove duplicated `fn aggregate()` in aggregate expression tests [\#2399](https://github.com/apache/arrow-datafusion/issues/2399)
- split `distinct_expression.rs` into `count_distinct.rs` and `array_agg_distinct.rs` [\#2385](https://github.com/apache/arrow-datafusion/issues/2385)
- move sql tests in `context.rs` to corresponding test files in `datafustion/core/tests/sql` [\#2328](https://github.com/apache/arrow-datafusion/issues/2328)
- Date32/Date64 as join keys for merge join [\#2314](https://github.com/apache/arrow-datafusion/issues/2314)
- Error precision and scale for decimal coercion in logic comparison [\#2232](https://github.com/apache/arrow-datafusion/issues/2232)
- Support Multiple row layout [\#2188](https://github.com/apache/arrow-datafusion/issues/2188)
-  TPC-H Query 18 [\#169](https://github.com/apache/arrow-datafusion/issues/169)
-  TPC-H Query 16 [\#167](https://github.com/apache/arrow-datafusion/issues/167)
-   Implement Sort-Merge Join [\#141](https://github.com/apache/arrow-datafusion/issues/141)
-   Split logical expressions out into separate source files [\#114](https://github.com/apache/arrow-datafusion/issues/114)

**Merged pull requests:**

- Minor: remove code that is now included in arrow-rs [\#2511](https://github.com/apache/arrow-datafusion/pull/2511) ([alamb](https://github.com/alamb))
- MINOR: Enable multi-statement benchmark queries [\#2507](https://github.com/apache/arrow-datafusion/pull/2507) ([andygrove](https://github.com/andygrove))
- MINOR: Add ignored tests for all remaining benchmark queries [\#2506](https://github.com/apache/arrow-datafusion/pull/2506) ([andygrove](https://github.com/andygrove))
- Update to `sqlparser` `0.17.0` [\#2500](https://github.com/apache/arrow-datafusion/pull/2500) ([alamb](https://github.com/alamb))
- Add metrics for ParquetExec [\#2499](https://github.com/apache/arrow-datafusion/pull/2499) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Limit cpu cores used when generating changelog [\#2494](https://github.com/apache/arrow-datafusion/pull/2494) ([andygrove](https://github.com/andygrove))
- Optimize MergeJoin by storing joined indices instead of creating small record batches for each match [\#2492](https://github.com/apache/arrow-datafusion/pull/2492) ([richox](https://github.com/richox))
- Add SQL planner support for `grouping()` aggregate expressions [\#2486](https://github.com/apache/arrow-datafusion/pull/2486) ([andygrove](https://github.com/andygrove))
- MINOR: Parameterize changelog script [\#2484](https://github.com/apache/arrow-datafusion/pull/2484) ([jychen7](https://github.com/jychen7))
- Numeric, String, Boolean comparisons with literal `NULL` [\#2481](https://github.com/apache/arrow-datafusion/pull/2481) ([WinkerDu](https://github.com/WinkerDu))
- Adds unit test cases of mathematical expressions working with `null` literal [\#2478](https://github.com/apache/arrow-datafusion/pull/2478) ([WinkerDu](https://github.com/WinkerDu))
- Minor: Move test code from `context.rs` into `sql_integration`  [\#2473](https://github.com/apache/arrow-datafusion/pull/2473) ([alamb](https://github.com/alamb))
- Minor: Use ExprVisitor to find columns referenced by expr [\#2471](https://github.com/apache/arrow-datafusion/pull/2471) ([alamb](https://github.com/alamb))
- minor: remove expr dependency from the row crate, update crate-deps.dot/svg [\#2470](https://github.com/apache/arrow-datafusion/pull/2470) ([yjshen](https://github.com/yjshen))
- Fix `read_from_registered_table_with_glob_path` fails if path contains // \#2465 [\#2468](https://github.com/apache/arrow-datafusion/pull/2468) ([timvw](https://github.com/timvw))
- Add support for list\_dir\(\) on local fs [\#2467](https://github.com/apache/arrow-datafusion/pull/2467) ([wjones127](https://github.com/wjones127))
- MINOR: Partial fix for SQL aggregate queries with aliases [\#2464](https://github.com/apache/arrow-datafusion/pull/2464) ([andygrove](https://github.com/andygrove))
- minor: move struct definition out of `aggregate/mod.rs`, etc [\#2458](https://github.com/apache/arrow-datafusion/pull/2458) ([WinkerDu](https://github.com/WinkerDu))
- Fix bugs in SQL planner with GROUP BY scalar function and alias [\#2457](https://github.com/apache/arrow-datafusion/pull/2457) ([andygrove](https://github.com/andygrove))
- feat: Support CompoundIdentifier as GetIndexedField access [\#2454](https://github.com/apache/arrow-datafusion/pull/2454) ([ovr](https://github.com/ovr))
- Table provider error propagation [\#2438](https://github.com/apache/arrow-datafusion/pull/2438) ([jdye64](https://github.com/jdye64))
- MINOR: Improve error messages for GROUP BY / HAVING queries [\#2435](https://github.com/apache/arrow-datafusion/pull/2435) ([andygrove](https://github.com/andygrove))
- minor: remove redundant code [\#2432](https://github.com/apache/arrow-datafusion/pull/2432) ([jackwener](https://github.com/jackwener))
- minor: update versions and paths in changelog scripts [\#2429](https://github.com/apache/arrow-datafusion/pull/2429) ([andygrove](https://github.com/andygrove))
- Fix Ballista executing during plan [\#2428](https://github.com/apache/arrow-datafusion/pull/2428) ([tustvold](https://github.com/tustvold))
- minor: format table result vec & remove some unnecessary semicolons [\#2425](https://github.com/apache/arrow-datafusion/pull/2425) ([WinkerDu](https://github.com/WinkerDu))
- Basic support for `IN` and `NOT IN` Subqueries by rewriting them to `SEMI` / `ANTI` Join [\#2421](https://github.com/apache/arrow-datafusion/pull/2421) ([korowa](https://github.com/korowa))
- Allow subqueries without aliases [\#2418](https://github.com/apache/arrow-datafusion/pull/2418) ([andygrove](https://github.com/andygrove))
- Fix bug in subquery join filters referencing outer query [\#2416](https://github.com/apache/arrow-datafusion/pull/2416) ([andygrove](https://github.com/andygrove))
- MINOR: remove duplicated function `format_state_name()` [\#2414](https://github.com/apache/arrow-datafusion/pull/2414) ([WinkerDu](https://github.com/WinkerDu))
- Make expected result string in unit tests more readable [\#2413](https://github.com/apache/arrow-datafusion/pull/2413) ([WinkerDu](https://github.com/WinkerDu))
- `sum(distinct)` support [\#2405](https://github.com/apache/arrow-datafusion/pull/2405) ([WinkerDu](https://github.com/WinkerDu))
- Update ordered-float requirement from 2.10 to 3.0 [\#2403](https://github.com/apache/arrow-datafusion/pull/2403) ([dependabot[bot]](https://github.com/apps/dependabot))
- remove duplicated `fn aggregate()` in aggregate expression tests [\#2400](https://github.com/apache/arrow-datafusion/pull/2400) ([WinkerDu](https://github.com/WinkerDu))
- Support type-coercion from Decimal to Float64 [\#2396](https://github.com/apache/arrow-datafusion/pull/2396) ([comphead](https://github.com/comphead))
- minor: SchemaError code cleanup and improvements [\#2391](https://github.com/apache/arrow-datafusion/pull/2391) ([andygrove](https://github.com/andygrove))
- Support struct\_expr generate struct in sql [\#2389](https://github.com/apache/arrow-datafusion/pull/2389) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Re-organize and rename aggregates physical plan [\#2388](https://github.com/apache/arrow-datafusion/pull/2388) ([yjshen](https://github.com/yjshen))
- refactor `distinct_expressions.rs` and split into `count_distinct.rs` and `array_agg_distinct.rs` [\#2386](https://github.com/apache/arrow-datafusion/pull/2386) ([WinkerDu](https://github.com/WinkerDu))
- Allow CTEs to be referenced from subquery expressions [\#2384](https://github.com/apache/arrow-datafusion/pull/2384) ([andygrove](https://github.com/andygrove))
- Upgrade to arrow 13 [\#2382](https://github.com/apache/arrow-datafusion/pull/2382) ([alamb](https://github.com/alamb))
- Grouped Aggregate in row format [\#2375](https://github.com/apache/arrow-datafusion/pull/2375) ([yjshen](https://github.com/yjshen))
- Fix bugs with CTE aliasing and normalize all identifiers in the SQL planner [\#2373](https://github.com/apache/arrow-datafusion/pull/2373) ([andygrove](https://github.com/andygrove))
- Stop optimizing queries twice [\#2369](https://github.com/apache/arrow-datafusion/pull/2369) ([andygrove](https://github.com/andygrove))
- feat: Support casting to arrays to  primitive type [\#2366](https://github.com/apache/arrow-datafusion/pull/2366) ([ovr](https://github.com/ovr))
- Add proper support for `null` literal by introducing `ScalarValue::Null` [\#2364](https://github.com/apache/arrow-datafusion/pull/2364) ([WinkerDu](https://github.com/WinkerDu))
- minor: fix duplicate column bug in subquery support [\#2362](https://github.com/apache/arrow-datafusion/pull/2362) ([andygrove](https://github.com/andygrove))
- Normalize subquery aliases [\#2359](https://github.com/apache/arrow-datafusion/pull/2359) ([andygrove](https://github.com/andygrove))
- Implement physical planner support for DATE +/- INTERVAL [\#2357](https://github.com/apache/arrow-datafusion/pull/2357) ([andygrove](https://github.com/andygrove))
- Add SQL query planner support for Scalar Subqueries [\#2354](https://github.com/apache/arrow-datafusion/pull/2354) ([andygrove](https://github.com/andygrove))
- Add SQL query planner support for IN subqueries [\#2352](https://github.com/apache/arrow-datafusion/pull/2352) ([andygrove](https://github.com/andygrove))
- Add `Expr` to prelude [\#2348](https://github.com/apache/arrow-datafusion/pull/2348) ([alamb](https://github.com/alamb))
- Add SQL planner support for EXISTS subqueries [\#2344](https://github.com/apache/arrow-datafusion/pull/2344) ([andygrove](https://github.com/andygrove))
- Add public Serialization/Deserialization API for `Expr` to/from bytes [\#2341](https://github.com/apache/arrow-datafusion/pull/2341) ([alamb](https://github.com/alamb))
- Support for date32 and date64 in sort merge join [\#2336](https://github.com/apache/arrow-datafusion/pull/2336) ([hntd187](https://github.com/hntd187))
- \[physical-expr\] move aggregate exprs and window exprs to their own modules [\#2335](https://github.com/apache/arrow-datafusion/pull/2335) ([yjshen](https://github.com/yjshen))
- fix: union schema [\#2334](https://github.com/apache/arrow-datafusion/pull/2334) ([gandronchik](https://github.com/gandronchik))
- Improve sql integration test organization [\#2333](https://github.com/apache/arrow-datafusion/pull/2333) ([alamb](https://github.com/alamb))
- Support scalar values for func Array [\#2332](https://github.com/apache/arrow-datafusion/pull/2332) ([Ted-Jiang](https://github.com/Ted-Jiang))
- move sql tests from `context.rs` to corresponding test files in `tests/sql` [\#2329](https://github.com/apache/arrow-datafusion/pull/2329) ([WinkerDu](https://github.com/WinkerDu))
- deprecate `index_of` and make `index_of_column_by_name` public [\#2320](https://github.com/apache/arrow-datafusion/pull/2320) ([jdye64](https://github.com/jdye64))
- Fix HashJoin evaluating during plan [\#2317](https://github.com/apache/arrow-datafusion/pull/2317) ([tustvold](https://github.com/tustvold))
- minor: remove two source files that only had re-exports [\#2313](https://github.com/apache/arrow-datafusion/pull/2313) ([andygrove](https://github.com/andygrove))
- Don't sort batches during plan [\#2312](https://github.com/apache/arrow-datafusion/pull/2312) ([tustvold](https://github.com/tustvold))
- Move case/when expressions to datafusion-expr crate [\#2311](https://github.com/apache/arrow-datafusion/pull/2311) ([andygrove](https://github.com/andygrove))
- Fix CrossJoinExec evaluating during plan [\#2310](https://github.com/apache/arrow-datafusion/pull/2310) ([tustvold](https://github.com/tustvold))
- Make SortPreservingMerge Usable Outside Tokio \(\#2201\) [\#2305](https://github.com/apache/arrow-datafusion/pull/2305) ([tustvold](https://github.com/tustvold))
- chore: update cranelift to 0.83.0 [\#2304](https://github.com/apache/arrow-datafusion/pull/2304) ([yjshen](https://github.com/yjshen))
- Always increment timer on record [\#2298](https://github.com/apache/arrow-datafusion/pull/2298) ([tustvold](https://github.com/tustvold))
- Remove unnecessary env var for parquet\_sql example [\#2297](https://github.com/apache/arrow-datafusion/pull/2297) ([sergey-melnychuk](https://github.com/sergey-melnychuk))
- Simplify sort streams [\#2296](https://github.com/apache/arrow-datafusion/pull/2296) ([tustvold](https://github.com/tustvold))
- MINOR: beautify code with neat idents [\#2295](https://github.com/apache/arrow-datafusion/pull/2295) ([WinkerDu](https://github.com/WinkerDu))
- Move FileType enum from sql module to logical\_plan module [\#2290](https://github.com/apache/arrow-datafusion/pull/2290) ([andygrove](https://github.com/andygrove))
- Remove Parquet Empty Projection Workaround [\#2289](https://github.com/apache/arrow-datafusion/pull/2289) ([tustvold](https://github.com/tustvold))
- Add BatchPartitioner \(\#2285\) [\#2287](https://github.com/apache/arrow-datafusion/pull/2287) ([tustvold](https://github.com/tustvold))
- Make row its crate to make it accessible from physical-expr [\#2283](https://github.com/apache/arrow-datafusion/pull/2283) ([yjshen](https://github.com/yjshen))
- Enable filter pushdown when using In\_list on parquet [\#2282](https://github.com/apache/arrow-datafusion/pull/2282) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Update uuid requirement from 0.8 to 1.0 [\#2280](https://github.com/apache/arrow-datafusion/pull/2280) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add bytes scanned metric to ParquetExec [\#2273](https://github.com/apache/arrow-datafusion/pull/2273) ([thinkharderdev](https://github.com/thinkharderdev))
- Fix outer join output with all-null indices on empty batch [\#2272](https://github.com/apache/arrow-datafusion/pull/2272) ([yjshen](https://github.com/yjshen))
- Re-export DataFusion crates [\#2264](https://github.com/apache/arrow-datafusion/pull/2264) ([andygrove](https://github.com/andygrove))
- rewrite approx\_median to approx\_percentile\_cont while planning phase [\#2262](https://github.com/apache/arrow-datafusion/pull/2262) ([korowa](https://github.com/korowa))
- Introduce RowLayout to represent rows for different purposes [\#2261](https://github.com/apache/arrow-datafusion/pull/2261) ([yjshen](https://github.com/yjshen))
- fix string coercion missing in Eq/NotEq operator [\#2258](https://github.com/apache/arrow-datafusion/pull/2258) ([WinkerDu](https://github.com/WinkerDu))
- Update to Arrow 12.0.0, update tonic and prost [\#2253](https://github.com/apache/arrow-datafusion/pull/2253) ([alamb](https://github.com/alamb))
- minor: move field\_util from `physical-expr` crate to `expr` crate [\#2250](https://github.com/apache/arrow-datafusion/pull/2250) ([andygrove](https://github.com/andygrove))
- Move identifer case tests to `sql_integ`, add negative cases, Debug for `DataFrame` [\#2243](https://github.com/apache/arrow-datafusion/pull/2243) ([alamb](https://github.com/alamb))
- Implement sort-merge join [\#2242](https://github.com/apache/arrow-datafusion/pull/2242) ([richox](https://github.com/richox))
- fix: find the right wider decimal datatype for comparison operation [\#2241](https://github.com/apache/arrow-datafusion/pull/2241) ([liukun4515](https://github.com/liukun4515))
- Fix join without constraints [\#2240](https://github.com/apache/arrow-datafusion/pull/2240) ([Dandandan](https://github.com/Dandandan))
- Add type coercion rule for date + interval [\#2235](https://github.com/apache/arrow-datafusion/pull/2235) ([andygrove](https://github.com/andygrove))
- support array with scalar arithmetic operation for decimal data type [\#2233](https://github.com/apache/arrow-datafusion/pull/2233) ([liukun4515](https://github.com/liukun4515))
- chore: add `debug!` log in some execution operators [\#2231](https://github.com/apache/arrow-datafusion/pull/2231) ([NGA-TRAN](https://github.com/NGA-TRAN))
- Introduce new optional scheduler, using Morsel-driven Parallelism + rayon \(\#2199\) [\#2226](https://github.com/apache/arrow-datafusion/pull/2226) ([tustvold](https://github.com/tustvold))
- minor: add editor config file [\#2224](https://github.com/apache/arrow-datafusion/pull/2224) ([jackwener](https://github.com/jackwener))
- minor: Refactor to avoid repeated code in replace\_qualifier [\#2222](https://github.com/apache/arrow-datafusion/pull/2222) ([andygrove](https://github.com/andygrove))
- update cli readme [\#2220](https://github.com/apache/arrow-datafusion/pull/2220) ([liukun4515](https://github.com/liukun4515))
- Use `filter` \(filter\_record\_batch\) instead of `take` to avoid using indices [\#2218](https://github.com/apache/arrow-datafusion/pull/2218) ([Dandandan](https://github.com/Dandandan))
- Add single line description of ExecutionPlan \(\#2216\) [\#2217](https://github.com/apache/arrow-datafusion/pull/2217) ([tustvold](https://github.com/tustvold))
- Remove tokio::spawn from HashAggregateExec \(\#2201\) [\#2215](https://github.com/apache/arrow-datafusion/pull/2215) ([tustvold](https://github.com/tustvold))
- Remove tokio::spawn from WindowAggExec \(\#2201\) [\#2203](https://github.com/apache/arrow-datafusion/pull/2203) ([tustvold](https://github.com/tustvold))
- Make ParquetExec usable outside of a tokio runtime \(\#2201\) [\#2202](https://github.com/apache/arrow-datafusion/pull/2202) ([tustvold](https://github.com/tustvold))
- add sql level test for decimal data type [\#2200](https://github.com/apache/arrow-datafusion/pull/2200) ([liukun4515](https://github.com/liukun4515))
- `case when` supports `NULL`  constant [\#2197](https://github.com/apache/arrow-datafusion/pull/2197) ([WinkerDu](https://github.com/WinkerDu))
- feat: Support simple Arrays with Literals [\#2194](https://github.com/apache/arrow-datafusion/pull/2194) ([ovr](https://github.com/ovr))
- \[Ballista\] Enable ApproxPercentileWithWeight in Ballista and fill UT  [\#2192](https://github.com/apache/arrow-datafusion/pull/2192) ([Ted-Jiang](https://github.com/Ted-Jiang))
- refactor: simplify `prepare_select_exprs` [\#2190](https://github.com/apache/arrow-datafusion/pull/2190) ([jackwener](https://github.com/jackwener))
- Multiple row-layout support, part-1: Restructure code for clearness [\#2189](https://github.com/apache/arrow-datafusion/pull/2189) ([yjshen](https://github.com/yjshen))
- make nightly clippy happy [\#2186](https://github.com/apache/arrow-datafusion/pull/2186) ([xudong963](https://github.com/xudong963))
- \[Ballista\]Make PhysicalAggregateExprNode has repeated PhysicalExprNode [\#2184](https://github.com/apache/arrow-datafusion/pull/2184) ([Ted-Jiang](https://github.com/Ted-Jiang))
- MINOR: handle `NULL` in advance to avoid value copy in `string_concat` [\#2183](https://github.com/apache/arrow-datafusion/pull/2183) ([WinkerDu](https://github.com/WinkerDu))
- fix: Sort with a lot of repetition values [\#2182](https://github.com/apache/arrow-datafusion/pull/2182) ([yjshen](https://github.com/yjshen))
- cli: update lockfile [\#2178](https://github.com/apache/arrow-datafusion/pull/2178) ([happysalada](https://github.com/happysalada))
- Add LogicalPlan::SubqueryAlias [\#2172](https://github.com/apache/arrow-datafusion/pull/2172) ([andygrove](https://github.com/andygrove))
- minor: Avoid per cell evaluation in Coalesce, use zip in CaseWhen [\#2171](https://github.com/apache/arrow-datafusion/pull/2171) ([yjshen](https://github.com/yjshen))
- Handle merged schemas in parquet pruning [\#2170](https://github.com/apache/arrow-datafusion/pull/2170) ([thinkharderdev](https://github.com/thinkharderdev))
- Implement fast path of with\_new\_children\(\) in ExecutionPlan [\#2168](https://github.com/apache/arrow-datafusion/pull/2168) ([mingmwang](https://github.com/mingmwang))
- enable explain for ballista [\#2163](https://github.com/apache/arrow-datafusion/pull/2163) ([doki23](https://github.com/doki23))
- Add delimiter for create external table [\#2162](https://github.com/apache/arrow-datafusion/pull/2162) ([matthewmturner](https://github.com/matthewmturner))
- \[MINOR\] enable `EXTRACT week` and add test \(after sqlparser update to 0.16\) [\#2157](https://github.com/apache/arrow-datafusion/pull/2157) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Optimize the evaluation of `IN` for large lists using InSet [\#2156](https://github.com/apache/arrow-datafusion/pull/2156) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Update sqlparser requirement from 0.15 to 0.16 [\#2152](https://github.com/apache/arrow-datafusion/pull/2152) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix `not(null)` with constant `null` [\#2144](https://github.com/apache/arrow-datafusion/pull/2144) ([WinkerDu](https://github.com/WinkerDu))
- Add IF NOT EXISTS to `CREATE TABLE` and `CREATE EXTERNAL TABLE` [\#2143](https://github.com/apache/arrow-datafusion/pull/2143) ([matthewmturner](https://github.com/matthewmturner))
- implement 'StringConcat' operator to support sql like "select 'aa' || 'b' " [\#2142](https://github.com/apache/arrow-datafusion/pull/2142) ([WinkerDu](https://github.com/WinkerDu))
- \#2109 By default, use only 1000 rows to infer the schema [\#2139](https://github.com/apache/arrow-datafusion/pull/2139) ([jychen7](https://github.com/jychen7))
- \[CLI\] Add show tables in ballista for datafusion-cli [\#2137](https://github.com/apache/arrow-datafusion/pull/2137) ([gaojun2048](https://github.com/gaojun2048))
- fix:  incorrect memory usage track for sort [\#2135](https://github.com/apache/arrow-datafusion/pull/2135) ([yjshen](https://github.com/yjshen))
- Update quarterly roadmap for Q2 [\#2133](https://github.com/apache/arrow-datafusion/pull/2133) ([matthewmturner](https://github.com/matthewmturner))
- Reduce SortExec memory usage by void constructing single huge batch [\#2132](https://github.com/apache/arrow-datafusion/pull/2132) ([yjshen](https://github.com/yjshen))
- MINOR: fix concat\_ws corner bug [\#2128](https://github.com/apache/arrow-datafusion/pull/2128) ([WinkerDu](https://github.com/WinkerDu))
- Minor add clarifying comment in parquet [\#2127](https://github.com/apache/arrow-datafusion/pull/2127) ([alamb](https://github.com/alamb))
- Minor: make disk\_manager public [\#2126](https://github.com/apache/arrow-datafusion/pull/2126) ([yjshen](https://github.com/yjshen))
- JIT-compille DataFusion expression with column name [\#2124](https://github.com/apache/arrow-datafusion/pull/2124) ([Dandandan](https://github.com/Dandandan))
- minor: replace array\_equals in case evaluation with eq\_dyn from arrow-rs [\#2121](https://github.com/apache/arrow-datafusion/pull/2121) ([alamb](https://github.com/alamb))
- Serialize timezone in timestamp scalar values [\#2120](https://github.com/apache/arrow-datafusion/pull/2120) ([thinkharderdev](https://github.com/thinkharderdev))
- minor: fix some clippy warnings from nightly rust [\#2119](https://github.com/apache/arrow-datafusion/pull/2119) ([alamb](https://github.com/alamb))
- Fix case evaluation with NULLs [\#2118](https://github.com/apache/arrow-datafusion/pull/2118) ([alamb](https://github.com/alamb))
- issue\#1967 ignore channel close [\#2113](https://github.com/apache/arrow-datafusion/pull/2113) ([silence-coding](https://github.com/silence-coding))
- cli: add cargo.lock [\#2112](https://github.com/apache/arrow-datafusion/pull/2112) ([happysalada](https://github.com/happysalada))
- doc: update release schedule [\#2110](https://github.com/apache/arrow-datafusion/pull/2110) ([jychen7](https://github.com/jychen7))
- fix df union all bug [\#2108](https://github.com/apache/arrow-datafusion/pull/2108) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([WinkerDu](https://github.com/WinkerDu))
- Reduce repetition in Decimal binary kernels, upgrade to arrow 11.1 [\#2107](https://github.com/apache/arrow-datafusion/pull/2107) ([alamb](https://github.com/alamb))
- update zlib version to 1.2.12 [\#2106](https://github.com/apache/arrow-datafusion/pull/2106) ([waitingkuo](https://github.com/waitingkuo))
- Create jit-expression from datafusion expression [\#2103](https://github.com/apache/arrow-datafusion/pull/2103) ([Dandandan](https://github.com/Dandandan))
- Add CREATE DATABASE command to SQL [\#2094](https://github.com/apache/arrow-datafusion/pull/2094) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([matthewmturner](https://github.com/matthewmturner))
- Refactor SessionContext, BallistaContext to support multi-tenancy configurations - Part 3 [\#2091](https://github.com/apache/arrow-datafusion/pull/2091) ([mingmwang](https://github.com/mingmwang))
- minor: remove duplicate test [\#2089](https://github.com/apache/arrow-datafusion/pull/2089) ([jackwener](https://github.com/jackwener))
- minor: remove repeated test [\#2085](https://github.com/apache/arrow-datafusion/pull/2085) ([jackwener](https://github.com/jackwener))
- Fix lost filters and projections in ParquetExec, CSVExec etc [\#2077](https://github.com/apache/arrow-datafusion/pull/2077) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Remove dependency of common for the storage crate [\#2076](https://github.com/apache/arrow-datafusion/pull/2076) ([yahoNanJing](https://github.com/yahoNanJing))
- [MINOR] fix doc in `EXTRACT\(field FROM source\) [\#2074](https://github.com/apache/arrow-datafusion/pull/2074) ([Ted-Jiang](https://github.com/Ted-Jiang))
- \[Bug\]\[Datafusion\] fix TaskContext session\_config bug [\#2070](https://github.com/apache/arrow-datafusion/pull/2070) ([gaojun2048](https://github.com/gaojun2048))
- Short-circuit evaluation for `CaseWhen` [\#2068](https://github.com/apache/arrow-datafusion/pull/2068) ([yjshen](https://github.com/yjshen))
- split datafusion-object-store module [\#2065](https://github.com/apache/arrow-datafusion/pull/2065) ([yahoNanJing](https://github.com/yahoNanJing))
- Allow `CatalogProvider::register_catalog` to return an error [\#2052](https://github.com/apache/arrow-datafusion/pull/2052) ([alamb](https://github.com/alamb))
- Add test in register\_catalog and change to use named symbolic constants [\#2050](https://github.com/apache/arrow-datafusion/pull/2050) ([alamb](https://github.com/alamb))
- Update to arrow/parquet 11.0 [\#2048](https://github.com/apache/arrow-datafusion/pull/2048) ([alamb](https://github.com/alamb))
- minor: format comments \(`//` to `// `\) [\#2047](https://github.com/apache/arrow-datafusion/pull/2047) ([jackwener](https://github.com/jackwener))
- use cargo-tomlfmt to check Cargo.toml formatting in CI [\#2033](https://github.com/apache/arrow-datafusion/pull/2033) ([WinkerDu](https://github.com/WinkerDu))
- feat: \#2004 approx percentile with weight [\#2031](https://github.com/apache/arrow-datafusion/pull/2031) ([jychen7](https://github.com/jychen7))
- Refactor SessionContext, SessionState and SessionConfig to support multi-tenancy configurations - Part 2 [\#2029](https://github.com/apache/arrow-datafusion/pull/2029) ([mingmwang](https://github.com/mingmwang))
- Simplify prerequisites for running examples [\#2028](https://github.com/apache/arrow-datafusion/pull/2028) ([doki23](https://github.com/doki23))
- Replace usage of `println!` with logger macros [\#2020](https://github.com/apache/arrow-datafusion/pull/2020) ([silence-coding](https://github.com/silence-coding))
- Automatically test examples in user guide [\#2018](https://github.com/apache/arrow-datafusion/pull/2018) ([vchag](https://github.com/vchag))
- return VecDeque for DFParser::parse\_sql [\#2017](https://github.com/apache/arrow-datafusion/pull/2017) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([doki23](https://github.com/doki23))
- Eliminate the scalar value filter [\#2002](https://github.com/apache/arrow-datafusion/pull/2002) ([jackwener](https://github.com/jackwener))
- Fixing a typo in documentation [\#1997](https://github.com/apache/arrow-datafusion/pull/1997) ([psvri](https://github.com/psvri))
- Correct documentation of ExprVisitor [\#1996](https://github.com/apache/arrow-datafusion/pull/1996) ([alamb](https://github.com/alamb))
- Make it possible to only scan part of a parquet file in a partition [\#1990](https://github.com/apache/arrow-datafusion/pull/1990) ([yjshen](https://github.com/yjshen))
- Update Dockerfile to fix integration tests [\#1982](https://github.com/apache/arrow-datafusion/pull/1982) ([andygrove](https://github.com/andygrove))
- Remove some more unecessary cloning in sql\_expr\_to\_logical\_expr [\#1981](https://github.com/apache/arrow-datafusion/pull/1981) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Add ticket reference to clippy allow [\#1978](https://github.com/apache/arrow-datafusion/pull/1978) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Implement  EXTRACT expression with week, month, day, hour [\#1974](https://github.com/apache/arrow-datafusion/pull/1974) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Address typo in ExprVisitable trait documentation [\#1970](https://github.com/apache/arrow-datafusion/pull/1970) ([jdye64](https://github.com/jdye64))
- Update sqlparser requirement from 0.14 to 0.15 [\#1966](https://github.com/apache/arrow-datafusion/pull/1966) ([dependabot[bot]](https://github.com/apps/dependabot))
- PruningPredicate should take owned Expr [\#1960](https://github.com/apache/arrow-datafusion/pull/1960) ([thinkharderdev](https://github.com/thinkharderdev))
- Update to arrow 10.0.0, pyo3 0.16 [\#1957](https://github.com/apache/arrow-datafusion/pull/1957) ([alamb](https://github.com/alamb))
- update jit-related dependencies [\#1953](https://github.com/apache/arrow-datafusion/pull/1953) ([xudong963](https://github.com/xudong963))
- minor code refinement: `if_exists` name change, wildcard field for logical plan, etc. [\#1951](https://github.com/apache/arrow-datafusion/pull/1951) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Allow different types of query variables \(`@@var`\) rather than just string [\#1943](https://github.com/apache/arrow-datafusion/pull/1943) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([maxburke](https://github.com/maxburke))
- Pruning serialization [\#1941](https://github.com/apache/arrow-datafusion/pull/1941) ([thinkharderdev](https://github.com/thinkharderdev))
- Add write\_parquet to `DataFrame` [\#1940](https://github.com/apache/arrow-datafusion/pull/1940) ([matthewmturner](https://github.com/matthewmturner))
- Fix select from EmptyExec always return 0 row after optimizer passes [\#1938](https://github.com/apache/arrow-datafusion/pull/1938) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Add debug log when waiting for spilling on other consumers [\#1933](https://github.com/apache/arrow-datafusion/pull/1933) ([viirya](https://github.com/viirya))
- Add db benchmark script [\#1928](https://github.com/apache/arrow-datafusion/pull/1928) ([matthewmturner](https://github.com/matthewmturner))
- Add write\_csv to DataFrame [\#1922](https://github.com/apache/arrow-datafusion/pull/1922) ([matthewmturner](https://github.com/matthewmturner))
- \[MINOR\] Update copyright year in Docs [\#1918](https://github.com/apache/arrow-datafusion/pull/1918) ([alamb](https://github.com/alamb))
- add metadata to DFSchema, close \#1806. [\#1914](https://github.com/apache/arrow-datafusion/pull/1914) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([jiacai2050](https://github.com/jiacai2050))
- Clippy fix on nightly [\#1907](https://github.com/apache/arrow-datafusion/pull/1907) ([yjshen](https://github.com/yjshen))
- Updated Rust version to 1.59 in all the files [\#1903](https://github.com/apache/arrow-datafusion/pull/1903) ([NaincyKumariKnoldus](https://github.com/NaincyKumariKnoldus))
- support extract second and minute in expr. [\#1901](https://github.com/apache/arrow-datafusion/pull/1901) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Update crate descriptions [\#1899](https://github.com/apache/arrow-datafusion/pull/1899) ([alamb](https://github.com/alamb))
- Remove uneeded Mutex in Ballista Client [\#1898](https://github.com/apache/arrow-datafusion/pull/1898) ([alamb](https://github.com/alamb))
- \[split/17\] move the rest of physical expr to datafusion-physical-expr crate [\#1892](https://github.com/apache/arrow-datafusion/pull/1892) ([Jimexist](https://github.com/Jimexist))
- Avoid unnecessary branching in row read/write if schema is null-free [\#1891](https://github.com/apache/arrow-datafusion/pull/1891) ([yjshen](https://github.com/yjshen))
- Make parquet support optional for datafusion-common crate [\#1886](https://github.com/apache/arrow-datafusion/pull/1886) ([jonmmease](https://github.com/jonmmease))
- Fix clippy lints [\#1885](https://github.com/apache/arrow-datafusion/pull/1885) ([HaoYang670](https://github.com/HaoYang670))
- Add support for `~/.datafusionrc` and cli option for overriding it to datafusion-cli [\#1875](https://github.com/apache/arrow-datafusion/pull/1875) ([matthewmturner](https://github.com/matthewmturner))
- \[Minor\] Clean up DecimalArray API Usage [\#1869](https://github.com/apache/arrow-datafusion/pull/1869) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Changes after went through "Datafusion as a library section" [\#1868](https://github.com/apache/arrow-datafusion/pull/1868) ([nonontb](https://github.com/nonontb))
- Enhance MemorySchemaProvider to support `register_listing_table` [\#1863](https://github.com/apache/arrow-datafusion/pull/1863) ([matthewmturner](https://github.com/matthewmturner))
- Increase default partition column type from Dict\(UInt8\) to Dict\(UInt16\) [\#1860](https://github.com/apache/arrow-datafusion/pull/1860) ([Igosuki](https://github.com/Igosuki))
- Update to arrow 9.1.0 [\#1851](https://github.com/apache/arrow-datafusion/pull/1851) ([alamb](https://github.com/alamb))
- move some tests out of context and into sql [\#1846](https://github.com/apache/arrow-datafusion/pull/1846) ([alamb](https://github.com/alamb))
- \[split/14\] create `datafusion-physical-expr` module [\#1843](https://github.com/apache/arrow-datafusion/pull/1843) ([Jimexist](https://github.com/Jimexist))
- Return `Error` when parquet reader fails rather than no data with `println!` [\#1837](https://github.com/apache/arrow-datafusion/pull/1837) ([alamb](https://github.com/alamb))
- determine build side in hash join by `total_byte_size` instead of `num_rows` [\#1831](https://github.com/apache/arrow-datafusion/pull/1831) ([xudong963](https://github.com/xudong963))
- Make ballista support an optional feature to datafusion-cli [\#1816](https://github.com/apache/arrow-datafusion/pull/1816) ([alamb](https://github.com/alamb))
- Update documentation example for change in API [\#1812](https://github.com/apache/arrow-datafusion/pull/1812) ([alamb](https://github.com/alamb))
- rename references of expr in physical plan module after datafusion-expr split [\#1798](https://github.com/apache/arrow-datafusion/pull/1798) ([Jimexist](https://github.com/Jimexist))
- DataFusion + Conbench Integration [\#1791](https://github.com/apache/arrow-datafusion/pull/1791) ([dianaclarke](https://github.com/dianaclarke))
- The returned path value of get\_by\_uri should be self-described with entire path [\#1779](https://github.com/apache/arrow-datafusion/pull/1779) ([yahoNanJing](https://github.com/yahoNanJing))
- Use`eq_dyn`, `neq_dyn`, `lt_dyn`, `lt_eq_dyn`, `gt_dyn`, `gt_eq_dyn` kernels from arrow [\#1475](https://github.com/apache/arrow-datafusion/pull/1475) ([alamb](https://github.com/alamb))


## [7.1.0](https://github.com/apache/arrow-datafusion/tree/7.1.0) (2022-04-10)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/7.0.0...7.1.0)

**Fixed bugs:**

- By default, use only 1000 rows to infer the schema [\#2159](https://github.com/apache/arrow-datafusion/pull/2159)

## [7.0.0](https://github.com/apache/arrow-datafusion/tree/7.0.0) (2022-02-14)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/6.0.0...7.0.0)

**Breaking changes:**

- Consolidate various configurations options, remove unrelated `batch_size` [\#1565](https://github.com/apache/arrow-datafusion/issues/1565)
- Extract logical plans in  LogicalPlan as independent struct [\#1228](https://github.com/apache/arrow-datafusion/issues/1228)
- Update `ExecutionPlan` to know about sortedness and repartitioning optimizer pass respect the invariants [\#1776](https://github.com/apache/arrow-datafusion/pull/1776) ([alamb](https://github.com/alamb))
- Update to `arrow 8.0.0` [\#1673](https://github.com/apache/arrow-datafusion/pull/1673) ([alamb](https://github.com/alamb))
- Remove non idiomatic `DataFusionError::into_arrow_external_error` in favor of From conversion [\#1645](https://github.com/apache/arrow-datafusion/pull/1645) ([alamb](https://github.com/alamb))
- Remove `Accumulator::update` and `Accumulator::merge` [\#1582](https://github.com/apache/arrow-datafusion/pull/1582) ([Jimexist](https://github.com/Jimexist))
- implement `Hash` for various types and replace `PartialOrd` [\#1580](https://github.com/apache/arrow-datafusion/pull/1580) ([Jimexist](https://github.com/Jimexist))
- Replace `DatafusionError` with `GenericError` in `ObjectStore` interface [\#1541](https://github.com/apache/arrow-datafusion/pull/1541) ([matthewmturner](https://github.com/matthewmturner))
- Make `FLOAT` SQL type map to `Float32` rather than `Float64` [\#1423](https://github.com/apache/arrow-datafusion/pull/1423) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([liukun4515](https://github.com/liukun4515))
- Map `REAL` SQL type to `Float32` rather than `Float64` to be consistent with pg  [\#1390](https://github.com/apache/arrow-datafusion/pull/1390) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([hntd187](https://github.com/hntd187))

**Implemented enhancements:**

- Create new `datafusion_expr` crate [\#1753](https://github.com/apache/arrow-datafusion/issues/1753)
- Create new `datafusion_common` crate [\#1752](https://github.com/apache/arrow-datafusion/issues/1752)
- API to get Expr's type and nullability without a `DFSchema` [\#1725](https://github.com/apache/arrow-datafusion/issues/1725)
- Cleaner API to create `Expr::ScalarFunction` programatically [\#1718](https://github.com/apache/arrow-datafusion/issues/1718)
- Introduce a `Vec<u8>` based row-wise representation for DataFusion [\#1708](https://github.com/apache/arrow-datafusion/issues/1708)
- Simplify creating new `ListingTable`  [\#1705](https://github.com/apache/arrow-datafusion/issues/1705)
- Implement TableProvider for DataFrameImpl to allow registration of logical plans [\#1698](https://github.com/apache/arrow-datafusion/issues/1698)
- Public Expr simplification API [\#1694](https://github.com/apache/arrow-datafusion/issues/1694)
- Query Optimizer: Add OUTER --\> INNER join conversion [\#1670](https://github.com/apache/arrow-datafusion/issues/1670)
- Support reading from CSV, Avro and Json files that have mergeable/compatible,  but not identical schemas [\#1669](https://github.com/apache/arrow-datafusion/issues/1669)
- Remove `DataFusionError::into_arrow_external_error` in favor of `From` conversion [\#1644](https://github.com/apache/arrow-datafusion/issues/1644)
- Include join type in display implementation for logical plan [\#1620](https://github.com/apache/arrow-datafusion/issues/1620)
- Switch datafusion to using `eq_dyn_scalar`, etc kernels [\#1610](https://github.com/apache/arrow-datafusion/issues/1610)
- Proposal: Remove `Accumulator::update` and `Accumulator::merge` [\#1549](https://github.com/apache/arrow-datafusion/issues/1549)
- Replace DataFusionError/Result with impl Error for ObjectStore and Reader  [\#1540](https://github.com/apache/arrow-datafusion/issues/1540)
- Add `approx_quantile`  support [\#1538](https://github.com/apache/arrow-datafusion/issues/1538)
- support sorting decimal data type [\#1522](https://github.com/apache/arrow-datafusion/issues/1522)
- Keep all datafusion's packages up to date with Dependabot [\#1472](https://github.com/apache/arrow-datafusion/issues/1472)
- ExecutionContext support init ExecutionContextState with `new(state: Arc<Mutex<ExecutionContextState>>)` method [\#1439](https://github.com/apache/arrow-datafusion/issues/1439)
- support the decimal scalar value [\#1393](https://github.com/apache/arrow-datafusion/issues/1393)
- Documentation for using scalar functions with the the DataFrame API [\#1364](https://github.com/apache/arrow-datafusion/issues/1364)
- Support `boolean == boolean` and `boolean != boolean` operators  [\#1159](https://github.com/apache/arrow-datafusion/issues/1159)
-  Support DataType::Decimal\(15, 2\) in TPC-H benchmark [\#174](https://github.com/apache/arrow-datafusion/issues/174)
-   Make `MemoryStream` public [\#150](https://github.com/apache/arrow-datafusion/issues/150)
-   Add support for Parquet schema merging  [\#132](https://github.com/apache/arrow-datafusion/issues/132)
-   Add SQL support for IN expression [\#118](https://github.com/apache/arrow-datafusion/issues/118)
- Add logging to datafusion-cli [\#1789](https://github.com/apache/arrow-datafusion/pull/1789) ([alamb](https://github.com/alamb))
- Add `approx_median()` aggregate function [\#1729](https://github.com/apache/arrow-datafusion/pull/1729) ([realno](https://github.com/realno))
- Add join type for logical plan display [\#1674](https://github.com/apache/arrow-datafusion/pull/1674) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Fix null comparison for Parquet pruning predicate [\#1595](https://github.com/apache/arrow-datafusion/pull/1595) ([viirya](https://github.com/viirya))
- Add `corr` aggregate function [\#1561](https://github.com/apache/arrow-datafusion/pull/1561) ([realno](https://github.com/realno))
- Add `covar`, `covar_pop` and `covar_samp` aggregate functions [\#1551](https://github.com/apache/arrow-datafusion/pull/1551) ([realno](https://github.com/realno))
- Add `approx_quantile()` aggregation function [\#1539](https://github.com/apache/arrow-datafusion/pull/1539) ([domodwyer](https://github.com/domodwyer))
- Initial MemoryManager and DiskManager APIs  for query execution + External Sort implementation [\#1526](https://github.com/apache/arrow-datafusion/pull/1526) ([yjshen](https://github.com/yjshen))
- Add `stddev` and `variance` [\#1525](https://github.com/apache/arrow-datafusion/pull/1525) ([realno](https://github.com/realno))
- Add `rem` operation for Expr [\#1467](https://github.com/apache/arrow-datafusion/pull/1467) ([liukun4515](https://github.com/liukun4515))
- support decimal data type in create table [\#1431](https://github.com/apache/arrow-datafusion/pull/1431) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([liukun4515](https://github.com/liukun4515))
- Ordering by index in select expression [\#1419](https://github.com/apache/arrow-datafusion/pull/1419) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([hntd187](https://github.com/hntd187))
- Add support for `ORDER BY` on unprojected columns [\#1415](https://github.com/apache/arrow-datafusion/pull/1415) ([viirya](https://github.com/viirya))
- Support decimal for `min` and `max` aggregate [\#1407](https://github.com/apache/arrow-datafusion/pull/1407) ([liukun4515](https://github.com/liukun4515))
- Consolidate `ConstantFolding` and `SimplifyExpression` [\#1375](https://github.com/apache/arrow-datafusion/pull/1375) ([alamb](https://github.com/alamb))
- Datafusion cli quiet mode command to contain option bool [\#1345](https://github.com/apache/arrow-datafusion/pull/1345) ([Jimexist](https://github.com/Jimexist))
- Implement `array_agg` aggregate function [\#1300](https://github.com/apache/arrow-datafusion/pull/1300) ([viirya](https://github.com/viirya))
- Add a command to switch output format in cli [\#1284](https://github.com/apache/arrow-datafusion/pull/1284) ([capkurmagati](https://github.com/capkurmagati))
- Support `=`, `<`, `<=`, `>`, `>=`, `!=`, `is distinct from`, `is not distinct from` for `BooleanArray` [\#1163](https://github.com/apache/arrow-datafusion/pull/1163) ([alamb](https://github.com/alamb))

**Fixed bugs:**

- Unsupported data type in hasher: Timestamp\(Second, None\) [\#1768](https://github.com/apache/arrow-datafusion/issues/1768)
- SQL column identifiers should be converted to lowercase when unquoted [\#1746](https://github.com/apache/arrow-datafusion/issues/1746)
- Data type Dictionary\(Int32, Utf8\) not supported for binary operation 'eq' on dyn arrays [\#1605](https://github.com/apache/arrow-datafusion/issues/1605)
- datafusion doesn't process predicate pushdown correctly when there is outer join [\#1586](https://github.com/apache/arrow-datafusion/issues/1586)
- casting `Int64` to `Float64` unsuccessfully caused tpch8 to fail [\#1576](https://github.com/apache/arrow-datafusion/issues/1576)
- CTE/WITH .. UNION ALL confuses name resolution in WHERE [\#1509](https://github.com/apache/arrow-datafusion/issues/1509)
- ORDER BY min\(x\) results in error  `Plan("No field named 'foo.x'. Valid fields are 'MIN(foo.x)'.")` [\#1479](https://github.com/apache/arrow-datafusion/issues/1479)
- Sort discards field metadata on the output schema [\#1476](https://github.com/apache/arrow-datafusion/issues/1476)
- Datafusion should not strip out timezone information from existing types [\#1454](https://github.com/apache/arrow-datafusion/issues/1454)
- Error on some queries: "column types must match schema types, expected XXX but found YYY" [\#1447](https://github.com/apache/arrow-datafusion/issues/1447)
- Query failing to return any results when filter is an equality check on strings \(bad statistics in parquet\) [\#1433](https://github.com/apache/arrow-datafusion/issues/1433)
- Field names containing period such as `f.c1` cannot be named in SQL query [\#1432](https://github.com/apache/arrow-datafusion/issues/1432)
- `Select *` returns an unexpected result [\#1412](https://github.com/apache/arrow-datafusion/issues/1412)
- Turn off unused default features of chrono and ahash [\#1398](https://github.com/apache/arrow-datafusion/issues/1398)
- real data type is float32 in PG database, but in the datafusion it is as float64 [\#1380](https://github.com/apache/arrow-datafusion/issues/1380)
- TPC-H q10 performance regression \(expression for filter with added alias is not pushed down\)  [\#1367](https://github.com/apache/arrow-datafusion/issues/1367)
- ProjectionExec Loses Field Metadata [\#1361](https://github.com/apache/arrow-datafusion/issues/1361)
- Support Filter on unprojected columns [\#1351](https://github.com/apache/arrow-datafusion/issues/1351)
- NULLS ORDER is inconsistent with postgres [\#1343](https://github.com/apache/arrow-datafusion/issues/1343)
- Fix bug while merging `RecordBatch`, add `SortPreservingMerge` fuzz tester [\#1678](https://github.com/apache/arrow-datafusion/pull/1678) ([alamb](https://github.com/alamb))
- fix a cte block with same name for many times [\#1639](https://github.com/apache/arrow-datafusion/pull/1639) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- fix: casting Int64 to Float64 unsuccessfully caused tpch8 to fail [\#1601](https://github.com/apache/arrow-datafusion/pull/1601) ([xudong963](https://github.com/xudong963))
- Fix single\_distinct\_to\_groupby for arbitrary expressions [\#1519](https://github.com/apache/arrow-datafusion/pull/1519) ([james727](https://github.com/james727))
- Fix SortExec discards field metadata on the output schema [\#1477](https://github.com/apache/arrow-datafusion/pull/1477) ([alamb](https://github.com/alamb))
- fix calculate in many\_to\_many\_hash\_partition test. [\#1463](https://github.com/apache/arrow-datafusion/pull/1463) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Add Timezone to Scalar::Time\* types,   and better timezone awareness to Datafusion's time types [\#1455](https://github.com/apache/arrow-datafusion/pull/1455) ([maxburke](https://github.com/maxburke))
- Support identifiers with `.` in them [\#1449](https://github.com/apache/arrow-datafusion/pull/1449) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fixes for working with functions in dataframes, additional documentation [\#1430](https://github.com/apache/arrow-datafusion/pull/1430) ([tobyhede](https://github.com/tobyhede))
- \[Minor\] Fix `send_time` metric for hash-repartition [\#1421](https://github.com/apache/arrow-datafusion/pull/1421) ([Dandandan](https://github.com/Dandandan))
- fix: Select \* returns an unexpected result [\#1413](https://github.com/apache/arrow-datafusion/pull/1413) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Make cli handle multiple whitespaces [\#1388](https://github.com/apache/arrow-datafusion/pull/1388) ([capkurmagati](https://github.com/capkurmagati))
- Metadata is kept in projections for non-derived columns [\#1378](https://github.com/apache/arrow-datafusion/pull/1378) ([hntd187](https://github.com/hntd187))
- Fix Predicate Pushdown: split\_members should be able to split aliased predicate [\#1368](https://github.com/apache/arrow-datafusion/pull/1368) ([viirya](https://github.com/viirya))
- Change the arg names and make parameters more meaningful [\#1357](https://github.com/apache/arrow-datafusion/pull/1357) ([liukun4515](https://github.com/liukun4515))
- collect table stats by default for listing table [\#1347](https://github.com/apache/arrow-datafusion/pull/1347) ([houqp](https://github.com/houqp))
- fix: make nulls-order consistent with postgres [\#1344](https://github.com/apache/arrow-datafusion/pull/1344) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Avoid changing expression names during constant folding [\#1319](https://github.com/apache/arrow-datafusion/pull/1319) ([viirya](https://github.com/viirya))
- improve error message for invalid create table statement [\#1294](https://github.com/apache/arrow-datafusion/pull/1294) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([houqp](https://github.com/houqp))
- Forbid creating the table with the same name [\#1288](https://github.com/apache/arrow-datafusion/pull/1288) ([liukun4515](https://github.com/liukun4515))

**Documentation updates:**

- Clarify docs about `Accumulator::update` and `Accumulator::update_batch` [\#1542](https://github.com/apache/arrow-datafusion/pull/1542) ([alamb](https://github.com/alamb))
- Fix duplicated `cargo run --example parquet_sql` [\#1482](https://github.com/apache/arrow-datafusion/pull/1482) ([sergey-melnychuk](https://github.com/sergey-melnychuk))
- add documentation to Datafusion cli's new commands [\#1348](https://github.com/apache/arrow-datafusion/pull/1348) ([liukun4515](https://github.com/liukun4515))
- fix some clippy warnings from nightly channel [\#1277](https://github.com/apache/arrow-datafusion/pull/1277) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Jimexist](https://github.com/Jimexist))

**Performance improvements:**

- Parquet pruning predicate for `IS NULL` [\#1591](https://github.com/apache/arrow-datafusion/issues/1591)
- Fix predicate pushdown for outer joins [\#1618](https://github.com/apache/arrow-datafusion/pull/1618) ([james727](https://github.com/james727))
- fix: sql planner creates cross join instead of inner join from select predicates [\#1566](https://github.com/apache/arrow-datafusion/pull/1566) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Split fetch\_metadata into fetch\_statistics and fetch\_schema [\#1365](https://github.com/apache/arrow-datafusion/pull/1365) ([Dandandan](https://github.com/Dandandan))
- Optimize the performance queries with a single distinct aggregate [\#1315](https://github.com/apache/arrow-datafusion/pull/1315) ([ic4y](https://github.com/ic4y))
- Left join could use bitmap for left join instead of Vec\<bool\> [\#1291](https://github.com/apache/arrow-datafusion/pull/1291) ([boazberman](https://github.com/boazberman))

**Closed issues:**

- Add `release compile` to CI [\#1728](https://github.com/apache/arrow-datafusion/issues/1728)
- DiskManager and TempFiles getting created several times per query [\#1690](https://github.com/apache/arrow-datafusion/issues/1690)
- Add a test for the `pyarrow` feature in CI  [\#1635](https://github.com/apache/arrow-datafusion/issues/1635)
- SQL tests for when sorting exceeded available memory and had to spill to disk [\#1573](https://github.com/apache/arrow-datafusion/issues/1573)
- Consolidate the N-way merging code and `SortPreservingMergeStream` \(which has quite good tests of what is often quite tricky code, and it will be performance critical\) [\#1572](https://github.com/apache/arrow-datafusion/issues/1572)
- Consolidate the `SortExec` code \(so there is only a single sort operator that does in memory sorting if it has enough memory budget but then spills to disk if needed\). [\#1571](https://github.com/apache/arrow-datafusion/issues/1571)
- Track memory usage in Non Limited Operators [\#1569](https://github.com/apache/arrow-datafusion/issues/1569)
- \[Question\] Why does ballista store tables in the client instead of in the SchedulerServer [\#1473](https://github.com/apache/arrow-datafusion/issues/1473)
- Consolidate Projection for Schema and RecordBatch [\#1425](https://github.com/apache/arrow-datafusion/issues/1425)
- Support Sort on unprojected columns [\#1372](https://github.com/apache/arrow-datafusion/issues/1372)
- Unused code in hash\_aggregate [\#1362](https://github.com/apache/arrow-datafusion/issues/1362)
- Why use the expr types before coercion to get the result type? [\#1358](https://github.com/apache/arrow-datafusion/issues/1358)
- A problem about the projection\_push\_down optimizer gathers valid columns  [\#1312](https://github.com/apache/arrow-datafusion/issues/1312)
- apply constant folding to `LogicalPlan::Values` [\#1170](https://github.com/apache/arrow-datafusion/issues/1170)
- reduce usage of `IntoIterator<Item = Expr>` in logical plan builder window fn [\#372](https://github.com/apache/arrow-datafusion/issues/372)
- Why does DataFusion throw a Tokio 0.2 runtime error? [\#176](https://github.com/apache/arrow-datafusion/issues/176)
-  TPC-H Query 14 [\#165](https://github.com/apache/arrow-datafusion/issues/165)
- Length kernel returns bytes not character length [\#156](https://github.com/apache/arrow-datafusion/issues/156)
-   Split the logical operators out into separate source files [\#115](https://github.com/apache/arrow-datafusion/issues/115)

**Merged pull requests:**

- Fixup some doc warnings [\#1811](https://github.com/apache/arrow-datafusion/pull/1811) ([alamb](https://github.com/alamb))
- Ensure most of links in docs are correct [\#1808](https://github.com/apache/arrow-datafusion/pull/1808) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([HaoYang670](https://github.com/HaoYang670))
- Update CHANGELOG.md, update release scripts [\#1807](https://github.com/apache/arrow-datafusion/pull/1807) ([alamb](https://github.com/alamb))
- Update versions for split crates [\#1803](https://github.com/apache/arrow-datafusion/pull/1803) ([matthewmturner](https://github.com/matthewmturner))
- Improve the error message and UX of tpch benchmark program [\#1800](https://github.com/apache/arrow-datafusion/pull/1800) ([alamb](https://github.com/alamb))
- rename references of expr in logical plan module after datafusion-expr split [\#1797](https://github.com/apache/arrow-datafusion/pull/1797) ([Jimexist](https://github.com/Jimexist))
- Update to sqlparser 0.14 [\#1796](https://github.com/apache/arrow-datafusion/pull/1796) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- \[split/13\] move rest of expr to expr\_fn in datafusion-expr module [\#1794](https://github.com/apache/arrow-datafusion/pull/1794) ([Jimexist](https://github.com/Jimexist))
- Update datafusion versions [\#1793](https://github.com/apache/arrow-datafusion/pull/1793) ([matthewmturner](https://github.com/matthewmturner))
- Less verbose plans in debug logging [\#1787](https://github.com/apache/arrow-datafusion/pull/1787) ([alamb](https://github.com/alamb))
- \[split/11\] split expr type and null info to be expr-schemable [\#1784](https://github.com/apache/arrow-datafusion/pull/1784) ([Jimexist](https://github.com/Jimexist))
- Introduce `Row` format backed by raw bytes [\#1782](https://github.com/apache/arrow-datafusion/pull/1782) ([yjshen](https://github.com/yjshen))
- rewrite predicates before pushing to union inputs [\#1781](https://github.com/apache/arrow-datafusion/pull/1781) ([korowa](https://github.com/korowa))
- Update datafusion to use arrow 9.0.0 [\#1775](https://github.com/apache/arrow-datafusion/pull/1775) ([alamb](https://github.com/alamb))
- \[split/10\] split up expr for rewriting, visiting, and simplification traits [\#1774](https://github.com/apache/arrow-datafusion/pull/1774) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Jimexist](https://github.com/Jimexist))
- \#1768 Support TimeUnit::Second in hasher [\#1769](https://github.com/apache/arrow-datafusion/pull/1769) ([jychen7](https://github.com/jychen7))
- TPC-H benchmark can optionally write JSON output file with benchmark summary [\#1766](https://github.com/apache/arrow-datafusion/pull/1766) ([andygrove](https://github.com/andygrove))
- \[split/8\] move `Accumulator` and `ColumnarValue` to datafusion-expr [\#1765](https://github.com/apache/arrow-datafusion/pull/1765) ([Jimexist](https://github.com/Jimexist))
- \[split/7\] move built-in scalar function to datafusion-expr [\#1764](https://github.com/apache/arrow-datafusion/pull/1764) ([Jimexist](https://github.com/Jimexist))
- \[split/6\] move signature, type signature, volatility to datafusion-expr [\#1763](https://github.com/apache/arrow-datafusion/pull/1763) ([Jimexist](https://github.com/Jimexist))
- \[split/9+12\] move udf, udaf, `Expr` to datafusion-expr module [\#1762](https://github.com/apache/arrow-datafusion/pull/1762) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Jimexist](https://github.com/Jimexist))
- \[split/5\] move window frame and operator to datafusion-expr module [\#1761](https://github.com/apache/arrow-datafusion/pull/1761) ([Jimexist](https://github.com/Jimexist))
- \[split/4\] move scalar value to datafusion-common [\#1760](https://github.com/apache/arrow-datafusion/pull/1760) ([Jimexist](https://github.com/Jimexist))
- \[split/3\] split datafusion expr module and move aggregate and window function expr [\#1759](https://github.com/apache/arrow-datafusion/pull/1759) ([Jimexist](https://github.com/Jimexist))
- \[split/2\] move column and dfschema to datafusion-common module [\#1758](https://github.com/apache/arrow-datafusion/pull/1758) ([Jimexist](https://github.com/Jimexist))
- Use ordered-float 2.10 [\#1756](https://github.com/apache/arrow-datafusion/pull/1756) ([andygrove](https://github.com/andygrove))
- \[split/1\] split datafusion-common module [\#1751](https://github.com/apache/arrow-datafusion/pull/1751) ([Jimexist](https://github.com/Jimexist))
- use clap 3 style args parsing for datafusion cli [\#1749](https://github.com/apache/arrow-datafusion/pull/1749) ([Jimexist](https://github.com/Jimexist))
- fix: Case insensitive unquoted identifiers in SQL [\#1747](https://github.com/apache/arrow-datafusion/pull/1747) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([mkmik](https://github.com/mkmik))
- Move more tests out of context.rs [\#1743](https://github.com/apache/arrow-datafusion/pull/1743) ([alamb](https://github.com/alamb))
- Move optimize test out of context.rs [\#1742](https://github.com/apache/arrow-datafusion/pull/1742) ([alamb](https://github.com/alamb))
- Fix typos in crate documentation [\#1739](https://github.com/apache/arrow-datafusion/pull/1739) ([r4ntix](https://github.com/r4ntix))
- add `cargo check --release` to ci [\#1737](https://github.com/apache/arrow-datafusion/pull/1737) ([xudong963](https://github.com/xudong963))
- Update parking\_lot requirement from 0.11 to 0.12 [\#1735](https://github.com/apache/arrow-datafusion/pull/1735) ([dependabot[bot]](https://github.com/apps/dependabot))
- Create built-in scalar functions programmatically [\#1734](https://github.com/apache/arrow-datafusion/pull/1734) ([HaoYang670](https://github.com/HaoYang670))
- Prevent repartitioning of certain operator's direct children \(\#1731\) [\#1732](https://github.com/apache/arrow-datafusion/pull/1732) ([tustvold](https://github.com/tustvold))
- API to get Expr's type and nullability without a `DFSchema` [\#1726](https://github.com/apache/arrow-datafusion/pull/1726) ([alamb](https://github.com/alamb))
- minor: fix `cargo run --release` error [\#1723](https://github.com/apache/arrow-datafusion/pull/1723) ([xudong963](https://github.com/xudong963))
- substitute `parking_lot::Mutex` for `std::sync::Mutex` [\#1720](https://github.com/apache/arrow-datafusion/pull/1720) ([xudong963](https://github.com/xudong963))
- Convert boolean case expressions to boolean logic [\#1719](https://github.com/apache/arrow-datafusion/pull/1719) ([tustvold](https://github.com/tustvold))
- Add Expression Simplification API [\#1717](https://github.com/apache/arrow-datafusion/pull/1717) ([alamb](https://github.com/alamb))
- Create ListingTableConfig which includes file format and schema inference [\#1715](https://github.com/apache/arrow-datafusion/pull/1715) ([matthewmturner](https://github.com/matthewmturner))
- make `select_to_plan` clearer [\#1714](https://github.com/apache/arrow-datafusion/pull/1714) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Add upper bound for public function `signature` [\#1713](https://github.com/apache/arrow-datafusion/pull/1713) ([HaoYang670](https://github.com/HaoYang670))
- Add tests and CI for optional pyarrow module [\#1711](https://github.com/apache/arrow-datafusion/pull/1711) ([wjones127](https://github.com/wjones127))
- Create SchemaAdapter trait to map table schema to file schemas [\#1709](https://github.com/apache/arrow-datafusion/pull/1709) ([thinkharderdev](https://github.com/thinkharderdev))
- refine test in repartition.rs & coalesce\_batches.rs [\#1707](https://github.com/apache/arrow-datafusion/pull/1707) ([xudong963](https://github.com/xudong963))
- Fuzz test for spillable sort [\#1706](https://github.com/apache/arrow-datafusion/pull/1706) ([yjshen](https://github.com/yjshen))
- Support `create_physical_expr` and `ExecutionContextState` or `DefaultPhysicalPlanner` for faster speed [\#1700](https://github.com/apache/arrow-datafusion/pull/1700) ([alamb](https://github.com/alamb))
- Implement TableProvider for DataFrameImpl [\#1699](https://github.com/apache/arrow-datafusion/pull/1699) ([cpcloud](https://github.com/cpcloud))
- Move timestamp related tests out of context.rs and into sql integration test [\#1696](https://github.com/apache/arrow-datafusion/pull/1696) ([alamb](https://github.com/alamb))
- Lazy TempDir creation in DiskManager [\#1695](https://github.com/apache/arrow-datafusion/pull/1695) ([alamb](https://github.com/alamb))
- Add `MemTrackingMetrics` to ease memory tracking for non-limited memory consumers [\#1691](https://github.com/apache/arrow-datafusion/pull/1691) ([yjshen](https://github.com/yjshen))
- \(minor\) Reduce memory manager and disk manager logs from `info!` to `debug!` [\#1689](https://github.com/apache/arrow-datafusion/pull/1689) ([alamb](https://github.com/alamb))
- Make `SortPreservingMergeStream` stable on input stream order [\#1687](https://github.com/apache/arrow-datafusion/pull/1687) ([alamb](https://github.com/alamb))
- Incorporate dyn scalar kernels [\#1685](https://github.com/apache/arrow-datafusion/pull/1685) ([matthewmturner](https://github.com/matthewmturner))
- Move `information_schema` tests out of execution/context.rs to `sql_integration` tests [\#1684](https://github.com/apache/arrow-datafusion/pull/1684) ([alamb](https://github.com/alamb))
- Add a new metric type: `Gauge` + `CurrentMemoryUsage` to metrics [\#1682](https://github.com/apache/arrow-datafusion/pull/1682) ([yjshen](https://github.com/yjshen))
- refactor array\_agg to not to have `update` and `merge` [\#1681](https://github.com/apache/arrow-datafusion/pull/1681) ([Jimexist](https://github.com/Jimexist))
- Use NamedTempFile rather than `String` in DiskManager [\#1680](https://github.com/apache/arrow-datafusion/pull/1680) ([alamb](https://github.com/alamb))
- upgrade clap to version 3 [\#1672](https://github.com/apache/arrow-datafusion/pull/1672) ([Jimexist](https://github.com/Jimexist))
- Improve configuration and resource use of `MemoryManager` and `DiskManager` [\#1668](https://github.com/apache/arrow-datafusion/pull/1668) ([alamb](https://github.com/alamb))
- feat: Support quarter granularity in date\_trunc function [\#1667](https://github.com/apache/arrow-datafusion/pull/1667) ([ovr](https://github.com/ovr))
- Fix can not load parquet table form spark in datafusion-cli. [\#1665](https://github.com/apache/arrow-datafusion/pull/1665) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Make `MemoryManager` and `MemoryStream` public [\#1664](https://github.com/apache/arrow-datafusion/pull/1664) ([yjshen](https://github.com/yjshen))
- \[Cleanup\] Move `AggregatedMetricsSet` to `metrics` for further reuse [\#1663](https://github.com/apache/arrow-datafusion/pull/1663) ([yjshen](https://github.com/yjshen))
- fix: substr - correct behaivour with negative start pos [\#1660](https://github.com/apache/arrow-datafusion/pull/1660) ([ovr](https://github.com/ovr))
- suppport bitwise and as an example [\#1653](https://github.com/apache/arrow-datafusion/pull/1653) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([liukun4515](https://github.com/liukun4515))
- refine match pattern related code [\#1650](https://github.com/apache/arrow-datafusion/pull/1650) ([xudong963](https://github.com/xudong963))
- update md-5, sha2, blake2 [\#1647](https://github.com/apache/arrow-datafusion/pull/1647) ([xudong963](https://github.com/xudong963))
- Add `DataFusionError` -\> `ArrowError` conversion [\#1643](https://github.com/apache/arrow-datafusion/pull/1643) ([alamb](https://github.com/alamb))
- Add `spill_count` and `spilled_bytes` to `BaselineMetrics`, test sort with spill [\#1641](https://github.com/apache/arrow-datafusion/pull/1641) ([yjshen](https://github.com/yjshen))
- support hash decimal array and group by [\#1640](https://github.com/apache/arrow-datafusion/pull/1640) ([liukun4515](https://github.com/liukun4515))
- Consolidate Schema and RecordBatch projection [\#1638](https://github.com/apache/arrow-datafusion/pull/1638) ([alamb](https://github.com/alamb))
- Update hashbrown requirement from 0.11 to 0.12 [\#1631](https://github.com/apache/arrow-datafusion/pull/1631) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update pyo3 requirement from 0.14 to 0.15 [\#1627](https://github.com/apache/arrow-datafusion/pull/1627) ([dependabot[bot]](https://github.com/apps/dependabot))
- Optimize `SortPreservingMergeStream` to avoid `SortKeyCursor` sharing [\#1624](https://github.com/apache/arrow-datafusion/pull/1624) ([yjshen](https://github.com/yjshen))
- Handle merging of evolved schemas in ParquetExec [\#1622](https://github.com/apache/arrow-datafusion/pull/1622) ([thinkharderdev](https://github.com/thinkharderdev))
- feat: Support Substring\(str \[from int\] \[for int\]\) [\#1621](https://github.com/apache/arrow-datafusion/pull/1621) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([ovr](https://github.com/ovr))
- feat: Support complex interval via IntervalMonthDayNano [\#1615](https://github.com/apache/arrow-datafusion/pull/1615) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([ovr](https://github.com/ovr))
- consolidate binary\_expr coercion rule code into `binary_rule.rs` module [\#1607](https://github.com/apache/arrow-datafusion/pull/1607) ([alamb](https://github.com/alamb))
- Fix comparison of dictionary arrays [\#1606](https://github.com/apache/arrow-datafusion/pull/1606) ([alamb](https://github.com/alamb))
- add test for decimal to decimal [\#1603](https://github.com/apache/arrow-datafusion/pull/1603) ([liukun4515](https://github.com/liukun4515))
- update nightly version [\#1597](https://github.com/apache/arrow-datafusion/pull/1597) ([Jimexist](https://github.com/Jimexist))
- Consolidate sort and external\_sort [\#1596](https://github.com/apache/arrow-datafusion/pull/1596) ([yjshen](https://github.com/yjshen))
- support from\_slice for binary, string, and boolean array types [\#1589](https://github.com/apache/arrow-datafusion/pull/1589) ([Jimexist](https://github.com/Jimexist))
- add from\_slice trait to ease arrow2 migration [\#1588](https://github.com/apache/arrow-datafusion/pull/1588) ([Jimexist](https://github.com/Jimexist))
- Implement ARRAY\_AGG\(DISTINCT ...\) [\#1579](https://github.com/apache/arrow-datafusion/pull/1579) ([james727](https://github.com/james727))
- Rename sql integration tests from `mod` to `sql_integration` [\#1575](https://github.com/apache/arrow-datafusion/pull/1575) ([alamb](https://github.com/alamb))
- minor: improve the benchmark readme [\#1567](https://github.com/apache/arrow-datafusion/pull/1567) ([xudong963](https://github.com/xudong963))
- Consolidate `batch_size` configuration in `ExecutionConfig`, `RuntimeConfig` and `PhysicalPlanConfig` [\#1562](https://github.com/apache/arrow-datafusion/pull/1562) ([yjshen](https://github.com/yjshen))
- Update to rust 1.58 [\#1557](https://github.com/apache/arrow-datafusion/pull/1557) ([xudong963](https://github.com/xudong963))
- support mathematics operation for decimal data type [\#1554](https://github.com/apache/arrow-datafusion/pull/1554) ([liukun4515](https://github.com/liukun4515))
- Address clippy warnings [\#1553](https://github.com/apache/arrow-datafusion/pull/1553) ([sergey-melnychuk](https://github.com/sergey-melnychuk))
- enhance arithmetic operation for array with scalar [\#1552](https://github.com/apache/arrow-datafusion/pull/1552) ([liukun4515](https://github.com/liukun4515))
- Remove unused `update` and `merge` implementations from Aggregates and supporting `ScalarValue` arithmetic [\#1550](https://github.com/apache/arrow-datafusion/pull/1550) ([alamb](https://github.com/alamb))
- Add batch operations to stddev [\#1547](https://github.com/apache/arrow-datafusion/pull/1547) ([realno](https://github.com/realno))
- Mark ARRAY\_AGG\(DISTINCT ...\) not implemented [\#1534](https://github.com/apache/arrow-datafusion/pull/1534) ([james727](https://github.com/james727))
- Update to arrow-7.0.0 [\#1523](https://github.com/apache/arrow-datafusion/pull/1523) ([alamb](https://github.com/alamb))
- Fix ORDER BY on aggregate [\#1506](https://github.com/apache/arrow-datafusion/pull/1506) ([viirya](https://github.com/viirya))
- Add example on how to query multiple parquet files [\#1497](https://github.com/apache/arrow-datafusion/pull/1497) ([nitisht](https://github.com/nitisht))
- Refactor testing modules [\#1491](https://github.com/apache/arrow-datafusion/pull/1491) ([hntd187](https://github.com/hntd187))
- add rfcs for datafusion [\#1490](https://github.com/apache/arrow-datafusion/pull/1490) ([xudong963](https://github.com/xudong963))
- support comparison for decimal data type and refactor the binary coercion rule [\#1483](https://github.com/apache/arrow-datafusion/pull/1483) ([liukun4515](https://github.com/liukun4515))
- Minor: Rename `predicate_builder` --\> `pruning_predicate` for consistency [\#1481](https://github.com/apache/arrow-datafusion/pull/1481) ([alamb](https://github.com/alamb))
- Tests for support try\_cast/cast decimal to numeric [\#1465](https://github.com/apache/arrow-datafusion/pull/1465) ([liukun4515](https://github.com/liukun4515))
- Avoid send empty batches for Hash partitioning. [\#1459](https://github.com/apache/arrow-datafusion/pull/1459) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Planner code cleanup [\#1450](https://github.com/apache/arrow-datafusion/pull/1450) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fix bug in projection: "column types must match schema types, expected XXX but found YYY" [\#1448](https://github.com/apache/arrow-datafusion/pull/1448) ([alamb](https://github.com/alamb))
- Update arrow-rs to 6.4.0 and replace boolean comparison in datafusion with arrow compute kernel [\#1446](https://github.com/apache/arrow-datafusion/pull/1446) ([xudong963](https://github.com/xudong963))
- support cast/try\_cast for decimal: signed numeric to decimal [\#1442](https://github.com/apache/arrow-datafusion/pull/1442) ([liukun4515](https://github.com/liukun4515))
- Consolidate decimal error checking and improve error messages [\#1438](https://github.com/apache/arrow-datafusion/pull/1438) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- use 0.13 sql parser [\#1435](https://github.com/apache/arrow-datafusion/pull/1435) ([Jimexist](https://github.com/Jimexist))
- Minor Code cleanups [\#1428](https://github.com/apache/arrow-datafusion/pull/1428) ([alamb](https://github.com/alamb))
- Clarify communication on bi-weekly sync [\#1427](https://github.com/apache/arrow-datafusion/pull/1427) ([alamb](https://github.com/alamb))
- support sum/avg agg for decimal, change sum\(float32\) --\> float64 [\#1408](https://github.com/apache/arrow-datafusion/pull/1408) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([liukun4515](https://github.com/liukun4515))
- Fix bugs with nullability during rewrites: Combine `simplify` and `Simplifier` [\#1401](https://github.com/apache/arrow-datafusion/pull/1401) ([alamb](https://github.com/alamb))
- Minimize features [\#1399](https://github.com/apache/arrow-datafusion/pull/1399) ([carols10cents](https://github.com/carols10cents))
- Update rust vesion to 1.57 [\#1395](https://github.com/apache/arrow-datafusion/pull/1395) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- support decimal scalar value  [\#1394](https://github.com/apache/arrow-datafusion/pull/1394) ([liukun4515](https://github.com/liukun4515))
- Add coercion rules for AggregateFunctions [\#1387](https://github.com/apache/arrow-datafusion/pull/1387) ([liukun4515](https://github.com/liukun4515))
- upgrade the arrow-rs version [\#1385](https://github.com/apache/arrow-datafusion/pull/1385) ([liukun4515](https://github.com/liukun4515))
- add array agg name [\#1382](https://github.com/apache/arrow-datafusion/pull/1382) ([liukun4515](https://github.com/liukun4515))
- Make tests for `simplify` and `Simplifer` consistent [\#1376](https://github.com/apache/arrow-datafusion/pull/1376) ([alamb](https://github.com/alamb))
- Refactor: Consolidate expression simplification code in `simplify_expression.rs` [\#1374](https://github.com/apache/arrow-datafusion/pull/1374) ([alamb](https://github.com/alamb))
- remove unused code in hash\_aggregate [\#1370](https://github.com/apache/arrow-datafusion/pull/1370) ([ic4y](https://github.com/ic4y))
- Use `BufReader` for LocalFileReader to revert performance regression in parquet reading [\#1366](https://github.com/apache/arrow-datafusion/pull/1366) ([Dandandan](https://github.com/Dandandan))
- Add unit test for constant folding on values [\#1355](https://github.com/apache/arrow-datafusion/pull/1355) ([viirya](https://github.com/viirya))
- Extract logical plan: rename the plan name \(follow up\) [\#1354](https://github.com/apache/arrow-datafusion/pull/1354) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([liukun4515](https://github.com/liukun4515))
- Moved aggr\_test\_schema to test\_utils [\#1338](https://github.com/apache/arrow-datafusion/pull/1338) ([rdettai](https://github.com/rdettai))
- upgrade arrow-rs to 6.2.0 [\#1334](https://github.com/apache/arrow-datafusion/pull/1334) ([liukun4515](https://github.com/liukun4515))
- Update release instructions [\#1331](https://github.com/apache/arrow-datafusion/pull/1331) ([alamb](https://github.com/alamb))
- \#1268: allow datafusion-cli to toggle quiet flag within CLI [\#1330](https://github.com/apache/arrow-datafusion/pull/1330) ([jgoday](https://github.com/jgoday))
- Extract Aggregate, Sort, and Join to struct from AggregatePlan [\#1326](https://github.com/apache/arrow-datafusion/pull/1326) ([matthewmturner](https://github.com/matthewmturner))
- Extract `EmptyRelation`, `Limit`, `Values` from `LogicalPlan` [\#1325](https://github.com/apache/arrow-datafusion/pull/1325) ([liukun4515](https://github.com/liukun4515))
- Extract CrossJoin, Repartition, Union in LogicalPlan [\#1322](https://github.com/apache/arrow-datafusion/pull/1322) ([liukun4515](https://github.com/liukun4515))
- Fifth batch of updating sql tests to use assert\_batches\_eq [\#1318](https://github.com/apache/arrow-datafusion/pull/1318) ([matthewmturner](https://github.com/matthewmturner))
- Extract Explain, Analyze, Extension in LogicalPlan as independent struct [\#1317](https://github.com/apache/arrow-datafusion/pull/1317) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Extract CreateMemoryTable, DropTable, CreateExternalTable in LogicalPlan as independent struct [\#1311](https://github.com/apache/arrow-datafusion/pull/1311) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([liukun4515](https://github.com/liukun4515))
- Extract Projection, Filter, Window in LogicalPlan as independent struct [\#1309](https://github.com/apache/arrow-datafusion/pull/1309) ([ic4y](https://github.com/ic4y))
- Add PSQL comparison tests for except, intersect [\#1292](https://github.com/apache/arrow-datafusion/pull/1292) ([mrob95](https://github.com/mrob95))
- Extract logical plans in LogicalPlan as independent struct: TableScan [\#1290](https://github.com/apache/arrow-datafusion/pull/1290) ([xudong963](https://github.com/xudong963))
- Add statement helper command to cli [\#1285](https://github.com/apache/arrow-datafusion/pull/1285) ([matthewmturner](https://github.com/matthewmturner))
- Python bindings for window functions [\#819](https://github.com/apache/arrow-datafusion/pull/819) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([jgoday](https://github.com/jgoday))

## [6.0.0](https://github.com/apache/arrow-datafusion/tree/6.0.0) (2021-11-13)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/5.0.0...6.0.0)

**Breaking changes:**

- Removed deprecated with\_concurrency [\#1200](https://github.com/apache/arrow-datafusion/pull/1200) ([rdettai](https://github.com/rdettai))
- File partitioning for ListingTable [\#1141](https://github.com/apache/arrow-datafusion/pull/1141) ([rdettai](https://github.com/rdettai))
- Add function volatility to Signature [\#1071](https://github.com/apache/arrow-datafusion/pull/1071) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([pjmore](https://github.com/pjmore))
- fix: allow duplicate field names in table join, fix output with duplicated names [\#1023](https://github.com/apache/arrow-datafusion/pull/1023) ([houqp](https://github.com/houqp))
- Make TableProvider.scan\(\) and PhysicalPlanner::create\_physical\_plan\(\) async [\#1013](https://github.com/apache/arrow-datafusion/pull/1013) ([rdettai](https://github.com/rdettai))
- Reorganize table providers by table format [\#1010](https://github.com/apache/arrow-datafusion/pull/1010) ([rdettai](https://github.com/rdettai))
- Make Metrics::labels\(\) public [\#999](https://github.com/apache/arrow-datafusion/pull/999) ([alamb](https://github.com/alamb))
- Rename NthValue::{first\_value,last\_value,nth\_value} to satisfy clippy in Rust 1.55 [\#986](https://github.com/apache/arrow-datafusion/pull/986) ([alamb](https://github.com/alamb))
- Move CBOs and Statistics to physical plan [\#965](https://github.com/apache/arrow-datafusion/pull/965) ([rdettai](https://github.com/rdettai))
- Update to sqlparser v 0.10.0 [\#934](https://github.com/apache/arrow-datafusion/pull/934) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- FilePartition and PartitionedFile for scanning flexibility [\#932](https://github.com/apache/arrow-datafusion/pull/932) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([yjshen](https://github.com/yjshen))
- Improve SQLMetric APIs, port existing metrics [\#908](https://github.com/apache/arrow-datafusion/pull/908) ([alamb](https://github.com/alamb))
- Add support for EXPLAIN ANALYZE [\#858](https://github.com/apache/arrow-datafusion/pull/858) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Rename concurrency to target\_partitions [\#706](https://github.com/apache/arrow-datafusion/pull/706) ([andygrove](https://github.com/andygrove))

**Implemented enhancements:**

- Add booleans support to the `CASE` statement [\#1156](https://github.com/apache/arrow-datafusion/issues/1156)
- Implement General Purpose Constant Folding with the Expression Evaluator  [\#1070](https://github.com/apache/arrow-datafusion/issues/1070)
- Mark volatility categories of functions [\#1069](https://github.com/apache/arrow-datafusion/issues/1069)
- Add "show" support to DataFrame API [\#937](https://github.com/apache/arrow-datafusion/issues/937)
- Add support for TRIM BOTH/LEADING/TRAILING [\#935](https://github.com/apache/arrow-datafusion/issues/935)
- Add "baseline" metrics to all built in operators [\#866](https://github.com/apache/arrow-datafusion/issues/866)
-   Add SQL support for referencing fields in structs [\#119](https://github.com/apache/arrow-datafusion/issues/119)
- add filename completer for create table statement [\#1278](https://github.com/apache/arrow-datafusion/pull/1278) ([Jimexist](https://github.com/Jimexist))
- Add drop table support [\#1266](https://github.com/apache/arrow-datafusion/pull/1266) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([viirya](https://github.com/viirya))
- Dataframe supports except and update readme [\#1261](https://github.com/apache/arrow-datafusion/pull/1261) ([xudong963](https://github.com/xudong963))
- Implement EXCEPT & EXCEPT DISTINCT [\#1259](https://github.com/apache/arrow-datafusion/pull/1259) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Add DataFrame support for `INTERSECT` and update readme [\#1258](https://github.com/apache/arrow-datafusion/pull/1258) ([xudong963](https://github.com/xudong963))
- use arrow 6.1.0 [\#1255](https://github.com/apache/arrow-datafusion/pull/1255) ([Jimexist](https://github.com/Jimexist))
- fix 1250, add editor support for datafusion cli with validation [\#1251](https://github.com/apache/arrow-datafusion/pull/1251) ([Jimexist](https://github.com/Jimexist))
- Add support for `create table as` via MemTable [\#1243](https://github.com/apache/arrow-datafusion/pull/1243) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Dandandan](https://github.com/Dandandan))
- Add cli show columns command to describe tables [\#1231](https://github.com/apache/arrow-datafusion/pull/1231) ([Jimexist](https://github.com/Jimexist))
- datafusion-cli to add list table command [\#1229](https://github.com/apache/arrow-datafusion/pull/1229) ([Jimexist](https://github.com/Jimexist))
- datafusion cli to handle EoF and interrupt signal [\#1225](https://github.com/apache/arrow-datafusion/pull/1225) ([Jimexist](https://github.com/Jimexist))
- add \q as quit command and add \? for help [\#1224](https://github.com/apache/arrow-datafusion/pull/1224) ([Jimexist](https://github.com/Jimexist))
- Add algebraic simplifications to constant\_folding [\#1208](https://github.com/apache/arrow-datafusion/pull/1208) ([matthewmturner](https://github.com/matthewmturner))
- Improve GetIndexedFieldExpr adding utf8 key based access for struct v… [\#1204](https://github.com/apache/arrow-datafusion/pull/1204) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Igosuki](https://github.com/Igosuki))
- Fix `between` in select query [\#1202](https://github.com/apache/arrow-datafusion/pull/1202) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([capkurmagati](https://github.com/capkurmagati))
- Move code to fold Stable functions like `now()` from `Simplifier` to `ConstEvaluator` [\#1176](https://github.com/apache/arrow-datafusion/pull/1176) ([alamb](https://github.com/alamb))
- DataFrame supports window function [\#1167](https://github.com/apache/arrow-datafusion/pull/1167) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- add values list expression [\#1165](https://github.com/apache/arrow-datafusion/pull/1165) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Jimexist](https://github.com/Jimexist))
- Add booleans support to the CASE statement [\#1161](https://github.com/apache/arrow-datafusion/pull/1161) ([xudong963](https://github.com/xudong963))
- Improve error messages when operations are not supported [\#1158](https://github.com/apache/arrow-datafusion/pull/1158) ([alamb](https://github.com/alamb))
- Generic constant expression evaluation [\#1153](https://github.com/apache/arrow-datafusion/pull/1153) ([alamb](https://github.com/alamb))
- python `lit` function to support bool and byte vec [\#1152](https://github.com/apache/arrow-datafusion/pull/1152) ([Jimexist](https://github.com/Jimexist))
- \[nit\] simplify datafusion optimizer module codes [\#1146](https://github.com/apache/arrow-datafusion/pull/1146) ([panarch](https://github.com/panarch))
- Add ScalarValue support for arbitrary list elements [\#1142](https://github.com/apache/arrow-datafusion/pull/1142) ([jonmmease](https://github.com/jonmmease))
- Multiple files per partitions for CSV Avro Json [\#1138](https://github.com/apache/arrow-datafusion/pull/1138) ([rdettai](https://github.com/rdettai))
- Implement INTERSECT & INTERSECT DISTINCT [\#1135](https://github.com/apache/arrow-datafusion/pull/1135) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Simplify file struct abstractions [\#1120](https://github.com/apache/arrow-datafusion/pull/1120) ([rdettai](https://github.com/rdettai))
- Implement `is [not] distinct from` [\#1117](https://github.com/apache/arrow-datafusion/pull/1117) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Dandandan](https://github.com/Dandandan))
- Clean up spawned task on drop for `RepartitionExec`, `SortPreservingMergeExec`, `WindowAggExec` [\#1112](https://github.com/apache/arrow-datafusion/pull/1112) ([crepererum](https://github.com/crepererum))
- add hyperloglog implementation \(`add` and `count`\) [\#1095](https://github.com/apache/arrow-datafusion/pull/1095) ([Jimexist](https://github.com/Jimexist))
- Add ScalarValue::Struct variant [\#1091](https://github.com/apache/arrow-datafusion/pull/1091) ([jonmmease](https://github.com/jonmmease))
- add digest\(utf8, method\) function and refactor all current hash digest functions [\#1090](https://github.com/apache/arrow-datafusion/pull/1090) ([Jimexist](https://github.com/Jimexist))
- \[crypto\] add `blake3` algorithm to `digest` function [\#1086](https://github.com/apache/arrow-datafusion/pull/1086) ([Jimexist](https://github.com/Jimexist))
- \[crypto\] add blake2b and blake2s functions [\#1081](https://github.com/apache/arrow-datafusion/pull/1081) ([Jimexist](https://github.com/Jimexist))
- \[nit\] make schema qualifier error message in field lookup more readable [\#1079](https://github.com/apache/arrow-datafusion/pull/1079) ([Jimexist](https://github.com/Jimexist))
- \[window function\] add `percent_rank`  window function [\#1077](https://github.com/apache/arrow-datafusion/pull/1077) ([Jimexist](https://github.com/Jimexist))
- \[window function\] add `cume_dist` implementation [\#1076](https://github.com/apache/arrow-datafusion/pull/1076) ([Jimexist](https://github.com/Jimexist))
- Add a LogicalPlanBuilder::schema\(\) function [\#1075](https://github.com/apache/arrow-datafusion/pull/1075) ([alamb](https://github.com/alamb))
- Add support for UNION \[DISTINCT\] sql [\#1068](https://github.com/apache/arrow-datafusion/pull/1068) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- fix: fix joins on Float32/Float64 columns bug [\#1054](https://github.com/apache/arrow-datafusion/pull/1054) ([francis-du](https://github.com/francis-du))
-  Update sqlparser-rs to 0.11 [\#1052](https://github.com/apache/arrow-datafusion/pull/1052) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Support querying CSV files without providing the schema [\#1050](https://github.com/apache/arrow-datafusion/pull/1050) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- remove hard coded partition count in ballista logicalplan deserialization [\#1044](https://github.com/apache/arrow-datafusion/pull/1044) ([xudong963](https://github.com/xudong963))
- feat: add lit\_timestamp\_nanosecond [\#1030](https://github.com/apache/arrow-datafusion/pull/1030) ([NGA-TRAN](https://github.com/NGA-TRAN))
- Ignore metadata on schema merge [\#1024](https://github.com/apache/arrow-datafusion/pull/1024) ([Smurphy000](https://github.com/Smurphy000))
- add ExecutionConfig.with\_optimizer\_rules [\#1022](https://github.com/apache/arrow-datafusion/pull/1022) ([seddonm1](https://github.com/seddonm1))
- Add baseline execution stats to `WindowAggExec` and `UnionExec`, and fixup `CoalescePartitionsExec` [\#1018](https://github.com/apache/arrow-datafusion/pull/1018) ([alamb](https://github.com/alamb))
- Derive PartialOrd for Expr [\#1015](https://github.com/apache/arrow-datafusion/pull/1015) ([alamb](https://github.com/alamb))
- Indexed field access for List [\#1006](https://github.com/apache/arrow-datafusion/pull/1006) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Igosuki](https://github.com/Igosuki))
- Add metrics for Limit and Projection, and CoalesceBatches [\#1004](https://github.com/apache/arrow-datafusion/pull/1004) ([alamb](https://github.com/alamb))
- Update DataFusion to arrow 6.0 [\#984](https://github.com/apache/arrow-datafusion/pull/984) ([alamb](https://github.com/alamb))
- Implement Display for Expr, improve operator display [\#971](https://github.com/apache/arrow-datafusion/pull/971) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([matthewmturner](https://github.com/matthewmturner))
- Add metrics for FilterExec [\#960](https://github.com/apache/arrow-datafusion/pull/960) ([alamb](https://github.com/alamb))
- Change compound column field name rules [\#952](https://github.com/apache/arrow-datafusion/pull/952) ([waynexia](https://github.com/waynexia))
- ObjectStore API to read from remote storage systems [\#950](https://github.com/apache/arrow-datafusion/pull/950) ([yjshen](https://github.com/yjshen))
- Add baseline metrics to `SortPreservingMergeExec` [\#948](https://github.com/apache/arrow-datafusion/pull/948) ([alamb](https://github.com/alamb))
- Add support for TRIM LEADING/TRAILING/BOTH syntax [\#947](https://github.com/apache/arrow-datafusion/pull/947) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([adsharma](https://github.com/adsharma))
- fixes \#933 replace placeholder fmt\_as fr ExecutionPlan impls [\#939](https://github.com/apache/arrow-datafusion/pull/939) ([tiphaineruy](https://github.com/tiphaineruy))
- Add metrics for SortExect + HashAggregateExec [\#938](https://github.com/apache/arrow-datafusion/pull/938) ([alamb](https://github.com/alamb))
- Add some additional asserts in `utils::from_plan` [\#930](https://github.com/apache/arrow-datafusion/pull/930) ([alamb](https://github.com/alamb))
- Avro Table Provider [\#910](https://github.com/apache/arrow-datafusion/pull/910) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Igosuki](https://github.com/Igosuki))
- Add BaselineMetrics, Timestamp metrics, add for `CoalescePartitionsExec`, rename output\_time -\> elapsed\_compute [\#909](https://github.com/apache/arrow-datafusion/pull/909) ([alamb](https://github.com/alamb))
- add cross join support to ballista [\#891](https://github.com/apache/arrow-datafusion/pull/891) ([houqp](https://github.com/houqp))
- Add Ballista support to DataFusion CLI [\#889](https://github.com/apache/arrow-datafusion/pull/889) ([andygrove](https://github.com/andygrove))
- support like on DictionaryArray [\#876](https://github.com/apache/arrow-datafusion/pull/876) ([b41sh](https://github.com/b41sh))
- Register table based on known schema without file IO [\#872](https://github.com/apache/arrow-datafusion/pull/872) ([Dandandan](https://github.com/Dandandan))
- Add support for PostgreSQL regex match [\#870](https://github.com/apache/arrow-datafusion/pull/870) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([b41sh](https://github.com/b41sh))
- Include planning time in datafusion-cli printing [\#860](https://github.com/apache/arrow-datafusion/pull/860) ([Dandandan](https://github.com/Dandandan))
- Implement basic common subexpression eliminate optimization [\#792](https://github.com/apache/arrow-datafusion/pull/792) ([waynexia](https://github.com/waynexia))
- Impl `ops::Not` for `expr` [\#763](https://github.com/apache/arrow-datafusion/pull/763) ([Jimexist](https://github.com/Jimexist))

**Fixed bugs:**

- Can not use `between` in the select list:  [\#1196](https://github.com/apache/arrow-datafusion/issues/1196)
- ORDER BY does not work with literals: Sort operation is not applicable to scalar value 'foo' [\#1195](https://github.com/apache/arrow-datafusion/issues/1195)
- window functions with NULL literals in `partition by` and `order by` do not work: Internal\("Sort operation is not applicable to scalar value NULL"\) [\#1194](https://github.com/apache/arrow-datafusion/issues/1194)
- Operation name not included in internal errors -- Internal\("Data type Boolean not supported for binary operation on dyn arrays"\) [\#1157](https://github.com/apache/arrow-datafusion/issues/1157)
- Physical plan explain UNION query says "ExecutionPlan\(PlaceHolder\)" [\#933](https://github.com/apache/arrow-datafusion/issues/933)
- Can not use LIKE on DictionaryArray encoded strings [\#815](https://github.com/apache/arrow-datafusion/issues/815)
- physical\_plan::repartition::tests::repartition\_with\_dropping\_output\_stream failing locally [\#614](https://github.com/apache/arrow-datafusion/issues/614)
- Fix some `BuiltinScalarFunction` panics with zero arguments [\#1249](https://github.com/apache/arrow-datafusion/pull/1249) ([capkurmagati](https://github.com/capkurmagati))
- fix: not do boolean folding on NULL and/or expr [\#1245](https://github.com/apache/arrow-datafusion/pull/1245) ([NGA-TRAN](https://github.com/NGA-TRAN))
- ignore case of `with header row` in sql when creating external table [\#1237](https://github.com/apache/arrow-datafusion/pull/1237) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([lichuan6](https://github.com/lichuan6))
- fix: Min/Max aggregation data type should not be dictionary [\#1235](https://github.com/apache/arrow-datafusion/pull/1235) ([NGA-TRAN](https://github.com/NGA-TRAN))
- Fix build with `--no-default-features` [\#1219](https://github.com/apache/arrow-datafusion/pull/1219) ([alamb](https://github.com/alamb))
- Prevent "future cannot be sent between threads safely" compilation error [\#1155](https://github.com/apache/arrow-datafusion/pull/1155) ([jonmmease](https://github.com/jonmmease))
- Clean up spawned task on drop for `AnalyzeExec`, `CoalescePartitionsExec`, `HashAggregateExec` [\#1121](https://github.com/apache/arrow-datafusion/pull/1121) ([crepererum](https://github.com/crepererum))
- Clean up spawned task on `SortStream` drop [\#1105](https://github.com/apache/arrow-datafusion/pull/1105) ([crepererum](https://github.com/crepererum))
- fix UNION ALL bug: thread 'main' panicked at 'index out of bounds: the len is 1 but the index is 1', ./src/datatypes/schema.rs:165:10 [\#1088](https://github.com/apache/arrow-datafusion/pull/1088) ([xudong963](https://github.com/xudong963))
- python: fix generated table name in dataframe creation  [\#1078](https://github.com/apache/arrow-datafusion/pull/1078) ([houqp](https://github.com/houqp))
- fix subquery alias [\#1067](https://github.com/apache/arrow-datafusion/pull/1067) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- fix pattern handling in regexp\_match function [\#1065](https://github.com/apache/arrow-datafusion/pull/1065) ([houqp](https://github.com/houqp))
- fix: joins on Timestamp columns [\#1055](https://github.com/apache/arrow-datafusion/pull/1055) ([francis-du](https://github.com/francis-du))
- Fix metric name typo [\#943](https://github.com/apache/arrow-datafusion/pull/943) ([alamb](https://github.com/alamb))
- EXPLAIN ANALYZE should run all Optimizer passes [\#929](https://github.com/apache/arrow-datafusion/pull/929) ([alamb](https://github.com/alamb))

**Documentation updates:**

- update docs to fix DataFusion User Guide link  [\#1238](https://github.com/apache/arrow-datafusion/pull/1238) ([jiangzhx](https://github.com/jiangzhx))
- \[docs\] datafusion cli run via homebrew [\#1198](https://github.com/apache/arrow-datafusion/pull/1198) ([Jimexist](https://github.com/Jimexist))
- add support for unary and binary values in values list, update docs [\#1172](https://github.com/apache/arrow-datafusion/pull/1172) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Jimexist](https://github.com/Jimexist))
- Add additional docstring comments to `from_plan` [\#1168](https://github.com/apache/arrow-datafusion/pull/1168) ([alamb](https://github.com/alamb))
- \[nit\] fix document issue for `approx_distinct` [\#1110](https://github.com/apache/arrow-datafusion/pull/1110) ([Jimexist](https://github.com/Jimexist))
- implement `approx_distinct` function using HyperLogLog [\#1087](https://github.com/apache/arrow-datafusion/pull/1087) ([Jimexist](https://github.com/Jimexist))
- Remove unused `use` statements from examples [\#1032](https://github.com/apache/arrow-datafusion/pull/1032) ([alamb](https://github.com/alamb))
- consolidate datafusion docs with sphinx [\#993](https://github.com/apache/arrow-datafusion/pull/993) ([houqp](https://github.com/houqp))
- Updated user-guide library docs with optimized config [\#976](https://github.com/apache/arrow-datafusion/pull/976) ([matthewmturner](https://github.com/matthewmturner))
- Improve User Guide [\#954](https://github.com/apache/arrow-datafusion/pull/954) ([andygrove](https://github.com/andygrove))
- \[MINOR\] Fix typos in doc comments [\#945](https://github.com/apache/arrow-datafusion/pull/945) ([alamb](https://github.com/alamb))
- \[DataFusion\] -  Add show and show\_limit function for DataFrame [\#923](https://github.com/apache/arrow-datafusion/pull/923) ([francis-du](https://github.com/francis-du))
- Typo fix in DataFusion crate documentation [\#914](https://github.com/apache/arrow-datafusion/pull/914) ([antoinewdg](https://github.com/antoinewdg))

**Performance improvements:**

- Improve avro reader performance by avoiding some cloning on avro\_rs::Value [\#1206](https://github.com/apache/arrow-datafusion/pull/1206) ([Igosuki](https://github.com/Igosuki))
- optimize build profile for datafusion python binding, cli and ballista [\#1137](https://github.com/apache/arrow-datafusion/pull/1137) ([houqp](https://github.com/houqp))
- Avoid stack overflow by reducing stack usage of `BinaryExpr::evaluate` in debug builds [\#1047](https://github.com/apache/arrow-datafusion/pull/1047) ([alamb](https://github.com/alamb))
- Add ScalarValue::eq\_array optimized comparison function [\#844](https://github.com/apache/arrow-datafusion/pull/844) ([alamb](https://github.com/alamb))
- Rework GroupByHash to for faster performance and support grouping by nulls [\#808](https://github.com/apache/arrow-datafusion/pull/808) ([alamb](https://github.com/alamb))

**Closed issues:**

- InList expr with NULL literals do not work [\#1190](https://github.com/apache/arrow-datafusion/issues/1190)
- update the homepage README to include values, `approx_distinct`, etc. [\#1171](https://github.com/apache/arrow-datafusion/issues/1171)
- \[Python\]: Inconsistencies with Python package name  [\#1011](https://github.com/apache/arrow-datafusion/issues/1011)
- Wanting to contribute to project where to start? [\#983](https://github.com/apache/arrow-datafusion/issues/983)
- delete redundant code [\#973](https://github.com/apache/arrow-datafusion/issues/973)
- How to build DataFusion python wheel  [\#853](https://github.com/apache/arrow-datafusion/issues/853)
-   Add support for partition pruning [\#204](https://github.com/apache/arrow-datafusion/issues/204)
- \[Datafusion\] Support joins on TimestampMillisecond columns [\#187](https://github.com/apache/arrow-datafusion/issues/187)
-  TPC-H Query 21 [\#173](https://github.com/apache/arrow-datafusion/issues/173)
-  TPC-H Query 13 [\#164](https://github.com/apache/arrow-datafusion/issues/164)
-  TPC-H Query 8 [\#162](https://github.com/apache/arrow-datafusion/issues/162)
-  implement split\_part\(string, delimiter, position\) [\#157](https://github.com/apache/arrow-datafusion/issues/157)
-  Join Statement: Schema contains duplicate unqualified field name [\#155](https://github.com/apache/arrow-datafusion/issues/155)
-   ParquetTable should avoid scanning all files twice [\#136](https://github.com/apache/arrow-datafusion/issues/136)
-   Add support for reading partitioned Parquet files [\#133](https://github.com/apache/arrow-datafusion/issues/133)
-   Add support for Parquet schema merging  [\#132](https://github.com/apache/arrow-datafusion/issues/132)
-  Catalog abstraction [\#126](https://github.com/apache/arrow-datafusion/issues/126)
-   Optimizer rules should work with qualified column names [\#125](https://github.com/apache/arrow-datafusion/issues/125)
-   Add optional qualifier to Expr::Column [\#121](https://github.com/apache/arrow-datafusion/issues/121)
-  Implement modulus expression [\#99](https://github.com/apache/arrow-datafusion/issues/99)
- \[Rust\]  Add constant folding to expressions during logically planning [\#98](https://github.com/apache/arrow-datafusion/issues/98)
- \[Rust\]  Implement pretty print for physical query plan [\#93](https://github.com/apache/arrow-datafusion/issues/93)
- Can not group by boolean columns \(add  boolean to valid keys of groupBy\) [\#91](https://github.com/apache/arrow-datafusion/issues/91)
-  improve performance of building literal arrays [\#90](https://github.com/apache/arrow-datafusion/issues/90)
- \[rust\]\[datafusion\] optimize count\(\*\) queries on parquet sources [\#89](https://github.com/apache/arrow-datafusion/issues/89)
- Produce a design for a metrics framework [\#21](https://github.com/apache/arrow-datafusion/issues/21)

**Merged pull requests:**

- Add timezome string to stablize test [\#1265](https://github.com/apache/arrow-datafusion/pull/1265) ([viirya](https://github.com/viirya))
- numerical\_coercion pattern match optimize [\#1256](https://github.com/apache/arrow-datafusion/pull/1256) ([Jimexist](https://github.com/Jimexist))
- fix and update window function sql tests [\#1059](https://github.com/apache/arrow-datafusion/pull/1059) ([Jimexist](https://github.com/Jimexist))
- reduce ScalarValue from trait boilerplate with macro [\#989](https://github.com/apache/arrow-datafusion/pull/989) ([houqp](https://github.com/houqp))


For older versions, see [apache/arrow/CHANGELOG.md](https://github.com/apache/arrow/blob/master/CHANGELOG.md)

## [5.0.0](https://github.com/apache/arrow-datafusion/tree/5.0.0) (2021-08-10)

[Full Changelog](https://github.com/apache/arrow-datafusion/compare/4.0.0...5.0.0)

**Breaking changes:**

- Box ScalarValue:Lists, reduce size by half size [\#788](https://github.com/apache/arrow-datafusion/pull/788) ([alamb](https://github.com/alamb))
- JOIN conditions are order dependent [\#778](https://github.com/apache/arrow-datafusion/pull/778) ([seddonm1](https://github.com/seddonm1))
- Show the result of all optimizer passes in EXPLAIN VERBOSE [\#759](https://github.com/apache/arrow-datafusion/pull/759) ([alamb](https://github.com/alamb))
- \#723 Datafusion add option in ExecutionConfig to enable/disable parquet pruning [\#749](https://github.com/apache/arrow-datafusion/pull/749) ([lvheyang](https://github.com/lvheyang))
- Update API for extension planning to include logical plan [\#643](https://github.com/apache/arrow-datafusion/pull/643) ([alamb](https://github.com/alamb))
- Rename MergeExec to CoalescePartitionsExec [\#635](https://github.com/apache/arrow-datafusion/pull/635) ([andygrove](https://github.com/andygrove))
- fix 593, reduce cloning by taking ownership in logical planner's `from` fn [\#610](https://github.com/apache/arrow-datafusion/pull/610) ([Jimexist](https://github.com/Jimexist))
- fix join column handling logic for `On` and `Using` constraints [\#605](https://github.com/apache/arrow-datafusion/pull/605) ([houqp](https://github.com/houqp))
- Rewrite pruning logic in terms of PruningStatistics using Array trait \(option 2\) [\#426](https://github.com/apache/arrow-datafusion/pull/426) ([alamb](https://github.com/alamb))
- Support reading from NdJson formatted data sources [\#404](https://github.com/apache/arrow-datafusion/pull/404) ([heymind](https://github.com/heymind))
- Add metrics to RepartitionExec [\#398](https://github.com/apache/arrow-datafusion/pull/398) ([andygrove](https://github.com/andygrove))
- Use 4.x arrow-rs from crates.io rather than git sha [\#395](https://github.com/apache/arrow-datafusion/pull/395) ([alamb](https://github.com/alamb))
- Return Vec\<bool\> from PredicateBuilder rather than an `Fn` [\#370](https://github.com/apache/arrow-datafusion/pull/370) ([alamb](https://github.com/alamb))
- Refactor: move RowGroupPredicateBuilder into its own module, rename to PruningPredicateBuilder [\#365](https://github.com/apache/arrow-datafusion/pull/365) ([alamb](https://github.com/alamb))
- \[Datafusion\] NOW\(\) function support [\#288](https://github.com/apache/arrow-datafusion/pull/288) ([msathis](https://github.com/msathis))
- Implement select distinct [\#262](https://github.com/apache/arrow-datafusion/pull/262) ([Dandandan](https://github.com/Dandandan))
- Refactor datafusion/src/physical\_plan/common.rs build\_file\_list to take less param and reuse code [\#253](https://github.com/apache/arrow-datafusion/pull/253) ([Jimexist](https://github.com/Jimexist))
- Support qualified columns in queries [\#55](https://github.com/apache/arrow-datafusion/pull/55) ([houqp](https://github.com/houqp))
- Read CSV format text from stdin or memory [\#54](https://github.com/apache/arrow-datafusion/pull/54) ([heymind](https://github.com/heymind))
- Use atomics for SQLMetric implementation, remove unused name field [\#25](https://github.com/apache/arrow-datafusion/pull/25) ([returnString](https://github.com/returnString))

**Implemented enhancements:**

- Allow extension nodes to correctly plan physical expressions with relations [\#642](https://github.com/apache/arrow-datafusion/issues/642)
- Filters aren't passed down to table scans in a union [\#557](https://github.com/apache/arrow-datafusion/issues/557)
- Support pruning for `boolean` columns [\#490](https://github.com/apache/arrow-datafusion/issues/490)
- Implement SQLMetrics for RepartitionExec [\#397](https://github.com/apache/arrow-datafusion/issues/397)
- DataFusion benchmarks should show executed plan with metrics after query completes [\#396](https://github.com/apache/arrow-datafusion/issues/396)
- Use published versions of arrow rather than github shas [\#393](https://github.com/apache/arrow-datafusion/issues/393)
- Add Compare to GroupByScalar [\#364](https://github.com/apache/arrow-datafusion/issues/364)
- Reusable "row group pruning" logic [\#363](https://github.com/apache/arrow-datafusion/issues/363)
- Add an Order Preserving merge operator [\#362](https://github.com/apache/arrow-datafusion/issues/362)
- Implement Postgres compatible `now()` function [\#251](https://github.com/apache/arrow-datafusion/issues/251)
- COUNT DISTINCT does not support dictionary types [\#249](https://github.com/apache/arrow-datafusion/issues/249)
- Use standard make\_null\_array for CASE [\#222](https://github.com/apache/arrow-datafusion/issues/222)
-  Implement date\_trunc\(\) function [\#203](https://github.com/apache/arrow-datafusion/issues/203)
-  COUNT DISTINCT does not support for `Float64` [\#199](https://github.com/apache/arrow-datafusion/issues/199)
- Update SQLMetric to use atomics rather than a Mutex [\#30](https://github.com/apache/arrow-datafusion/issues/30)
- Implement PartialOrd for ScalarValue [\#838](https://github.com/apache/arrow-datafusion/pull/838) ([viirya](https://github.com/viirya))
- Support date datatypes in max/min [\#820](https://github.com/apache/arrow-datafusion/pull/820) ([viirya](https://github.com/viirya))
- Implement vectorized hashing for DictionaryArray types [\#812](https://github.com/apache/arrow-datafusion/pull/812) ([alamb](https://github.com/alamb))
- Convert unsupported conditions in left right join to filters [\#796](https://github.com/apache/arrow-datafusion/pull/796) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([Dandandan](https://github.com/Dandandan))
- Implement streaming versions of Dataframe.collect methods [\#789](https://github.com/apache/arrow-datafusion/pull/789) ([andygrove](https://github.com/andygrove))
- impl from str for column and scalar [\#762](https://github.com/apache/arrow-datafusion/pull/762) ([Jimexist](https://github.com/Jimexist))
- impl fmt::Display for PlanType [\#752](https://github.com/apache/arrow-datafusion/pull/752) ([Jimexist](https://github.com/Jimexist))
- Remove unnecessary projection in logical plan optimization phase [\#747](https://github.com/apache/arrow-datafusion/pull/747) ([waynexia](https://github.com/waynexia))
- Support table columns alias [\#735](https://github.com/apache/arrow-datafusion/pull/735) ([Dandandan](https://github.com/Dandandan))
- Derive PartialEq for datasource enums [\#734](https://github.com/apache/arrow-datafusion/pull/734) ([alamb](https://github.com/alamb))
- Allow filetype to be lowercase, Implement FromStr for FileType [\#728](https://github.com/apache/arrow-datafusion/pull/728) ([Jimexist](https://github.com/Jimexist))
- Update to use arrow 5.0 [\#721](https://github.com/apache/arrow-datafusion/pull/721) ([alamb](https://github.com/alamb))
- \#554: Lead/lag window function with offset and default value arguments [\#687](https://github.com/apache/arrow-datafusion/pull/687) ([jgoday](https://github.com/jgoday))
- dedup using join column in wildcard expansion [\#678](https://github.com/apache/arrow-datafusion/pull/678) ([houqp](https://github.com/houqp))
- Implement metrics for HashJoinExec [\#664](https://github.com/apache/arrow-datafusion/pull/664) ([andygrove](https://github.com/andygrove))
- Show physical plan with metrics in benchmark [\#662](https://github.com/apache/arrow-datafusion/pull/662) ([andygrove](https://github.com/andygrove))
- Allow non-equijoin filters in join condition [\#660](https://github.com/apache/arrow-datafusion/pull/660) ([Dandandan](https://github.com/Dandandan))
- Add End-to-end test for parquet pruning + metrics for ParquetExec [\#657](https://github.com/apache/arrow-datafusion/pull/657) ([alamb](https://github.com/alamb))
- Add support for leading field in interval [\#647](https://github.com/apache/arrow-datafusion/pull/647) ([Dandandan](https://github.com/Dandandan))
- Remove hard-coded PartitionMode from Ballista serde [\#637](https://github.com/apache/arrow-datafusion/pull/637) ([andygrove](https://github.com/andygrove))
- Ballista: Implement scalable distributed joins [\#634](https://github.com/apache/arrow-datafusion/pull/634) ([andygrove](https://github.com/andygrove))
- implement rank and dense\_rank function and refactor built-in window function evaluation [\#631](https://github.com/apache/arrow-datafusion/pull/631) ([Jimexist](https://github.com/Jimexist))
- Improve "field not found" error messages [\#625](https://github.com/apache/arrow-datafusion/pull/625) ([andygrove](https://github.com/andygrove))
- Support modulus op [\#577](https://github.com/apache/arrow-datafusion/pull/577) ([gangliao](https://github.com/gangliao))
- implement `std::default::Default` for execution config [\#570](https://github.com/apache/arrow-datafusion/pull/570) ([Jimexist](https://github.com/Jimexist))
- `to_timestamp_millis()`, `to_timestamp_micros()`, `to_timestamp_seconds()` [\#567](https://github.com/apache/arrow-datafusion/pull/567) ([velvia](https://github.com/velvia))
- Filter push down for Union [\#559](https://github.com/apache/arrow-datafusion/pull/559) ([Dandandan](https://github.com/Dandandan))
- Implement window functions with `partition_by` clause [\#558](https://github.com/apache/arrow-datafusion/pull/558) ([Jimexist](https://github.com/Jimexist))
- support table alias in join clause [\#547](https://github.com/apache/arrow-datafusion/pull/547) ([houqp](https://github.com/houqp))
- Not equal predicate in physical\_planning pruning [\#544](https://github.com/apache/arrow-datafusion/pull/544) ([jgoday](https://github.com/jgoday))
- add error handling and boundary checking for window frames [\#530](https://github.com/apache/arrow-datafusion/pull/530) ([Jimexist](https://github.com/Jimexist))
- Implement window functions with `order_by` clause [\#520](https://github.com/apache/arrow-datafusion/pull/520) ([Jimexist](https://github.com/Jimexist))
- support group by column positions [\#519](https://github.com/apache/arrow-datafusion/pull/519) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([jychen7](https://github.com/jychen7))
- Implement constant folding for CAST [\#513](https://github.com/apache/arrow-datafusion/pull/513) ([msathis](https://github.com/msathis))
- Add window frame constructs - alternative [\#506](https://github.com/apache/arrow-datafusion/pull/506) ([Jimexist](https://github.com/Jimexist))
- Add `partition by` constructs in window functions and modify logical planning [\#501](https://github.com/apache/arrow-datafusion/pull/501) ([Jimexist](https://github.com/Jimexist))
-  Add support for boolean columns in pruning logic [\#500](https://github.com/apache/arrow-datafusion/pull/500) ([alamb](https://github.com/alamb))
- \#215 resolve aliases for group by exprs [\#485](https://github.com/apache/arrow-datafusion/pull/485) ([jychen7](https://github.com/jychen7))
- Support anti join [\#482](https://github.com/apache/arrow-datafusion/pull/482) ([Dandandan](https://github.com/Dandandan))
- Support semi join [\#470](https://github.com/apache/arrow-datafusion/pull/470) ([Dandandan](https://github.com/Dandandan))
- add `order by` construct in window function and logical plans [\#463](https://github.com/apache/arrow-datafusion/pull/463) ([Jimexist](https://github.com/Jimexist))
- Remove reundant filters \(e.g. c\> 5 AND c\>5 --\> c\>5\) [\#436](https://github.com/apache/arrow-datafusion/pull/436) ([jgoday](https://github.com/jgoday))
- fix: display the content of debug explain [\#434](https://github.com/apache/arrow-datafusion/pull/434) ([NGA-TRAN](https://github.com/NGA-TRAN))
- implement lead and lag built-in window function [\#429](https://github.com/apache/arrow-datafusion/pull/429) ([Jimexist](https://github.com/Jimexist))
- add support for ndjson for datafusion-cli [\#427](https://github.com/apache/arrow-datafusion/pull/427) ([Jimexist](https://github.com/Jimexist))
- add `first_value`, `last_value`, and `nth_value` built-in window functions [\#403](https://github.com/apache/arrow-datafusion/pull/403) ([Jimexist](https://github.com/Jimexist))
- export both `now` and `random` functions [\#389](https://github.com/apache/arrow-datafusion/pull/389) ([Jimexist](https://github.com/Jimexist))
- Function to create `ArrayRef` from an iterator of ScalarValues [\#381](https://github.com/apache/arrow-datafusion/pull/381) ([alamb](https://github.com/alamb))
- Sort preserving merge \(\#362\) [\#379](https://github.com/apache/arrow-datafusion/pull/379) ([tustvold](https://github.com/tustvold))
- Add support for multiple partitions with SortExec \(\#362\) [\#378](https://github.com/apache/arrow-datafusion/pull/378) ([tustvold](https://github.com/tustvold))
- add window expression stream, delegated window aggregation to aggregate functions, and implement `row_number` [\#375](https://github.com/apache/arrow-datafusion/pull/375) ([Jimexist](https://github.com/Jimexist))
- Add PartialOrd and Ord to GroupByScalar \(\#364\) [\#368](https://github.com/apache/arrow-datafusion/pull/368) ([tustvold](https://github.com/tustvold))
- Implement readable explain plans for physical plans [\#337](https://github.com/apache/arrow-datafusion/pull/337) ([alamb](https://github.com/alamb))
- Add window expression part 1 - logical and physical planning, structure, to/from proto, and explain, for empty over clause only [\#334](https://github.com/apache/arrow-datafusion/pull/334) ([Jimexist](https://github.com/Jimexist))
- Use NullArray to Pass row count to ScalarFunctions that take 0 arguments  [\#328](https://github.com/apache/arrow-datafusion/pull/328) ([Jimexist](https://github.com/Jimexist))
- add --quiet/-q flag and allow timing info to be turned on/off [\#323](https://github.com/apache/arrow-datafusion/pull/323) ([Jimexist](https://github.com/Jimexist))
- Implement hash partitioned aggregation [\#320](https://github.com/apache/arrow-datafusion/pull/320) ([Dandandan](https://github.com/Dandandan))
- Support COUNT\(DISTINCT timestamps\)  [\#319](https://github.com/apache/arrow-datafusion/pull/319) ([charlibot](https://github.com/charlibot))
- add random SQL function [\#303](https://github.com/apache/arrow-datafusion/pull/303) ([Jimexist](https://github.com/Jimexist))
- allow datafusion cli to take -- comments [\#296](https://github.com/apache/arrow-datafusion/pull/296) ([Jimexist](https://github.com/Jimexist))
- Add json print format mode to datafusion cli [\#295](https://github.com/apache/arrow-datafusion/pull/295) ([Jimexist](https://github.com/Jimexist))
- Add print format param with support for tsv print format to datafusion cli [\#292](https://github.com/apache/arrow-datafusion/pull/292) ([Jimexist](https://github.com/Jimexist))
- Add print format param and support for csv print format to datafusion cli [\#289](https://github.com/apache/arrow-datafusion/pull/289) ([Jimexist](https://github.com/Jimexist))
- allow datafusion-cli to take a file param [\#285](https://github.com/apache/arrow-datafusion/pull/285) ([Jimexist](https://github.com/Jimexist))
- add param validation for datafusion-cli [\#284](https://github.com/apache/arrow-datafusion/pull/284) ([Jimexist](https://github.com/Jimexist))
- \[breaking change\] fix 265, log should be log10, and add ln [\#271](https://github.com/apache/arrow-datafusion/pull/271) ([Jimexist](https://github.com/Jimexist))
- Implement count distinct for dictionary arrays [\#256](https://github.com/apache/arrow-datafusion/pull/256) ([alamb](https://github.com/alamb))
- Count distinct floats [\#252](https://github.com/apache/arrow-datafusion/pull/252) ([pjmore](https://github.com/pjmore))
- Add rule to eliminate `LIMIT 0` and replace it with an `EmptyRelation` [\#213](https://github.com/apache/arrow-datafusion/pull/213) ([Dandandan](https://github.com/Dandandan))
- Allow table providers to indicate their type for catalog metadata [\#205](https://github.com/apache/arrow-datafusion/pull/205) ([returnString](https://github.com/returnString))
- Use arrow eq kernels in CaseWhen expression evaluation [\#52](https://github.com/apache/arrow-datafusion/pull/52) ([Dandandan](https://github.com/Dandandan))
- Re-export Arrow and Parquet crates from DataFusion [\#39](https://github.com/apache/arrow-datafusion/pull/39) ([returnString](https://github.com/returnString))
- \[DataFusion\] Optimize hash join inner workings, null handling fix [\#24](https://github.com/apache/arrow-datafusion/pull/24) ([Dandandan](https://github.com/Dandandan))
- \[ARROW-12441\] \[DataFusion\] Cross join implementation [\#11](https://github.com/apache/arrow-datafusion/pull/11) ([Dandandan](https://github.com/Dandandan))

**Fixed bugs:**

- Projection pushdown removes unqualified column names even when they are used [\#617](https://github.com/apache/arrow-datafusion/issues/617)
- Panic while running join datatypes/schema.rs:165:10 [\#601](https://github.com/apache/arrow-datafusion/issues/601)
- Indentation is incorrect for joins in formatted physical plans [\#345](https://github.com/apache/arrow-datafusion/issues/345)
- Error while running `COUNT DISTINCT (timestamp)`: 'Unexpected DataType for list [\#314](https://github.com/apache/arrow-datafusion/issues/314)
- When joining two tables, get Error: Plan\("Schema contains duplicate unqualified field name \'xxx\'"\) [\#311](https://github.com/apache/arrow-datafusion/issues/311)
- Incorrect answers with SELECT DISTINCT queries [\#250](https://github.com/apache/arrow-datafusion/issues/250)
- Intermitent failure in CI join\_with\_hash\_collision [\#227](https://github.com/apache/arrow-datafusion/issues/227)
- `Concat` from Dataframe API no longer accepts multiple expressions [\#226](https://github.com/apache/arrow-datafusion/issues/226)
- Fix right, full join handling when having multiple non-matching rows at the left side [\#845](https://github.com/apache/arrow-datafusion/pull/845) ([Dandandan](https://github.com/Dandandan))
- Qualified field resolution too strict [\#810](https://github.com/apache/arrow-datafusion/pull/810) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([seddonm1](https://github.com/seddonm1))
- Better join order resolution logic [\#797](https://github.com/apache/arrow-datafusion/pull/797) [[sql](https://github.com/apache/arrow-datafusion/labels/sql)] ([seddonm1](https://github.com/seddonm1))
- Produce correct answers for Group BY NULL \(Option 1\) [\#793](https://github.com/apache/arrow-datafusion/pull/793) ([alamb](https://github.com/alamb))
-  Use consistent version of string\_to\_timestamp\_nanos in DataFusion [\#767](https://github.com/apache/arrow-datafusion/pull/767) ([alamb](https://github.com/alamb))
- \#723 limit pruning rule to simple expression [\#764](https://github.com/apache/arrow-datafusion/pull/764) ([lvheyang](https://github.com/lvheyang))
- \#699 fix return type conflict when calling builtin math fuctions [\#716](https://github.com/apache/arrow-datafusion/pull/716) ([lvheyang](https://github.com/lvheyang))
- Fix Date32 and Date64 parquet row group pruning [\#690](https://github.com/apache/arrow-datafusion/pull/690) ([alamb](https://github.com/alamb))
- Remove qualifiers on pushed down predicates / Fix parquet pruning [\#689](https://github.com/apache/arrow-datafusion/pull/689) ([alamb](https://github.com/alamb))
- use `Weak` ptr to break catalog list \<\> info schema cyclic reference [\#681](https://github.com/apache/arrow-datafusion/pull/681) ([crepererum](https://github.com/crepererum))
- honor table name for csv/parquet scan in ballista plan serde [\#629](https://github.com/apache/arrow-datafusion/pull/629) ([houqp](https://github.com/houqp))
- fix 621, where unnamed window functions shall be differentiated by partition and order by clause [\#622](https://github.com/apache/arrow-datafusion/pull/622) ([Jimexist](https://github.com/Jimexist))
- RFC: Do not prune out unnecessary columns with unqualified references [\#619](https://github.com/apache/arrow-datafusion/pull/619) ([alamb](https://github.com/alamb))
- \[fix\] select \* on empty table [\#613](https://github.com/apache/arrow-datafusion/pull/613) ([rdettai](https://github.com/rdettai))
- fix 592, support alias in window functions [\#607](https://github.com/apache/arrow-datafusion/pull/607) ([Jimexist](https://github.com/Jimexist))
- RepartitionExec should not error if output has hung up [\#576](https://github.com/apache/arrow-datafusion/pull/576) ([alamb](https://github.com/alamb))
- Fix pruning on not equal predicate [\#561](https://github.com/apache/arrow-datafusion/pull/561) ([alamb](https://github.com/alamb))
- hash float arrays using primitive usigned integer type [\#556](https://github.com/apache/arrow-datafusion/pull/556) ([houqp](https://github.com/houqp))
- Return errors properly from RepartitionExec [\#521](https://github.com/apache/arrow-datafusion/pull/521) ([alamb](https://github.com/alamb))
- refactor sort exec stream and combine batches [\#515](https://github.com/apache/arrow-datafusion/pull/515) ([Jimexist](https://github.com/Jimexist))
- Fix display of execution time in datafusion-cli [\#514](https://github.com/apache/arrow-datafusion/pull/514) ([Dandandan](https://github.com/Dandandan))
- Wrong aggregation arguments error. [\#505](https://github.com/apache/arrow-datafusion/pull/505) ([jgoday](https://github.com/jgoday))
- fix window aggregation with alias and add integration test case [\#454](https://github.com/apache/arrow-datafusion/pull/454) ([Jimexist](https://github.com/Jimexist))
- fix: don't duplicate existing filters [\#409](https://github.com/apache/arrow-datafusion/pull/409) ([e-dard](https://github.com/e-dard))
- Fixed incorrect logical type in GroupByScalar. [\#391](https://github.com/apache/arrow-datafusion/pull/391) ([jorgecarleitao](https://github.com/jorgecarleitao))
- Fix indented display for multi-child nodes [\#358](https://github.com/apache/arrow-datafusion/pull/358) ([alamb](https://github.com/alamb))
- Fix SQL planner to support multibyte column names [\#357](https://github.com/apache/arrow-datafusion/pull/357) ([agatan](https://github.com/agatan))
- Fix wrong projection 'optimization' [\#268](https://github.com/apache/arrow-datafusion/pull/268) ([Dandandan](https://github.com/Dandandan))
- Fix Left join implementation is incorrect for 0 or multiple batches on the right side [\#238](https://github.com/apache/arrow-datafusion/pull/238) ([Dandandan](https://github.com/Dandandan))
- Count distinct boolean [\#230](https://github.com/apache/arrow-datafusion/pull/230) ([pjmore](https://github.com/pjmore))
- Fix Filter / where clause without column names is removed in optimization pass [\#225](https://github.com/apache/arrow-datafusion/pull/225) ([Dandandan](https://github.com/Dandandan))

**Documentation updates:**

-  No way to get to the examples from docs.rs [\#186](https://github.com/apache/arrow-datafusion/issues/186)
- Update docs to use vendored version of arrow [\#772](https://github.com/apache/arrow-datafusion/pull/772) ([alamb](https://github.com/alamb))
- Fix typo in DEVELOPERS.md [\#692](https://github.com/apache/arrow-datafusion/pull/692) ([lvheyang](https://github.com/lvheyang))
- update stale documentations related to window functions [\#598](https://github.com/apache/arrow-datafusion/pull/598) ([Jimexist](https://github.com/Jimexist))
- update readme to reflect work on window functions [\#471](https://github.com/apache/arrow-datafusion/pull/471) ([Jimexist](https://github.com/Jimexist))
- Add examples section to datafusion crate doc [\#457](https://github.com/apache/arrow-datafusion/pull/457) ([mluts](https://github.com/mluts))
- add invariants spec [\#443](https://github.com/apache/arrow-datafusion/pull/443) ([houqp](https://github.com/houqp))
- add output field name rfc [\#422](https://github.com/apache/arrow-datafusion/pull/422) ([houqp](https://github.com/houqp))
- Update more docs and also the developer.md doc [\#414](https://github.com/apache/arrow-datafusion/pull/414) ([Jimexist](https://github.com/Jimexist))
- use prettier to format md files [\#367](https://github.com/apache/arrow-datafusion/pull/367) ([Jimexist](https://github.com/Jimexist))
- Add new logo svg with white background [\#313](https://github.com/apache/arrow-datafusion/pull/313) ([parthsarthy](https://github.com/parthsarthy))
- Add projects \(Squirtle and Tensorbase\) to list in readme [\#312](https://github.com/apache/arrow-datafusion/pull/312) ([parthsarthy](https://github.com/parthsarthy))
- docs - fix the ballista link [\#274](https://github.com/apache/arrow-datafusion/pull/274) ([haoxins](https://github.com/haoxins))
- misc\(README\): Replace Cube.js with Cube Store [\#248](https://github.com/apache/arrow-datafusion/pull/248) ([ovr](https://github.com/ovr))
- Initial docs for SQL syntax [\#242](https://github.com/apache/arrow-datafusion/pull/242) ([Dandandan](https://github.com/Dandandan))
- Deduplicate README.md [\#79](https://github.com/apache/arrow-datafusion/pull/79) ([msathis](https://github.com/msathis))

**Performance improvements:**

- Speed up inlist for strings and primitives [\#813](https://github.com/apache/arrow-datafusion/pull/813) ([Dandandan](https://github.com/Dandandan))
- perf: improve performance of `SortPreservingMergeExec` operator [\#722](https://github.com/apache/arrow-datafusion/pull/722) ([e-dard](https://github.com/e-dard))
- Optimize min/max queries with table statistics [\#719](https://github.com/apache/arrow-datafusion/pull/719) ([b41sh](https://github.com/b41sh))
- perf: Improve materialisation performance of SortPreservingMergeExec [\#691](https://github.com/apache/arrow-datafusion/pull/691) ([e-dard](https://github.com/e-dard))
- Optimize count\(\*\) with table statistics [\#620](https://github.com/apache/arrow-datafusion/pull/620) ([Dandandan](https://github.com/Dandandan))
- optimize window function's `find_ranges_in_range` [\#595](https://github.com/apache/arrow-datafusion/pull/595) ([Jimexist](https://github.com/Jimexist))
- Collapse sort into window expr and do sort within logical phase [\#571](https://github.com/apache/arrow-datafusion/pull/571) ([Jimexist](https://github.com/Jimexist))
- Use repartition in window functions to speed up [\#569](https://github.com/apache/arrow-datafusion/pull/569) ([Jimexist](https://github.com/Jimexist))
- Constant fold / optimize `to_timestamp` function during planning [\#387](https://github.com/apache/arrow-datafusion/pull/387) ([msathis](https://github.com/msathis))
- Speed up `create_batch_from_map` [\#339](https://github.com/apache/arrow-datafusion/pull/339) ([Dandandan](https://github.com/Dandandan))
- Simplify math expression code \(use unary kernel\) [\#309](https://github.com/apache/arrow-datafusion/pull/309) ([Dandandan](https://github.com/Dandandan))

**Closed issues:**

- Confirm git tagging strategy for releases [\#770](https://github.com/apache/arrow-datafusion/issues/770)
- arrow::util::pretty::pretty\_format\_batches missing [\#769](https://github.com/apache/arrow-datafusion/issues/769)
- move the `assert_batches_eq!` macros to a non part of datafusion [\#745](https://github.com/apache/arrow-datafusion/issues/745)
- fix an issue where aliases are not respected in generating downstream schemas in window expr [\#592](https://github.com/apache/arrow-datafusion/issues/592)
- make the planner to print more succinct and useful information in window function explain clause [\#526](https://github.com/apache/arrow-datafusion/issues/526)
- move window frame module to be in `logical_plan` [\#517](https://github.com/apache/arrow-datafusion/issues/517)
- use a more rust idiomatic way of handling nth\_value [\#448](https://github.com/apache/arrow-datafusion/issues/448)
- create a test with more than one partition for window functions [\#435](https://github.com/apache/arrow-datafusion/issues/435)
-  COUNT DISTINCT does not support for `Boolean` [\#202](https://github.com/apache/arrow-datafusion/issues/202)
-  Read CSV format text from stdin or memory [\#198](https://github.com/apache/arrow-datafusion/issues/198)
-  Fix null handling hash join [\#195](https://github.com/apache/arrow-datafusion/issues/195)
-   Allow TableProviders to indicate their type for the information schema [\#191](https://github.com/apache/arrow-datafusion/issues/191)
-   Make DataFrame extensible [\#190](https://github.com/apache/arrow-datafusion/issues/190)
-  TPC-H Query 19 [\#170](https://github.com/apache/arrow-datafusion/issues/170)
-  TPC-H Query 7 [\#161](https://github.com/apache/arrow-datafusion/issues/161)
-  Upgrade hashbrown to 0.10 [\#151](https://github.com/apache/arrow-datafusion/issues/151)
-  Implement vectorized hashing for hash aggregate [\#149](https://github.com/apache/arrow-datafusion/issues/149)
-  More efficient LEFT join implementation [\#143](https://github.com/apache/arrow-datafusion/issues/143)
-  Implement vectorized hashing [\#142](https://github.com/apache/arrow-datafusion/issues/142)
-   RFC Roadmap for 2021 \(DataFusion\) [\#140](https://github.com/apache/arrow-datafusion/issues/140)
-   Implement hash partitioning [\#131](https://github.com/apache/arrow-datafusion/issues/131)
-   Grouping by column position [\#110](https://github.com/apache/arrow-datafusion/issues/110)
-  \[Datafusion\] GROUP BY with a high cardinality doesn't seem to finish [\#107](https://github.com/apache/arrow-datafusion/issues/107)
- \[Rust\]  Add support for JSON data sources [\#103](https://github.com/apache/arrow-datafusion/issues/103)
- \[Rust\]  Implement metrics framework [\#95](https://github.com/apache/arrow-datafusion/issues/95)
- Publically export Arrow crate from datafusion  [\#36](https://github.com/apache/arrow-datafusion/issues/36)
- Implement hash-partitioned hash aggregate [\#27](https://github.com/apache/arrow-datafusion/issues/27)
- Consider using GitHub pages for DataFusion/Ballista documentation [\#18](https://github.com/apache/arrow-datafusion/issues/18)
- Update "repository" in Cargo.toml [\#16](https://github.com/apache/arrow-datafusion/issues/16)

**Merged pull requests:**

- Use `RawTable`  API in hash join [\#827](https://github.com/apache/arrow-datafusion/pull/827) ([Dandandan](https://github.com/Dandandan))
- Add test for window functions on dictionary [\#823](https://github.com/apache/arrow-datafusion/pull/823) ([alamb](https://github.com/alamb))
- Update dependencies: prost to 0.8 and tonic to 0.5 [\#818](https://github.com/apache/arrow-datafusion/pull/818) ([alamb](https://github.com/alamb))
- Move `hash_array` into hash\_utils.rs [\#807](https://github.com/apache/arrow-datafusion/pull/807) ([alamb](https://github.com/alamb))
- Remove GroupByScalar and use ScalarValue in preparation for supporting null values in GroupBy [\#786](https://github.com/apache/arrow-datafusion/pull/786) ([alamb](https://github.com/alamb))
- fix 226, make `concat`, `concat_ws`, and `random` work with `Python` crate [\#761](https://github.com/apache/arrow-datafusion/pull/761) ([Jimexist](https://github.com/Jimexist))
- Test for parquet pruning disabling [\#754](https://github.com/apache/arrow-datafusion/pull/754) ([alamb](https://github.com/alamb))
- Add explain verbose with limit push down [\#751](https://github.com/apache/arrow-datafusion/pull/751) ([Jimexist](https://github.com/Jimexist))
- Move assert\_batches\_eq! macros to test\_utils.rs [\#746](https://github.com/apache/arrow-datafusion/pull/746) ([alamb](https://github.com/alamb))
- Show optimized physical and logical plans in EXPLAIN [\#744](https://github.com/apache/arrow-datafusion/pull/744) ([alamb](https://github.com/alamb))
- update `python` crate to support latest pyo3 syntax and gil sematics [\#741](https://github.com/apache/arrow-datafusion/pull/741) ([Jimexist](https://github.com/Jimexist))
- update `python` crate dependencies [\#740](https://github.com/apache/arrow-datafusion/pull/740) ([Jimexist](https://github.com/Jimexist))
- provide more details on required .parquet file extension error message [\#729](https://github.com/apache/arrow-datafusion/pull/729) ([Jimexist](https://github.com/Jimexist))
- split up windows functions into a dedicated module with separate files [\#724](https://github.com/apache/arrow-datafusion/pull/724) ([Jimexist](https://github.com/Jimexist))
- Use pytest in integration test [\#715](https://github.com/apache/arrow-datafusion/pull/715) ([Jimexist](https://github.com/Jimexist))
- replace once iter chain with array::IntoIter [\#704](https://github.com/apache/arrow-datafusion/pull/704) ([houqp](https://github.com/houqp))
- avoid iterator materialization in column index lookup [\#703](https://github.com/apache/arrow-datafusion/pull/703) ([houqp](https://github.com/houqp))
- Fix build with 1.52.1 [\#696](https://github.com/apache/arrow-datafusion/pull/696) ([alamb](https://github.com/alamb))
- Fix test output due to logical merge conflict [\#694](https://github.com/apache/arrow-datafusion/pull/694) ([alamb](https://github.com/alamb))
- add more integration tests [\#668](https://github.com/apache/arrow-datafusion/pull/668) ([Jimexist](https://github.com/Jimexist))
- Bump arrow and parquet versions to 4.4 [\#654](https://github.com/apache/arrow-datafusion/pull/654) ([toddtreece](https://github.com/toddtreece))
- Add query 15 to TPC-H queries [\#645](https://github.com/apache/arrow-datafusion/pull/645) ([Dandandan](https://github.com/Dandandan))
- Improve error message and comments [\#641](https://github.com/apache/arrow-datafusion/pull/641) ([alamb](https://github.com/alamb))
- add integration tests for rank, dense\_rank, fix last\_value evaluation with rank [\#638](https://github.com/apache/arrow-datafusion/pull/638) ([Jimexist](https://github.com/Jimexist))
- round trip TPCH queries in tests [\#630](https://github.com/apache/arrow-datafusion/pull/630) ([houqp](https://github.com/houqp))
- use Into\<String\> as argument type wherever applicable [\#615](https://github.com/apache/arrow-datafusion/pull/615) ([houqp](https://github.com/houqp))
- reuse alias map in aggregate logical planning and refactor position resolution [\#606](https://github.com/apache/arrow-datafusion/pull/606) ([Jimexist](https://github.com/Jimexist))
- fix clippy warnings [\#581](https://github.com/apache/arrow-datafusion/pull/581) ([Jimexist](https://github.com/Jimexist))
- Add benchmarks to window function queries [\#564](https://github.com/apache/arrow-datafusion/pull/564) ([Jimexist](https://github.com/Jimexist))
- reuse code for now function expr creation [\#548](https://github.com/apache/arrow-datafusion/pull/548) ([houqp](https://github.com/houqp))
- turn on clippy rule for needless borrow [\#545](https://github.com/apache/arrow-datafusion/pull/545) ([Jimexist](https://github.com/Jimexist))
- Refactor hash aggregates's planner building code [\#539](https://github.com/apache/arrow-datafusion/pull/539) ([Jimexist](https://github.com/Jimexist))
- Cleanup Repartition Exec code [\#538](https://github.com/apache/arrow-datafusion/pull/538) ([alamb](https://github.com/alamb))
- reuse datafusion physical planner in ballista building from protobuf [\#532](https://github.com/apache/arrow-datafusion/pull/532) ([Jimexist](https://github.com/Jimexist))
- remove redundant `into_iter()` calls [\#527](https://github.com/apache/arrow-datafusion/pull/527) ([Jimexist](https://github.com/Jimexist))
- Fix 517 - move `window_frames` module to `logical_plan` [\#518](https://github.com/apache/arrow-datafusion/pull/518) ([Jimexist](https://github.com/Jimexist))
- Refactor window aggregation, simplify batch processing logic [\#516](https://github.com/apache/arrow-datafusion/pull/516) ([Jimexist](https://github.com/Jimexist))
- Add datafusion::test\_util, resolve test data paths without env vars [\#498](https://github.com/apache/arrow-datafusion/pull/498) ([mluts](https://github.com/mluts))
- Avoid warnings in tests when compiling without default features [\#489](https://github.com/apache/arrow-datafusion/pull/489) ([alamb](https://github.com/alamb))
- update cargo.toml in python crate and fix unit test due to hash joins [\#483](https://github.com/apache/arrow-datafusion/pull/483) ([Jimexist](https://github.com/Jimexist))
- use prettier check in CI [\#453](https://github.com/apache/arrow-datafusion/pull/453) ([Jimexist](https://github.com/Jimexist))
- Optimize `nth_value`, remove `first_value`, `last_value` structs and use idiomatic rust style [\#452](https://github.com/apache/arrow-datafusion/pull/452) ([Jimexist](https://github.com/Jimexist))
- Fixed typo / logical merge conflict [\#433](https://github.com/apache/arrow-datafusion/pull/433) ([jorgecarleitao](https://github.com/jorgecarleitao))
- include test data and add aggregation tests in integration test [\#425](https://github.com/apache/arrow-datafusion/pull/425) ([Jimexist](https://github.com/Jimexist))
- Add some padding around the logo [\#411](https://github.com/apache/arrow-datafusion/pull/411) ([parthsarthy](https://github.com/parthsarthy))
- Benchmark subcommand to distinguish between DataFusion and Ballista [\#402](https://github.com/apache/arrow-datafusion/pull/402) ([jgoday](https://github.com/jgoday))
- refactor datafusion/`scalar_value` to use more macro and avoid dup code [\#392](https://github.com/apache/arrow-datafusion/pull/392) ([Jimexist](https://github.com/Jimexist))
- Update TPC-H benchmark to show physical plan when debug mode is enabled [\#386](https://github.com/apache/arrow-datafusion/pull/386) ([andygrove](https://github.com/andygrove))
- Update arrow dependencies again [\#341](https://github.com/apache/arrow-datafusion/pull/341) ([alamb](https://github.com/alamb))
- Update arrow-rs deps [\#317](https://github.com/apache/arrow-datafusion/pull/317) ([alamb](https://github.com/alamb))
- Update PR template by commenting out instructions [\#315](https://github.com/apache/arrow-datafusion/pull/315) ([alamb](https://github.com/alamb))
- fix clippy warning [\#286](https://github.com/apache/arrow-datafusion/pull/286) ([Jimexist](https://github.com/Jimexist))
- add integration test to compare datafusion-cli against psql [\#281](https://github.com/apache/arrow-datafusion/pull/281) ([Jimexist](https://github.com/Jimexist))
- Update arrow deps [\#269](https://github.com/apache/arrow-datafusion/pull/269) ([alamb](https://github.com/alamb))
- Use multi-stage build dockerfile in datafusion-cli and reduce image size from 2.16GB to 89.9MB [\#266](https://github.com/apache/arrow-datafusion/pull/266) ([Jimexist](https://github.com/Jimexist))
- Enable redundant\_field\_names clippy lint [\#261](https://github.com/apache/arrow-datafusion/pull/261) ([Dandandan](https://github.com/Dandandan))
- fix clippy lint [\#259](https://github.com/apache/arrow-datafusion/pull/259) ([alamb](https://github.com/alamb))
- Move datafusion-cli to new crate [\#231](https://github.com/apache/arrow-datafusion/pull/231) ([Dandandan](https://github.com/Dandandan))
- Make test join\_with\_hash\_collision deterministic [\#229](https://github.com/apache/arrow-datafusion/pull/229) ([Dandandan](https://github.com/Dandandan))
- Update arrow-rs deps \(to fix build due to flatbuffers update\) [\#224](https://github.com/apache/arrow-datafusion/pull/224) ([alamb](https://github.com/alamb))
- Use standard make\_null\_array for CASE [\#223](https://github.com/apache/arrow-datafusion/pull/223) ([alamb](https://github.com/alamb))
- update arrow-rs deps to latest master [\#216](https://github.com/apache/arrow-datafusion/pull/216) ([alamb](https://github.com/alamb))
- MINOR: Remove empty rust dir [\#61](https://github.com/apache/arrow-datafusion/pull/61) ([andygrove](https://github.com/andygrove))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
