// Code generated by _tmpl/utils.c.tmpl. DO NOT EDIT.

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// clang-format off
//go:build driverlib
//  clang-format on

#include "utils.h"

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

void Snowflake_release_error(struct AdbcError* error) {
  free(error->message);
  error->message = NULL;
  error->release = NULL;
}

void SnowflakeReleaseErrWithDetails(struct AdbcError* error) {
  if (!error || error->release != SnowflakeReleaseErrWithDetails ||
      !error->private_data) {
    return;
  }

  struct SnowflakeError* details =
      (struct SnowflakeError*) error->private_data;
  for (int i = 0; i < details->count; i++) {
    free(details->keys[i]);
    free(details->values[i]);
  }
  free(details->keys);
  free(details->values);
  free(details->lengths);
  free(details);

  free(error->message);
  error->message = NULL;
  error->release = NULL;
  error->private_data = NULL;
}

int SnowflakeErrorGetDetailCount(const struct AdbcError* error) {
  if (!error || error->release != SnowflakeReleaseErrWithDetails ||
      !error->private_data) {
    return 0;
  }

  return ((struct SnowflakeError*) error->private_data)->count;
}

struct AdbcErrorDetail SnowflakeErrorGetDetail(const struct AdbcError* error,
                                                 int index) {
  if (!error || error->release != SnowflakeReleaseErrWithDetails ||
      !error->private_data) {
    return (struct AdbcErrorDetail){NULL, NULL, 0};
  }
  struct SnowflakeError* details = (struct SnowflakeError*) error->private_data;
  if (index < 0 || index >= details->count) {
    return (struct AdbcErrorDetail){NULL, NULL, 0};
  }

  return (struct AdbcErrorDetail){
    .key = details->keys[index],
    .value = details->values[index],
    .value_length = details->lengths[index]
  };
}

#if !defined(ADBC_NO_COMMON_ENTRYPOINTS)
int AdbcErrorGetDetailCount(const struct AdbcError* error) {
  return SnowflakeErrorGetDetailCount(error);
}

struct AdbcErrorDetail AdbcErrorGetDetail(const struct AdbcError* error, int index) {
  return SnowflakeErrorGetDetail(error, index);
}

const struct AdbcError* AdbcErrorFromArrayStream(struct ArrowArrayStream* stream,
                                                 AdbcStatusCode* status) {
  return SnowflakeErrorFromArrayStream(stream, status);
}

AdbcStatusCode AdbcDatabaseGetOption(struct AdbcDatabase* database, const char* key,
                                     char* value, size_t* length,
                                     struct AdbcError* error) {
  return SnowflakeDatabaseGetOption(database, key, value, length, error);
}

AdbcStatusCode AdbcDatabaseGetOptionBytes(struct AdbcDatabase* database, const char* key,
                                          uint8_t* value, size_t* length,
                                          struct AdbcError* error) {
  return SnowflakeDatabaseGetOptionBytes(database, key, value, length, error);
}

AdbcStatusCode AdbcDatabaseGetOptionDouble(struct AdbcDatabase* database, const char* key,
                                           double* value, struct AdbcError* error) {
  return SnowflakeDatabaseGetOptionDouble(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseGetOptionInt(struct AdbcDatabase* database, const char* key,
                                        int64_t* value, struct AdbcError* error) {
  return SnowflakeDatabaseGetOptionInt(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseInit(struct AdbcDatabase* database, struct AdbcError* error) {
  return SnowflakeDatabaseInit(database, error);
}

AdbcStatusCode AdbcDatabaseNew(struct AdbcDatabase* database, struct AdbcError* error) {
  return SnowflakeDatabaseNew(database, error);
}

AdbcStatusCode AdbcDatabaseRelease(struct AdbcDatabase* database,
                                   struct AdbcError* error) {
  return SnowflakeDatabaseRelease(database, error);
}

AdbcStatusCode AdbcDatabaseSetOption(struct AdbcDatabase* database, const char* key,
                                     const char* value, struct AdbcError* error) {
  return SnowflakeDatabaseSetOption(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseSetOptionBytes(struct AdbcDatabase* database, const char* key,
                                          const uint8_t* value, size_t length,
                                          struct AdbcError* error) {
  return SnowflakeDatabaseSetOptionBytes(database, key, value, length, error);
}

AdbcStatusCode AdbcDatabaseSetOptionDouble(struct AdbcDatabase* database, const char* key,
                                           double value, struct AdbcError* error) {
  return SnowflakeDatabaseSetOptionDouble(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseSetOptionInt(struct AdbcDatabase* database, const char* key,
                                        int64_t value, struct AdbcError* error) {
  return SnowflakeDatabaseSetOptionInt(database, key, value, error);
}

AdbcStatusCode AdbcConnectionCancel(struct AdbcConnection* connection,
                                    struct AdbcError* error) {
  return SnowflakeConnectionCancel(connection, error);
}

AdbcStatusCode AdbcConnectionCommit(struct AdbcConnection* connection,
                                    struct AdbcError* error) {
  return SnowflakeConnectionCommit(connection, error);
}

AdbcStatusCode AdbcConnectionGetInfo(struct AdbcConnection* connection,
                                     const uint32_t* info_codes, size_t info_codes_length,
                                     struct ArrowArrayStream* out,
                                     struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return SnowflakeConnectionGetInfo(connection, info_codes, info_codes_length,
                                      out, error);
}

AdbcStatusCode AdbcConnectionGetObjects(struct AdbcConnection* connection, int depth,
                                        const char* catalog, const char* db_schema,
                                        const char* table_name, const char** table_type,
                                        const char* column_name,
                                        struct ArrowArrayStream* out,
                                        struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return SnowflakeConnectionGetObjects(connection, depth, catalog, db_schema, table_name,
                                         table_type, column_name, out, error);
}

AdbcStatusCode AdbcConnectionGetOption(struct AdbcConnection* connection, const char* key,
                                       char* value, size_t* length,
                                       struct AdbcError* error) {
  return SnowflakeConnectionGetOption(connection, key, value, length, error);
}

AdbcStatusCode AdbcConnectionGetOptionBytes(struct AdbcConnection* connection,
                                            const char* key, uint8_t* value,
                                            size_t* length, struct AdbcError* error) {
  return SnowflakeConnectionGetOptionBytes(connection, key, value, length, error);
}

AdbcStatusCode AdbcConnectionGetOptionDouble(struct AdbcConnection* connection,
                                             const char* key, double* value,
                                             struct AdbcError* error) {
  return SnowflakeConnectionGetOptionDouble(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionGetOptionInt(struct AdbcConnection* connection,
                                          const char* key, int64_t* value,
                                          struct AdbcError* error) {
  return SnowflakeConnectionGetOptionInt(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionGetStatistics(struct AdbcConnection* connection,
                                           const char* catalog, const char* db_schema,
                                           const char* table_name, char approximate,
                                           struct ArrowArrayStream* out,
                                           struct AdbcError* error) {
  return SnowflakeConnectionGetStatistics(connection, catalog, db_schema, table_name,
                                            approximate, out, error);
}

AdbcStatusCode AdbcConnectionGetStatisticNames(struct AdbcConnection* connection,
                                               struct ArrowArrayStream* out,
                                               struct AdbcError* error) {
  return SnowflakeConnectionGetStatisticNames(connection, out, error);
}

AdbcStatusCode AdbcConnectionGetTableSchema(struct AdbcConnection* connection,
                                            const char* catalog, const char* db_schema,
                                            const char* table_name,
                                            struct ArrowSchema* schema,
                                            struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  return SnowflakeConnectionGetTableSchema(connection, catalog, db_schema, table_name,
                                        schema, error);
}

AdbcStatusCode AdbcConnectionGetTableTypes(struct AdbcConnection* connection,
                                           struct ArrowArrayStream* out,
                                           struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return SnowflakeConnectionGetTableTypes(connection, out, error);
}

AdbcStatusCode AdbcConnectionInit(struct AdbcConnection* connection,
                                  struct AdbcDatabase* database,
                                  struct AdbcError* error) {
  return SnowflakeConnectionInit(connection, database, error);
}

AdbcStatusCode AdbcConnectionNew(struct AdbcConnection* connection,
                                 struct AdbcError* error) {
  return SnowflakeConnectionNew(connection, error);
}

AdbcStatusCode AdbcConnectionReadPartition(struct AdbcConnection* connection,
                                           const uint8_t* serialized_partition,
                                           size_t serialized_length,
                                           struct ArrowArrayStream* out,
                                           struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return SnowflakeConnectionReadPartition(connection, serialized_partition,
                                       serialized_length, out, error);
}

AdbcStatusCode AdbcConnectionRelease(struct AdbcConnection* connection,
                                     struct AdbcError* error) {
  return SnowflakeConnectionRelease(connection, error);
}

AdbcStatusCode AdbcConnectionRollback(struct AdbcConnection* connection,
                                      struct AdbcError* error) {
  return SnowflakeConnectionRollback(connection, error);
}

AdbcStatusCode AdbcConnectionSetOption(struct AdbcConnection* connection, const char* key,
                                       const char* value, struct AdbcError* error) {
  return SnowflakeConnectionSetOption(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionSetOptionBytes(struct AdbcConnection* connection,
                                            const char* key, const uint8_t* value,
                                            size_t length, struct AdbcError* error) {
  return SnowflakeConnectionSetOptionBytes(connection, key, value, length, error);
}

AdbcStatusCode AdbcConnectionSetOptionDouble(struct AdbcConnection* connection,
                                             const char* key, double value,
                                             struct AdbcError* error) {
  return SnowflakeConnectionSetOptionDouble(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionSetOptionInt(struct AdbcConnection* connection,
                                          const char* key, int64_t value,
                                          struct AdbcError* error) {
  return SnowflakeConnectionSetOptionInt(connection, key, value, error);
}

AdbcStatusCode AdbcStatementCancel(struct AdbcStatement* statement,
                                   struct AdbcError* error) {
  return SnowflakeStatementCancel(statement, error);
}

AdbcStatusCode AdbcStatementBind(struct AdbcStatement* statement,
                                 struct ArrowArray* values, struct ArrowSchema* schema,
                                 struct AdbcError* error) {
  return SnowflakeStatementBind(statement, values, schema, error);
}

AdbcStatusCode AdbcStatementBindStream(struct AdbcStatement* statement,
                                       struct ArrowArrayStream* stream,
                                       struct AdbcError* error) {
  return SnowflakeStatementBindStream(statement, stream, error);
}

AdbcStatusCode AdbcStatementExecutePartitions(struct AdbcStatement* statement,
                                              struct ArrowSchema* schema,
                                              struct AdbcPartitions* partitions,
                                              int64_t* rows_affected,
                                              struct AdbcError* error) {
  return SnowflakeStatementExecutePartitionsTrampoline(
    statement, schema, partitions, rows_affected, error);
}

AdbcStatusCode SnowflakeStatementExecutePartitionsTrampoline(
    struct AdbcStatement* statement,
    struct ArrowSchema* schema,
    struct AdbcPartitions* partitions,
    int64_t* rows_affected,
    struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  if (partitions) memset(partitions, 0, sizeof(*partitions));
  return SnowflakeStatementExecutePartitions(statement, schema, partitions,
                                               rows_affected, error);
}

AdbcStatusCode AdbcStatementExecuteQuery(struct AdbcStatement* statement,
                                         struct ArrowArrayStream* out,
                                         int64_t* rows_affected,
                                         struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return SnowflakeStatementExecuteQuery(statement, out, rows_affected, error);
}

AdbcStatusCode AdbcStatementExecuteSchema(struct AdbcStatement* statement,
                                          struct ArrowSchema* schema,
                                          struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  return SnowflakeStatementExecuteSchema(statement, schema, error);
}

AdbcStatusCode AdbcStatementGetOption(struct AdbcStatement* statement, const char* key,
                                      char* value, size_t* length,
                                      struct AdbcError* error) {
  return SnowflakeStatementGetOption(statement, key, value, length, error);
}

AdbcStatusCode AdbcStatementGetOptionBytes(struct AdbcStatement* statement,
                                           const char* key, uint8_t* value,
                                           size_t* length, struct AdbcError* error) {
  return SnowflakeStatementGetOptionBytes(statement, key, value, length, error);
}

AdbcStatusCode AdbcStatementGetOptionDouble(struct AdbcStatement* statement,
                                            const char* key, double* value,
                                            struct AdbcError* error) {
  return SnowflakeStatementGetOptionDouble(statement, key, value, error);
}

AdbcStatusCode AdbcStatementGetOptionInt(struct AdbcStatement* statement,
                                         const char* key, int64_t* value,
                                         struct AdbcError* error) {
  return SnowflakeStatementGetOptionInt(statement, key, value, error);
}

AdbcStatusCode AdbcStatementGetParameterSchema(struct AdbcStatement* statement,
                                               struct ArrowSchema* schema,
                                               struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  return SnowflakeStatementGetParameterSchema(statement, schema, error);
}

AdbcStatusCode AdbcStatementNew(struct AdbcConnection* connection,
                                struct AdbcStatement* statement,
                                struct AdbcError* error) {
  return SnowflakeStatementNew(connection, statement, error);
}

AdbcStatusCode AdbcStatementPrepare(struct AdbcStatement* statement,
                                    struct AdbcError* error) {
  return SnowflakeStatementPrepare(statement, error);
}

AdbcStatusCode AdbcStatementRelease(struct AdbcStatement* statement,
                                    struct AdbcError* error) {
  return SnowflakeStatementRelease(statement, error);
}

AdbcStatusCode AdbcStatementSetSqlQuery(struct AdbcStatement* statement,
                                        const char* query, struct AdbcError* error) {
  return SnowflakeStatementSetSqlQuery(statement, query, error);
}

AdbcStatusCode AdbcStatementSetSubstraitPlan(struct AdbcStatement* statement,
                                             const uint8_t* plan, size_t length,
                                             struct AdbcError* error) {
  return SnowflakeStatementSetSubstraitPlan(statement, plan, length, error);
}

AdbcStatusCode AdbcStatementSetOption(struct AdbcStatement* statement, const char* key,
                                      const char* value, struct AdbcError* error) {
  return SnowflakeStatementSetOption(statement, key, value, error);
}

AdbcStatusCode AdbcStatementSetOptionBytes(struct AdbcStatement* statement,
                                           const char* key, const uint8_t* value,
                                           size_t length, struct AdbcError* error) {
  return SnowflakeStatementSetOptionBytes(statement, key, value, length, error);
}

AdbcStatusCode AdbcStatementSetOptionDouble(struct AdbcStatement* statement,
                                            const char* key, double value,
                                            struct AdbcError* error) {
  return SnowflakeStatementSetOptionDouble(statement, key, value, error);
}

AdbcStatusCode AdbcStatementSetOptionInt(struct AdbcStatement* statement,
                                         const char* key, int64_t value,
                                         struct AdbcError* error) {
  return SnowflakeStatementSetOptionInt(statement, key, value, error);
}

ADBC_EXPORT
AdbcStatusCode AdbcDriverInit(int version, void* driver, struct AdbcError* error) {
  return AdbcDriverSnowflakeInit(version, driver, error);
}
#endif  // ADBC_NO_COMMON_ENTRYPOINTS

ADBC_EXPORT
AdbcStatusCode SnowflakeDriverInit(int version, void* driver, struct AdbcError* error) {
  // For backwards compatibility
  return AdbcDriverSnowflakeInit(version, driver, error);
}

int SnowflakeArrayStreamGetSchema(struct ArrowArrayStream*, struct ArrowSchema*);
int SnowflakeArrayStreamGetNext(struct ArrowArrayStream*, struct ArrowArray*);

int SnowflakeArrayStreamGetSchemaTrampoline(struct ArrowArrayStream* stream,
                                              struct ArrowSchema* out) {
  // XXX(https://github.com/apache/arrow-adbc/issues/729)
  memset(out, 0, sizeof(*out));
  return SnowflakeArrayStreamGetSchema(stream, out);
}

int SnowflakeArrayStreamGetNextTrampoline(struct ArrowArrayStream* stream,
                                            struct ArrowArray* out) {
  // XXX(https://github.com/apache/arrow-adbc/issues/729)
  memset(out, 0, sizeof(*out));
  return SnowflakeArrayStreamGetNext(stream, out);
}

#ifdef __cplusplus
}
#endif
