/**
 * Autogenerated by Thrift Compiler (0.17.0)
 * BUT THIS FILE HAS BEEN HAND EDITED TO SUPPORT ARROW SO REGENERATE AT YOUR OWN RISK
 */
using System;
using System.Buffers.Binary;
using System.IO;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using Apache.Arrow;
using Apache.Arrow.Adbc.Drivers.Apache;
using Apache.Arrow.Adbc.Drivers.Apache.Thrift;
using Thrift.Protocol;
using Thrift.Protocol.Entities;
using Thrift.Protocol.Utilities;

#nullable disable

#pragma warning disable IDE0079  // remove unnecessary pragmas
#pragma warning disable IDE0017  // object init can be simplified
#pragma warning disable IDE0028  // collection init can be simplified
#pragma warning disable IDE1006  // parts of the code use IDL spelling
#pragma warning disable CA1822   // empty DeepCopy() methods still non-static
#pragma warning disable IDE0083  // pattern matching "that is not SomeType" requires net5.0 but we still support earlier versions

namespace Apache.Hive.Service.Rpc.Thrift
{

  public partial class TByteColumn : TBase
  {

    public Int8Array Values { get; set; }

    public TByteColumn()
    {
    }

    public TByteColumn(Int8Array values) : this()
    {
      this.Values = values;
    }

    public TByteColumn DeepCopy()
    {
      throw new NotImplementedException();
    }

    public async global::System.Threading.Tasks.Task ReadAsync(TProtocol iprot, CancellationToken cancellationToken)
    {
      iprot.IncrementRecursionDepth();
      try
      {
        bool isset_values = false;
        bool isset_nulls = false;
        TField field;

        byte[] nulls = null;
        byte[] buffer = null;
        Stream transport = ((IPeekableTransport)iprot.Transport).Input;
        int length = -1;

        await iprot.ReadStructBeginAsync(cancellationToken);
        while (true)
        {
          field = await iprot.ReadFieldBeginAsync(cancellationToken);
          if (field.Type == TType.Stop)
          {
            break;
          }

          switch (field.ID)
          {
            case 1:
              if (field.Type == TType.List)
              {
                {
                  var _list142 = await iprot.ReadListBeginAsync(cancellationToken);
                  length = _list142.Count;

                  buffer = new byte[length];
                  var memory = buffer.AsMemory();
                  iprot.Transport.CheckReadBytesAvailable(buffer.Length);
                  await transport.ReadExactlyAsync(memory, cancellationToken);

                  await iprot.ReadListEndAsync(cancellationToken);
                }
                isset_values = true;
              }
              else
              {
                await TProtocolUtil.SkipAsync(iprot, field.Type, cancellationToken);
              }
              break;
            case 2:
              if (field.Type == TType.String)
              {
                nulls = await iprot.ReadBinaryAsync(cancellationToken);
                isset_nulls = true;
              }
              else
              {
                await TProtocolUtil.SkipAsync(iprot, field.Type, cancellationToken);
              }
              break;
            default:
              await TProtocolUtil.SkipAsync(iprot, field.Type, cancellationToken);
              break;
          }

          await iprot.ReadFieldEndAsync(cancellationToken);
        }

        await iprot.ReadStructEndAsync(cancellationToken);
        if (!isset_values)
        {
          throw new TProtocolException(TProtocolException.INVALID_DATA);
        }
        if (!isset_nulls)
        {
          throw new TProtocolException(TProtocolException.INVALID_DATA);
        }
        ArrowBuffer validityBitmapBuffer = BitmapUtilities.GetValidityBitmapBuffer(ref nulls, length, out int nullCount);
        Values = new Int8Array(new ArrowBuffer(buffer), validityBitmapBuffer, length, nullCount, 0);
      }
      finally
      {
        iprot.DecrementRecursionDepth();
      }
    }

    public async global::System.Threading.Tasks.Task WriteAsync(TProtocol oprot, CancellationToken cancellationToken)
    {
      oprot.IncrementRecursionDepth();
      try
      {
        var tmp145 = new TStruct("TByteColumn");
        await oprot.WriteStructBeginAsync(tmp145, cancellationToken);
        var tmp146 = new TField();
        if ((Values != null))
        {
          tmp146.Name = "values";
          tmp146.Type = TType.List;
          tmp146.ID = 1;
          await oprot.WriteFieldBeginAsync(tmp146, cancellationToken);
          await oprot.WriteListBeginAsync(new TList(TType.Byte, Values.Length), cancellationToken);
          for (int i = 0; i < Values.Length; i++)
          {
            sbyte _iter147 = Values.GetValue(i) ?? 0;
            await oprot.WriteByteAsync(_iter147, cancellationToken);
          }
          await oprot.WriteListEndAsync(cancellationToken);
          await oprot.WriteFieldEndAsync(cancellationToken);

          tmp146.Name = "nulls";
          tmp146.Type = TType.String;
          tmp146.ID = 2;
          byte[] nulls = new byte[Values.NullBitmapBuffer.Span.Length];
          Values.NullBitmapBuffer.Span.CopyTo(nulls);
          await oprot.WriteFieldBeginAsync(tmp146, cancellationToken);
          await oprot.WriteBinaryAsync(nulls, cancellationToken);
          await oprot.WriteFieldEndAsync(cancellationToken);
        }
        await oprot.WriteFieldStopAsync(cancellationToken);
        await oprot.WriteStructEndAsync(cancellationToken);
      }
      finally
      {
        oprot.DecrementRecursionDepth();
      }
    }

    public override bool Equals(object that)
    {
      if (!(that is TByteColumn other)) return false;
      if (ReferenceEquals(this, other)) return true;
      throw new NotImplementedException();
    }

    public override int GetHashCode()
    {
      throw new NotImplementedException();
    }

    public override string ToString()
    {
      var tmp148 = new StringBuilder("TByteColumn(");
      if ((Values != null))
      {
        tmp148.Append(", Values: ");
        Values.ToString(tmp148);
      }
      tmp148.Append(')');
      return tmp148.ToString();
    }
  }

}
