// Code generated by _tmpl/utils.c.tmpl. DO NOT EDIT.

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// clang-format off
//go:build driverlib
//  clang-format on

#include "utils.h"

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

void FlightSQL_release_error(struct AdbcError* error) {
  free(error->message);
  error->message = NULL;
  error->release = NULL;
}

void FlightSQLReleaseErrWithDetails(struct AdbcError* error) {
  if (!error || error->release != FlightSQLReleaseErrWithDetails ||
      !error->private_data) {
    return;
  }

  struct FlightSQLError* details =
      (struct FlightSQLError*) error->private_data;
  for (int i = 0; i < details->count; i++) {
    free(details->keys[i]);
    free(details->values[i]);
  }
  free(details->keys);
  free(details->values);
  free(details->lengths);
  free(details);

  free(error->message);
  error->message = NULL;
  error->release = NULL;
  error->private_data = NULL;
}

int FlightSQLErrorGetDetailCount(const struct AdbcError* error) {
  if (!error || error->release != FlightSQLReleaseErrWithDetails ||
      !error->private_data) {
    return 0;
  }

  return ((struct FlightSQLError*) error->private_data)->count;
}

struct AdbcErrorDetail FlightSQLErrorGetDetail(const struct AdbcError* error,
                                                 int index) {
  if (!error || error->release != FlightSQLReleaseErrWithDetails ||
      !error->private_data) {
    return (struct AdbcErrorDetail){NULL, NULL, 0};
  }
  struct FlightSQLError* details = (struct FlightSQLError*) error->private_data;
  if (index < 0 || index >= details->count) {
    return (struct AdbcErrorDetail){NULL, NULL, 0};
  }

  return (struct AdbcErrorDetail){
    .key = details->keys[index],
    .value = details->values[index],
    .value_length = details->lengths[index]
  };
}

int AdbcErrorGetDetailCount(const struct AdbcError* error) {
  return FlightSQLErrorGetDetailCount(error);
}

struct AdbcErrorDetail AdbcErrorGetDetail(const struct AdbcError* error, int index) {
  return FlightSQLErrorGetDetail(error, index);
}

const struct AdbcError* AdbcErrorFromArrayStream(struct ArrowArrayStream* stream,
                                                 AdbcStatusCode* status) {
  return FlightSQLErrorFromArrayStream(stream, status);
}

AdbcStatusCode AdbcDatabaseGetOption(struct AdbcDatabase* database, const char* key,
                                     char* value, size_t* length,
                                     struct AdbcError* error) {
  return FlightSQLDatabaseGetOption(database, key, value, length, error);
}

AdbcStatusCode AdbcDatabaseGetOptionBytes(struct AdbcDatabase* database, const char* key,
                                          uint8_t* value, size_t* length,
                                          struct AdbcError* error) {
  return FlightSQLDatabaseGetOptionBytes(database, key, value, length, error);
}

AdbcStatusCode AdbcDatabaseGetOptionDouble(struct AdbcDatabase* database, const char* key,
                                           double* value, struct AdbcError* error) {
  return FlightSQLDatabaseGetOptionDouble(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseGetOptionInt(struct AdbcDatabase* database, const char* key,
                                        int64_t* value, struct AdbcError* error) {
  return FlightSQLDatabaseGetOptionInt(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseInit(struct AdbcDatabase* database, struct AdbcError* error) {
  return FlightSQLDatabaseInit(database, error);
}

AdbcStatusCode AdbcDatabaseNew(struct AdbcDatabase* database, struct AdbcError* error) {
  return FlightSQLDatabaseNew(database, error);
}

AdbcStatusCode AdbcDatabaseRelease(struct AdbcDatabase* database,
                                   struct AdbcError* error) {
  return FlightSQLDatabaseRelease(database, error);
}

AdbcStatusCode AdbcDatabaseSetOption(struct AdbcDatabase* database, const char* key,
                                     const char* value, struct AdbcError* error) {
  return FlightSQLDatabaseSetOption(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseSetOptionBytes(struct AdbcDatabase* database, const char* key,
                                          const uint8_t* value, size_t length,
                                          struct AdbcError* error) {
  return FlightSQLDatabaseSetOptionBytes(database, key, value, length, error);
}

AdbcStatusCode AdbcDatabaseSetOptionDouble(struct AdbcDatabase* database, const char* key,
                                           double value, struct AdbcError* error) {
  return FlightSQLDatabaseSetOptionDouble(database, key, value, error);
}

AdbcStatusCode AdbcDatabaseSetOptionInt(struct AdbcDatabase* database, const char* key,
                                        int64_t value, struct AdbcError* error) {
  return FlightSQLDatabaseSetOptionInt(database, key, value, error);
}

AdbcStatusCode AdbcConnectionCancel(struct AdbcConnection* connection,
                                    struct AdbcError* error) {
  return FlightSQLConnectionCancel(connection, error);
}

AdbcStatusCode AdbcConnectionCommit(struct AdbcConnection* connection,
                                    struct AdbcError* error) {
  return FlightSQLConnectionCommit(connection, error);
}

AdbcStatusCode AdbcConnectionGetInfo(struct AdbcConnection* connection,
                                     const uint32_t* info_codes, size_t info_codes_length,
                                     struct ArrowArrayStream* out,
                                     struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return FlightSQLConnectionGetInfo(connection, info_codes, info_codes_length,
                                      out, error);
}

AdbcStatusCode AdbcConnectionGetObjects(struct AdbcConnection* connection, int depth,
                                        const char* catalog, const char* db_schema,
                                        const char* table_name, const char** table_type,
                                        const char* column_name,
                                        struct ArrowArrayStream* out,
                                        struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return FlightSQLConnectionGetObjects(connection, depth, catalog, db_schema, table_name,
                                         table_type, column_name, out, error);
}

AdbcStatusCode AdbcConnectionGetOption(struct AdbcConnection* connection, const char* key,
                                       char* value, size_t* length,
                                       struct AdbcError* error) {
  return FlightSQLConnectionGetOption(connection, key, value, length, error);
}

AdbcStatusCode AdbcConnectionGetOptionBytes(struct AdbcConnection* connection,
                                            const char* key, uint8_t* value,
                                            size_t* length, struct AdbcError* error) {
  return FlightSQLConnectionGetOptionBytes(connection, key, value, length, error);
}

AdbcStatusCode AdbcConnectionGetOptionDouble(struct AdbcConnection* connection,
                                             const char* key, double* value,
                                             struct AdbcError* error) {
  return FlightSQLConnectionGetOptionDouble(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionGetOptionInt(struct AdbcConnection* connection,
                                          const char* key, int64_t* value,
                                          struct AdbcError* error) {
  return FlightSQLConnectionGetOptionInt(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionGetStatistics(struct AdbcConnection* connection,
                                           const char* catalog, const char* db_schema,
                                           const char* table_name, char approximate,
                                           struct ArrowArrayStream* out,
                                           struct AdbcError* error) {
  return FlightSQLConnectionGetStatistics(connection, catalog, db_schema, table_name,
                                            approximate, out, error);
}

AdbcStatusCode AdbcConnectionGetStatisticNames(struct AdbcConnection* connection,
                                               struct ArrowArrayStream* out,
                                               struct AdbcError* error) {
  return FlightSQLConnectionGetStatisticNames(connection, out, error);
}

AdbcStatusCode AdbcConnectionGetTableSchema(struct AdbcConnection* connection,
                                            const char* catalog, const char* db_schema,
                                            const char* table_name,
                                            struct ArrowSchema* schema,
                                            struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  return FlightSQLConnectionGetTableSchema(connection, catalog, db_schema, table_name,
                                        schema, error);
}

AdbcStatusCode AdbcConnectionGetTableTypes(struct AdbcConnection* connection,
                                           struct ArrowArrayStream* out,
                                           struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return FlightSQLConnectionGetTableTypes(connection, out, error);
}

AdbcStatusCode AdbcConnectionInit(struct AdbcConnection* connection,
                                  struct AdbcDatabase* database,
                                  struct AdbcError* error) {
  return FlightSQLConnectionInit(connection, database, error);
}

AdbcStatusCode AdbcConnectionNew(struct AdbcConnection* connection,
                                 struct AdbcError* error) {
  return FlightSQLConnectionNew(connection, error);
}

AdbcStatusCode AdbcConnectionReadPartition(struct AdbcConnection* connection,
                                           const uint8_t* serialized_partition,
                                           size_t serialized_length,
                                           struct ArrowArrayStream* out,
                                           struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return FlightSQLConnectionReadPartition(connection, serialized_partition,
                                       serialized_length, out, error);
}

AdbcStatusCode AdbcConnectionRelease(struct AdbcConnection* connection,
                                     struct AdbcError* error) {
  return FlightSQLConnectionRelease(connection, error);
}

AdbcStatusCode AdbcConnectionRollback(struct AdbcConnection* connection,
                                      struct AdbcError* error) {
  return FlightSQLConnectionRollback(connection, error);
}

AdbcStatusCode AdbcConnectionSetOption(struct AdbcConnection* connection, const char* key,
                                       const char* value, struct AdbcError* error) {
  return FlightSQLConnectionSetOption(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionSetOptionBytes(struct AdbcConnection* connection,
                                            const char* key, const uint8_t* value,
                                            size_t length, struct AdbcError* error) {
  return FlightSQLConnectionSetOptionBytes(connection, key, value, length, error);
}

AdbcStatusCode AdbcConnectionSetOptionDouble(struct AdbcConnection* connection,
                                             const char* key, double value,
                                             struct AdbcError* error) {
  return FlightSQLConnectionSetOptionDouble(connection, key, value, error);
}

AdbcStatusCode AdbcConnectionSetOptionInt(struct AdbcConnection* connection,
                                          const char* key, int64_t value,
                                          struct AdbcError* error) {
  return FlightSQLConnectionSetOptionInt(connection, key, value, error);
}

AdbcStatusCode AdbcStatementCancel(struct AdbcStatement* statement,
                                   struct AdbcError* error) {
  return FlightSQLStatementCancel(statement, error);
}

AdbcStatusCode AdbcStatementBind(struct AdbcStatement* statement,
                                 struct ArrowArray* values, struct ArrowSchema* schema,
                                 struct AdbcError* error) {
  return FlightSQLStatementBind(statement, values, schema, error);
}

AdbcStatusCode AdbcStatementBindStream(struct AdbcStatement* statement,
                                       struct ArrowArrayStream* stream,
                                       struct AdbcError* error) {
  return FlightSQLStatementBindStream(statement, stream, error);
}

AdbcStatusCode AdbcStatementExecutePartitions(struct AdbcStatement* statement,
                                              struct ArrowSchema* schema,
                                              struct AdbcPartitions* partitions,
                                              int64_t* rows_affected,
                                              struct AdbcError* error) {
  return FlightSQLStatementExecutePartitionsTrampoline(
    statement, schema, partitions, rows_affected, error);
}

AdbcStatusCode FlightSQLStatementExecutePartitionsTrampoline(
    struct AdbcStatement* statement,
    struct ArrowSchema* schema,
    struct AdbcPartitions* partitions,
    int64_t* rows_affected,
    struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  if (partitions) memset(partitions, 0, sizeof(*partitions));
  return FlightSQLStatementExecutePartitions(statement, schema, partitions,
                                               rows_affected, error);
}

AdbcStatusCode AdbcStatementExecuteQuery(struct AdbcStatement* statement,
                                         struct ArrowArrayStream* out,
                                         int64_t* rows_affected,
                                         struct AdbcError* error) {
  if (out) memset(out, 0, sizeof(*out));
  return FlightSQLStatementExecuteQuery(statement, out, rows_affected, error);
}

AdbcStatusCode AdbcStatementExecuteSchema(struct AdbcStatement* statement,
                                          struct ArrowSchema* schema,
                                          struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  return FlightSQLStatementExecuteSchema(statement, schema, error);
}

AdbcStatusCode AdbcStatementGetOption(struct AdbcStatement* statement, const char* key,
                                      char* value, size_t* length,
                                      struct AdbcError* error) {
  return FlightSQLStatementGetOption(statement, key, value, length, error);
}

AdbcStatusCode AdbcStatementGetOptionBytes(struct AdbcStatement* statement,
                                           const char* key, uint8_t* value,
                                           size_t* length, struct AdbcError* error) {
  return FlightSQLStatementGetOptionBytes(statement, key, value, length, error);
}

AdbcStatusCode AdbcStatementGetOptionDouble(struct AdbcStatement* statement,
                                            const char* key, double* value,
                                            struct AdbcError* error) {
  return FlightSQLStatementGetOptionDouble(statement, key, value, error);
}

AdbcStatusCode AdbcStatementGetOptionInt(struct AdbcStatement* statement,
                                         const char* key, int64_t* value,
                                         struct AdbcError* error) {
  return FlightSQLStatementGetOptionInt(statement, key, value, error);
}

AdbcStatusCode AdbcStatementGetParameterSchema(struct AdbcStatement* statement,
                                               struct ArrowSchema* schema,
                                               struct AdbcError* error) {
  if (schema) memset(schema, 0, sizeof(*schema));
  return FlightSQLStatementGetParameterSchema(statement, schema, error);
}

AdbcStatusCode AdbcStatementNew(struct AdbcConnection* connection,
                                struct AdbcStatement* statement,
                                struct AdbcError* error) {
  return FlightSQLStatementNew(connection, statement, error);
}

AdbcStatusCode AdbcStatementPrepare(struct AdbcStatement* statement,
                                    struct AdbcError* error) {
  return FlightSQLStatementPrepare(statement, error);
}

AdbcStatusCode AdbcStatementRelease(struct AdbcStatement* statement,
                                    struct AdbcError* error) {
  return FlightSQLStatementRelease(statement, error);
}

AdbcStatusCode AdbcStatementSetSqlQuery(struct AdbcStatement* statement,
                                        const char* query, struct AdbcError* error) {
  return FlightSQLStatementSetSqlQuery(statement, query, error);
}

AdbcStatusCode AdbcStatementSetSubstraitPlan(struct AdbcStatement* statement,
                                             const uint8_t* plan, size_t length,
                                             struct AdbcError* error) {
  return FlightSQLStatementSetSubstraitPlan(statement, plan, length, error);
}

AdbcStatusCode AdbcStatementSetOption(struct AdbcStatement* statement, const char* key,
                                      const char* value, struct AdbcError* error) {
  return FlightSQLStatementSetOption(statement, key, value, error);
}

AdbcStatusCode AdbcStatementSetOptionBytes(struct AdbcStatement* statement,
                                           const char* key, const uint8_t* value,
                                           size_t length, struct AdbcError* error) {
  return FlightSQLStatementSetOptionBytes(statement, key, value, length, error);
}

AdbcStatusCode AdbcStatementSetOptionDouble(struct AdbcStatement* statement,
                                            const char* key, double value,
                                            struct AdbcError* error) {
  return FlightSQLStatementSetOptionDouble(statement, key, value, error);
}

AdbcStatusCode AdbcStatementSetOptionInt(struct AdbcStatement* statement,
                                         const char* key, int64_t value,
                                         struct AdbcError* error) {
  return FlightSQLStatementSetOptionInt(statement, key, value, error);
}

ADBC_EXPORT
AdbcStatusCode AdbcDriverInit(int version, void* driver, struct AdbcError* error) {
  return FlightSQLDriverInit(version, driver, error);
}

int FlightSQLArrayStreamGetSchema(struct ArrowArrayStream*, struct ArrowSchema*);
int FlightSQLArrayStreamGetNext(struct ArrowArrayStream*, struct ArrowArray*);

int FlightSQLArrayStreamGetSchemaTrampoline(struct ArrowArrayStream* stream,
                                              struct ArrowSchema* out) {
  // XXX(https://github.com/apache/arrow-adbc/issues/729)
  memset(out, 0, sizeof(*out));
  return FlightSQLArrayStreamGetSchema(stream, out);
}

int FlightSQLArrayStreamGetNextTrampoline(struct ArrowArrayStream* stream,
                                            struct ArrowArray* out) {
  // XXX(https://github.com/apache/arrow-adbc/issues/729)
  memset(out, 0, sizeof(*out));
  return FlightSQLArrayStreamGetNext(stream, out);
}

#ifdef __cplusplus
}
#endif
