/**
 * Autogenerated by Thrift Compiler (0.17.0)
 * BUT THIS FILE HAS BEEN HAND EDITED TO SUPPORT ARROW AND DISABLE NULLABLE SO REGENERATE AT YOUR OWN RISK
 */
using System;
using System.Buffers.Binary;
using System.IO;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using Apache.Arrow;
using Apache.Arrow.Adbc.Drivers.Apache;
using Apache.Arrow.Adbc.Drivers.Apache.Thrift;
using Thrift.Protocol;
using Thrift.Protocol.Entities;
using Thrift.Protocol.Utilities;

#nullable disable

#pragma warning disable IDE0079  // remove unnecessary pragmas
#pragma warning disable IDE0017  // object init can be simplified
#pragma warning disable IDE0028  // collection init can be simplified
#pragma warning disable IDE1006  // parts of the code use IDL spelling
#pragma warning disable CA1822   // empty DeepCopy() methods still non-static
#pragma warning disable IDE0083  // pattern matching "that is not SomeType" requires net5.0 but we still support earlier versions

namespace Apache.Hive.Service.Rpc.Thrift
{

  public partial class TDoubleColumn : TBase
  {

    public DoubleArray Values { get; set; }

    public TDoubleColumn()
    {
    }

    public TDoubleColumn(DoubleArray values) : this()
    {
      this.Values = values;
    }

    public TDoubleColumn DeepCopy()
    {
      throw new NotImplementedException();
    }

    public async global::System.Threading.Tasks.Task ReadAsync(TProtocol iprot, CancellationToken cancellationToken)
    {
      iprot.IncrementRecursionDepth();
      try
      {
        bool isset_values = false;
        bool isset_nulls = false;
        TField field;

        byte[] nulls = null;
        byte[] buffer = null;
        Stream transport = ((IPeekableTransport)iprot.Transport).Input;
        int length = -1;

        await iprot.ReadStructBeginAsync(cancellationToken);
        while (true)
        {
          field = await iprot.ReadFieldBeginAsync(cancellationToken);
          if (field.Type == TType.Stop)
          {
            break;
          }

          switch (field.ID)
          {
            case 1:
              if (field.Type == TType.List)
              {
                {
                  var _list178 = await iprot.ReadListBeginAsync(cancellationToken);
                  length = _list178.Count;

                  buffer = new byte[length * 8];
                  var memory = buffer.AsMemory();
                  var typedMemory = Unsafe.As<Memory<byte>, Memory<long>>(ref memory).Slice(0, length);
                  iprot.Transport.CheckReadBytesAvailable(buffer.Length);
                  await transport.ReadExactlyAsync(memory, cancellationToken);
                  for (int _i179 = 0; _i179 < length; ++_i179)
                  {
                    typedMemory.Span[_i179] = BinaryPrimitives.ReverseEndianness(typedMemory.Span[_i179]);
                  }
                  await iprot.ReadListEndAsync(cancellationToken);
                }
                isset_values = true;
              }
              else
              {
                await TProtocolUtil.SkipAsync(iprot, field.Type, cancellationToken);
              }
              break;
            case 2:
              if (field.Type == TType.String)
              {
                nulls = await iprot.ReadBinaryAsync(cancellationToken);
                isset_nulls = true;
              }
              else
              {
                await TProtocolUtil.SkipAsync(iprot, field.Type, cancellationToken);
              }
              break;
            default:
              await TProtocolUtil.SkipAsync(iprot, field.Type, cancellationToken);
              break;
          }

          await iprot.ReadFieldEndAsync(cancellationToken);
        }

        await iprot.ReadStructEndAsync(cancellationToken);
        if (!isset_values)
        {
          throw new TProtocolException(TProtocolException.INVALID_DATA);
        }
        if (!isset_nulls)
        {
          throw new TProtocolException(TProtocolException.INVALID_DATA);
        }

        Values = new DoubleArray(new ArrowBuffer(buffer), new ArrowBuffer(nulls), length, BitUtility.CountBits(nulls), 0);
      }
      finally
      {
        iprot.DecrementRecursionDepth();
      }
    }

    public async global::System.Threading.Tasks.Task WriteAsync(TProtocol oprot, CancellationToken cancellationToken)
    {
      oprot.IncrementRecursionDepth();
      try
      {
        var tmp181 = new TStruct("TDoubleColumn");
        await oprot.WriteStructBeginAsync(tmp181, cancellationToken);
        var tmp182 = new TField();
        if ((Values != null))
        {
          tmp182.Name = "values";
          tmp182.Type = TType.List;
          tmp182.ID = 1;
          await oprot.WriteFieldBeginAsync(tmp182, cancellationToken);
          await oprot.WriteListBeginAsync(new TList(TType.Double, Values.Length), cancellationToken);
          for (int i = 0; i < Values.Length; i++)
          {
            double _iter183 = Values.GetValue(i) ?? 0.0;
            await oprot.WriteDoubleAsync(_iter183, cancellationToken);
          }
          await oprot.WriteListEndAsync(cancellationToken);
          await oprot.WriteFieldEndAsync(cancellationToken);

          tmp182.Name = "nulls";
          tmp182.Type = TType.String;
          tmp182.ID = 2;
          byte[] nulls = new byte[Values.NullBitmapBuffer.Span.Length];
          Values.NullBitmapBuffer.Span.CopyTo(nulls);
          await oprot.WriteFieldBeginAsync(tmp182, cancellationToken);
          await oprot.WriteBinaryAsync(nulls, cancellationToken);
          await oprot.WriteFieldEndAsync(cancellationToken);
        }
        await oprot.WriteFieldStopAsync(cancellationToken);
        await oprot.WriteStructEndAsync(cancellationToken);
      }
      finally
      {
        oprot.DecrementRecursionDepth();
      }
    }

    public override bool Equals(object that)
    {
      if (!(that is TDoubleColumn other)) return false;
      if (ReferenceEquals(this, other)) return true;
      throw new NotImplementedException();
    }

    public override int GetHashCode()
    {
      throw new NotImplementedException();
    }

    public override string ToString()
    {
      var tmp184 = new StringBuilder("TDoubleColumn(");
      if ((Values != null))
      {
        tmp184.Append(", Values: ");
        Values.ToString(tmp184);
      }
      tmp184.Append(')');
      return tmp184.ToString();
    }
  }

}
