// Code generated by _tmpl/utils.h.tmpl. DO NOT EDIT.

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// clang-format off
//go:build driverlib
//  clang-format on

#pragma once

#include <stdlib.h>
#include "../../drivermgr/adbc.h"

AdbcStatusCode SnowflakeDatabaseNew(struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode SnowflakeDatabaseSetOption(struct AdbcDatabase* db, const char* key,
                                          const char* value, struct AdbcError* err);
AdbcStatusCode SnowflakeDatabaseInit(struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode SnowflakeDatabaseRelease(struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionNew(struct AdbcConnection* cnxn, struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionSetOption(struct AdbcConnection* cnxn, const char* key,
                                            const char* val, struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionInit(struct AdbcConnection* cnxn,
                                       struct AdbcDatabase* db, struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionRelease(struct AdbcConnection* cnxn,
                                          struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionGetInfo(struct AdbcConnection* cnxn, uint32_t* codes,
                                          size_t len, struct ArrowArrayStream* out,
                                          struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionGetObjects(
    struct AdbcConnection* cnxn, int depth, const char* catalog, const char* dbSchema,
    const char* tableName, const char** tableType, const char* columnName,
    struct ArrowArrayStream* out, struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionGetTableSchema(
    struct AdbcConnection* cnxn, const char* catalog, const char* dbSchema,
    const char* tableName, struct ArrowSchema* schema, struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionGetTableTypes(struct AdbcConnection* cnxn,
                                                struct ArrowArrayStream* out,
                                                struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionReadPartition(struct AdbcConnection* cnxn,
                                                const uint8_t* serialized,
                                                size_t serializedLen,
                                                struct ArrowArrayStream* out,
                                                struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionCommit(struct AdbcConnection* cnxn,
                                         struct AdbcError* err);
AdbcStatusCode SnowflakeConnectionRollback(struct AdbcConnection* cnxn,
                                           struct AdbcError* err);
AdbcStatusCode SnowflakeStatementNew(struct AdbcConnection* cnxn,
                                     struct AdbcStatement* stmt, struct AdbcError* err);
AdbcStatusCode SnowflakeStatementRelease(struct AdbcStatement* stmt,
                                         struct AdbcError* err);
AdbcStatusCode SnowflakeStatementPrepare(struct AdbcStatement* stmt,
                                         struct AdbcError* err);
AdbcStatusCode SnowflakeStatementExecuteQuery(struct AdbcStatement* stmt,
                                              struct ArrowArrayStream* out,
                                              int64_t* affected, struct AdbcError* err);
AdbcStatusCode SnowflakeStatementSetSqlQuery(struct AdbcStatement* stmt,
                                             const char* query, struct AdbcError* err);
AdbcStatusCode SnowflakeStatementSetSubstraitPlan(struct AdbcStatement* stmt,
                                                  const uint8_t* plan, size_t length,
                                                  struct AdbcError* err);
AdbcStatusCode SnowflakeStatementBind(struct AdbcStatement* stmt,
                                      struct ArrowArray* values,
                                      struct ArrowSchema* schema, struct AdbcError* err);
AdbcStatusCode SnowflakeStatementBindStream(struct AdbcStatement* stmt,
                                            struct ArrowArrayStream* stream,
                                            struct AdbcError* err);
AdbcStatusCode SnowflakeStatementGetParameterSchema(struct AdbcStatement* stmt,
                                                    struct ArrowSchema* schema,
                                                    struct AdbcError* err);
AdbcStatusCode SnowflakeStatementSetOption(struct AdbcStatement* stmt, const char* key,
                                           const char* value, struct AdbcError* err);
AdbcStatusCode SnowflakeStatementExecutePartitions(struct AdbcStatement* stmt,
                                                   struct ArrowSchema* schema,
                                                   struct AdbcPartitions* partitions,
                                                   int64_t* affected,
                                                   struct AdbcError* err);
AdbcStatusCode SnowflakeDriverInit(int version, void* rawDriver, struct AdbcError* err);

static inline void SnowflakeerrRelease(struct AdbcError* error) { error->release(error); }

void Snowflake_release_error(struct AdbcError* error);
