/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.transaction;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;

import javax.xml.validation.Schema;

import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;
import org.xml.sax.SAXException;

public class DummyNamespaceHandlerSet implements NamespaceHandlerSet {
    private Map<URI, NamespaceHandler> nsHandlers;

    public DummyNamespaceHandlerSet(Map<URI, NamespaceHandler> nsHandlers) {
        this.nsHandlers = nsHandlers;
    }

    @Override
    public void addListener(Listener listener) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void destroy() {
    }

    @Override
    public NamespaceHandler getNamespaceHandler(URI nsuri) {
        return nsHandlers.get(nsuri);
    }

    @Override
    public Set<URI> getNamespaces() {
        return nsHandlers.keySet();
    }

    @Override
    public Schema getSchema() throws SAXException, IOException {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public void removeListener(Listener listener) {
        throw new IllegalStateException("Not implemented");
    }

}
