/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.BlueprintStateMBean;
import org.apache.aries.jmx.blueprint.impl.BlueprintMetadata;
import org.apache.aries.jmx.blueprint.impl.BlueprintState;
import org.apache.aries.jmx.blueprint.impl.RegistrableStandardEmitterMBean;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.aries.jmx.blueprint");
    protected BundleContext bundleContext;
    protected StandardMBean blueprintState;
    protected ObjectName blueprintStateName;
    protected StandardMBean blueprintMetadata;
    protected ObjectName blueprintMetadataName;
    protected List<MBeanServer> mbeanServers = new CopyOnWriteArrayList<MBeanServer>();
    protected ServiceTracker mbeanServiceTracker;
    protected AtomicBoolean servicesRegistered = new AtomicBoolean(false);

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.blueprintStateName = new ObjectName("org.apache.aries.blueprint:service=blueprintState,version=1.0");
        this.blueprintMetadataName = new ObjectName("org.apache.aries.blueprint:service=blueprintMetadata,version=1.0");
        this.mbeanServiceTracker = new ServiceTracker(this.bundleContext, MBeanServer.class.getCanonicalName(), (ServiceTrackerCustomizer)new MBeanServerServiceTracker());
        LOGGER.debug("Awaiting MBeanServer service registration");
        this.mbeanServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        for (MBeanServer mbeanServer : this.mbeanServers) {
            this.deregisterMBeans(mbeanServer);
        }
        this.mbeanServiceTracker.close();
        this.mbeanServers.clear();
    }

    private void processRegister(final MBeanServer mbeanServer) {
        Runnable registration = new Runnable(){

            public void run() {
                Activator.this.registerMBeans(mbeanServer);
            }
        };
        Thread registrationThread = new Thread(registration, "Blueprint MBeans Registration");
        registrationThread.setDaemon(true);
        registrationThread.start();
    }

    private void processDeregister(final MBeanServer mbeanServer) {
        Runnable deregister = new Runnable(){

            public void run() {
                Activator.this.deregisterMBeans(mbeanServer);
            }
        };
        Thread deregisterThread = new Thread(deregister, "Blueprint MBeans Deregistration");
        deregisterThread.setDaemon(true);
        deregisterThread.start();
    }

    protected synchronized void registerMBeans(MBeanServer mbeanServer) {
        try {
            this.blueprintState = new RegistrableStandardEmitterMBean(new BlueprintState(this.bundleContext), BlueprintStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error("Unable to create StandardMBean for BlueprintState", (Throwable)e);
            return;
        }
        LOGGER.debug("Registering bundle state monitor with MBeanServer: {} with name: {}", (Object)mbeanServer, (Object)this.blueprintStateName);
        try {
            mbeanServer.registerMBean(this.blueprintState, this.blueprintStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.debug("Cannot register BlueprintStateMBean");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("Cannot register BlueprintStateMBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error("Cannot register BlueprintStateMBean", (Throwable)e);
        }
        try {
            this.blueprintMetadata = new StandardMBean(new BlueprintMetadata(this.bundleContext), BlueprintMetadataMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error("Unable to create StandardMBean for BlueprintMetadata", (Throwable)e);
            return;
        }
        LOGGER.debug("Registering bundle metadata monitor with MBeanServer: {} with name: {}", (Object)mbeanServer, (Object)this.blueprintMetadataName);
        try {
            mbeanServer.registerMBean(this.blueprintMetadata, this.blueprintMetadataName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.debug("Cannot register BlueprintMetadataMBean");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("Cannot register BlueprintMetadataMBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error("Cannot register BlueprintMetadataMBean", (Throwable)e);
        }
        this.servicesRegistered.set(true);
    }

    protected synchronized void deregisterMBeans(MBeanServer mbeanServer) {
        if (!this.servicesRegistered.get()) {
            return;
        }
        try {
            mbeanServer.unregisterMBean(this.blueprintStateName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("BlueprintStateMBean not found on deregistration");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("BlueprintStateMBean deregistration problem");
        }
        this.blueprintState = null;
        try {
            mbeanServer.unregisterMBean(this.blueprintMetadataName);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("BlueprintMetadataMBean not found on deregistration");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error("BlueprintMetadataMBean deregistration problem");
        }
        this.blueprintMetadata = null;
        this.servicesRegistered.set(false);
    }

    class MBeanServerServiceTracker
    implements ServiceTrackerCustomizer {
        MBeanServerServiceTracker() {
        }

        public Object addingService(ServiceReference servicereference) {
            try {
                LOGGER.debug("Adding MBeanServer: {}", (Object)servicereference);
                MBeanServer mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                Activator.this.mbeanServers.add(mbeanServer);
                Activator.this.processRegister(mbeanServer);
                return mbeanServer;
            }
            catch (RuntimeException e) {
                LOGGER.error("uncaught exception in addingService", (Throwable)e);
                throw e;
            }
        }

        public void removedService(ServiceReference servicereference, Object obj) {
            try {
                LOGGER.debug("Removing MBeanServer: {}", (Object)servicereference);
                MBeanServer mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                Activator.this.mbeanServers.remove(mbeanServer);
                Activator.this.processDeregister(mbeanServer);
            }
            catch (Throwable e) {
                LOGGER.debug("uncaught exception in removedService", e);
            }
        }

        public void modifiedService(ServiceReference servicereference, Object obj) {
        }
    }
}

