/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.shiro.authz.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.ws.rs.core.Feature;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.jax.rs.shiro.authz.impl.ShiroAuthorizationFeature;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class ShiroAuthorizationActivator
implements BundleActivator {
    private static final Logger _LOG = LoggerFactory.getLogger(ShiroAuthorizationActivator.class);
    private OSGiResult _registration;

    public void start(BundleContext context) throws Exception {
        _LOG.debug("Starting the Shiro JAX-RS Authorization Feature");
        this._registration = OSGi.coalesce(OSGi.configuration("org.apache.aries.jax.rs.shiro.authorization"), OSGi.just(() -> {
            _LOG.debug("Using the default configuration for the Shiro JAX-RS Authorization Feature");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.pid", "org.apache.aries.jax.rs.shiro.authorization");
            return properties;
        })).map(this::filter).flatMap(p -> OSGi.register(Feature.class, new ShiroAuthorizationFeature(), (Map<String, Object>)p)).run(context);
    }

    Map<String, Object> filter(Dictionary<String, ?> props) {
        Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.startsWith(".")) continue;
            serviceProps.put(key, props.get(key));
        }
        serviceProps.put("osgi.jaxrs.extension", Boolean.TRUE);
        serviceProps.putIfAbsent("osgi.jaxrs.name", "aries.shiro.authz");
        _LOG.debug("Shiro JAX-RS Authorization Feature service properties are: {}", serviceProps);
        return serviceProps;
    }

    public void stop(BundleContext context) throws Exception {
        _LOG.debug("Stopping the Shiro JAX-RS Authorization Feature");
        this._registration.close();
    }
}

