/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.jax.rs.openapi.OpenApiPrototypeServiceFactory;
import org.apache.aries.jax.rs.openapi.PropertyWrapper;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@Header(name="Bundle-Activator", value="${@class}")
public class OpenApiBundleActivator
implements BundleActivator {
    private OSGiResult result;

    public void start(BundleContext bundleContext) throws Exception {
        OSGi program = OSGi.serviceReferences(OpenAPI.class).flatMap(sr -> OSGi.service(sr).flatMap(openAPI -> OSGi.just(new OpenApiPrototypeServiceFactory(new PropertyWrapper((CachingServiceReference<OpenAPI>)sr), (OpenAPI)openAPI))).flatMap(factory -> OSGi.register(Object.class, factory, () -> this.getProperties((CachingServiceReference<OpenAPI>)sr))));
        this.result = program.run(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.result.close();
    }

    private Map<String, Object> getProperties(CachingServiceReference<OpenAPI> serviceReference) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String propertyKey : serviceReference.getPropertyKeys()) {
            map.put(propertyKey, serviceReference.getProperty(propertyKey));
        }
        map.put("org.apache.aries.jax.rs.whiteboard.application.scoped", true);
        map.put("osgi.jaxrs.resource", true);
        return map;
    }
}

