// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by informer-gen. DO NOT EDIT.

package v2

import (
	internalinterfaces "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/client/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// ApisixClusterConfigs returns a ApisixClusterConfigInformer.
	ApisixClusterConfigs() ApisixClusterConfigInformer
	// ApisixConsumers returns a ApisixConsumerInformer.
	ApisixConsumers() ApisixConsumerInformer
	// ApisixPluginConfigs returns a ApisixPluginConfigInformer.
	ApisixPluginConfigs() ApisixPluginConfigInformer
	// ApisixRoutes returns a ApisixRouteInformer.
	ApisixRoutes() ApisixRouteInformer
	// ApisixTlses returns a ApisixTlsInformer.
	ApisixTlses() ApisixTlsInformer
	// ApisixUpstreams returns a ApisixUpstreamInformer.
	ApisixUpstreams() ApisixUpstreamInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// ApisixClusterConfigs returns a ApisixClusterConfigInformer.
func (v *version) ApisixClusterConfigs() ApisixClusterConfigInformer {
	return &apisixClusterConfigInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// ApisixConsumers returns a ApisixConsumerInformer.
func (v *version) ApisixConsumers() ApisixConsumerInformer {
	return &apisixConsumerInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// ApisixPluginConfigs returns a ApisixPluginConfigInformer.
func (v *version) ApisixPluginConfigs() ApisixPluginConfigInformer {
	return &apisixPluginConfigInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// ApisixRoutes returns a ApisixRouteInformer.
func (v *version) ApisixRoutes() ApisixRouteInformer {
	return &apisixRouteInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// ApisixTlses returns a ApisixTlsInformer.
func (v *version) ApisixTlses() ApisixTlsInformer {
	return &apisixTlsInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// ApisixUpstreams returns a ApisixUpstreamInformer.
func (v *version) ApisixUpstreams() ApisixUpstreamInformer {
	return &apisixUpstreamInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
