// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v2beta3

import (
	v2beta3 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v2beta3"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ApisixPluginConfigLister helps list ApisixPluginConfigs.
// All objects returned here must be treated as read-only.
type ApisixPluginConfigLister interface {
	// List lists all ApisixPluginConfigs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2beta3.ApisixPluginConfig, err error)
	// ApisixPluginConfigs returns an object that can list and get ApisixPluginConfigs.
	ApisixPluginConfigs(namespace string) ApisixPluginConfigNamespaceLister
	ApisixPluginConfigListerExpansion
}

// apisixPluginConfigLister implements the ApisixPluginConfigLister interface.
type apisixPluginConfigLister struct {
	indexer cache.Indexer
}

// NewApisixPluginConfigLister returns a new ApisixPluginConfigLister.
func NewApisixPluginConfigLister(indexer cache.Indexer) ApisixPluginConfigLister {
	return &apisixPluginConfigLister{indexer: indexer}
}

// List lists all ApisixPluginConfigs in the indexer.
func (s *apisixPluginConfigLister) List(selector labels.Selector) (ret []*v2beta3.ApisixPluginConfig, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v2beta3.ApisixPluginConfig))
	})
	return ret, err
}

// ApisixPluginConfigs returns an object that can list and get ApisixPluginConfigs.
func (s *apisixPluginConfigLister) ApisixPluginConfigs(namespace string) ApisixPluginConfigNamespaceLister {
	return apisixPluginConfigNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ApisixPluginConfigNamespaceLister helps list and get ApisixPluginConfigs.
// All objects returned here must be treated as read-only.
type ApisixPluginConfigNamespaceLister interface {
	// List lists all ApisixPluginConfigs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2beta3.ApisixPluginConfig, err error)
	// Get retrieves the ApisixPluginConfig from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2beta3.ApisixPluginConfig, error)
	ApisixPluginConfigNamespaceListerExpansion
}

// apisixPluginConfigNamespaceLister implements the ApisixPluginConfigNamespaceLister
// interface.
type apisixPluginConfigNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ApisixPluginConfigs in the indexer for a given namespace.
func (s apisixPluginConfigNamespaceLister) List(selector labels.Selector) (ret []*v2beta3.ApisixPluginConfig, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v2beta3.ApisixPluginConfig))
	})
	return ret, err
}

// Get retrieves the ApisixPluginConfig from the indexer for a given namespace and name.
func (s apisixPluginConfigNamespaceLister) Get(name string) (*v2beta3.ApisixPluginConfig, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v2beta3.Resource("apisixpluginconfig"), name)
	}
	return obj.(*v2beta3.ApisixPluginConfig), nil
}
