// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ApisixTlsLister helps list ApisixTlses.
// All objects returned here must be treated as read-only.
type ApisixTlsLister interface {
	// List lists all ApisixTlses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ApisixTls, err error)
	// ApisixTlses returns an object that can list and get ApisixTlses.
	ApisixTlses(namespace string) ApisixTlsNamespaceLister
	ApisixTlsListerExpansion
}

// apisixTlsLister implements the ApisixTlsLister interface.
type apisixTlsLister struct {
	indexer cache.Indexer
}

// NewApisixTlsLister returns a new ApisixTlsLister.
func NewApisixTlsLister(indexer cache.Indexer) ApisixTlsLister {
	return &apisixTlsLister{indexer: indexer}
}

// List lists all ApisixTlses in the indexer.
func (s *apisixTlsLister) List(selector labels.Selector) (ret []*v1.ApisixTls, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ApisixTls))
	})
	return ret, err
}

// ApisixTlses returns an object that can list and get ApisixTlses.
func (s *apisixTlsLister) ApisixTlses(namespace string) ApisixTlsNamespaceLister {
	return apisixTlsNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ApisixTlsNamespaceLister helps list and get ApisixTlses.
// All objects returned here must be treated as read-only.
type ApisixTlsNamespaceLister interface {
	// List lists all ApisixTlses in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ApisixTls, err error)
	// Get retrieves the ApisixTls from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.ApisixTls, error)
	ApisixTlsNamespaceListerExpansion
}

// apisixTlsNamespaceLister implements the ApisixTlsNamespaceLister
// interface.
type apisixTlsNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ApisixTlses in the indexer for a given namespace.
func (s apisixTlsNamespaceLister) List(selector labels.Selector) (ret []*v1.ApisixTls, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ApisixTls))
	})
	return ret, err
}

// Get retrieves the ApisixTls from the indexer for a given namespace and name.
func (s apisixTlsNamespaceLister) Get(name string) (*v1.ApisixTls, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("apisixtls"), name)
	}
	return obj.(*v1.ApisixTls), nil
}
