// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v2beta3

import (
	"context"
	"time"

	v2beta3 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v2beta3"
	scheme "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ApisixUpstreamsGetter has a method to return a ApisixUpstreamInterface.
// A group's client should implement this interface.
type ApisixUpstreamsGetter interface {
	ApisixUpstreams(namespace string) ApisixUpstreamInterface
}

// ApisixUpstreamInterface has methods to work with ApisixUpstream resources.
type ApisixUpstreamInterface interface {
	Create(ctx context.Context, apisixUpstream *v2beta3.ApisixUpstream, opts v1.CreateOptions) (*v2beta3.ApisixUpstream, error)
	Update(ctx context.Context, apisixUpstream *v2beta3.ApisixUpstream, opts v1.UpdateOptions) (*v2beta3.ApisixUpstream, error)
	UpdateStatus(ctx context.Context, apisixUpstream *v2beta3.ApisixUpstream, opts v1.UpdateOptions) (*v2beta3.ApisixUpstream, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2beta3.ApisixUpstream, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2beta3.ApisixUpstreamList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2beta3.ApisixUpstream, err error)
	ApisixUpstreamExpansion
}

// apisixUpstreams implements ApisixUpstreamInterface
type apisixUpstreams struct {
	client rest.Interface
	ns     string
}

// newApisixUpstreams returns a ApisixUpstreams
func newApisixUpstreams(c *ApisixV2beta3Client, namespace string) *apisixUpstreams {
	return &apisixUpstreams{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the apisixUpstream, and returns the corresponding apisixUpstream object, and an error if there is any.
func (c *apisixUpstreams) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2beta3.ApisixUpstream, err error) {
	result = &v2beta3.ApisixUpstream{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("apisixupstreams").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ApisixUpstreams that match those selectors.
func (c *apisixUpstreams) List(ctx context.Context, opts v1.ListOptions) (result *v2beta3.ApisixUpstreamList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2beta3.ApisixUpstreamList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("apisixupstreams").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested apisixUpstreams.
func (c *apisixUpstreams) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("apisixupstreams").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a apisixUpstream and creates it.  Returns the server's representation of the apisixUpstream, and an error, if there is any.
func (c *apisixUpstreams) Create(ctx context.Context, apisixUpstream *v2beta3.ApisixUpstream, opts v1.CreateOptions) (result *v2beta3.ApisixUpstream, err error) {
	result = &v2beta3.ApisixUpstream{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("apisixupstreams").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(apisixUpstream).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a apisixUpstream and updates it. Returns the server's representation of the apisixUpstream, and an error, if there is any.
func (c *apisixUpstreams) Update(ctx context.Context, apisixUpstream *v2beta3.ApisixUpstream, opts v1.UpdateOptions) (result *v2beta3.ApisixUpstream, err error) {
	result = &v2beta3.ApisixUpstream{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("apisixupstreams").
		Name(apisixUpstream.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(apisixUpstream).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *apisixUpstreams) UpdateStatus(ctx context.Context, apisixUpstream *v2beta3.ApisixUpstream, opts v1.UpdateOptions) (result *v2beta3.ApisixUpstream, err error) {
	result = &v2beta3.ApisixUpstream{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("apisixupstreams").
		Name(apisixUpstream.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(apisixUpstream).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the apisixUpstream and deletes it. Returns an error if one occurs.
func (c *apisixUpstreams) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("apisixupstreams").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *apisixUpstreams) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("apisixupstreams").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched apisixUpstream.
func (c *apisixUpstreams) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2beta3.ApisixUpstream, err error) {
	result = &v2beta3.ApisixUpstream{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("apisixupstreams").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
