// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	configv1 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeApisixTlses implements ApisixTlsInterface
type FakeApisixTlses struct {
	Fake *FakeApisixV1
	ns   string
}

var apisixtlsesResource = schema.GroupVersionResource{Group: "apisix.apache.org", Version: "v1", Resource: "apisixtlses"}

var apisixtlsesKind = schema.GroupVersionKind{Group: "apisix.apache.org", Version: "v1", Kind: "ApisixTls"}

// Get takes name of the apisixTls, and returns the corresponding apisixTls object, and an error if there is any.
func (c *FakeApisixTlses) Get(ctx context.Context, name string, options v1.GetOptions) (result *configv1.ApisixTls, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(apisixtlsesResource, c.ns, name), &configv1.ApisixTls{})

	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.ApisixTls), err
}

// List takes label and field selectors, and returns the list of ApisixTlses that match those selectors.
func (c *FakeApisixTlses) List(ctx context.Context, opts v1.ListOptions) (result *configv1.ApisixTlsList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(apisixtlsesResource, apisixtlsesKind, c.ns, opts), &configv1.ApisixTlsList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &configv1.ApisixTlsList{ListMeta: obj.(*configv1.ApisixTlsList).ListMeta}
	for _, item := range obj.(*configv1.ApisixTlsList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested apisixTlses.
func (c *FakeApisixTlses) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(apisixtlsesResource, c.ns, opts))

}

// Create takes the representation of a apisixTls and creates it.  Returns the server's representation of the apisixTls, and an error, if there is any.
func (c *FakeApisixTlses) Create(ctx context.Context, apisixTls *configv1.ApisixTls, opts v1.CreateOptions) (result *configv1.ApisixTls, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(apisixtlsesResource, c.ns, apisixTls), &configv1.ApisixTls{})

	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.ApisixTls), err
}

// Update takes the representation of a apisixTls and updates it. Returns the server's representation of the apisixTls, and an error, if there is any.
func (c *FakeApisixTlses) Update(ctx context.Context, apisixTls *configv1.ApisixTls, opts v1.UpdateOptions) (result *configv1.ApisixTls, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(apisixtlsesResource, c.ns, apisixTls), &configv1.ApisixTls{})

	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.ApisixTls), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeApisixTlses) UpdateStatus(ctx context.Context, apisixTls *configv1.ApisixTls, opts v1.UpdateOptions) (*configv1.ApisixTls, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(apisixtlsesResource, "status", c.ns, apisixTls), &configv1.ApisixTls{})

	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.ApisixTls), err
}

// Delete takes name of the apisixTls and deletes it. Returns an error if one occurs.
func (c *FakeApisixTlses) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(apisixtlsesResource, c.ns, name), &configv1.ApisixTls{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeApisixTlses) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(apisixtlsesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &configv1.ApisixTlsList{})
	return err
}

// Patch applies the patch and returns the patched apisixTls.
func (c *FakeApisixTlses) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *configv1.ApisixTls, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(apisixtlsesResource, c.ns, name, pt, data, subresources...), &configv1.ApisixTls{})

	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.ApisixTls), err
}
