/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElement;

public class IvyNodeElementAdapter {
    public static IvyNodeElement adapt(ResolveReport report) {
        IvyNodeElement nodeElement;
        IvyNode node;
        HashMap<ModuleRevisionId, IvyNodeElement> resolvedNodes = new HashMap<ModuleRevisionId, IvyNodeElement>();
        IvyNodeElement root = new IvyNodeElement();
        root.setModuleRevisionId(report.getModuleDescriptor().getModuleRevisionId());
        resolvedNodes.put(report.getModuleDescriptor().getModuleRevisionId(), root);
        List dependencies = report.getDependencies();
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            node = (IvyNode)iter.next();
            if (node.getAllEvictingNodes() != null) continue;
            nodeElement = new IvyNodeElement();
            nodeElement.setModuleRevisionId(node.getResolvedId());
            resolvedNodes.put(node.getResolvedId(), nodeElement);
        }
        iter = dependencies.iterator();
        while (iter.hasNext()) {
            node = (IvyNode)iter.next();
            if (node.getAllEvictingNodes() != null) continue;
            nodeElement = (IvyNodeElement)resolvedNodes.get(node.getResolvedId());
            IvyNodeCallers.Caller[] callers = node.getAllRealCallers();
            int i = 0;
            while (i < callers.length) {
                IvyNodeElement caller = (IvyNodeElement)resolvedNodes.get(callers[i].getModuleRevisionId());
                if (caller != null) {
                    nodeElement.addCaller(caller);
                    nodeElement.setCallerConfigurations(caller, callers[i].getCallerConfigurations());
                }
                ++i;
            }
        }
        IvyNode[] evictions = report.getEvictedNodes();
        int i = 0;
        while (i < evictions.length) {
            IvyNode eviction = evictions[i];
            IvyNodeElement evictionElement = new IvyNodeElement();
            evictionElement.setModuleRevisionId(eviction.getResolvedId());
            evictionElement.setEvicted(true);
            IvyNodeCallers.Caller[] callers = eviction.getAllCallers();
            int j = 0;
            while (j < callers.length) {
                IvyNodeElement caller = (IvyNodeElement)resolvedNodes.get(callers[j].getModuleRevisionId());
                if (caller != null) {
                    evictionElement.addCaller(caller);
                    evictionElement.setCallerConfigurations(caller, callers[j].getCallerConfigurations());
                }
                ++j;
            }
            ++i;
        }
        root.setDepth(0);
        IvyNodeElementAdapter.findConflictsBeneathNode(root);
        return root;
    }

    private static void findConflictsBeneathNode(IvyNodeElement node) {
        HashMap<ModuleId, HashSet<IvyNodeElement>> moduleRevisionMap = new HashMap<ModuleId, HashSet<IvyNodeElement>>();
        IvyNodeElement[] deepDependencies = node.getDeepDependencies();
        int i = 0;
        while (i < deepDependencies.length) {
            if (!deepDependencies[i].isEvicted()) {
                ModuleId moduleId = deepDependencies[i].getModuleRevisionId().getModuleId();
                if (moduleRevisionMap.containsKey(moduleId)) {
                    Collection conflicts = (Collection)moduleRevisionMap.get(moduleId);
                    conflicts.add(deepDependencies[i]);
                    Iterator iter = conflicts.iterator();
                    while (iter.hasNext()) {
                        IvyNodeElement conflict = (IvyNodeElement)iter.next();
                        conflict.setConflicts(conflicts);
                    }
                } else {
                    List<IvyNodeElement> immutableMatchingSet = Arrays.asList(deepDependencies[i]);
                    moduleRevisionMap.put(moduleId, new HashSet<IvyNodeElement>(immutableMatchingSet));
                }
            }
            ++i;
        }
    }
}

