/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainer;
import org.apache.ivyde.eclipse.resolvevisualizer.ClasspathContainerSelectionDialog;
import org.apache.ivyde.eclipse.resolvevisualizer.IvyNodeLabelProvider;
import org.apache.ivyde.eclipse.resolvevisualizer.MessageContentProvider;
import org.apache.ivyde.eclipse.resolvevisualizer.Plugin;
import org.apache.ivyde.eclipse.resolvevisualizer.ResolveVisualizerContentProvider;
import org.apache.ivyde.eclipse.resolvevisualizer.ResolveVisualizerForm;
import org.apache.ivyde.eclipse.resolvevisualizer.ResolveVisualizerPlugin;
import org.apache.ivyde.eclipse.resolvevisualizer.label.ILabelDecoratorAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElement;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElementAdapter;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElementFilterAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;

public class ResolveVisualizerView
extends ViewPart
implements IZoomableWorkbenchPart {
    private GraphViewer viewer;
    private FormToolkit toolKit;
    private Action focusDialogAction;
    private Action focusDialogActionToolbar;
    private Action focusOnSelectionAction;
    private Action hideSelectionAction;
    private Action showHiddenAction;
    private Action applyDefaultLayoutAction;
    private Action historyAction;
    private Action forwardAction;
    private Action refreshAction;
    private ZoomContributionViewItem contextZoomContributionViewItem;
    private ZoomContributionViewItem toolbarZoomContributionViewItem;
    private Stack historyStack;
    private Stack forwardStack;
    private IvyNodeElement currentRoot;
    private IvyNodeElement currentSelection;
    private IvyClasspathContainer currentContainer;
    private ResolveVisualizerContentProvider contentProvider = new ResolveVisualizerContentProvider();
    private MessageContentProvider messageContentProvider = new MessageContentProvider();
    private IvyNodeLabelProvider labelProvider;
    private ResolveVisualizerForm visualizationForm;
    private ForceHiddenFilter forceHiddenFilter;

    public ResolveVisualizerView() {
        this.historyStack = new Stack();
        this.forwardStack = new Stack();
        this.forceHiddenFilter = new ForceHiddenFilter();
        this.forceHiddenFilter.setEnabled(true);
        this.contentProvider.addFilter(this.forceHiddenFilter);
    }

    public void createPartControl(Composite parent) {
        this.toolKit = new FormToolkit(parent.getDisplay());
        this.visualizationForm = new ResolveVisualizerForm(parent, this.toolKit, this);
        this.viewer = this.visualizationForm.getGraphViewer();
        this.labelProvider = new IvyNodeLabelProvider(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput(null);
        this.viewer.setConnectionStyle(2);
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{new DirectedGraphLayoutAlgorithm(1), new HorizontalShift(1)}));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedElement instanceof EntityConnectionData) {
                    return;
                }
                ResolveVisualizerView.this.selectionChanged((IvyNodeElement)selectedElement);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResolveVisualizerView.this.focusOnSelectionAction.run();
            }
        });
        this.visualizationForm.getSearchBox().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textString = ResolveVisualizerView.this.visualizationForm.getSearchBox().getText();
                HashMap<String, GraphItem> figureListing = new HashMap<String, GraphItem>();
                ArrayList list = new ArrayList();
                Iterator<Object> iterator = ResolveVisualizerView.this.viewer.getGraphControl().getNodes().iterator();
                while (iterator.hasNext()) {
                    GraphItem item = (GraphItem)iterator.next();
                    figureListing.put(item.getText(), item);
                }
                iterator = figureListing.keySet().iterator();
                if (textString.length() > 0) {
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (string.toLowerCase().indexOf(textString.toLowerCase()) < 0) continue;
                        list.add(figureListing.get(string));
                    }
                }
                ResolveVisualizerView.this.viewer.getGraphControl().setSelection(list.toArray(new GraphItem[list.size()]));
            }
        });
        this.messageContentProvider.setMessageManager(this.visualizationForm.getManagedForm().getMessageManager());
        this.contextZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        this.toolbarZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResolveVisualizerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IContributionItem)this.toolbarZoomContributionViewItem);
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.focusDialogAction);
        manager.add((IAction)this.focusOnSelectionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.historyAction);
        manager.add((IAction)this.forwardAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.hideSelectionAction);
        manager.add((IAction)this.showHiddenAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.applyDefaultLayoutAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)this.contextZoomContributionViewItem);
    }

    private void fillLocalToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IAction)this.focusDialogActionToolbar);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.historyAction);
        toolBarManager.add((IAction)this.forwardAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                IvyClasspathContainer container = ResolveVisualizerView.this.currentContainer;
                if (container == null) {
                    return;
                }
                ResolveReport report = container.getResolveReport();
                if (report == null) {
                    return;
                }
                ResolveVisualizerView.this.focusOnContainer(container);
                ResolveVisualizerView.this.forwardStack.clear();
                ResolveVisualizerView.this.forwardAction.setEnabled(false);
            }
        };
        this.refreshAction.setText("Resolve");
        this.refreshAction.setEnabled(true);
        this.refreshAction.setImageDescriptor(Plugin.getImageDescriptor("icons/refresh.gif"));
        this.focusDialogAction = new Action(){

            public void run() {
                ClasspathContainerSelectionDialog dialog = new ClasspathContainerSelectionDialog(ResolveVisualizerView.this.viewer.getControl().getShell());
                dialog.create();
                int dialogStatus = dialog.open();
                if (dialogStatus == 0) {
                    ResolveVisualizerView.this.currentContainer = (IvyClasspathContainer)dialog.getFirstResult();
                    ResolveVisualizerView.this.refreshAction.run();
                }
            }
        };
        this.focusDialogAction.setText("Focus on ivy file...");
        this.focusDialogActionToolbar = new Action(){

            public void run() {
                ResolveVisualizerView.this.focusDialogAction.run();
            }
        };
        this.focusDialogActionToolbar.setToolTipText("Focus on ivy file...");
        this.focusDialogActionToolbar.setImageDescriptor(ResolveVisualizerPlugin.getImageDescriptor("icons/focus.gif"));
        this.focusOnSelectionAction = new Action(){

            public void run() {
                if (ResolveVisualizerView.this.currentSelection != null && ResolveVisualizerView.this.currentRoot != ResolveVisualizerView.this.currentSelection) {
                    if (ResolveVisualizerView.this.currentRoot != null) {
                        ResolveVisualizerView.this.historyStack.push(ResolveVisualizerView.this.currentRoot);
                        ResolveVisualizerView.this.historyAction.setEnabled(true);
                    }
                    ResolveVisualizerView.this.focusOn(ResolveVisualizerView.this.currentSelection);
                }
            }
        };
        this.focusOnSelectionAction.setText("Focus on selection");
        this.focusOnSelectionAction.setEnabled(false);
        this.historyAction = new Action(){

            public void run() {
                if (ResolveVisualizerView.this.historyStack.size() > 0) {
                    IvyNodeElement element = (IvyNodeElement)ResolveVisualizerView.this.historyStack.pop();
                    ResolveVisualizerView.this.forwardStack.push(ResolveVisualizerView.this.currentRoot);
                    ResolveVisualizerView.this.forwardAction.setEnabled(true);
                    ResolveVisualizerView.this.focusOn(element);
                    if (ResolveVisualizerView.this.historyStack.size() <= 0) {
                        ResolveVisualizerView.this.historyAction.setEnabled(false);
                    }
                }
            }
        };
        this.historyAction.setText("Back");
        this.historyAction.setToolTipText("Back");
        this.historyAction.setEnabled(false);
        this.historyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        this.forwardAction = new Action(){

            public void run() {
                if (ResolveVisualizerView.this.forwardStack.size() > 0) {
                    IvyNodeElement element = (IvyNodeElement)ResolveVisualizerView.this.forwardStack.pop();
                    ResolveVisualizerView.this.historyStack.push(ResolveVisualizerView.this.currentRoot);
                    ResolveVisualizerView.this.historyAction.setEnabled(true);
                    ResolveVisualizerView.this.focusOn(element);
                    if (ResolveVisualizerView.this.forwardStack.size() <= 0) {
                        ResolveVisualizerView.this.forwardAction.setEnabled(false);
                    }
                }
            }
        };
        this.forwardAction.setText("Forward");
        this.forwardAction.setToolTipText("Forward");
        this.forwardAction.setEnabled(false);
        this.forwardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.hideSelectionAction = new Action(){

            public void run() {
                ResolveVisualizerView.this.forceHiddenFilter.addHidden(ResolveVisualizerView.this.currentSelection);
                ResolveVisualizerView.this.refresh();
            }
        };
        this.hideSelectionAction.setText("Hide");
        this.showHiddenAction = new Action(){

            public void run() {
                ResolveVisualizerView.this.forceHiddenFilter.clearHidden();
                ResolveVisualizerView.this.refresh();
            }
        };
        this.showHiddenAction.setText("Show hidden");
        this.applyDefaultLayoutAction = new Action(){

            public void run() {
                ResolveVisualizerView.this.viewer.applyLayout();
            }
        };
        this.applyDefaultLayoutAction.setText("Apply default layout");
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private final void focusOnContainer(IvyClasspathContainer container) {
        ResolveReport report = container.getResolveReport();
        if (report != null) {
            this.forceHiddenFilter.clearHidden();
            this.visualizationForm.getForm().setText("Ivy Resolve Visualization - " + container.getConf().getIvyXmlPath() + " in \"" + container.getConf().getJavaProject().getProject().getName() + "\"");
            IvyNodeElement nextRoot = IvyNodeElementAdapter.adapt(report);
            if (this.currentRoot != nextRoot) {
                if (this.currentRoot != null) {
                    this.historyStack.push(this.currentRoot);
                    this.historyAction.setEnabled(true);
                }
                this.focusOn(nextRoot);
            }
        }
    }

    public void focusOn(IvyNodeElement focus) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)focus));
        this.viewer.setFilters(new ViewerFilter[0]);
        this.viewer.setInput((Object)focus);
        Iterator nodes = this.viewer.getGraphControl().getNodes().iterator();
        Graph graph = this.viewer.getGraphControl();
        Dimension centre = new Dimension(graph.getBounds().width / 2, graph.getBounds().height / 2);
        while (nodes.hasNext()) {
            GraphNode graphNode = (GraphNode)nodes.next();
            if (graphNode.getLocation().x > 1 || graphNode.getLocation().y > 1) continue;
            graphNode.setLocation((double)centre.width, (double)centre.height);
        }
        this.currentRoot = focus;
        if (this.viewer.getGraphControl().getNodes().size() > 0) {
            this.visualizationForm.enableSearchBox(true);
        } else {
            this.visualizationForm.enableSearchBox(false);
        }
        this.visualizationForm.enableSearchBox(true);
        this.focusOnSelectionAction.setEnabled(true);
        this.selectionChanged(focus);
    }

    private void selectionChanged(IvyNodeElement selectedItem) {
        this.currentSelection = selectedItem;
        this.labelProvider.setCurrentSelection(this.currentRoot, selectedItem);
        this.messageContentProvider.selectionChanged(this.currentRoot);
        this.viewer.update(this.contentProvider.getElements(this.currentRoot), null);
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    public void setAutoSelectDecorator(ILabelDecoratorAlgorithm algorithm) {
        this.labelProvider.setAutoSelectDecorator(algorithm);
        if (this.viewer.getSelection() != null) {
            Object selected = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            this.selectionChanged((IvyNodeElement)selected);
        }
    }

    public ResolveVisualizerContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void refresh() {
        this.viewer.refresh();
        this.viewer.applyLayout();
    }

    public IvyNodeElement getCurrentRoot() {
        return this.currentRoot;
    }

    private class ForceHiddenFilter
    extends IvyNodeElementFilterAdapter {
        private Collection forceHidden = new HashSet();

        private ForceHiddenFilter() {
        }

        public boolean accept(IvyNodeElement unfiltered) {
            return !this.forceHidden.contains(unfiltered);
        }

        public void addHidden(IvyNodeElement hide) {
            this.forceHidden.addAll(Arrays.asList(hide.getDeepDependencies()));
        }

        public void clearHidden() {
            this.forceHidden.clear();
        }
    }
}

