/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Set;
import org.apache.ivyde.eclipse.resolvevisualizer.ResolveVisualizerView;
import org.apache.ivyde.eclipse.resolvevisualizer.label.AllCallersAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.label.AllDependencyAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.label.AllRootPathsAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.label.SameModuleIdAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.label.ShortestRootPathAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElement;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElementFilterAdapter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.widgets.Graph;

public class ResolveVisualizerForm {
    public static final String HeaderText = "Ivy Resolve Visualization";
    private FormToolkit toolkit;
    private GraphViewer viewer;
    private ScrolledForm form;
    private ManagedForm managedForm;
    private ResolveVisualizerView view;
    private Label searchLabel;
    private Text searchBox;
    private SashForm sash;
    private Button showAllDependencies;
    private Button showAllCallers;
    private Button showShortestRootPath;
    private Button showAllRootPaths;
    private Button showSameModuleId;
    private Button evictionFilterEnablement;
    private Button depthLimitFilterEnablement;
    private Spinner depthLimit;
    private ThumbnailNavigator thumbnailNavigator;
    private DepthFilter depthFilter = new DepthFilter();
    private EvictionFilter evictionFilter = new EvictionFilter();

    public ResolveVisualizerForm(Composite parent, FormToolkit toolkit, ResolveVisualizerView view) {
        this.toolkit = toolkit;
        this.view = view;
        this.form = this.toolkit.createScrolledForm(parent);
        this.managedForm = new ManagedForm(this.toolkit, this.form);
        this.createHeaderRegion(this.form);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 4;
        this.form.getBody().setLayout((Layout)layout);
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.createSash(this.form.getBody());
        view.getContentProvider().addFilter(this.depthFilter);
        view.getContentProvider().addFilter(this.evictionFilter);
    }

    private void createGraphSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        this.thumbnailNavigator = new ThumbnailNavigator((Composite)section, 0);
        this.viewer = new InternalGraphViewer(this.thumbnailNavigator, 0);
        this.viewer.getGraphControl().setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.viewer.getGraphControl().setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.thumbnailNavigator.setGraph((Graph)this.viewer.getControl());
        this.thumbnailNavigator.setSize(100, 25);
        section.setClient((Control)this.thumbnailNavigator);
    }

    private void createHeaderRegion(ScrolledForm form) {
        Composite headClient = new Composite(form.getForm().getHead(), 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 3;
        headClient.setLayout((Layout)glayout);
        headClient.setBackgroundMode(1);
        this.searchLabel = new Label(headClient, 0);
        this.searchLabel.setText("Search:");
        this.searchBox = this.toolkit.createText(headClient, "");
        GridData data = new GridData();
        data.widthHint = 300;
        this.searchBox.setLayoutData((Object)data);
        this.toolkit.paintBordersFor(headClient);
        form.setHeadClient((Control)headClient);
        form.setText(HeaderText);
        this.enableSearchBox(false);
        form.getForm().addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IMessage oneMessage;
                Set conflicts;
                String title = e.getLabel();
                Object href = e.getHref();
                if (href instanceof IMessage[] && ((IMessage[])href).length > 1) {
                    Point hl = ((Control)e.widget).toDisplay(0, 0);
                    hl.x += 10;
                    hl.y += 10;
                    Shell shell = new Shell(ResolveVisualizerForm.this.form.getShell(), 16388);
                    shell.setImage(ResolveVisualizerForm.this.getImage(ResolveVisualizerForm.this.form.getMessageType()));
                    shell.setBackground(Display.getCurrent().getSystemColor(1));
                    shell.setBackgroundMode(1);
                    GridLayout layout = new GridLayout();
                    layout.numColumns = 1;
                    layout.verticalSpacing = 0;
                    shell.setText(title);
                    shell.setLayout((Layout)layout);
                    Link link = new Link((Composite)shell, 0);
                    link.setText("<A>close</A>");
                    GridData data = new GridData(131072, 0x1000000, false, false);
                    link.setLayoutData((Object)data);
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(this, shell){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = var1_1;
                            this.val$shell = shell;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            this.val$shell.close();
                        }
                    });
                    Group group = new Group((Composite)shell, 0);
                    data = new GridData(16384, 128, true, true);
                    group.setLayoutData((Object)data);
                    group.setLayout((Layout)layout);
                    group.setBackground(Display.getCurrent().getSystemColor(1));
                    FormText text = ResolveVisualizerForm.this.toolkit.createFormText((Composite)group, true);
                    ResolveVisualizerForm.this.configureFormText(ResolveVisualizerForm.this.form.getForm(), text);
                    if (href instanceof IMessage[]) {
                        text.setText(ResolveVisualizerForm.this.createFormTextContent((IMessage[])href), true, false);
                    }
                    shell.setLocation(hl);
                    shell.pack();
                    shell.open();
                } else if (href instanceof IMessage[] && (conflicts = (Set)(oneMessage = ((IMessage[])href)[0]).getData()) != null) {
                    ResolveVisualizerForm.this.viewer.setSelection((ISelection)new StructuredSelection(new ArrayList(conflicts)));
                }
            }
        });
    }

    public void enableSearchBox(boolean enable) {
        this.searchLabel.setEnabled(enable);
        this.searchBox.setEnabled(enable);
    }

    private void createSash(Composite parent) {
        this.sash = new SashForm(parent, 0);
        this.toolkit.paintBordersFor(parent);
        this.createGraphSection((Composite)this.sash);
        this.createOptionsSection((Composite)this.sash);
        this.sash.setWeights(new int[]{10, 2});
    }

    private void createOptionsSection(Composite parent) {
        Section controls = this.toolkit.createSection(parent, 320);
        controls.setText("Options");
        Composite controlComposite = new Composite((Composite)controls, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                return new Point(0, 0);
            }
        };
        this.toolkit.adapt(controlComposite);
        controlComposite.setLayout((Layout)new GridLayout());
        Section autoSelectOptions = this.toolkit.createSection(controlComposite, 64);
        autoSelectOptions.setText("Auto Selection");
        autoSelectOptions.setLayout((Layout)new FillLayout());
        Composite autoSelectOptionsComposite = this.toolkit.createComposite((Composite)autoSelectOptions);
        autoSelectOptionsComposite.setLayout((Layout)new TableWrapLayout());
        this.showShortestRootPath = this.toolkit.createButton(autoSelectOptionsComposite, "Shortest path to root", 16);
        this.showShortestRootPath.setLayoutData((Object)new TableWrapData(128));
        this.showShortestRootPath.setSelection(true);
        this.showShortestRootPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolveVisualizerForm.this.view.setAutoSelectDecorator(new ShortestRootPathAlgorithm());
            }
        });
        this.showAllRootPaths = this.toolkit.createButton(autoSelectOptionsComposite, "All paths to root", 16);
        this.showAllRootPaths.setLayoutData((Object)new TableWrapData(128));
        this.showAllRootPaths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolveVisualizerForm.this.view.setAutoSelectDecorator(new AllRootPathsAlgorithm());
            }
        });
        this.showAllCallers = this.toolkit.createButton(autoSelectOptionsComposite, "All callers", 16);
        this.showAllCallers.setLayoutData((Object)new TableWrapData(128));
        this.showAllCallers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolveVisualizerForm.this.view.setAutoSelectDecorator(new AllCallersAlgorithm());
            }
        });
        this.showAllDependencies = this.toolkit.createButton(autoSelectOptionsComposite, "All dependencies", 16);
        this.showAllDependencies.setLayoutData((Object)new TableWrapData(128));
        this.showAllDependencies.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolveVisualizerForm.this.view.setAutoSelectDecorator(new AllDependencyAlgorithm());
            }
        });
        this.showSameModuleId = this.toolkit.createButton(autoSelectOptionsComposite, "Other revisions", 16);
        this.showSameModuleId.setLayoutData((Object)new TableWrapData(128));
        this.showSameModuleId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolveVisualizerForm.this.view.setAutoSelectDecorator(new SameModuleIdAlgorithm());
            }
        });
        autoSelectOptions.setClient((Control)autoSelectOptionsComposite);
        Section filterOptions = this.toolkit.createSection(controlComposite, 64);
        filterOptions.setText("Filter Options");
        filterOptions.setLayout((Layout)new FillLayout());
        Composite filterOptionsComposite = this.toolkit.createComposite((Composite)filterOptions);
        filterOptionsComposite.setLayout((Layout)new TableWrapLayout());
        this.evictionFilterEnablement = this.toolkit.createButton(filterOptionsComposite, "Hide evicted nodes", 32);
        this.evictionFilterEnablement.setLayoutData((Object)new TableWrapData(128));
        this.evictionFilterEnablement.setSelection(true);
        this.evictionFilter.setEnabled(true);
        this.evictionFilterEnablement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResolveVisualizerForm.this.evictionFilterEnablement.getSelection()) {
                    ResolveVisualizerForm.this.evictionFilter.setEnabled(true);
                    ResolveVisualizerForm.this.view.refresh();
                } else {
                    ResolveVisualizerForm.this.evictionFilter.setEnabled(false);
                    ResolveVisualizerForm.this.view.refresh();
                }
            }
        });
        this.depthLimitFilterEnablement = this.toolkit.createButton(filterOptionsComposite, "Limit depth", 32);
        this.depthLimitFilterEnablement.setLayoutData((Object)new TableWrapData(128));
        this.depthLimitFilterEnablement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResolveVisualizerForm.this.depthLimitFilterEnablement.getSelection()) {
                    ResolveVisualizerForm.this.depthFilter.setDepth(ResolveVisualizerForm.this.depthLimit.getSelection());
                    ResolveVisualizerForm.this.depthFilter.setEnabled(true);
                    ResolveVisualizerForm.this.view.refresh();
                    ResolveVisualizerForm.this.depthLimit.setEnabled(true);
                } else {
                    ResolveVisualizerForm.this.depthFilter.setEnabled(false);
                    ResolveVisualizerForm.this.view.refresh();
                    ResolveVisualizerForm.this.depthLimit.setEnabled(false);
                }
            }
        });
        this.depthLimit = new Spinner(filterOptionsComposite, 0);
        this.toolkit.adapt((Composite)this.depthLimit);
        this.depthLimit.setMinimum(1);
        this.depthLimit.setSelection(2);
        this.depthLimit.setIncrement(1);
        this.depthLimit.setSize(150, 40);
        this.depthLimit.setBackground(new Color((Device)Display.getDefault(), 216, 228, 248));
        this.depthLimit.setEnabled(false);
        this.depthLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResolveVisualizerForm.this.depthFilter.setDepth(ResolveVisualizerForm.this.depthLimit.getSelection());
                ResolveVisualizerForm.this.depthFilter.setEnabled(true);
                ResolveVisualizerForm.this.view.refresh();
            }
        });
        filterOptions.setClient((Control)filterOptionsComposite);
        controls.setClient((Control)controlComposite);
    }

    public GraphViewer getGraphViewer() {
        return this.viewer;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public Text getSearchBox() {
        return this.searchBox;
    }

    public ManagedForm getManagedForm() {
        return this.managedForm;
    }

    private Image getImage(int type) {
        switch (type) {
            case 3: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    private void configureFormText(final Form form, FormText text) {
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String is = (String)e.getHref();
                try {
                    ((FormText)e.widget).getShell().dispose();
                    int index = Integer.parseInt(is);
                    IMessage[] messages = form.getChildrenMessages();
                    IMessage message = messages[index];
                    Set conflicts = (Set)message.getData();
                    if (conflicts != null) {
                        ResolveVisualizerForm.this.viewer.setSelection((ISelection)new StructuredSelection(new ArrayList(conflicts)));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        text.setImage("error", this.getImage(3));
        text.setImage("warning", this.getImage(2));
        text.setImage("info", this.getImage(1));
    }

    String createFormTextContent(IMessage[] messages) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<form>");
        int i = 0;
        while (i < messages.length) {
            IMessage message = messages[i];
            pw.print("<li vspace=\"false\" style=\"image\" indent=\"16\" value=\"");
            switch (message.getMessageType()) {
                case 3: {
                    pw.print("error");
                    break;
                }
                case 2: {
                    pw.print("warning");
                    break;
                }
                case 1: {
                    pw.print("info");
                }
            }
            pw.print("\"> <a href=\"");
            pw.print(String.valueOf(i));
            pw.print("\">");
            if (message.getPrefix() != null) {
                pw.print(message.getPrefix());
            }
            pw.print(message.getMessage());
            pw.println("</a></li>");
            ++i;
        }
        pw.println("</form>");
        pw.flush();
        return sw.toString();
    }

    private class DepthFilter
    extends IvyNodeElementFilterAdapter {
        private int depth = 2;

        private DepthFilter() {
        }

        public boolean accept(IvyNodeElement unfiltered) {
            return unfiltered.getDepth() - ResolveVisualizerForm.this.view.getCurrentRoot().getDepth() <= this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }
    }

    private class EvictionFilter
    extends IvyNodeElementFilterAdapter {
        private EvictionFilter() {
        }

        public boolean accept(IvyNodeElement unfiltered) {
            return !unfiltered.isEvicted();
        }
    }

    private class InternalGraphViewer
    extends GraphViewer {
        public InternalGraphViewer(Composite parent, int style) {
            super(parent, style);
            Graph graph = new Graph(this, parent, style){
                final /* synthetic */ InternalGraphViewer this$1;
                {
                    this.this$1 = internalGraphViewer;
                    super($anonymous0, $anonymous1);
                }

                public Point computeSize(int hint, int hint2, boolean changed) {
                    return new Point(0, 0);
                }
            };
            this.setControl(graph);
        }
    }

    private static class ThumbnailNavigator
    extends Composite {
        FigureCanvas thumbnail;
        ScrollableThumbnail tb;

        public ThumbnailNavigator(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new FormLayout());
            this.createZoomableCanvas(this);
        }

        public void setGraph(Graph graph) {
            if (graph.getParent() != this) {
                throw new AssertionError((Object)"Graph must be a child of this zoomable composite.");
            }
            this.createContents((Control)graph);
            this.tb.setViewport(graph.getViewport());
            this.tb.setSource(graph.getContents());
        }

        private void createZoomableCanvas(Composite parent) {
            FormData data = new FormData();
            data.top = new FormAttachment(100, -100);
            data.left = new FormAttachment(100, -100);
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
            this.thumbnail = new FigureCanvas(parent, 0);
            this.thumbnail.setBackground(ColorConstants.white);
            this.thumbnail.setLayoutData((Object)data);
            this.tb = new ScrollableThumbnail();
            this.tb.setBorder((Border)new LineBorder(1));
            this.thumbnail.setContents((IFigure)this.tb);
        }

        private void createContents(Control control) {
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
            control.setParent((Composite)this);
            control.setLayoutData((Object)data);
        }
    }
}

