/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElement;
import org.eclipse.ui.forms.IMessageManager;

public class MessageContentProvider {
    private IMessageManager manager;

    public void selectionChanged(IvyNodeElement root) {
        if (root == null) {
            return;
        }
        this.manager.removeAllMessages();
        HashMap<ModuleId, HashSet<IvyNodeElement>> conflicts = new HashMap<ModuleId, HashSet<IvyNodeElement>>();
        IvyNodeElement[] deepDependencies = root.getDeepDependencies();
        int i = 0;
        while (i < deepDependencies.length) {
            if (deepDependencies[i].getConflicts().length > 0) {
                HashSet<IvyNodeElement> conflictParticipants = (HashSet<IvyNodeElement>)conflicts.get(deepDependencies[i].getModuleRevisionId().getModuleId());
                if (conflictParticipants == null) {
                    conflictParticipants = new HashSet<IvyNodeElement>();
                }
                conflictParticipants.add(deepDependencies[i]);
                conflicts.put(deepDependencies[i].getModuleRevisionId().getModuleId(), conflictParticipants);
            }
            ++i;
        }
        Iterator conflictIter = conflicts.keySet().iterator();
        while (conflictIter.hasNext()) {
            ModuleId conflictKey = (ModuleId)conflictIter.next();
            this.manager.addMessage((Object)conflictKey, "Conflict on module " + conflictKey.getOrganisation() + "#" + conflictKey.getName(), conflicts.get(conflictKey), 3);
        }
    }

    public void setMessageManager(IMessageManager manager) {
        this.manager = manager;
    }
}

