/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class IvyNodeElement {
    private ModuleRevisionId moduleRevisionId;
    private boolean evicted = false;
    private int depth = 0xCCCCCCC;
    private Collection dependencies = new HashSet();
    private Collection callers = new HashSet();
    private Collection conflicts = new HashSet();
    private Map callerConfigurationMap = new HashMap();
    private IvyNodeElement[] deepDependencyCache;

    public boolean equals(Object obj) {
        IvyNodeElement elem;
        return obj instanceof IvyNodeElement && (elem = (IvyNodeElement)obj).getOrganization().equals(this.getOrganization()) && elem.getName().equals(this.getName()) && elem.getRevision().equals(this.getRevision());
    }

    public IvyNodeElement[] getDependencies() {
        return this.dependencies.toArray(new IvyNodeElement[this.dependencies.size()]);
    }

    public IvyNodeElement[] getDeepDependencies() {
        if (this.deepDependencyCache == null) {
            this.deepDependencyCache = this.getDeepDependencies(this).toArray(new IvyNodeElement[0]);
        }
        return this.deepDependencyCache;
    }

    private Collection getDeepDependencies(IvyNodeElement node) {
        HashSet<IvyNodeElement> deepDependencies = new HashSet<IvyNodeElement>();
        deepDependencies.add(node);
        IvyNodeElement[] directDependencies = node.getDependencies();
        int i = 0;
        while (i < directDependencies.length) {
            deepDependencies.addAll(this.getDeepDependencies(directDependencies[i]));
            ++i;
        }
        return deepDependencies;
    }

    public String[] getCallerConfigurations(IvyNodeElement caller) {
        return (String[])this.callerConfigurationMap.get(caller);
    }

    public void setCallerConfigurations(IvyNodeElement caller, String[] configurations) {
        this.callerConfigurationMap.put(caller, configurations);
    }

    public String getOrganization() {
        return this.moduleRevisionId.getOrganisation();
    }

    public String getName() {
        return this.moduleRevisionId.getName();
    }

    public String getRevision() {
        return this.moduleRevisionId.getRevision();
    }

    public boolean isEvicted() {
        return this.evicted;
    }

    public void setEvicted(boolean evicted) {
        this.evicted = evicted;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        Iterator iter = this.dependencies.iterator();
        while (iter.hasNext()) {
            IvyNodeElement dependency = (IvyNodeElement)iter.next();
            dependency.setDepth(depth + 1);
        }
    }

    public IvyNodeElement[] getConflicts() {
        return this.conflicts.toArray(new IvyNodeElement[this.conflicts.size()]);
    }

    public void setConflicts(Collection conflicts) {
        this.conflicts = conflicts;
    }

    public ModuleRevisionId getModuleRevisionId() {
        return this.moduleRevisionId;
    }

    public void setModuleRevisionId(ModuleRevisionId moduleRevisionId) {
        this.moduleRevisionId = moduleRevisionId;
    }

    public void addCaller(IvyNodeElement caller) {
        this.callers.add(caller);
        caller.dependencies.add(this);
    }

    public IvyNodeElement[] getCallers() {
        return this.callers.toArray(new IvyNodeElement[this.callers.size()]);
    }
}

