/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer.label;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ivyde.eclipse.resolvevisualizer.label.LabelDecoratorAlgorithmAdapter;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElement;
import org.eclipse.zest.core.viewers.EntityConnectionData;

public class ShortestRootPathAlgorithm
extends LabelDecoratorAlgorithmAdapter {
    public void calculateHighlighted(IvyNodeElement root, IvyNodeElement selected, Map highlightRelationships, Map highlightEntities) {
        IvyNodeElement[] path;
        if (selected != null && (path = this.getShortestPathToDescendent(root, selected)).length > 1) {
            int i = 0;
            while (i < path.length - 1) {
                EntityConnectionData entityConnectionData = new EntityConnectionData((Object)path[i + 1], (Object)path[i]);
                highlightRelationships.put(entityConnectionData, this.relationshipColor);
                highlightEntities.put(path[i], this.entityColor);
                ++i;
            }
            highlightEntities.put(path[path.length - 1], this.entityColor);
        }
    }

    public IvyNodeElement[] getShortestPathToDescendent(IvyNodeElement root, IvyNodeElement target) {
        LinkedList<IvyNodeElement> q = new LinkedList<IvyNodeElement>();
        HashSet<IvyNodeElement> orderedSet = new HashSet<IvyNodeElement>();
        LinkedList<IvyNodeElement> orderedList = new LinkedList<IvyNodeElement>();
        q.add(root);
        while (!q.isEmpty()) {
            IvyNodeElement head = (IvyNodeElement)q.remove(0);
            if (orderedSet.contains(head)) continue;
            orderedSet.add(head);
            orderedList.add(head);
            q.addAll(Arrays.asList(head.getDependencies()));
        }
        IvyNodeElement[] path = this.fixedWeightDijkstraAlgorithm(orderedList, root, target);
        return path;
    }

    private IvyNodeElement[] fixedWeightDijkstraAlgorithm(LinkedList q, IvyNodeElement s, IvyNodeElement t) {
        HashMap<IvyNodeElement, IvyNodeElement> previous = new HashMap<IvyNodeElement, IvyNodeElement>();
        HashMap<Object, Integer> dValues = new HashMap<Object, Integer>();
        Iterator iter = q.iterator();
        while (iter.hasNext()) {
            dValues.put(iter.next(), new Integer(0xCCCCCCC));
        }
        dValues.put(s, new Integer(0));
        while (!q.isEmpty()) {
            IvyNodeElement head = (IvyNodeElement)q.remove(0);
            IvyNodeElement[] outgoing = head.getDependencies();
            int i = 0;
            while (i < outgoing.length) {
                IvyNodeElement v = outgoing[i];
                if ((Integer)dValues.get(head) + 1 < (Integer)dValues.get(v)) {
                    previous.put(v, head);
                    dValues.put(v, new Integer((Integer)dValues.get(head) + 1));
                }
                ++i;
            }
        }
        LinkedList<IvyNodeElement> path = new LinkedList<IvyNodeElement>();
        IvyNodeElement currentNode = t;
        while (previous.containsKey(currentNode)) {
            path.add(currentNode);
            currentNode = (IvyNodeElement)previous.get(currentNode);
        }
        path.add(currentNode);
        return path.toArray(new IvyNodeElement[path.size()]);
    }
}

