/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IIvyNodeElementFilter;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;

public class ResolveVisualizerContentProvider
implements IGraphEntityContentProvider {
    Collection filters = new HashSet();

    public Object[] getConnectedTo(Object entity) {
        return this.filter(((IvyNodeElement)entity).getDependencies());
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return new Object[0];
        }
        IvyNodeElement inputNode = (IvyNodeElement)inputElement;
        List<IvyNodeElement> elements = Arrays.asList(this.filter(inputNode.getDeepDependencies()));
        Collections.sort(elements, new IvyNodeElementComparator());
        return elements.toArray();
    }

    public IvyNodeElement[] filter(IvyNodeElement[] deepDependencies) {
        IvyNodeElement[] filtered = deepDependencies;
        Iterator iter = this.filters.iterator();
        while (iter.hasNext()) {
            IIvyNodeElementFilter filter = (IIvyNodeElementFilter)iter.next();
            filtered = filter.filter(filtered);
        }
        return filtered;
    }

    public void addFilter(IIvyNodeElementFilter filter) {
        this.filters.add(filter);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private class IvyNodeElementComparator
    implements Comparator {
        private IvyNodeElementComparator() {
        }

        public int compare(Object arg1, Object arg2) {
            IvyNodeElement element1 = (IvyNodeElement)arg1;
            IvyNodeElement element2 = (IvyNodeElement)arg2;
            if (element1.getDepth() > element2.getDepth()) {
                return -1;
            }
            if (element1.getDepth() < element2.getDepth()) {
                return 1;
            }
            return element1.getModuleRevisionId().toString().compareTo(element2.getModuleRevisionId().toString());
        }
    }
}

