/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.resolvevisualizer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivyde.eclipse.resolvevisualizer.ResolveVisualizerPlugin;
import org.apache.ivyde.eclipse.resolvevisualizer.label.ConfigurationConflictAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.label.ConnectionStyle;
import org.apache.ivyde.eclipse.resolvevisualizer.label.DirectDependenciesAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.label.ILabelDecoratorAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.label.ShortestRootPathAlgorithm;
import org.apache.ivyde.eclipse.resolvevisualizer.model.IvyNodeElement;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;

public class IvyNodeLabelProvider
implements ILabelProvider,
IConnectionStyleProvider,
IEntityStyleProvider {
    public Color GRAY = new Color((Device)Display.getDefault(), 128, 128, 128);
    public Color LIGHT_GRAY = new Color((Device)Display.getDefault(), 220, 220, 220);
    public Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);
    public Color RED = new Color((Device)Display.getDefault(), 255, 0, 0);
    public Color LIGHT_GREEN = new Color((Device)Display.getDefault(), 96, 255, 96);
    private IvyNodeElement selected = null;
    private IvyNodeElement rootNode = null;
    private Map highlightedRelationships = new HashMap();
    private Map highlightedDependencies = new HashMap();
    private Color disabledColor = null;
    private IvyNodeElement pinnedNode = null;
    private GraphViewer viewer;
    private ILabelDecoratorAlgorithm autoSelectDecorator = new ShortestRootPathAlgorithm();
    private DirectDependenciesAlgorithm rootDirectDependenciesDecorator = new DirectDependenciesAlgorithm();
    private ConfigurationConflictAlgorithm conflictDecorator = new ConfigurationConflictAlgorithm();
    private Color rootColor;
    private Color rootSelectedColor;

    public IvyNodeLabelProvider(GraphViewer viewer) {
        this.viewer = viewer;
        this.rootDirectDependenciesDecorator.setStyles(new Color((Device)Display.getDefault(), 197, 237, 197), new ConnectionStyle(4, new Color((Device)Display.getDefault(), 175, 175, 175), 1, false));
    }

    public Image getImage(Object element) {
        IvyNodeElement node;
        if (element instanceof IvyNodeElement && (node = (IvyNodeElement)element).isEvicted()) {
            return ResolveVisualizerPlugin.getImageDescriptor("icons/evicted.gif").createImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IvyNodeElement) {
            IvyNodeElement node = (IvyNodeElement)element;
            String text = String.valueOf(node.getOrganization()) + "#" + node.getName() + ";";
            text = node.getRevision().indexOf("working@") != -1 ? String.valueOf(text) + "WORKSPACE" : String.valueOf(text) + node.getRevision();
            return text;
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Color getColor(Object rel) {
        if (this.highlightedRelationships.keySet().contains(rel)) {
            ConnectionStyle style = (ConnectionStyle)this.highlightedRelationships.get(rel);
            return style.getHighlightColor();
        }
        return this.LIGHT_GRAY;
    }

    public int getConnectionStyle(Object rel) {
        return 2;
    }

    public Color getHighlightColor(Object rel) {
        if (this.highlightedRelationships.keySet().contains(rel)) {
            ConnectionStyle style = (ConnectionStyle)this.highlightedRelationships.get(rel);
            return style.getHighlightColor();
        }
        return ColorConstants.blue;
    }

    public Color getNodeHighlightColor(Object entity) {
        return null;
    }

    public int getLineWidth(Object rel) {
        ConnectionStyle style;
        if (this.highlightedRelationships.keySet().contains(rel) && (style = (ConnectionStyle)this.highlightedRelationships.get(rel)).isRevealOnHighlight()) {
            return style.getLineWidth();
        }
        return 1;
    }

    public Color getAdjacentEntityHighlightColor(Object entity) {
        return null;
    }

    public Color getBorderColor(Object entity) {
        if (this.selected != null || this.pinnedNode != null) {
            if (entity == this.selected || entity == this.pinnedNode) {
                return this.BLACK;
            }
            if (this.highlightedDependencies.keySet().contains(entity)) {
                return this.BLACK;
            }
            return this.LIGHT_GRAY;
        }
        return this.BLACK;
    }

    public Color getBorderHighlightColor(Object entity) {
        return null;
    }

    public int getBorderWidth(Object entity) {
        return 0;
    }

    public Color getBackgroundColour(Object entity) {
        if (entity == this.rootNode) {
            if (this.rootColor == null) {
                this.rootColor = this.LIGHT_GREEN;
            }
            return this.rootColor;
        }
        if (this.highlightedDependencies.keySet().contains(entity)) {
            return (Color)this.highlightedDependencies.get(entity);
        }
        return this.viewer.getGraphControl().DEFAULT_NODE_COLOR;
    }

    public Color getForegroundColour(Object entity) {
        if (this.selected != null || this.pinnedNode != null) {
            if (entity == this.selected || this.pinnedNode == entity) {
                return this.BLACK;
            }
            if (this.highlightedDependencies.keySet().contains(entity)) {
                return this.BLACK;
            }
            return this.GRAY;
        }
        return this.BLACK;
    }

    public void setPinnedNode(IvyNodeElement pinnedNode) {
        this.pinnedNode = pinnedNode;
    }

    protected IvyNodeElement getSelected() {
        if (this.pinnedNode != null) {
            return this.pinnedNode;
        }
        return this.selected;
    }

    public void setCurrentSelection(IvyNodeElement root, IvyNodeElement currentSelection) {
        Iterator iter = this.highlightedRelationships.keySet().iterator();
        while (iter.hasNext()) {
            EntityConnectionData entityConnectionData = (EntityConnectionData)iter.next();
            ConnectionStyle style = (ConnectionStyle)this.highlightedRelationships.get(entityConnectionData);
            if (!style.isRevealOnHighlight()) continue;
            this.viewer.unReveal((Object)entityConnectionData);
        }
        this.rootNode = root;
        this.selected = null;
        this.selected = currentSelection;
        this.highlightedRelationships = new HashMap();
        this.highlightedDependencies = new HashMap();
        this.rootDirectDependenciesDecorator.calculateHighlighted(root, root, this.highlightedRelationships, this.highlightedDependencies);
        this.conflictDecorator.calculateHighlighted(root, root, this.highlightedRelationships, this.highlightedDependencies);
        if (this.selected != null || this.pinnedNode != null) {
            this.autoSelectDecorator.calculateHighlighted(root, this.selected, this.highlightedRelationships, this.highlightedDependencies);
        }
        Object[] connections = this.viewer.getConnectionElements();
        Iterator iter2 = this.highlightedRelationships.keySet().iterator();
        while (iter2.hasNext()) {
            Object entityConnectionData = iter2.next();
            ConnectionStyle style = (ConnectionStyle)this.highlightedRelationships.get(entityConnectionData);
            if (!style.isRevealOnHighlight()) continue;
            this.viewer.reveal(entityConnectionData);
        }
        int i = 0;
        while (i < connections.length) {
            this.viewer.update(connections[i], null);
            ++i;
        }
    }

    public void dispose() {
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
            this.disabledColor = null;
        }
        if (this.rootColor != null) {
            this.rootColor.dispose();
            this.rootColor = null;
        }
        if (this.rootSelectedColor != null) {
            this.rootSelectedColor.dispose();
            this.rootSelectedColor = null;
        }
    }

    public IFigure getTooltip(Object entity) {
        if (entity instanceof EntityConnectionData) {
            EntityConnectionData connection = (EntityConnectionData)entity;
            IvyNodeElement source = (IvyNodeElement)connection.source;
            IvyNodeElement dest = (IvyNodeElement)connection.dest;
            String[] confs = dest.getCallerConfigurations(source);
            String tooltipText = "";
            int i = 0;
            while (i < confs.length) {
                tooltipText = String.valueOf(tooltipText) + confs[i] + ", ";
                ++i;
            }
            return new Label(tooltipText.substring(0, tooltipText.length() - 2));
        }
        return null;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }

    public void setAutoSelectDecorator(ILabelDecoratorAlgorithm decoratorAlgorithm) {
        this.autoSelectDecorator = decoratorAlgorithm;
    }
}

