# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-postgres",
        "name": "PostgreSQL",
        "description": "`PostgreSQL <https://www.postgresql.org/>`__\n",
        "suspended": False,
        "source-date-epoch": 1703288162,
        "versions": [
            "5.10.0",
            "5.9.0",
            "5.8.0",
            "5.7.1",
            "5.7.0",
            "5.6.1",
            "5.6.0",
            "5.5.2",
            "5.5.1",
            "5.5.0",
            "5.4.0",
            "5.3.1",
            "5.3.0",
            "5.2.2",
            "5.2.1",
            "5.2.0",
            "5.1.0",
            "5.0.0",
            "4.1.0",
            "4.0.1",
            "4.0.0",
            "3.0.0",
            "2.4.0",
            "2.3.0",
            "2.2.0",
            "2.1.0",
            "2.0.0",
            "1.0.2",
            "1.0.1",
            "1.0.0",
        ],
        "dependencies": [
            "apache-airflow>=2.6.0",
            "apache-airflow-providers-common-sql>=1.3.1",
            "psycopg2-binary>=2.8.0",
        ],
        "integrations": [
            {
                "integration-name": "PostgreSQL",
                "external-doc-url": "https://www.postgresql.org/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-postgres/operators/postgres_operator_howto_guide.rst"
                ],
                "logo": "/integration-logos/postgres/Postgres.png",
                "tags": ["software"],
            }
        ],
        "operators": [
            {
                "integration-name": "PostgreSQL",
                "python-modules": ["airflow.providers.postgres.operators.postgres"],
            }
        ],
        "hooks": [
            {
                "integration-name": "PostgreSQL",
                "python-modules": ["airflow.providers.postgres.hooks.postgres"],
            }
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.postgres.hooks.postgres.PostgresHook",
                "connection-type": "postgres",
            }
        ],
        "additional-extras": [{"name": "amazon", "dependencies": ["apache-airflow-providers-amazon>=2.6.0"]}],
    }
