# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-openlineage",
        "name": "OpenLineage Airflow",
        "description": "`OpenLineage <https://openlineage.io/>`__\n",
        "state": "ready",
        "source-date-epoch": 1705912192,
        "versions": [
            "1.5.0",
            "1.4.0",
            "1.3.1",
            "1.3.0",
            "1.2.1",
            "1.2.0",
            "1.1.1",
            "1.1.0",
            "1.0.2",
            "1.0.1",
            "1.0.0",
        ],
        "dependencies": [
            "apache-airflow>=2.7.0",
            "apache-airflow-providers-common-sql>=1.6.0",
            "attrs>=22.2",
            "openlineage-integration-common>=0.28.0",
            "openlineage-python>=0.28.0",
        ],
        "integrations": [
            {
                "integration-name": "OpenLineage",
                "external-doc-url": "https://openlineage.io",
                "logo": "/integration-logos/openlineage/openlineage.svg",
                "tags": ["protocol"],
            }
        ],
        "plugins": [
            {
                "name": "openlineage",
                "plugin-class": "airflow.providers.openlineage.plugins.openlineage.OpenLineageProviderPlugin",
            }
        ],
        "config": {
            "openlineage": {
                "description": "This section applies settings for OpenLineage integration.\nFor backwards compatibility with `openlineage-python` one can still use\n`openlineage.yml` file or `OPENLINEAGE_` environment variables. However, below\nconfiguration takes precedence over those.\nMore in documentation - https://openlineage.io/docs/client/python#configuration.\n",
                "options": {
                    "disabled": {
                        "description": "Set this to true if you don't want OpenLineage to emit events.\n",
                        "type": "boolean",
                        "example": None,
                        "default": "False",
                        "version_added": None,
                    },
                    "disabled_for_operators": {
                        "description": "Semicolon separated string of Airflow Operator names to disable\n",
                        "type": "string",
                        "example": "airflow.operators.bash.BashOperator;airflow.operators.python.PythonOperator",
                        "default": "",
                        "version_added": "1.1.0",
                    },
                    "namespace": {
                        "description": "OpenLineage namespace\n",
                        "version_added": None,
                        "type": "string",
                        "example": "food_delivery",
                        "default": None,
                    },
                    "extractors": {
                        "description": "Semicolon separated paths to custom OpenLineage extractors.\n",
                        "type": "string",
                        "example": "full.path.to.ExtractorClass;full.path.to.AnotherExtractorClass",
                        "default": None,
                        "version_added": None,
                    },
                    "config_path": {
                        "description": "Path to YAML config. This provides backwards compatibility to pass config as\n`openlineage.yml` file.\n",
                        "version_added": None,
                        "type": "string",
                        "example": None,
                        "default": "",
                    },
                    "transport": {
                        "description": "OpenLineage Client transport configuration. It should contain type\nand additional options per each type.\n\nCurrently supported types are:\n\n  * HTTP\n  * Kafka\n  * Console\n",
                        "type": "string",
                        "example": '{"type": "http", "url": "http://localhost:5000"}',
                        "default": "",
                        "version_added": None,
                    },
                    "disable_source_code": {
                        "description": "If disabled, OpenLineage events do not contain source code of particular\noperators, like PythonOperator.\n",
                        "default": None,
                        "example": None,
                        "type": "boolean",
                        "version_added": None,
                    },
                },
            }
        },
    }
