# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE OVERWRITTEN!
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-google",
        "name": "Google",
        "description": "Google services including:\n\n  - `Google Ads <https://ads.google.com/>`__\n  - `Google Cloud (GCP) <https://cloud.google.com/>`__\n  - `Google Firebase <https://firebase.google.com/>`__\n  - `Google LevelDB <https://github.com/google/leveldb/>`__\n  - `Google Marketing Platform <https://marketingplatform.google.com/>`__\n  - `Google Workspace <https://workspace.google.com/>`__ (formerly Google Suite)\n",
        "integrations": [
            {
                "integration-name": "Google Analytics (GA4)",
                "external-doc-url": "https://analytics.google.com/",
                "logo": "/docs/integration-logos/Google-Analytics.png",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/marketing_platform/analytics_admin.rst"
                ],
                "tags": ["gmp"],
            },
            {
                "integration-name": "Google Ads",
                "external-doc-url": "https://ads.google.com/",
                "logo": "/docs/integration-logos/Google-Ads.png",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/ads.rst"],
                "tags": ["gmp"],
            },
            {
                "integration-name": "Google AutoML",
                "external-doc-url": "https://cloud.google.com/automl/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/automl.rst"],
                "logo": "/docs/integration-logos/Cloud-AutoML.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google BigQuery Data Transfer Service",
                "external-doc-url": "https://cloud.google.com/bigquery/transfer/",
                "logo": "/docs/integration-logos/BigQuery.png",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/bigquery_dts.rst"],
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google BigQuery",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/bigquery.rst"],
                "external-doc-url": "https://cloud.google.com/bigquery/",
                "logo": "/docs/integration-logos/BigQuery.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Bigtable",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/bigtable.rst"],
                "external-doc-url": "https://cloud.google.com/bigtable/",
                "logo": "/docs/integration-logos/Cloud-Bigtable.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud AlloyDB",
                "external-doc-url": "https://cloud.google.com/alloydb",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/alloy_db.rst"],
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Build",
                "external-doc-url": "https://cloud.google.com/build/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/cloud_build.rst"],
                "logo": "/docs/integration-logos/Cloud-Build.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Common",
                "external-doc-url": "https://cloud.google.com/",
                "tags": ["gcp"],
                "logo": "/docs/integration-logos/Google.png",
            },
            {
                "integration-name": "Google Cloud Composer",
                "external-doc-url": "https://cloud.google.com/composer",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/cloud_composer.rst"],
                "tags": ["google"],
            },
            {
                "integration-name": "Google Cloud Run",
                "external-doc-url": "https://cloud.google.com/run",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/cloud_run.rst"],
                "tags": ["google"],
            },
            {
                "integration-name": "Google Cloud Batch",
                "external-doc-url": "https://cloud.google.com/batch",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/cloud_batch.rst"],
                "tags": ["google"],
            },
            {
                "integration-name": "Google Cloud Dataform",
                "external-doc-url": "https://cloud.google.com/dataform/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/dataform.rst"],
                "tags": ["google"],
            },
            {
                "integration-name": "Google Cloud Data Loss Prevention (DLP)",
                "external-doc-url": "https://cloud.google.com/dlp/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/data_loss_prevention.rst"
                ],
                "logo": "/docs/integration-logos/google-data-loss-prevention.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Firestore",
                "external-doc-url": "https://firebase.google.com/docs/firestore",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/firebase/firestore.rst"],
                "logo": "/docs/integration-logos/Google-Firestore.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Functions",
                "external-doc-url": "https://cloud.google.com/functions/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/functions.rst"],
                "logo": "/docs/integration-logos/Cloud-Functions.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Key Management Service (KMS)",
                "external-doc-url": "https://cloud.google.com/security-key-management/",
                "logo": "/docs/integration-logos/Key-Management-Service.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Life Sciences",
                "external-doc-url": "https://cloud.google.com/life-sciences/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/life_sciences.rst"],
                "logo": "/docs/integration-logos/Google-Cloud-Life-Sciences.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Managed Service for Apache Kafka",
                "external-doc-url": "https://cloud.google.com/managed-service-for-apache-kafka/docs/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/managed_kafka.rst"],
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Memorystore",
                "external-doc-url": "https://cloud.google.com/memorystore/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/cloud_memorystore.rst",
                    "/docs/apache-airflow-providers-google/operators/cloud/cloud_memorystore_memcached.rst",
                ],
                "logo": "/docs/integration-logos/Cloud-Memorystore.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud OS Login",
                "external-doc-url": "https://cloud.google.com/compute/docs/oslogin/",
                "logo": "/docs/integration-logos/Google-Cloud-Generic.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Pub/Sub",
                "external-doc-url": "https://cloud.google.com/pubsub/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/pubsub.rst"],
                "logo": "/docs/integration-logos/Cloud-PubSub.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Secret Manager",
                "external-doc-url": "https://cloud.google.com/secret-manager/",
                "logo": "/docs/integration-logos/Google-Cloud-Secret-Manager.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Spanner",
                "external-doc-url": "https://cloud.google.com/spanner/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/spanner.rst"],
                "logo": "/docs/integration-logos/Cloud-Spanner.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Speech-to-Text",
                "external-doc-url": "https://cloud.google.com/speech-to-text/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/speech_to_text.rst",
                    "/docs/apache-airflow-providers-google/operators/cloud/translate_speech.rst",
                ],
                "logo": "/docs/integration-logos/Cloud-Speech-to-Text.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud SQL",
                "external-doc-url": "https://cloud.google.com/sql/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/cloud_sql.rst"],
                "logo": "/docs/integration-logos/Cloud-SQL.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Stackdriver",
                "external-doc-url": "https://cloud.google.com/products/operations/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/stackdriver.rst"],
                "logo": "/docs/integration-logos/Google-Cloud-Stackdriver.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Storage (GCS)",
                "external-doc-url": "https://cloud.google.com/storage/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/gcs.rst"],
                "logo": "/docs/integration-logos/Cloud-Storage.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Tasks",
                "external-doc-url": "https://cloud.google.com/tasks/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/tasks.rst"],
                "logo": "/docs/integration-logos/Cloud-Tasks.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Text-to-Speech",
                "external-doc-url": "https://cloud.google.com/text-to-speech/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/text_to_speech.rst"],
                "logo": "/docs/integration-logos/Cloud-Text-to-Speech.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Translation",
                "external-doc-url": "https://cloud.google.com/translate/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/translate.rst",
                    "/docs/apache-airflow-providers-google/operators/cloud/translate_speech.rst",
                ],
                "logo": "/docs/integration-logos/Cloud-Translation-API.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Video Intelligence",
                "external-doc-url": "https://cloud.google.com/video-intelligence/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/video_intelligence.rst"
                ],
                "logo": "/docs/integration-logos/Cloud-Video-Intelligence-API.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Vision",
                "external-doc-url": "https://cloud.google.com/vision/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/vision.rst"],
                "logo": "/docs/integration-logos/Cloud-Vision-API.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Compute Engine",
                "external-doc-url": "https://cloud.google.com/compute/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/compute.rst",
                    "/docs/apache-airflow-providers-google/operators/cloud/compute_ssh.rst",
                ],
                "logo": "/docs/integration-logos/Compute-Engine.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Data Proc",
                "external-doc-url": "https://cloud.google.com/dataproc/",
                "logo": "/docs/integration-logos/Google-Data-Proc.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Data Catalog",
                "external-doc-url": "https://cloud.google.com/data-catalog/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/datacatalog.rst"],
                "logo": "/docs/integration-logos/Google-Data-Catalog.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Dataflow",
                "external-doc-url": "https://cloud.google.com/dataflow/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/dataflow.rst"],
                "logo": "/docs/integration-logos/Cloud-Dataflow.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Data Fusion",
                "external-doc-url": "https://cloud.google.com/data-fusion/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/datafusion.rst"],
                "logo": "/docs/integration-logos/Google-Data-Fusion.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Dataplex",
                "external-doc-url": "https://cloud.google.com/dataplex/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/dataplex.rst"],
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Dataprep",
                "external-doc-url": "https://cloud.google.com/dataprep/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/dataprep.rst"],
                "logo": "/docs/integration-logos/Google-Dataprep.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Dataproc Metastore",
                "external-doc-url": "https://cloud.google.com/dataproc-metastore/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/dataproc_metastore.rst"
                ],
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Dataproc",
                "external-doc-url": "https://cloud.google.com/dataproc/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/dataproc.rst"],
                "logo": "/docs/integration-logos/Cloud-Dataproc.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Datastore",
                "external-doc-url": "https://cloud.google.com/datastore/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/datastore.rst"],
                "logo": "/docs/integration-logos/Cloud-Datastore.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Deployment Manager",
                "external-doc-url": "https://cloud.google.com/deployment-manager/",
                "logo": "/docs/integration-logos/Google-Deployment-Manager.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google API Python Client",
                "external-doc-url": "https://github.com/googleapis/google-api-python-client/",
                "logo": "/docs/integration-logos/Google-API-Python-Client.png",
                "tags": ["google"],
            },
            {
                "integration-name": "Google Calendar",
                "external-doc-url": "https://calendar.google.com/",
                "logo": "/docs/integration-logos/Google-Calendar.png",
                "tags": ["google"],
            },
            {
                "integration-name": "Google Campaign Manager",
                "external-doc-url": "https://developers.google.com/doubleclick-advertisers",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/marketing_platform/campaign_manager.rst"
                ],
                "logo": "/docs/integration-logos/Google-Campaign-Manager.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud",
                "external-doc-url": "https://cloud.google.com/",
                "logo": "/docs/integration-logos/Google-Cloud.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Discovery API",
                "external-doc-url": "https://developers.google.com/discovery/",
                "logo": "/docs/integration-logos/Google-Cloud-Generic.png",
                "tags": ["google"],
            },
            {
                "integration-name": "Google Display&Video 360",
                "external-doc-url": "https://marketingplatform.google.com/about/display-video-360/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/marketing_platform/display_video.rst"
                ],
                "logo": "/docs/integration-logos/Google-Display-And-Video-360.png",
                "tags": ["gmp"],
            },
            {
                "integration-name": "Google Drive",
                "external-doc-url": "https://www.google.com/drive/",
                "logo": "/docs/integration-logos/Google-Drive.png",
                "tags": ["google"],
            },
            {
                "integration-name": "Google Search Ads 360",
                "external-doc-url": "https://marketingplatform.google.com/about/search-ads-360/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/marketing_platform/search_ads.rst"
                ],
                "logo": "/docs/integration-logos/Google-Search-Ads360.png",
                "tags": ["gmp"],
            },
            {
                "integration-name": "Google",
                "external-doc-url": "https://developer.google.com/",
                "logo": "/docs/integration-logos/Google.png",
                "tags": ["google"],
            },
            {
                "integration-name": "Google Spreadsheet",
                "external-doc-url": "https://www.google.com/intl/en/sheets/about/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/suite/sheets.rst"],
                "logo": "/docs/integration-logos/Google-Spreadsheet.png",
                "tags": ["google"],
            },
            {
                "integration-name": "Google Cloud Storage Transfer Service",
                "external-doc-url": "https://cloud.google.com/storage-transfer-service/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/cloud_storage_transfer_service.rst"
                ],
                "logo": "/docs/integration-logos/Cloud-Storage.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Kubernetes Engine",
                "external-doc-url": "https://cloud.google.com/kubernetes-engine/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/kubernetes_engine.rst"
                ],
                "logo": "/docs/integration-logos/Kubernetes-Engine.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Machine Learning Engine",
                "external-doc-url": "https://cloud.google.com/vertex-ai/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/mlengine.rst"],
                "logo": "/docs/integration-logos/AI-Platform.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Natural Language",
                "external-doc-url": "https://cloud.google.com/natural-language/",
                "how-to-guide": [
                    "/docs/apache-airflow-providers-google/operators/cloud/natural_language.rst"
                ],
                "logo": "/docs/integration-logos/Cloud-NLP.png",
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Cloud Workflows",
                "external-doc-url": "https://cloud.google.com/workflows/",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/workflows.rst"],
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google LevelDB",
                "external-doc-url": "https://github.com/google/leveldb/blob/main/doc/index.md",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/leveldb/leveldb.rst"],
                "tags": ["google"],
            },
            {
                "integration-name": "Google Vertex AI",
                "external-doc-url": "https://cloud.google.com/vertex-ai",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/vertex_ai.rst"],
                "tags": ["gcp"],
            },
            {
                "integration-name": "Google Looker",
                "external-doc-url": "https://cloud.google.com/looker",
                "logo": "/docs/integration-logos/Cloud-Looker.png",
                "how-to-guide": ["/docs/apache-airflow-providers-google/operators/cloud/looker.rst"],
                "tags": ["gcp"],
            },
        ],
        "operators": [
            {
                "integration-name": "Google Ads",
                "python-modules": ["airflow.providers.google.ads.operators.ads"],
            },
            {
                "integration-name": "Google Cloud Common",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_base"],
            },
            {
                "integration-name": "Google Cloud AlloyDB",
                "python-modules": ["airflow.providers.google.cloud.operators.alloy_db"],
            },
            {
                "integration-name": "Google AutoML",
                "python-modules": ["airflow.providers.google.cloud.operators.automl"],
            },
            {
                "integration-name": "Google BigQuery",
                "python-modules": ["airflow.providers.google.cloud.operators.bigquery"],
            },
            {
                "integration-name": "Google BigQuery Data Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.operators.bigquery_dts"],
            },
            {
                "integration-name": "Google Bigtable",
                "python-modules": ["airflow.providers.google.cloud.operators.bigtable"],
            },
            {
                "integration-name": "Google Cloud Build",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_build"],
            },
            {
                "integration-name": "Google Cloud Composer",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_composer"],
            },
            {
                "integration-name": "Google Cloud Run",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_run"],
            },
            {
                "integration-name": "Google Cloud Memorystore",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_memorystore"],
            },
            {
                "integration-name": "Google Cloud SQL",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_sql"],
            },
            {
                "integration-name": "Google Cloud Storage Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_storage_transfer_service"],
            },
            {
                "integration-name": "Google Compute Engine",
                "python-modules": ["airflow.providers.google.cloud.operators.compute"],
            },
            {
                "integration-name": "Google Data Catalog",
                "python-modules": ["airflow.providers.google.cloud.operators.datacatalog"],
            },
            {
                "integration-name": "Google Dataflow",
                "python-modules": ["airflow.providers.google.cloud.operators.dataflow"],
            },
            {
                "integration-name": "Google Data Fusion",
                "python-modules": ["airflow.providers.google.cloud.operators.datafusion"],
            },
            {
                "integration-name": "Google Dataplex",
                "python-modules": ["airflow.providers.google.cloud.operators.dataplex"],
            },
            {
                "integration-name": "Google Dataprep",
                "python-modules": ["airflow.providers.google.cloud.operators.dataprep"],
            },
            {
                "integration-name": "Google Dataproc Metastore",
                "python-modules": ["airflow.providers.google.cloud.operators.dataproc_metastore"],
            },
            {
                "integration-name": "Google Dataproc",
                "python-modules": ["airflow.providers.google.cloud.operators.dataproc"],
            },
            {
                "integration-name": "Google Datastore",
                "python-modules": ["airflow.providers.google.cloud.operators.datastore"],
            },
            {
                "integration-name": "Google Cloud Data Loss Prevention (DLP)",
                "python-modules": ["airflow.providers.google.cloud.operators.dlp"],
            },
            {
                "integration-name": "Google Cloud Functions",
                "python-modules": ["airflow.providers.google.cloud.operators.functions"],
            },
            {
                "integration-name": "Google Cloud Storage (GCS)",
                "python-modules": ["airflow.providers.google.cloud.operators.gcs"],
            },
            {
                "integration-name": "Google Kubernetes Engine",
                "python-modules": ["airflow.providers.google.cloud.operators.kubernetes_engine"],
            },
            {
                "integration-name": "Google Cloud Life Sciences",
                "python-modules": ["airflow.providers.google.cloud.operators.life_sciences"],
            },
            {
                "integration-name": "Google Machine Learning Engine",
                "python-modules": ["airflow.providers.google.cloud.operators.mlengine"],
            },
            {
                "integration-name": "Google Cloud Natural Language",
                "python-modules": ["airflow.providers.google.cloud.operators.natural_language"],
            },
            {
                "integration-name": "Google Cloud Pub/Sub",
                "python-modules": ["airflow.providers.google.cloud.operators.pubsub"],
            },
            {
                "integration-name": "Google Cloud Spanner",
                "python-modules": ["airflow.providers.google.cloud.operators.spanner"],
            },
            {
                "integration-name": "Google Cloud Speech-to-Text",
                "python-modules": ["airflow.providers.google.cloud.operators.speech_to_text"],
            },
            {
                "integration-name": "Google Cloud Stackdriver",
                "python-modules": ["airflow.providers.google.cloud.operators.stackdriver"],
            },
            {
                "integration-name": "Google Cloud Tasks",
                "python-modules": ["airflow.providers.google.cloud.operators.tasks"],
            },
            {
                "integration-name": "Google Cloud Text-to-Speech",
                "python-modules": [
                    "airflow.providers.google.cloud.operators.text_to_speech",
                    "airflow.providers.google.cloud.operators.translate_speech",
                ],
            },
            {
                "integration-name": "Google Cloud Translation",
                "python-modules": [
                    "airflow.providers.google.cloud.operators.translate",
                    "airflow.providers.google.cloud.operators.translate_speech",
                ],
            },
            {
                "integration-name": "Google Cloud Video Intelligence",
                "python-modules": ["airflow.providers.google.cloud.operators.video_intelligence"],
            },
            {
                "integration-name": "Google Cloud Vision",
                "python-modules": ["airflow.providers.google.cloud.operators.vision"],
            },
            {
                "integration-name": "Google Cloud Workflows",
                "python-modules": ["airflow.providers.google.cloud.operators.workflows"],
            },
            {
                "integration-name": "Google Cloud Firestore",
                "python-modules": ["airflow.providers.google.firebase.operators.firestore"],
            },
            {
                "integration-name": "Google Analytics (GA4)",
                "python-modules": ["airflow.providers.google.marketing_platform.operators.analytics_admin"],
            },
            {
                "integration-name": "Google Campaign Manager",
                "python-modules": ["airflow.providers.google.marketing_platform.operators.campaign_manager"],
            },
            {
                "integration-name": "Google Display&Video 360",
                "python-modules": ["airflow.providers.google.marketing_platform.operators.display_video"],
            },
            {
                "integration-name": "Google Search Ads 360",
                "python-modules": ["airflow.providers.google.marketing_platform.operators.search_ads"],
            },
            {
                "integration-name": "Google Spreadsheet",
                "python-modules": ["airflow.providers.google.suite.operators.sheets"],
            },
            {
                "integration-name": "Google LevelDB",
                "python-modules": ["airflow.providers.google.leveldb.operators.leveldb"],
            },
            {
                "integration-name": "Google Vertex AI",
                "python-modules": [
                    "airflow.providers.google.cloud.operators.vertex_ai.dataset",
                    "airflow.providers.google.cloud.operators.vertex_ai.custom_job",
                    "airflow.providers.google.cloud.operators.vertex_ai.auto_ml",
                    "airflow.providers.google.cloud.operators.vertex_ai.batch_prediction_job",
                    "airflow.providers.google.cloud.operators.vertex_ai.endpoint_service",
                    "airflow.providers.google.cloud.operators.vertex_ai.hyperparameter_tuning_job",
                    "airflow.providers.google.cloud.operators.vertex_ai.model_service",
                    "airflow.providers.google.cloud.operators.vertex_ai.pipeline_job",
                    "airflow.providers.google.cloud.operators.vertex_ai.generative_model",
                    "airflow.providers.google.cloud.operators.vertex_ai.feature_store",
                    "airflow.providers.google.cloud.operators.vertex_ai.ray",
                ],
            },
            {
                "integration-name": "Google Looker",
                "python-modules": ["airflow.providers.google.cloud.operators.looker"],
            },
            {
                "integration-name": "Google Cloud Dataform",
                "python-modules": ["airflow.providers.google.cloud.operators.dataform"],
            },
            {
                "integration-name": "Google Cloud Batch",
                "python-modules": ["airflow.providers.google.cloud.operators.cloud_batch"],
            },
            {
                "integration-name": "Google Cloud Managed Service for Apache Kafka",
                "python-modules": ["airflow.providers.google.cloud.operators.managed_kafka"],
            },
        ],
        "sensors": [
            {
                "integration-name": "Google BigQuery",
                "python-modules": ["airflow.providers.google.cloud.sensors.bigquery"],
            },
            {
                "integration-name": "Google BigQuery Data Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.sensors.bigquery_dts"],
            },
            {
                "integration-name": "Google Bigtable",
                "python-modules": ["airflow.providers.google.cloud.sensors.bigtable"],
            },
            {
                "integration-name": "Google Cloud Composer",
                "python-modules": ["airflow.providers.google.cloud.sensors.cloud_composer"],
            },
            {
                "integration-name": "Google Cloud Storage Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.sensors.cloud_storage_transfer_service"],
            },
            {
                "integration-name": "Google Dataflow",
                "python-modules": ["airflow.providers.google.cloud.sensors.dataflow"],
            },
            {
                "integration-name": "Google Data Fusion",
                "python-modules": ["airflow.providers.google.cloud.sensors.datafusion"],
            },
            {
                "integration-name": "Google Dataprep",
                "python-modules": ["airflow.providers.google.cloud.sensors.dataprep"],
            },
            {
                "integration-name": "Google Dataplex",
                "python-modules": ["airflow.providers.google.cloud.sensors.dataplex"],
            },
            {
                "integration-name": "Google Dataproc",
                "python-modules": ["airflow.providers.google.cloud.sensors.dataproc"],
            },
            {
                "integration-name": "Google Dataproc Metastore",
                "python-modules": ["airflow.providers.google.cloud.sensors.dataproc_metastore"],
            },
            {
                "integration-name": "Google Cloud Storage (GCS)",
                "python-modules": ["airflow.providers.google.cloud.sensors.gcs"],
            },
            {
                "integration-name": "Google Cloud Pub/Sub",
                "python-modules": ["airflow.providers.google.cloud.sensors.pubsub"],
            },
            {
                "integration-name": "Google Vertex AI",
                "python-modules": ["airflow.providers.google.cloud.sensors.vertex_ai.feature_store"],
            },
            {
                "integration-name": "Google Cloud Workflows",
                "python-modules": ["airflow.providers.google.cloud.sensors.workflows"],
            },
            {
                "integration-name": "Google Drive",
                "python-modules": ["airflow.providers.google.suite.sensors.drive"],
            },
            {
                "integration-name": "Google Campaign Manager",
                "python-modules": ["airflow.providers.google.marketing_platform.sensors.campaign_manager"],
            },
            {
                "integration-name": "Google Display&Video 360",
                "python-modules": ["airflow.providers.google.marketing_platform.sensors.display_video"],
            },
            {
                "integration-name": "Google Looker",
                "python-modules": ["airflow.providers.google.cloud.sensors.looker"],
            },
            {
                "integration-name": "Google Cloud Dataform",
                "python-modules": ["airflow.providers.google.cloud.sensors.dataform"],
            },
            {
                "integration-name": "Google Cloud Tasks",
                "python-modules": ["airflow.providers.google.cloud.sensors.tasks"],
            },
        ],
        "filesystems": ["airflow.providers.google.cloud.fs.gcs"],
        "asset-uris": [
            {"schemes": ["gcp"], "handler": None},
            {
                "schemes": ["bigquery"],
                "handler": "airflow.providers.google.assets.bigquery.sanitize_uri",
                "factory": "airflow.providers.google.assets.bigquery.create_asset",
                "to_openlineage_converter": "airflow.providers.google.assets.bigquery.convert_asset_to_openlineage",
            },
            {
                "schemes": ["gs"],
                "handler": "airflow.providers.google.assets.gcs.sanitize_uri",
                "factory": "airflow.providers.google.assets.gcs.create_asset",
                "to_openlineage_converter": "airflow.providers.google.assets.gcs.convert_asset_to_openlineage",
            },
        ],
        "dataset-uris": [
            {"schemes": ["gcp"], "handler": None},
            {
                "schemes": ["bigquery"],
                "handler": "airflow.providers.google.assets.bigquery.sanitize_uri",
                "factory": "airflow.providers.google.assets.bigquery.create_asset",
                "to_openlineage_converter": "airflow.providers.google.assets.bigquery.convert_asset_to_openlineage",
            },
            {
                "schemes": ["gs"],
                "handler": "airflow.providers.google.assets.gcs.sanitize_uri",
                "factory": "airflow.providers.google.assets.gcs.create_asset",
                "to_openlineage_converter": "airflow.providers.google.assets.gcs.convert_asset_to_openlineage",
            },
        ],
        "hooks": [
            {"integration-name": "Google Ads", "python-modules": ["airflow.providers.google.ads.hooks.ads"]},
            {
                "integration-name": "Google AutoML",
                "python-modules": ["airflow.providers.google.cloud.hooks.automl"],
            },
            {
                "integration-name": "Google BigQuery",
                "python-modules": ["airflow.providers.google.cloud.hooks.bigquery"],
            },
            {
                "integration-name": "Google BigQuery Data Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.hooks.bigquery_dts"],
            },
            {
                "integration-name": "Google Bigtable",
                "python-modules": ["airflow.providers.google.cloud.hooks.bigtable"],
            },
            {
                "integration-name": "Google Cloud AlloyDB",
                "python-modules": ["airflow.providers.google.cloud.hooks.alloy_db"],
            },
            {
                "integration-name": "Google Cloud Build",
                "python-modules": ["airflow.providers.google.cloud.hooks.cloud_build"],
            },
            {
                "integration-name": "Google Cloud Composer",
                "python-modules": ["airflow.providers.google.cloud.hooks.cloud_composer"],
            },
            {
                "integration-name": "Google Cloud Run",
                "python-modules": ["airflow.providers.google.cloud.hooks.cloud_run"],
            },
            {
                "integration-name": "Google Cloud Memorystore",
                "python-modules": ["airflow.providers.google.cloud.hooks.cloud_memorystore"],
            },
            {
                "integration-name": "Google Cloud SQL",
                "python-modules": ["airflow.providers.google.cloud.hooks.cloud_sql"],
            },
            {
                "integration-name": "Google Cloud Storage Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.hooks.cloud_storage_transfer_service"],
            },
            {
                "integration-name": "Google Compute Engine",
                "python-modules": [
                    "airflow.providers.google.cloud.hooks.compute",
                    "airflow.providers.google.cloud.hooks.compute_ssh",
                ],
            },
            {
                "integration-name": "Google Data Catalog",
                "python-modules": ["airflow.providers.google.cloud.hooks.datacatalog"],
            },
            {
                "integration-name": "Google Dataflow",
                "python-modules": ["airflow.providers.google.cloud.hooks.dataflow"],
            },
            {
                "integration-name": "Google Data Fusion",
                "python-modules": ["airflow.providers.google.cloud.hooks.datafusion"],
            },
            {
                "integration-name": "Google Dataplex",
                "python-modules": ["airflow.providers.google.cloud.hooks.dataplex"],
            },
            {
                "integration-name": "Google Dataprep",
                "python-modules": ["airflow.providers.google.cloud.hooks.dataprep"],
            },
            {
                "integration-name": "Google Dataproc Metastore",
                "python-modules": ["airflow.providers.google.cloud.hooks.dataproc_metastore"],
            },
            {
                "integration-name": "Google Dataproc",
                "python-modules": ["airflow.providers.google.cloud.hooks.dataproc"],
            },
            {
                "integration-name": "Google Datastore",
                "python-modules": ["airflow.providers.google.cloud.hooks.datastore"],
            },
            {
                "integration-name": "Google Cloud Data Loss Prevention (DLP)",
                "python-modules": ["airflow.providers.google.cloud.hooks.dlp"],
            },
            {
                "integration-name": "Google Cloud Functions",
                "python-modules": ["airflow.providers.google.cloud.hooks.functions"],
            },
            {
                "integration-name": "Google Cloud Storage (GCS)",
                "python-modules": ["airflow.providers.google.cloud.hooks.gcs"],
            },
            {
                "integration-name": "Google Deployment Manager",
                "python-modules": ["airflow.providers.google.cloud.hooks.gdm"],
            },
            {
                "integration-name": "Google Cloud Key Management Service (KMS)",
                "python-modules": ["airflow.providers.google.cloud.hooks.kms"],
            },
            {
                "integration-name": "Google Kubernetes Engine",
                "python-modules": ["airflow.providers.google.cloud.hooks.kubernetes_engine"],
            },
            {
                "integration-name": "Google Cloud Life Sciences",
                "python-modules": ["airflow.providers.google.cloud.hooks.life_sciences"],
            },
            {
                "integration-name": "Google Machine Learning Engine",
                "python-modules": ["airflow.providers.google.cloud.hooks.mlengine"],
            },
            {
                "integration-name": "Google Cloud Natural Language",
                "python-modules": ["airflow.providers.google.cloud.hooks.natural_language"],
            },
            {
                "integration-name": "Google Cloud OS Login",
                "python-modules": ["airflow.providers.google.cloud.hooks.os_login"],
            },
            {
                "integration-name": "Google Cloud Pub/Sub",
                "python-modules": ["airflow.providers.google.cloud.hooks.pubsub"],
            },
            {
                "integration-name": "Google Cloud Secret Manager",
                "python-modules": ["airflow.providers.google.cloud.hooks.secret_manager"],
            },
            {
                "integration-name": "Google Cloud Spanner",
                "python-modules": ["airflow.providers.google.cloud.hooks.spanner"],
            },
            {
                "integration-name": "Google Cloud Speech-to-Text",
                "python-modules": ["airflow.providers.google.cloud.hooks.speech_to_text"],
            },
            {
                "integration-name": "Google Cloud Stackdriver",
                "python-modules": ["airflow.providers.google.cloud.hooks.stackdriver"],
            },
            {
                "integration-name": "Google Cloud Tasks",
                "python-modules": ["airflow.providers.google.cloud.hooks.tasks"],
            },
            {
                "integration-name": "Google Cloud Text-to-Speech",
                "python-modules": ["airflow.providers.google.cloud.hooks.text_to_speech"],
            },
            {
                "integration-name": "Google Cloud Translation",
                "python-modules": ["airflow.providers.google.cloud.hooks.translate"],
            },
            {
                "integration-name": "Google Cloud Video Intelligence",
                "python-modules": ["airflow.providers.google.cloud.hooks.video_intelligence"],
            },
            {
                "integration-name": "Google Cloud Vision",
                "python-modules": ["airflow.providers.google.cloud.hooks.vision"],
            },
            {
                "integration-name": "Google Cloud Workflows",
                "python-modules": ["airflow.providers.google.cloud.hooks.workflows"],
            },
            {
                "integration-name": "Google",
                "python-modules": [
                    "airflow.providers.google.common.hooks.base_google",
                    "airflow.providers.google.common.hooks.operation_helpers",
                ],
            },
            {
                "integration-name": "Google Discovery API",
                "python-modules": ["airflow.providers.google.common.hooks.discovery_api"],
            },
            {
                "integration-name": "Google Cloud Firestore",
                "python-modules": ["airflow.providers.google.firebase.hooks.firestore"],
            },
            {
                "integration-name": "Google Analytics (GA4)",
                "python-modules": ["airflow.providers.google.marketing_platform.hooks.analytics_admin"],
            },
            {
                "integration-name": "Google Campaign Manager",
                "python-modules": ["airflow.providers.google.marketing_platform.hooks.campaign_manager"],
            },
            {
                "integration-name": "Google Display&Video 360",
                "python-modules": ["airflow.providers.google.marketing_platform.hooks.display_video"],
            },
            {
                "integration-name": "Google Search Ads 360",
                "python-modules": ["airflow.providers.google.marketing_platform.hooks.search_ads"],
            },
            {
                "integration-name": "Google Calendar",
                "python-modules": ["airflow.providers.google.suite.hooks.calendar"],
            },
            {
                "integration-name": "Google Drive",
                "python-modules": ["airflow.providers.google.suite.hooks.drive"],
            },
            {
                "integration-name": "Google Spreadsheet",
                "python-modules": ["airflow.providers.google.suite.hooks.sheets"],
            },
            {
                "integration-name": "Google LevelDB",
                "python-modules": ["airflow.providers.google.leveldb.hooks.leveldb"],
            },
            {
                "integration-name": "Google Vertex AI",
                "python-modules": [
                    "airflow.providers.google.cloud.hooks.vertex_ai.dataset",
                    "airflow.providers.google.cloud.hooks.vertex_ai.custom_job",
                    "airflow.providers.google.cloud.hooks.vertex_ai.auto_ml",
                    "airflow.providers.google.cloud.hooks.vertex_ai.batch_prediction_job",
                    "airflow.providers.google.cloud.hooks.vertex_ai.endpoint_service",
                    "airflow.providers.google.cloud.hooks.vertex_ai.hyperparameter_tuning_job",
                    "airflow.providers.google.cloud.hooks.vertex_ai.model_service",
                    "airflow.providers.google.cloud.hooks.vertex_ai.pipeline_job",
                    "airflow.providers.google.cloud.hooks.vertex_ai.generative_model",
                    "airflow.providers.google.cloud.hooks.vertex_ai.prediction_service",
                    "airflow.providers.google.cloud.hooks.vertex_ai.feature_store",
                    "airflow.providers.google.cloud.hooks.vertex_ai.ray",
                ],
            },
            {
                "integration-name": "Google Looker",
                "python-modules": ["airflow.providers.google.cloud.hooks.looker"],
            },
            {
                "integration-name": "Google Cloud Dataform",
                "python-modules": ["airflow.providers.google.cloud.hooks.dataform"],
            },
            {
                "integration-name": "Google Cloud Batch",
                "python-modules": ["airflow.providers.google.cloud.hooks.cloud_batch"],
            },
            {
                "integration-name": "Google Cloud Managed Service for Apache Kafka",
                "python-modules": ["airflow.providers.google.cloud.hooks.managed_kafka"],
            },
        ],
        "triggers": [
            {
                "integration-name": "Google BigQuery Data Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.triggers.bigquery_dts"],
            },
            {
                "integration-name": "Google BigQuery",
                "python-modules": ["airflow.providers.google.cloud.triggers.bigquery"],
            },
            {
                "integration-name": "Google Cloud Build",
                "python-modules": ["airflow.providers.google.cloud.triggers.cloud_build"],
            },
            {
                "integration-name": "Google Cloud Composer",
                "python-modules": ["airflow.providers.google.cloud.triggers.cloud_composer"],
            },
            {
                "integration-name": "Google Cloud Run",
                "python-modules": ["airflow.providers.google.cloud.triggers.cloud_run"],
            },
            {
                "integration-name": "Google Cloud Storage Transfer Service",
                "python-modules": ["airflow.providers.google.cloud.triggers.cloud_storage_transfer_service"],
            },
            {
                "integration-name": "Google Cloud SQL",
                "python-modules": ["airflow.providers.google.cloud.triggers.cloud_sql"],
            },
            {
                "integration-name": "Google Dataflow",
                "python-modules": ["airflow.providers.google.cloud.triggers.dataflow"],
            },
            {
                "integration-name": "Google Data Fusion",
                "python-modules": ["airflow.providers.google.cloud.triggers.datafusion"],
            },
            {
                "integration-name": "Google Dataplex",
                "python-modules": ["airflow.providers.google.cloud.triggers.dataplex"],
            },
            {
                "integration-name": "Google Dataproc",
                "python-modules": ["airflow.providers.google.cloud.triggers.dataproc"],
            },
            {
                "integration-name": "Google Cloud Storage (GCS)",
                "python-modules": ["airflow.providers.google.cloud.triggers.gcs"],
            },
            {
                "integration-name": "Google Kubernetes Engine",
                "python-modules": ["airflow.providers.google.cloud.triggers.kubernetes_engine"],
            },
            {
                "integration-name": "Google Machine Learning Engine",
                "python-modules": ["airflow.providers.google.cloud.triggers.mlengine"],
            },
            {
                "integration-name": "Google Cloud Pub/Sub",
                "python-modules": ["airflow.providers.google.cloud.triggers.pubsub"],
            },
            {
                "integration-name": "Google Cloud",
                "python-modules": ["airflow.providers.google.cloud.triggers.cloud_batch"],
            },
            {
                "integration-name": "Google Vertex AI",
                "python-modules": ["airflow.providers.google.cloud.triggers.vertex_ai"],
            },
        ],
        "transfers": [
            {
                "source-integration-name": "Presto",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/presto_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.presto_to_gcs",
            },
            {
                "source-integration-name": "Trino",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/trino_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.trino_to_gcs",
            },
            {
                "source-integration-name": "Common SQL",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.sql_to_gcs",
            },
            {
                "source-integration-name": "Google Cloud Storage (GCS)",
                "target-integration-name": "Google Drive",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gcs_to_gdrive.rst",
                "python-module": "airflow.providers.google.suite.transfers.gcs_to_gdrive",
            },
            {
                "source-integration-name": "Google Drive",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gdrive_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.gdrive_to_gcs",
            },
            {
                "source-integration-name": "Microsoft Azure FileShare",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/azure_fileshare_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.azure_fileshare_to_gcs",
            },
            {
                "source-integration-name": "Apache Cassandra",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.cassandra_to_gcs",
            },
            {
                "source-integration-name": "Google Calendar",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/calendar_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.calendar_to_gcs",
            },
            {
                "source-integration-name": "Google Spreadsheet",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/sheets_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.sheets_to_gcs",
            },
            {
                "source-integration-name": "Amazon Simple Storage Service (S3)",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/s3_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.s3_to_gcs",
            },
            {
                "source-integration-name": "Google Cloud Storage (GCS)",
                "target-integration-name": "SSH File Transfer Protocol (SFTP)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gcs_to_sftp.rst",
                "python-module": "airflow.providers.google.cloud.transfers.gcs_to_sftp",
            },
            {
                "source-integration-name": "PostgreSQL",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/postgres_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.postgres_to_gcs",
            },
            {
                "source-integration-name": "Google BigQuery",
                "target-integration-name": "Common SQL",
                "python-module": "airflow.providers.google.cloud.transfers.bigquery_to_sql",
            },
            {
                "source-integration-name": "Google BigQuery",
                "target-integration-name": "MySQL",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/bigquery_to_mysql.rst",
                "python-module": "airflow.providers.google.cloud.transfers.bigquery_to_mysql",
            },
            {
                "source-integration-name": "Google BigQuery",
                "target-integration-name": "Microsoft SQL Server (MSSQL)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/bigquery_to_mssql.rst",
                "python-module": "airflow.providers.google.cloud.transfers.bigquery_to_mssql",
            },
            {
                "source-integration-name": "Google BigQuery",
                "target-integration-name": "PostgreSQL",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/bigquery_to_postgres.rst",
                "python-module": "airflow.providers.google.cloud.transfers.bigquery_to_postgres",
            },
            {
                "source-integration-name": "Google Cloud Storage (GCS)",
                "target-integration-name": "Google BigQuery",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gcs_to_bigquery.rst",
                "python-module": "airflow.providers.google.cloud.transfers.gcs_to_bigquery",
            },
            {
                "source-integration-name": "Google Cloud Storage (GCS)",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gcs_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.gcs_to_gcs",
            },
            {
                "source-integration-name": "Facebook Ads",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/facebook_ads_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.facebook_ads_to_gcs",
            },
            {
                "source-integration-name": "SSH File Transfer Protocol (SFTP)",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/sftp_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.sftp_to_gcs",
            },
            {
                "source-integration-name": "Microsoft Azure Data Lake Storage",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.adls_to_gcs",
            },
            {
                "source-integration-name": "Google BigQuery",
                "target-integration-name": "Google BigQuery",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/bigquery_to_bigquery.rst",
                "python-module": "airflow.providers.google.cloud.transfers.bigquery_to_bigquery",
            },
            {
                "source-integration-name": "MySQL",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.mysql_to_gcs",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/mysql_to_gcs.rst",
            },
            {
                "source-integration-name": "Oracle",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.oracle_to_gcs",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/oracle_to_gcs.rst",
            },
            {
                "source-integration-name": "Google Cloud Storage (GCS)",
                "target-integration-name": "Google Spreadsheet",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gcs_to_sheets.rst",
                "python-module": "airflow.providers.google.suite.transfers.gcs_to_sheets",
            },
            {
                "source-integration-name": "Common SQL",
                "target-integration-name": "Google Spreadsheet",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/sql_to_sheets.rst",
                "python-module": "airflow.providers.google.suite.transfers.sql_to_sheets",
            },
            {
                "source-integration-name": "Local",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/local_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.local_to_gcs",
            },
            {
                "source-integration-name": "Google BigQuery",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/bigquery_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.bigquery_to_gcs",
            },
            {
                "source-integration-name": "Google Cloud Storage (GCS)",
                "target-integration-name": "Local",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gcs_to_local.rst",
                "python-module": "airflow.providers.google.cloud.transfers.gcs_to_local",
            },
            {
                "source-integration-name": "Google Drive",
                "target-integration-name": "Local",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/gdrive_to_local.rst",
                "python-module": "airflow.providers.google.cloud.transfers.gdrive_to_local",
            },
            {
                "source-integration-name": "Local",
                "target-integration-name": "Google Drive",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/local_to_drive.rst",
                "python-module": "airflow.providers.google.suite.transfers.local_to_drive",
            },
            {
                "source-integration-name": "Salesforce",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/salesforce_to_gcs.rst",
                "python-module": "airflow.providers.google.cloud.transfers.salesforce_to_gcs",
            },
            {
                "source-integration-name": "Google Ads",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.ads.transfers.ads_to_gcs",
            },
            {
                "source-integration-name": "Microsoft SQL Server (MSSQL)",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.mssql_to_gcs",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/mssql_to_gcs.rst",
            },
            {
                "source-integration-name": "Microsoft Azure Blob Storage",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.azure_blob_to_gcs",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/azure_blob_to_gcs.rst",
            },
            {
                "source-integration-name": "Hypertext Transfer Protocol (HTTP)",
                "target-integration-name": "Google Cloud Storage (GCS)",
                "python-module": "airflow.providers.google.cloud.transfers.http_to_gcs",
                "how-to-guide": "/docs/apache-airflow-providers-google/operators/transfer/http_to_gcs.rst",
            },
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.google.common.hooks.base_google.GoogleBaseHook",
                "connection-type": "google_cloud_platform",
            },
            {
                "hook-class-name": "airflow.providers.google.cloud.hooks.dataprep.GoogleDataprepHook",
                "connection-type": "dataprep",
            },
            {
                "hook-class-name": "airflow.providers.google.cloud.hooks.cloud_sql.CloudSQLHook",
                "connection-type": "gcpcloudsql",
            },
            {
                "hook-class-name": "airflow.providers.google.cloud.hooks.cloud_sql.CloudSQLDatabaseHook",
                "connection-type": "gcpcloudsqldb",
            },
            {
                "hook-class-name": "airflow.providers.google.cloud.hooks.bigquery.BigQueryHook",
                "connection-type": "gcpbigquery",
            },
            {
                "hook-class-name": "airflow.providers.google.cloud.hooks.compute_ssh.ComputeEngineSSHHook",
                "connection-type": "gcpssh",
            },
            {
                "hook-class-name": "airflow.providers.google.leveldb.hooks.leveldb.LevelDBHook",
                "connection-type": "leveldb",
            },
            {
                "hook-class-name": "airflow.providers.google.ads.hooks.ads.GoogleAdsHook",
                "connection-type": "google_ads",
            },
            {
                "hook-class-name": "airflow.providers.google.cloud.hooks.looker.LookerHook",
                "connection-type": "gcp_looker",
            },
        ],
        "extra-links": [
            "airflow.providers.google.cloud.links.alloy_db.AlloyDBBackupsLink",
            "airflow.providers.google.cloud.links.alloy_db.AlloyDBClusterLink",
            "airflow.providers.google.cloud.links.alloy_db.AlloyDBUsersLink",
            "airflow.providers.google.cloud.links.dataform.DataformRepositoryLink",
            "airflow.providers.google.cloud.links.dataform.DataformWorkspaceLink",
            "airflow.providers.google.cloud.links.dataform.DataformWorkflowInvocationLink",
            "airflow.providers.google.cloud.links.datafusion.DataFusionInstanceLink",
            "airflow.providers.google.cloud.links.datafusion.DataFusionPipelineLink",
            "airflow.providers.google.cloud.links.datafusion.DataFusionPipelinesLink",
            "airflow.providers.google.cloud.links.cloud_sql.CloudSQLInstanceLink",
            "airflow.providers.google.cloud.links.cloud_sql.CloudSQLInstanceDatabaseLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexTaskLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexTasksLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexLakeLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexCatalogAspectTypeLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexCatalogEntryLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexCatalogAspectTypesLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexCatalogEntryGroupLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexCatalogEntryGroupsLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexCatalogEntryTypeLink",
            "airflow.providers.google.cloud.links.dataplex.DataplexCatalogEntryTypesLink",
            "airflow.providers.google.cloud.links.bigquery.BigQueryDatasetLink",
            "airflow.providers.google.cloud.links.bigquery.BigQueryTableLink",
            "airflow.providers.google.cloud.links.bigquery.BigQueryJobDetailLink",
            "airflow.providers.google.cloud.links.bigquery_dts.BigQueryDataTransferConfigLink",
            "airflow.providers.google.cloud.links.compute.ComputeInstanceDetailsLink",
            "airflow.providers.google.cloud.links.compute.ComputeInstanceTemplateDetailsLink",
            "airflow.providers.google.cloud.links.compute.ComputeInstanceGroupManagerDetailsLink",
            "airflow.providers.google.cloud.links.cloud_tasks.CloudTasksQueueLink",
            "airflow.providers.google.cloud.links.cloud_tasks.CloudTasksLink",
            "airflow.providers.google.cloud.links.datacatalog.DataCatalogEntryGroupLink",
            "airflow.providers.google.cloud.links.datacatalog.DataCatalogEntryLink",
            "airflow.providers.google.cloud.links.datacatalog.DataCatalogTagTemplateLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocListLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocClusterLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocJobLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocWorkflowLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocWorkflowTemplateLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocBatchLink",
            "airflow.providers.google.cloud.links.dataproc.DataprocBatchesListLink",
            "airflow.providers.google.cloud.operators.dataproc_metastore.DataprocMetastoreDetailedLink",
            "airflow.providers.google.cloud.operators.dataproc_metastore.DataprocMetastoreLink",
            "airflow.providers.google.cloud.links.dataprep.DataprepFlowLink",
            "airflow.providers.google.cloud.links.dataprep.DataprepJobGroupLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIModelLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIModelListLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIModelExportLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAITrainingLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAITrainingPipelinesLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIDatasetLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIDatasetListLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIHyperparameterTuningJobListLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIBatchPredictionJobLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIBatchPredictionJobListLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIEndpointLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIEndpointListLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIPipelineJobLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIPipelineJobListLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIRayClusterLink",
            "airflow.providers.google.cloud.links.vertex_ai.VertexAIRayClusterListLink",
            "airflow.providers.google.cloud.links.workflows.WorkflowsWorkflowDetailsLink",
            "airflow.providers.google.cloud.links.workflows.WorkflowsListOfWorkflowsLink",
            "airflow.providers.google.cloud.links.workflows.WorkflowsExecutionLink",
            "airflow.providers.google.cloud.operators.cloud_composer.CloudComposerEnvironmentLink",
            "airflow.providers.google.cloud.operators.cloud_composer.CloudComposerEnvironmentsLink",
            "airflow.providers.google.cloud.links.dataflow.DataflowJobLink",
            "airflow.providers.google.cloud.links.dataflow.DataflowPipelineLink",
            "airflow.providers.google.cloud.links.datastore.CloudDatastoreImportExportLink",
            "airflow.providers.google.cloud.links.datastore.CloudDatastoreEntitiesLink",
            "airflow.providers.google.cloud.links.bigtable.BigtableInstanceLink",
            "airflow.providers.google.cloud.links.bigtable.BigtableClusterLink",
            "airflow.providers.google.cloud.links.bigtable.BigtableTablesLink",
            "airflow.providers.google.cloud.links.spanner.SpannerDatabaseLink",
            "airflow.providers.google.cloud.links.spanner.SpannerInstanceLink",
            "airflow.providers.google.cloud.links.stackdriver.StackdriverNotificationsLink",
            "airflow.providers.google.cloud.links.stackdriver.StackdriverPoliciesLink",
            "airflow.providers.google.cloud.links.kubernetes_engine.KubernetesEngineClusterLink",
            "airflow.providers.google.cloud.links.kubernetes_engine.KubernetesEnginePodLink",
            "airflow.providers.google.cloud.links.kubernetes_engine.KubernetesEngineJobLink",
            "airflow.providers.google.cloud.links.kubernetes_engine.KubernetesEngineWorkloadsLink",
            "airflow.providers.google.cloud.links.pubsub.PubSubSubscriptionLink",
            "airflow.providers.google.cloud.links.pubsub.PubSubTopicLink",
            "airflow.providers.google.cloud.links.cloud_memorystore.MemcachedInstanceDetailsLink",
            "airflow.providers.google.cloud.links.cloud_memorystore.MemcachedInstanceListLink",
            "airflow.providers.google.cloud.links.cloud_memorystore.RedisInstanceDetailsLink",
            "airflow.providers.google.cloud.links.cloud_memorystore.RedisInstanceListLink",
            "airflow.providers.google.cloud.links.cloud_build.CloudBuildLink",
            "airflow.providers.google.cloud.links.cloud_build.CloudBuildListLink",
            "airflow.providers.google.cloud.links.cloud_build.CloudBuildTriggersListLink",
            "airflow.providers.google.cloud.links.cloud_build.CloudBuildTriggerDetailsLink",
            "airflow.providers.google.cloud.links.life_sciences.LifeSciencesLink",
            "airflow.providers.google.cloud.links.cloud_functions.CloudFunctionsDetailsLink",
            "airflow.providers.google.cloud.links.cloud_functions.CloudFunctionsListLink",
            "airflow.providers.google.cloud.links.cloud_storage_transfer.CloudStorageTransferListLink",
            "airflow.providers.google.cloud.links.cloud_storage_transfer.CloudStorageTransferJobLink",
            "airflow.providers.google.cloud.links.cloud_storage_transfer.CloudStorageTransferDetailsLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPDeidentifyTemplatesListLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPDeidentifyTemplateDetailsLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPJobTriggersListLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPJobTriggerDetailsLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPJobsListLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPJobDetailsLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPInspectTemplatesListLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPInspectTemplateDetailsLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPInfoTypesListLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPInfoTypeDetailsLink",
            "airflow.providers.google.cloud.links.data_loss_prevention.CloudDLPPossibleInfoTypesListLink",
            "airflow.providers.google.cloud.links.mlengine.MLEngineModelLink",
            "airflow.providers.google.cloud.links.mlengine.MLEngineModelsListLink",
            "airflow.providers.google.cloud.links.mlengine.MLEngineJobDetailsLink",
            "airflow.providers.google.cloud.links.mlengine.MLEngineJobSListLink",
            "airflow.providers.google.cloud.links.mlengine.MLEngineModelVersionDetailsLink",
            "airflow.providers.google.common.links.storage.StorageLink",
            "airflow.providers.google.common.links.storage.FileDetailsLink",
            "airflow.providers.google.marketing_platform.links.analytics_admin.GoogleAnalyticsPropertyLink",
            "airflow.providers.google.cloud.links.translate.TranslationLegacyDatasetLink",
            "airflow.providers.google.cloud.links.translate.TranslationDatasetListLink",
            "airflow.providers.google.cloud.links.translate.TranslationLegacyModelLink",
            "airflow.providers.google.cloud.links.translate.TranslationLegacyModelTrainLink",
            "airflow.providers.google.cloud.links.translate.TranslationLegacyModelPredictLink",
            "airflow.providers.google.cloud.links.translate.TranslateTextBatchLink",
            "airflow.providers.google.cloud.links.translate.TranslationNativeDatasetLink",
            "airflow.providers.google.cloud.links.translate.TranslationDatasetsListLink",
            "airflow.providers.google.cloud.links.translate.TranslationModelLink",
            "airflow.providers.google.cloud.links.translate.TranslationModelsListLink",
            "airflow.providers.google.cloud.links.translate.TranslateResultByOutputConfigLink",
            "airflow.providers.google.cloud.links.translate.TranslationGlossariesListLink",
            "airflow.providers.google.cloud.links.managed_kafka.ApacheKafkaClusterLink",
            "airflow.providers.google.cloud.links.managed_kafka.ApacheKafkaClusterListLink",
            "airflow.providers.google.cloud.links.managed_kafka.ApacheKafkaTopicLink",
            "airflow.providers.google.cloud.links.managed_kafka.ApacheKafkaConsumerGroupLink",
        ],
        "secrets-backends": [
            "airflow.providers.google.cloud.secrets.secret_manager.CloudSecretManagerBackend"
        ],
        "auth-backends": ["airflow.providers.google.common.auth_backend.google_openid"],
        "logging": [
            "airflow.providers.google.cloud.log.gcs_task_handler.GCSTaskHandler",
            "airflow.providers.google.cloud.log.stackdriver_task_handler.StackdriverTaskHandler",
        ],
    }
