# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-sftp",
        "name": "SFTP",
        "description": "`SSH File Transfer Protocol (SFTP) <https://tools.ietf.org/wg/secsh/draft-ietf-secsh-filexfer/>`__\n",
        "suspended": False,
        "versions": [
            "4.6.1",
            "4.6.0",
            "4.5.0",
            "4.4.0",
            "4.3.1",
            "4.3.0",
            "4.2.4",
            "4.2.3",
            "4.2.2",
            "4.2.1",
            "4.2.0",
            "4.1.0",
            "4.0.0",
            "3.0.0",
            "2.6.0",
            "2.5.2",
            "2.5.1",
            "2.5.0",
            "2.4.1",
            "2.4.0",
            "2.3.0",
            "2.2.0",
            "2.1.1",
            "2.1.0",
            "2.0.0",
            "1.2.0",
            "1.1.1",
            "1.1.0",
            "1.0.0",
        ],
        "dependencies": ["apache-airflow>=2.4.0", "apache-airflow-providers-ssh>=2.1.0", "paramiko>=2.8.0"],
        "integrations": [
            {
                "integration-name": "SSH File Transfer Protocol (SFTP)",
                "external-doc-url": "https://tools.ietf.org/wg/secsh/draft-ietf-secsh-filexfer/",
                "logo": "/integration-logos/sftp/SFTP.png",
                "tags": ["protocol"],
            }
        ],
        "operators": [
            {
                "integration-name": "SSH File Transfer Protocol (SFTP)",
                "python-modules": ["airflow.providers.sftp.operators.sftp"],
            }
        ],
        "sensors": [
            {
                "integration-name": "SSH File Transfer Protocol (SFTP)",
                "python-modules": [
                    "airflow.providers.sftp.sensors.sftp",
                    "airflow.providers.sftp.decorators.sensors.sftp",
                ],
            }
        ],
        "hooks": [
            {
                "integration-name": "SSH File Transfer Protocol (SFTP)",
                "python-modules": ["airflow.providers.sftp.hooks.sftp"],
            }
        ],
        "connection-types": [
            {"hook-class-name": "airflow.providers.sftp.hooks.sftp.SFTPHook", "connection-type": "sftp"}
        ],
        "task-decorators": [
            {
                "class-name": "airflow.providers.sftp.decorators.sensors.sftp.sftp_sensor_task",
                "name": "sftp_sensor",
            }
        ],
    }
