# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-jenkins",
        "name": "Jenkins",
        "description": "`Jenkins <https://jenkins.io/>`__\n",
        "suspended": False,
        "versions": [
            "3.3.1",
            "3.3.0",
            "3.2.1",
            "3.2.0",
            "3.1.0",
            "3.0.0",
            "2.1.0",
            "2.0.7",
            "2.0.6",
            "2.0.5",
            "2.0.4",
            "2.0.3",
            "2.0.2",
            "2.0.1",
            "2.0.0",
            "1.1.0",
            "1.0.1",
            "1.0.0",
        ],
        "dependencies": ["apache-airflow>=2.4.0", "python-jenkins>=1.0.0"],
        "integrations": [
            {
                "integration-name": "Jenkins",
                "external-doc-url": "https://jenkins.io/",
                "logo": "/integration-logos/jenkins/Jenkins.png",
                "tags": ["software"],
            }
        ],
        "operators": [
            {
                "integration-name": "Jenkins",
                "python-modules": ["airflow.providers.jenkins.operators.jenkins_job_trigger"],
            }
        ],
        "hooks": [
            {"integration-name": "Jenkins", "python-modules": ["airflow.providers.jenkins.hooks.jenkins"]}
        ],
        "sensors": [
            {"integration-name": "Jenkins", "python-modules": ["airflow.providers.jenkins.sensors.jenkins"]}
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.jenkins.hooks.jenkins.JenkinsHook",
                "connection-type": "jenkins",
            }
        ],
    }
